/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.helper;

import java.io.Serializable;
import java.util.List;
import java.util.Vector;
import org.eclipse.persistence.internal.databaseaccess.DatabasePlatform;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DatabaseTable
implements Cloneable,
Serializable {
    protected String name;
    protected String tableQualifier;
    protected String qualifiedName;
    protected Vector<List<String>> uniqueConstraints;

    public DatabaseTable() {
        this.name = "";
        this.tableQualifier = "";
        this.uniqueConstraints = new Vector();
    }

    public DatabaseTable(String string) {
        this.setPossiblyQualifiedName(string);
        this.uniqueConstraints = new Vector();
    }

    public DatabaseTable(String string, String string2) {
        this.name = string;
        this.tableQualifier = string2;
        this.uniqueConstraints = new Vector();
    }

    public void addUniqueConstraints(List<String> list) {
        this.uniqueConstraints.add(list);
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    public boolean equals(Object object) {
        if (object instanceof DatabaseTable) {
            return this.equals((DatabaseTable)object);
        }
        return false;
    }

    public boolean equals(DatabaseTable databaseTable) {
        if (this == databaseTable) {
            return true;
        }
        return DatabasePlatform.shouldIgnoreCaseOnFieldComparisons() ? this.getName().equalsIgnoreCase(databaseTable.getName()) && (this.getTableQualifier().length() == 0 || databaseTable.getTableQualifier().length() == 0 || this.getTableQualifier().equalsIgnoreCase(databaseTable.getTableQualifier())) : this.getName().equals(databaseTable.getName()) && (this.getTableQualifier().length() == 0 || databaseTable.getTableQualifier().length() == 0 || this.getTableQualifier().equals(databaseTable.getTableQualifier()));
    }

    public String getName() {
        return this.name;
    }

    public String getQualifiedName() {
        if (this.qualifiedName == null) {
            this.qualifiedName = this.tableQualifier.equals("") ? this.getName() : this.getTableQualifier() + "." + this.getName();
        }
        return this.qualifiedName;
    }

    public String getTableQualifier() {
        return this.tableQualifier;
    }

    public Vector<List<String>> getUniqueConstraints() {
        return this.uniqueConstraints;
    }

    public int hashCode() {
        return this.getName().hashCode();
    }

    public boolean hasName() {
        return this.getName().length() != 0 || this.getTableQualifier().length() != 0;
    }

    public boolean isDecorated() {
        return false;
    }

    protected void resetQualifiedName() {
        this.qualifiedName = null;
    }

    public void setName(String string) {
        this.name = string;
        this.resetQualifiedName();
    }

    public void setPossiblyQualifiedName(String string) {
        this.resetQualifiedName();
        int n = string.lastIndexOf(46);
        if (n == -1) {
            this.name = string;
            this.tableQualifier = "";
        } else {
            this.name = string.substring(n + 1, string.length());
            this.tableQualifier = string.substring(0, n);
        }
    }

    public void setTableQualifier(String string) {
        this.tableQualifier = string;
        this.resetQualifiedName();
    }

    public String toString() {
        return "DatabaseTable(" + this.getQualifiedName() + ")";
    }
}

