/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.indirection;

import java.rmi.server.ObjID;
import java.util.Vector;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.indirection.ValueHolder;
import org.eclipse.persistence.indirection.ValueHolderInterface;
import org.eclipse.persistence.internal.indirection.DatabaseValueHolder;
import org.eclipse.persistence.internal.sessions.UnitOfWorkImpl;
import org.eclipse.persistence.internal.sessions.remote.RemoteValueHolder;
import org.eclipse.persistence.mappings.DatabaseMapping;

public abstract class UnitOfWorkValueHolder
extends DatabaseValueHolder {
    protected transient ValueHolderInterface wrappedValueHolder;
    protected transient DatabaseMapping mapping;
    protected ValueHolder backupValueHolder;
    protected UnitOfWorkImpl remoteUnitOfWork;
    protected Object sourceObject;
    protected transient Object relationshipSourceObject;
    protected String sourceAttributeName;
    protected ObjID wrappedValueHolderRemoteID;

    protected UnitOfWorkValueHolder(ValueHolderInterface valueHolderInterface, Object object, DatabaseMapping databaseMapping, UnitOfWorkImpl unitOfWorkImpl) {
        this.wrappedValueHolder = valueHolderInterface;
        this.mapping = databaseMapping;
        this.session = unitOfWorkImpl;
        this.sourceAttributeName = databaseMapping.getAttributeName();
        this.relationshipSourceObject = object;
        if (unitOfWorkImpl.isRemoteUnitOfWork()) {
            if (valueHolderInterface instanceof RemoteValueHolder) {
                this.wrappedValueHolderRemoteID = ((RemoteValueHolder)valueHolderInterface).getID();
            }
            this.remoteUnitOfWork = unitOfWorkImpl;
            this.sourceObject = object;
        }
    }

    protected abstract Object buildBackupCloneFor(Object var1);

    public abstract Object buildCloneFor(Object var1);

    protected ValueHolder getBackupValueHolder() {
        return this.backupValueHolder;
    }

    protected DatabaseMapping getMapping() {
        return this.mapping;
    }

    protected UnitOfWorkImpl getRemoteUnitOfWork() {
        return this.remoteUnitOfWork;
    }

    protected String getSourceAttributeName() {
        return this.sourceAttributeName;
    }

    protected Object getSourceObject() {
        return this.sourceObject;
    }

    protected Object getRelationshipSourceObject() {
        return this.relationshipSourceObject;
    }

    protected UnitOfWorkImpl getUnitOfWork() {
        return (UnitOfWorkImpl)this.getSession();
    }

    protected Object getValueFromServerObject() {
        this.setSession(this.getRemoteUnitOfWork());
        Vector vector = this.getSession().keyFromObject(this.getSourceObject());
        Object object = this.getUnitOfWork().getParent().getIdentityMapAccessor().getFromIdentityMap(vector, this.getSourceObject().getClass());
        if (object == null) {
            object = this.getUnitOfWork().getParent().readObject(this.getSourceObject());
        }
        ClassDescriptor classDescriptor = this.getSession().getDescriptor(object);
        DatabaseMapping databaseMapping = classDescriptor.getObjectBuilder().getMappingForAttributeName(this.getSourceAttributeName());
        this.setMapping(databaseMapping);
        return this.getMapping().getRealAttributeValueFromObject(object, this.getSession());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object instantiateImpl() {
        Object object;
        if (this.getWrappedValueHolder() instanceof DatabaseValueHolder) {
            object = this.getWrappedValueHolder();
            synchronized (object) {
                DatabaseValueHolder databaseValueHolder = (DatabaseValueHolder)this.getWrappedValueHolder();
                UnitOfWorkImpl unitOfWorkImpl = this.getUnitOfWork();
                if (!databaseValueHolder.isEasilyInstantiated()) {
                    if (databaseValueHolder.isPessimisticLockingValueHolder()) {
                        if (!unitOfWorkImpl.getCommitManager().isActive() && !unitOfWorkImpl.wasTransactionBegunPrematurely()) {
                            unitOfWorkImpl.beginEarlyTransaction();
                        }
                        unitOfWorkImpl.log(1, "transaction", "instantiate_pl_relationship");
                    }
                    if (unitOfWorkImpl.getCommitManager().isActive() || unitOfWorkImpl.wasTransactionBegunPrematurely()) {
                        return databaseValueHolder.instantiateForUnitOfWorkValueHolder(this);
                    }
                }
            }
        }
        object = this.getWrappedValueHolder().getValue();
        return this.buildCloneFor(object);
    }

    public boolean isEasilyInstantiated() {
        return this.isInstantiated() || this.getWrappedValueHolder() != null && this.getWrappedValueHolder() instanceof DatabaseValueHolder && ((DatabaseValueHolder)this.getWrappedValueHolder()).isEasilyInstantiated();
    }

    public boolean isPessimisticLockingValueHolder() {
        return this.getWrappedValueHolder() != null && this.getWrappedValueHolder() instanceof DatabaseValueHolder && ((DatabaseValueHolder)this.getWrappedValueHolder()).isPessimisticLockingValueHolder();
    }

    public ValueHolderInterface getWrappedValueHolder() {
        return this.wrappedValueHolder;
    }

    public ObjID getWrappedValueHolderRemoteID() {
        return this.wrappedValueHolderRemoteID;
    }

    public boolean isSerializedRemoteUnitOfWorkValueHolder() {
        return this.getRemoteUnitOfWork() != null && this.getRemoteUnitOfWork().getParent() != null && this.getWrappedValueHolder() == null;
    }

    protected Object instantiate() {
        Object object;
        UnitOfWorkImpl unitOfWorkImpl = this.isSerializedRemoteUnitOfWorkValueHolder() ? this.getRemoteUnitOfWork() : this.getUnitOfWork();
        if (unitOfWorkImpl == null) {
            throw ValidationException.instantiatingValueholderWithNullSession();
        }
        if (this.isSerializedRemoteUnitOfWorkValueHolder()) {
            Object object2 = this.getValueFromServerObject();
            object = this.buildCloneFor(object2);
        } else {
            object = this.instantiateImpl();
        }
        if (this.getBackupValueHolder() != null) {
            this.getBackupValueHolder().setValue(this.buildBackupCloneFor(object));
        }
        return object;
    }

    public Object instantiateForUnitOfWorkValueHolder(UnitOfWorkValueHolder unitOfWorkValueHolder) {
        return this.instantiate();
    }

    public void releaseWrappedValueHolder() {
    }

    protected void resetFields() {
    }

    public void setBackupValueHolder(ValueHolder valueHolder) {
        this.backupValueHolder = valueHolder;
    }

    protected void setMapping(DatabaseMapping databaseMapping) {
        this.mapping = databaseMapping;
    }

    protected void setRemoteUnitOfWork(UnitOfWorkImpl unitOfWorkImpl) {
        this.remoteUnitOfWork = unitOfWorkImpl;
    }

    protected void setSourceAttributeName(String string) {
        this.sourceAttributeName = string;
    }

    protected void setSourceObject(Object object) {
        this.sourceObject = object;
    }

    protected void setRelationshipSourceObject(Object object) {
        this.relationshipSourceObject = object;
    }

    protected void setWrappedValueHolder(DatabaseValueHolder databaseValueHolder) {
        this.wrappedValueHolder = databaseValueHolder;
    }
}

