/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.parsing;

import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.exceptions.JPQLException;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.internal.jpa.parsing.GenerationContext;
import org.eclipse.persistence.internal.jpa.parsing.Node;
import org.eclipse.persistence.internal.jpa.parsing.ParseTreeContext;
import org.eclipse.persistence.mappings.DatabaseMapping;

public class AttributeNode
extends Node {
    private String name;
    private boolean outerJoin;
    private boolean requiresCollectionAttribute;
    private DatabaseMapping mapping;

    public AttributeNode() {
    }

    public AttributeNode(String string) {
        this.setAttributeName(string);
    }

    public Node qualifyAttributeAccess(ParseTreeContext parseTreeContext) {
        return (Node)parseTreeContext.getNodeFactory().newQualifiedAttribute(this.getLine(), this.getColumn(), parseTreeContext.getBaseVariable(), this.name);
    }

    public void validate(ParseTreeContext parseTreeContext) {
    }

    public Expression addToExpression(Expression expression, GenerationContext generationContext) {
        if (this.isCollectionAttribute()) {
            if (generationContext.hasMemberOfNode()) {
                return expression.noneOf(this.name, new ExpressionBuilder().equal(generationContext.getMemberOfNode().getLeftExpression()));
            }
            return this.outerJoin ? expression.anyOfAllowingNone(this.name) : expression.anyOf(this.name);
        }
        if (this.requiresCollectionAttribute()) {
            throw JPQLException.invalidCollectionMemberDecl(generationContext.getParseTreeContext().getQueryInfo(), this.getLine(), this.getColumn(), this.name);
        }
        if (generationContext.shouldUseOuterJoins() || this.isOuterJoin()) {
            return expression.getAllowingNull(this.name);
        }
        return expression.get(this.name);
    }

    public boolean isAttributeNode() {
        return true;
    }

    public String getAttributeName() {
        return this.name;
    }

    public void setAttributeName(String string) {
        this.name = string;
    }

    public boolean isOuterJoin() {
        return this.outerJoin;
    }

    public void setOuterJoin(boolean bl) {
        this.outerJoin = bl;
    }

    public boolean requiresCollectionAttribute() {
        return this.requiresCollectionAttribute;
    }

    public void setRequiresCollectionAttribute(boolean bl) {
        this.requiresCollectionAttribute = bl;
    }

    public DatabaseMapping getMapping() {
        return this.mapping;
    }

    public void setMapping(DatabaseMapping databaseMapping) {
        this.mapping = databaseMapping;
    }

    public boolean isCollectionAttribute() {
        DatabaseMapping databaseMapping = this.getMapping();
        return databaseMapping != null && databaseMapping.isCollectionMapping();
    }

    public DatabaseMapping resolveMapping(GenerationContext generationContext, Class clazz) {
        ClassDescriptor classDescriptor = generationContext.getSession().getDescriptor(clazz);
        return classDescriptor == null ? null : classDescriptor.getMappingForAttributeName(this.getAttributeName());
    }

    public Class resolveClass(GenerationContext generationContext, Class clazz) {
        DatabaseMapping databaseMapping = this.resolveMapping(generationContext, clazz);
        if (databaseMapping == null || databaseMapping.isDirectToFieldMapping()) {
            return clazz;
        }
        ClassDescriptor classDescriptor = databaseMapping.getReferenceDescriptor();
        return classDescriptor == null ? null : classDescriptor.getJavaClass();
    }

    public String toString(int n) {
        StringBuffer stringBuffer = new StringBuffer();
        this.toStringIndent(n, stringBuffer);
        stringBuffer.append(this.toStringDisplayName() + "[" + this.getAttributeName() + "]");
        return stringBuffer.toString();
    }

    public String getAsString() {
        return this.getAttributeName();
    }
}

