/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.parsing;

import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.internal.jpa.parsing.AttributeNode;
import org.eclipse.persistence.internal.jpa.parsing.BinaryOperatorNode;
import org.eclipse.persistence.internal.jpa.parsing.GenerationContext;
import org.eclipse.persistence.internal.jpa.parsing.Node;
import org.eclipse.persistence.internal.jpa.parsing.ParseTreeContext;
import org.eclipse.persistence.internal.jpa.parsing.TypeHelper;
import org.eclipse.persistence.internal.jpa.parsing.VariableNode;

public class MemberOfNode
extends BinaryOperatorNode {
    private boolean notIndicated = false;
    private Expression leftExpression = null;

    public void makeNodeOneToMany(Node node) {
        Node node2 = node;
        while (true) {
            if (!node2.hasRight()) {
                ((AttributeNode)node2).setRequiresCollectionAttribute(true);
                return;
            }
            node2 = node2.getRight();
        }
    }

    public void validate(ParseTreeContext parseTreeContext) {
        super.validate(parseTreeContext);
        Node node = this.getLeft();
        if (node.isVariableNode() && ((VariableNode)node).isAlias(parseTreeContext)) {
            parseTreeContext.usedVariable(((VariableNode)node).getCanonicalVariableName());
        }
        node.validateParameter(parseTreeContext, this.right.getType());
        TypeHelper typeHelper = parseTreeContext.getTypeHelper();
        this.setType(typeHelper.getBooleanType());
    }

    public Expression generateExpression(GenerationContext generationContext) {
        if (this.getRight().isParameterNode()) {
            this.makeNodeOneToMany(this.getLeft());
        } else {
            this.makeNodeOneToMany(this.getRight());
        }
        if (this.notIndicated()) {
            Expression expression = null;
            generationContext.setMemberOfNode(this);
            this.setLeftExpression(this.getLeft().generateExpression(generationContext));
            expression = this.getRight().generateExpression(generationContext);
            generationContext.setMemberOfNode(null);
            this.setLeftExpression(null);
            return expression;
        }
        return this.getRight().generateExpression(generationContext).equal(this.getLeft().generateExpression(generationContext));
    }

    public void indicateNot() {
        this.notIndicated = true;
    }

    public boolean notIndicated() {
        return this.notIndicated;
    }

    public void setLeftExpression(Expression expression) {
        this.leftExpression = expression;
    }

    public Expression getLeftExpression() {
        return this.leftExpression;
    }
}

