/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.parsing;

import java.io.Serializable;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.internal.helper.BasicTypeHelperImpl;
import org.eclipse.persistence.internal.jpa.parsing.TypeHelper;
import org.eclipse.persistence.internal.security.PrivilegedAccessHelper;
import org.eclipse.persistence.internal.security.PrivilegedClassForName;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.mappings.AggregateMapping;
import org.eclipse.persistence.mappings.DatabaseMapping;

public class TypeHelperImpl
extends BasicTypeHelperImpl
implements TypeHelper {
    private final AbstractSession session;
    private final ClassLoader classLoader;

    public TypeHelperImpl(AbstractSession abstractSession, ClassLoader classLoader) {
        this.session = abstractSession;
        this.classLoader = classLoader;
    }

    public Object resolveTypeName(String string) {
        try {
            if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
                try {
                    return AccessController.doPrivileged(new PrivilegedClassForName(string, true, this.classLoader));
                }
                catch (PrivilegedActionException privilegedActionException) {
                    return null;
                }
            }
            return PrivilegedAccessHelper.getClassForName(string, true, this.classLoader);
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    public Object resolveAttribute(Object object, String string) {
        DatabaseMapping databaseMapping = this.resolveAttributeMapping(object, string);
        return this.getType(databaseMapping);
    }

    public Object resolveSchema(String string) {
        ClassDescriptor classDescriptor = this.session.getDescriptorForAlias(string);
        return classDescriptor != null ? classDescriptor.getJavaClass() : null;
    }

    public Object resolveEnumConstant(Object object, String string) {
        Class clazz = this.getJavaClass(object);
        T[] TArray = clazz.getEnumConstants();
        if (TArray != null) {
            for (int i = 0; i < TArray.length; ++i) {
                if (!string.equals(TArray[i].toString())) continue;
                return TArray[i];
            }
        }
        return null;
    }

    public boolean isEntityClass(Object object) {
        ClassDescriptor classDescriptor = this.getDescriptor(object);
        return classDescriptor != null && !classDescriptor.isAggregateDescriptor();
    }

    public boolean isEmbeddable(Object object) {
        ClassDescriptor classDescriptor = this.getDescriptor(object);
        return classDescriptor != null && classDescriptor.isAggregateDescriptor();
    }

    public boolean isEmbeddedAttribute(Object object, String string) {
        DatabaseMapping databaseMapping = this.resolveAttributeMapping(object, string);
        return databaseMapping != null && databaseMapping.isAggregateMapping();
    }

    public boolean isSimpleStateAttribute(Object object, String string) {
        DatabaseMapping databaseMapping = this.resolveAttributeMapping(object, string);
        return databaseMapping != null && databaseMapping.isDirectToFieldMapping();
    }

    public boolean isRelationship(Object object, String string) {
        DatabaseMapping databaseMapping = this.resolveAttributeMapping(object, string);
        return databaseMapping != null && (databaseMapping.isObjectReferenceMapping() || databaseMapping.isOneToManyMapping() || databaseMapping.isManyToManyMapping());
    }

    public boolean isSingleValuedRelationship(Object object, String string) {
        DatabaseMapping databaseMapping = this.resolveAttributeMapping(object, string);
        return databaseMapping != null && databaseMapping.isObjectReferenceMapping();
    }

    public boolean isCollectionValuedRelationship(Object object, String string) {
        DatabaseMapping databaseMapping = this.resolveAttributeMapping(object, string);
        return databaseMapping != null && (databaseMapping.isOneToManyMapping() || databaseMapping.isManyToManyMapping());
    }

    private ClassDescriptor getDescriptor(Object object) {
        ClassDescriptor classDescriptor = null;
        if (object instanceof Class) {
            classDescriptor = this.session.getDescriptor((Class)object);
        } else if (object instanceof ClassDescriptor) {
            classDescriptor = (ClassDescriptor)object;
        }
        return classDescriptor;
    }

    private DatabaseMapping resolveAttributeMapping(Object object, String string) {
        ClassDescriptor classDescriptor = this.getDescriptor(object);
        return classDescriptor == null ? null : classDescriptor.getMappingForAttributeName(string);
    }

    private Object getType(DatabaseMapping databaseMapping) {
        ClassDescriptor classDescriptor;
        if (databaseMapping == null) {
            return null;
        }
        Serializable serializable = null;
        serializable = databaseMapping.isForeignReferenceMapping() ? ((classDescriptor = databaseMapping.getReferenceDescriptor()) == null ? null : classDescriptor.getJavaClass()) : (databaseMapping.isAggregateMapping() ? ((AggregateMapping)databaseMapping).getReferenceDescriptor() : databaseMapping.getAttributeClassification());
        return serializable;
    }
}

