/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.oxm.record;

import java.io.File;
import java.io.InputStream;
import java.io.Reader;
import java.lang.reflect.Method;
import java.net.URL;
import javax.xml.namespace.QName;
import javax.xml.transform.Source;
import javax.xml.validation.Schema;
import org.eclipse.persistence.exceptions.XMLMarshalException;
import org.eclipse.persistence.internal.helper.ClassConstants;
import org.eclipse.persistence.internal.oxm.XMLConversionManager;
import org.eclipse.persistence.internal.oxm.XMLObjectBuilder;
import org.eclipse.persistence.internal.oxm.XPathFragment;
import org.eclipse.persistence.internal.oxm.record.PlatformUnmarshaller;
import org.eclipse.persistence.internal.security.PrivilegedAccessHelper;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.oxm.XMLContext;
import org.eclipse.persistence.oxm.XMLDescriptor;
import org.eclipse.persistence.oxm.XMLRoot;
import org.eclipse.persistence.oxm.XMLUnmarshaller;
import org.eclipse.persistence.oxm.record.DOMRecord;
import org.eclipse.persistence.platform.xml.XMLParser;
import org.eclipse.persistence.platform.xml.XMLPlatformException;
import org.eclipse.persistence.platform.xml.XMLPlatformFactory;
import org.eclipse.persistence.queries.ReadObjectQuery;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;

public class DOMUnmarshaller
implements PlatformUnmarshaller {
    private XMLParser parser = XMLPlatformFactory.getInstance().getXMLPlatform().newXMLParser();
    private XMLUnmarshaller xmlUnmarshaller;
    private boolean isResultAlwaysXMLRoot;

    public DOMUnmarshaller(XMLUnmarshaller xMLUnmarshaller) {
        this.parser.setNamespaceAware(true);
        this.parser.setValidationMode(0);
        this.xmlUnmarshaller = xMLUnmarshaller;
    }

    public EntityResolver getEntityResolver() {
        return this.parser.getEntityResolver();
    }

    public void setEntityResolver(EntityResolver entityResolver) {
        this.parser.setEntityResolver(entityResolver);
    }

    public ErrorHandler getErrorHandler() {
        return this.parser.getErrorHandler();
    }

    public void setErrorHandler(ErrorHandler errorHandler) {
        this.parser.setErrorHandler(errorHandler);
    }

    public int getValidationMode() {
        return this.parser.getValidationMode();
    }

    public void setValidationMode(int n) {
        this.parser.setValidationMode(n);
    }

    public void setWhitespacePreserving(boolean bl) {
        this.parser.setWhitespacePreserving(bl);
    }

    public void setSchemas(Object[] objectArray) {
        try {
            this.parser.setXMLSchemas(objectArray);
        }
        catch (XMLPlatformException xMLPlatformException) {
            throw XMLMarshalException.errorSettingSchemas(xMLPlatformException, objectArray);
        }
    }

    public void setSchema(Schema schema) {
        this.parser.setXMLSchema(schema);
    }

    public Schema getSchema() {
        return this.parser.getXMLSchema();
    }

    public Object unmarshal(File file) {
        try {
            Document document = null;
            document = this.parser.parse(file);
            return this.xmlToObject(new DOMRecord(document));
        }
        catch (XMLPlatformException xMLPlatformException) {
            throw XMLMarshalException.unmarshalException(xMLPlatformException);
        }
    }

    public Object unmarshal(File file, Class clazz) {
        try {
            Document document = null;
            document = this.parser.parse(file);
            return this.xmlToObject(new DOMRecord(document), clazz);
        }
        catch (XMLPlatformException xMLPlatformException) {
            throw XMLMarshalException.unmarshalException(xMLPlatformException);
        }
    }

    public Object unmarshal(InputStream inputStream) {
        try {
            Document document = null;
            document = this.parser.parse(inputStream);
            return this.xmlToObject(new DOMRecord(document));
        }
        catch (XMLPlatformException xMLPlatformException) {
            throw XMLMarshalException.unmarshalException(xMLPlatformException);
        }
    }

    public Object unmarshal(InputStream inputStream, Class clazz) {
        try {
            Document document = null;
            document = this.parser.parse(inputStream);
            return this.xmlToObject(new DOMRecord(document), clazz);
        }
        catch (XMLPlatformException xMLPlatformException) {
            throw XMLMarshalException.unmarshalException(xMLPlatformException);
        }
    }

    public Object unmarshal(InputSource inputSource) {
        try {
            Document document = null;
            document = this.parser.parse(inputSource);
            return this.xmlToObject(new DOMRecord(document));
        }
        catch (XMLPlatformException xMLPlatformException) {
            throw XMLMarshalException.unmarshalException(xMLPlatformException);
        }
    }

    public Object unmarshal(InputSource inputSource, Class clazz) {
        try {
            Document document = null;
            document = this.parser.parse(inputSource);
            return this.xmlToObject(new DOMRecord(document), clazz);
        }
        catch (XMLPlatformException xMLPlatformException) {
            throw XMLMarshalException.unmarshalException(xMLPlatformException);
        }
    }

    public Object unmarshal(Node node) {
        Element element = null;
        switch (node.getNodeType()) {
            case 9: {
                element = ((Document)node).getDocumentElement();
                break;
            }
            case 1: {
                element = (Element)node;
                break;
            }
            default: {
                throw XMLMarshalException.unmarshalException();
            }
        }
        return this.xmlToObject(new DOMRecord(element));
    }

    public Object unmarshal(Node node, Class clazz) {
        Element element = null;
        switch (node.getNodeType()) {
            case 9: {
                element = ((Document)node).getDocumentElement();
                break;
            }
            case 1: {
                element = (Element)node;
                break;
            }
            default: {
                throw XMLMarshalException.unmarshalException();
            }
        }
        return this.xmlToObject(new DOMRecord(element), clazz);
    }

    public Object unmarshal(Reader reader) {
        try {
            Document document = null;
            document = this.parser.parse(reader);
            return this.xmlToObject(new DOMRecord(document));
        }
        catch (XMLPlatformException xMLPlatformException) {
            throw XMLMarshalException.unmarshalException(xMLPlatformException);
        }
    }

    public Object unmarshal(Reader reader, Class clazz) {
        try {
            Document document = null;
            document = this.parser.parse(reader);
            return this.xmlToObject(new DOMRecord(document), clazz);
        }
        catch (XMLPlatformException xMLPlatformException) {
            throw XMLMarshalException.unmarshalException(xMLPlatformException);
        }
    }

    public Object unmarshal(Source source) {
        try {
            Document document = null;
            document = this.parser.parse(source);
            return this.xmlToObject(new DOMRecord(document));
        }
        catch (XMLPlatformException xMLPlatformException) {
            throw XMLMarshalException.unmarshalException(xMLPlatformException);
        }
    }

    public Object unmarshal(Source source, Class clazz) {
        try {
            Document document = null;
            document = this.parser.parse(source);
            return this.xmlToObject(new DOMRecord(document), clazz);
        }
        catch (XMLPlatformException xMLPlatformException) {
            throw XMLMarshalException.unmarshalException(xMLPlatformException);
        }
    }

    public Object unmarshal(URL uRL) {
        try {
            Document document = null;
            document = this.parser.parse(uRL);
            return this.xmlToObject(new DOMRecord(document));
        }
        catch (XMLPlatformException xMLPlatformException) {
            throw XMLMarshalException.unmarshalException(xMLPlatformException);
        }
    }

    public Object unmarshal(URL uRL, Class clazz) {
        try {
            Document document = null;
            document = this.parser.parse(uRL);
            return this.xmlToObject(new DOMRecord(document), clazz);
        }
        catch (XMLPlatformException xMLPlatformException) {
            throw XMLMarshalException.unmarshalException(xMLPlatformException);
        }
    }

    protected XMLDescriptor getDescriptor(DOMRecord dOMRecord) throws XMLMarshalException {
        QName qName;
        XMLContext xMLContext = this.xmlUnmarshaller.getXMLContext();
        XMLDescriptor xMLDescriptor = xMLContext.getDescriptor(qName = new QName(dOMRecord.getNamespaceURI(), dOMRecord.getLocalName()));
        if (null == xMLDescriptor) {
            String string = ((Element)dOMRecord.getDOM()).getAttributeNS("http://www.w3.org/2001/XMLSchema-instance", "type");
            if (null != string) {
                XPathFragment xPathFragment = new XPathFragment(string);
                String string2 = dOMRecord.resolveNamespacePrefix(xPathFragment.getPrefix());
                xPathFragment.setNamespaceURI(string2);
                xMLDescriptor = xMLContext.getDescriptorByGlobalType(xPathFragment);
            }
            if (null == xMLDescriptor) {
                throw XMLMarshalException.noDescriptorWithMatchingRootElement(qName.toString());
            }
        }
        return xMLDescriptor;
    }

    public Object xmlToObject(DOMRecord dOMRecord) throws XMLMarshalException {
        XMLDescriptor xMLDescriptor = this.getDescriptor(dOMRecord);
        return this.xmlToObject(dOMRecord, xMLDescriptor.getJavaClass());
    }

    public Object xmlToObject(DOMRecord dOMRecord, Class clazz) throws XMLMarshalException {
        Object object;
        Object object2;
        String string = "UTF-8";
        String string2 = "1.0";
        try {
            object2 = PrivilegedAccessHelper.getMethod(dOMRecord.getDocument().getClass(), "getXmlEncoding", new Class[0], true);
            object = PrivilegedAccessHelper.getMethod(dOMRecord.getDocument().getClass(), "getXmlVersion", new Class[0], true);
            string = (String)PrivilegedAccessHelper.invokeMethod((Method)object2, dOMRecord.getDocument(), new Object[0]);
            string2 = (String)PrivilegedAccessHelper.invokeMethod((Method)object, dOMRecord.getDocument(), new Object[0]);
        }
        catch (Exception exception) {
            // empty catch block
        }
        object2 = this.xmlUnmarshaller.getXMLContext();
        if (XMLConversionManager.getDefaultJavaTypes().get(clazz) != null || ClassConstants.XML_GREGORIAN_CALENDAR.isAssignableFrom(clazz) || ClassConstants.DURATION.isAssignableFrom(clazz)) {
            Object object3;
            try {
                object3 = (Text)dOMRecord.getDOM().getFirstChild();
                object = object3.getNodeValue();
            }
            catch (Exception exception) {
                object = null;
            }
            object3 = ((XMLConversionManager)((XMLContext)object2).getSession(0).getDatasourcePlatform().getConversionManager()).convertObject(object, clazz);
            XMLRoot xMLRoot = new XMLRoot();
            xMLRoot.setObject(object3);
            String string3 = dOMRecord.getDOM().getLocalName();
            if (string3 == null) {
                string3 = dOMRecord.getDOM().getNodeName();
            }
            xMLRoot.setLocalName(string3);
            xMLRoot.setNamespaceURI(dOMRecord.getDOM().getNamespaceURI());
            xMLRoot.setEncoding(string);
            xMLRoot.setVersion(string2);
            return xMLRoot;
        }
        object = ((XMLContext)object2).getReadSession(clazz);
        ReadObjectQuery readObjectQuery = new ReadObjectQuery();
        readObjectQuery.setReferenceClass(clazz);
        readObjectQuery.setSession((AbstractSession)object);
        XMLDescriptor xMLDescriptor = (XMLDescriptor)((AbstractSession)object).getDescriptor(clazz);
        if (xMLDescriptor == null) {
            throw XMLMarshalException.descriptorNotFoundInProject(clazz.getName());
        }
        dOMRecord.setUnmarshaller(this.xmlUnmarshaller);
        dOMRecord.setDocPresPolicy(((XMLContext)object2).getDocumentPreservationPolicy((AbstractSession)object));
        XMLObjectBuilder xMLObjectBuilder = (XMLObjectBuilder)xMLDescriptor.getObjectBuilder();
        Object object4 = xMLObjectBuilder.buildObject(readObjectQuery, dOMRecord, null);
        this.xmlUnmarshaller.resolveReferences((AbstractSession)object);
        String string4 = dOMRecord.getDOM().getNamespaceURI();
        String string5 = dOMRecord.getDOM().getLocalName();
        if (string5 == null) {
            string5 = dOMRecord.getDOM().getNodeName();
        }
        String string6 = dOMRecord.getDOM().getPrefix();
        return xMLDescriptor.wrapObjectInXMLRoot(object4, string4, string5, string6, string, string2, this.isResultAlwaysXMLRoot);
    }

    public boolean isResultAlwaysXMLRoot() {
        return this.isResultAlwaysXMLRoot;
    }

    public void setResultAlwaysXMLRoot(boolean bl) {
        this.isResultAlwaysXMLRoot = bl;
    }
}

