/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.oxm.record;

import java.util.Stack;
import org.eclipse.persistence.oxm.NamespaceResolver;
import org.eclipse.persistence.oxm.record.DOMRecord;
import org.eclipse.persistence.oxm.record.UnmarshalRecord;

public class XMLTransformationRecord
extends DOMRecord {
    private UnmarshalRecord owningRecord;
    private NamespaceResolver resolver;

    public XMLTransformationRecord(UnmarshalRecord unmarshalRecord) {
        this.owningRecord = unmarshalRecord;
        this.initializeNamespaceMaps();
    }

    public XMLTransformationRecord(String string, UnmarshalRecord unmarshalRecord) {
        super(string);
        this.owningRecord = unmarshalRecord;
        this.session = unmarshalRecord.getSession();
        this.resolver = new NamespaceResolver();
        this.initializeNamespaceMaps();
    }

    public String resolveNamespacePrefix(String string) {
        return this.resolver.resolveNamespacePrefix(string);
    }

    public void initializeNamespaceMaps() {
        UnmarshalRecord unmarshalRecord;
        Stack<UnmarshalRecord> stack = new Stack<UnmarshalRecord>();
        for (unmarshalRecord = this.owningRecord; unmarshalRecord != null; unmarshalRecord = unmarshalRecord.getParentRecord()) {
            stack.push(unmarshalRecord);
        }
        for (int i = 0; i < stack.size(); ++i) {
            unmarshalRecord = (UnmarshalRecord)stack.pop();
            if (unmarshalRecord.getNamespaceMap() == null) continue;
            for (String string : unmarshalRecord.getNamespaceMap().keySet()) {
                Stack stack2 = (Stack)unmarshalRecord.getNamespaceMap().get(string);
                if (stack2.size() <= 0) continue;
                this.resolver.put(string, (String)stack2.peek());
            }
        }
    }
}

