/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.queries;

import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.exceptions.DescriptorException;
import org.eclipse.persistence.exceptions.QueryException;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.helper.DatabaseTable;
import org.eclipse.persistence.internal.queries.DirectMapUsableContainerPolicy;
import org.eclipse.persistence.internal.queries.JoinedAttributeManager;
import org.eclipse.persistence.internal.queries.MapContainerPolicy;
import org.eclipse.persistence.internal.sessions.AbstractRecord;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.internal.sessions.CollectionChangeRecord;
import org.eclipse.persistence.internal.sessions.CommitManager;
import org.eclipse.persistence.internal.sessions.MergeManager;
import org.eclipse.persistence.internal.sessions.ObjectChangeSet;
import org.eclipse.persistence.internal.sessions.UnitOfWorkChangeSet;
import org.eclipse.persistence.internal.sessions.UnitOfWorkImpl;
import org.eclipse.persistence.mappings.Association;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.DirectMapMapping;
import org.eclipse.persistence.mappings.DirectToFieldMapping;
import org.eclipse.persistence.mappings.ForeignReferenceMapping;
import org.eclipse.persistence.mappings.converters.Converter;
import org.eclipse.persistence.mappings.foundation.MapComponentMapping;
import org.eclipse.persistence.mappings.foundation.MapKeyMapping;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.ObjectBuildingQuery;
import org.eclipse.persistence.queries.ObjectLevelReadQuery;
import org.eclipse.persistence.queries.ReadQuery;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MappedKeyMapContainerPolicy
extends MapContainerPolicy
implements DirectMapUsableContainerPolicy {
    protected transient MapKeyMapping keyMapping;
    protected transient MapComponentMapping valueMapping;
    public DatabaseQuery keyQuery;

    public MappedKeyMapContainerPolicy() {
    }

    public MappedKeyMapContainerPolicy(Class clazz) {
        super(clazz);
    }

    public MappedKeyMapContainerPolicy(String string) {
        super(string);
    }

    @Override
    public void addAdditionalFieldsToQuery(ReadQuery readQuery, Expression expression) {
        this.keyMapping.addAdditionalFieldsToQuery(readQuery, expression);
    }

    @Override
    public Map getKeyMappingDataForWriteQuery(Object object, AbstractSession abstractSession) {
        Object k = ((Map.Entry)object).getKey();
        return this.keyMapping.extractIdentityFieldsForQuery(k, abstractSession);
    }

    @Override
    public void addFieldsForMapKey(AbstractRecord abstractRecord) {
        this.keyMapping.addFieldsForMapKey(abstractRecord);
    }

    @Override
    public boolean addInto(Object object, Object object2, AbstractSession abstractSession) {
        Object object3 = null;
        Object object4 = null;
        if (object instanceof AbstractRecord) {
            AbstractRecord abstractRecord = (AbstractRecord)object;
            object3 = this.keyMapping.createMapComponentFromRow(abstractRecord, null, abstractSession);
            object4 = this.valueMapping.createMapComponentFromRow(abstractRecord, null, abstractSession);
            return this.addInto(object3, object4, object2, abstractSession);
        }
        if (object instanceof Association) {
            Association association = (Association)object;
            object3 = association.getKey();
            object4 = association.getValue();
            return this.addInto(object3, object4, object2, abstractSession);
        }
        return super.addInto(object, object2, abstractSession);
    }

    @Override
    public boolean addInto(Object object, Object object2, AbstractSession abstractSession, AbstractRecord abstractRecord, ObjectBuildingQuery objectBuildingQuery) {
        Object object3 = null;
        Object object4 = null;
        if (this.valueMapping != null && ((DatabaseMapping)((Object)this.valueMapping)).isDirectCollectionMapping() && abstractSession.getDescriptor(object.getClass()) != null) {
            object3 = object;
            object4 = this.valueMapping.createMapComponentFromRow(abstractRecord, null, abstractSession);
        } else if (this.keyMapping != null) {
            object4 = object;
            try {
                object3 = this.keyMapping.createMapComponentFromRow(abstractRecord, objectBuildingQuery, abstractSession);
            }
            catch (Exception exception) {
                throw QueryException.exceptionWhileReadingMapKey(object, exception);
            }
        }
        return this.addInto(object3, object4, object2, abstractSession);
    }

    @Override
    public void addNestedJoinsQueriesForMapKey(JoinedAttributeManager joinedAttributeManager, ObjectLevelReadQuery objectLevelReadQuery, AbstractSession abstractSession) {
        ObjectLevelReadQuery objectLevelReadQuery2 = this.keyMapping.getNestedJoinQuery(joinedAttributeManager, objectLevelReadQuery, abstractSession);
        if (objectLevelReadQuery2 != null) {
            joinedAttributeManager.getJoinedMappingQueries_().put((DatabaseMapping)((Object)this.keyMapping), objectLevelReadQuery2);
        }
    }

    @Override
    public void addToDeletedObjectsList(Object object, CommitManager commitManager) {
        if (((DatabaseMapping)((Object)this.keyMapping)).isPrivateOwned()) {
            this.keyMapping.addKeyToDeletedObjectsList(((Map.Entry)object).getKey(), commitManager);
        }
        commitManager.addObjectToDelete(this.unwrapIteratorResult(object));
    }

    @Override
    protected Object buildCloneForKey(Object object, UnitOfWorkImpl unitOfWorkImpl, boolean bl) {
        return this.keyMapping.buildElementClone(object, unitOfWorkImpl, bl);
    }

    @Override
    public ReadQuery buildSelectionQueryForDirectCollectionMapping() {
        ReadQuery readQuery = this.keyMapping.buildSelectionQueryForDirectCollectionKeyMapping(this);
        return readQuery;
    }

    public Object buildContainerFromVector(Vector vector, DatabaseQuery databaseQuery, AbstractSession abstractSession) {
        Object object = this.containerInstance(vector.size());
        int n = vector.size();
        for (int i = 0; i < n; ++i) {
            Object e = vector.get(i);
            if (e instanceof AbstractRecord && databaseQuery.isObjectBuildingQuery()) {
                Object object2 = null;
                object2 = this.keyMapping.createMapComponentFromRow((AbstractRecord)e, (ObjectBuildingQuery)databaseQuery, abstractSession);
                Object e2 = ((AbstractRecord)e).getValues().elementAt(1);
                this.addInto(object2, e2, object, abstractSession);
                continue;
            }
            this.addInto(vector.get(i), object, abstractSession);
        }
        return object;
    }

    @Override
    public Object buildKey(AbstractRecord abstractRecord, ObjectBuildingQuery objectBuildingQuery, AbstractSession abstractSession) {
        return this.keyMapping.createMapComponentFromRow(abstractRecord, objectBuildingQuery, abstractSession);
    }

    @Override
    public Object buildKeyFromJoinedRow(AbstractRecord abstractRecord, JoinedAttributeManager joinedAttributeManager, ObjectBuildingQuery objectBuildingQuery, AbstractSession abstractSession) {
        return this.keyMapping.createMapComponentFromJoinedRow(abstractRecord, joinedAttributeManager, objectBuildingQuery, abstractSession);
    }

    @Override
    public void compareCollectionsForChange(Object object, Object object2, CollectionChangeRecord collectionChangeRecord, AbstractSession abstractSession, ClassDescriptor classDescriptor) {
        Object object3;
        Object object42;
        Iterator iterator;
        IdentityHashMap identityHashMap = new IdentityHashMap();
        IdentityHashMap<Object, Object> identityHashMap2 = new IdentityHashMap<Object, Object>();
        if (object != null) {
            iterator = this.iteratorFor(object);
            while (this.hasNext(iterator)) {
                object42 = (Map.Entry)this.nextEntry(iterator, abstractSession);
                if (object42 == null) continue;
                identityHashMap.put(object42.getValue(), object42);
            }
        }
        if (object2 != null) {
            iterator = this.iteratorFor(object2);
            while (this.hasNext(iterator)) {
                object42 = (Map.Entry)this.nextEntry(iterator, abstractSession);
                object3 = object42.getValue();
                if (object3 == null) continue;
                if (identityHashMap.containsKey(object3)) {
                    identityHashMap.remove(object3);
                    continue;
                }
                this.buildChangeSetForNewObjectInCollection(object42, classDescriptor, (UnitOfWorkChangeSet)collectionChangeRecord.getOwner().getUOWChangeSet(), abstractSession);
                identityHashMap2.put(object3, object3);
            }
        }
        for (Object object42 : identityHashMap.keySet()) {
            object3 = classDescriptor.getObjectBuilder().createObjectChangeSet(object42, (UnitOfWorkChangeSet)collectionChangeRecord.getOwner().getUOWChangeSet(), abstractSession);
            Map.Entry entry = (Map.Entry)identityHashMap.get(object42);
            ((ObjectChangeSet)object3).setOldKey(entry.getKey());
        }
        collectionChangeRecord.addAdditionChange(identityHashMap2, (UnitOfWorkChangeSet)collectionChangeRecord.getOwner().getUOWChangeSet(), abstractSession);
        collectionChangeRecord.addRemoveChange(identityHashMap, (UnitOfWorkChangeSet)collectionChangeRecord.getOwner().getUOWChangeSet(), abstractSession);
    }

    @Override
    public boolean compareContainers(Object object, Object object2) {
        if (this.sizeFor(object) != this.sizeFor(object2)) {
            return false;
        }
        Object object3 = this.iteratorFor(object);
        while (this.hasNext(object3)) {
            Map.Entry entry = (Map.Entry)this.nextEntry(object3);
            Object k = entry.getKey();
            if (((Map)object).get(k).equals(((Map)object2).get(k))) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean compareKeys(Object object, AbstractSession abstractSession) {
        if (this.keyMapping != null) {
            return true;
        }
        return super.compareKeys(object, abstractSession);
    }

    @Override
    public Object createWrappedObjectFromExistingWrappedObject(Object object, ClassDescriptor classDescriptor, MergeManager mergeManager) {
        Object object2 = ((Map.Entry)object).getKey();
        object2 = this.keyMapping.getTargetVersionOfSourceObject(object2, mergeManager);
        object2 = this.keyMapping.wrapKey(object2, mergeManager.getSession());
        Object object3 = classDescriptor.getObjectBuilder().wrapObject(mergeManager.getTargetVersionOfSourceObject(this.unwrapIteratorResult(object)), mergeManager.getSession());
        return new Association(object2, object3);
    }

    @Override
    public void convertClassNamesToClasses(ClassLoader classLoader) {
        ((DatabaseMapping)((Object)this.keyMapping)).convertClassNamesToClasses(classLoader);
    }

    @Override
    public void deleteWrappedObject(Object object, AbstractSession abstractSession) {
        if (((DatabaseMapping)((Object)this.keyMapping)).isPrivateOwned()) {
            this.keyMapping.deleteMapKey(((Map.Entry)object).getKey(), abstractSession);
        }
        abstractSession.deleteObject(this.unwrapIteratorResult(object));
    }

    @Override
    public List<DatabaseTable> getAdditionalTablesForJoinQuery() {
        return this.keyMapping.getAdditionalTablesForJoinQuery();
    }

    @Override
    public List<DatabaseField> getAllFieldsForMapKey() {
        return this.keyMapping.getAllFieldsForMapKey();
    }

    @Override
    public Object getCloneDataFromChangeSet(ObjectChangeSet objectChangeSet) {
        Object object = objectChangeSet.getNewKey();
        if (object == null) {
            object = objectChangeSet.getOldKey();
        }
        return new Association(object, objectChangeSet.getUnitOfWorkClone());
    }

    @Override
    public DatabaseField getDirectKeyField() {
        if (((DatabaseMapping)((Object)this.keyMapping)).isDirectToFieldMapping()) {
            return ((DirectToFieldMapping)this.keyMapping).getField();
        }
        return null;
    }

    @Override
    public List<DatabaseField> getIdentityFieldsForMapKey() {
        return this.keyMapping.getIdentityFieldsForMapKey();
    }

    @Override
    public Converter getKeyConverter() {
        if (((DatabaseMapping)((Object)this.keyMapping)).isDirectToFieldMapping()) {
            return ((DirectToFieldMapping)this.keyMapping).getConverter();
        }
        return null;
    }

    public MapKeyMapping getKeyMapping() {
        return this.keyMapping;
    }

    public DatabaseQuery getKeyQuery() {
        return this.keyQuery;
    }

    @Override
    public Expression getKeySelectionCriteria() {
        return this.keyMapping.getAdditionalSelectionCriteriaForMapKey();
    }

    public MapComponentMapping getValueMapping() {
        return this.valueMapping;
    }

    @Override
    public void initialize(AbstractSession abstractSession, DatabaseTable databaseTable) {
        this.getKeyMapping().preinitializeMapKey(databaseTable);
        ((DatabaseMapping)((Object)this.keyMapping)).initialize(abstractSession);
    }

    @Override
    protected boolean isKeyAvailableFromElement() {
        return false;
    }

    @Override
    public boolean isMappedKeyMapPolicy() {
        return true;
    }

    @Override
    public boolean requiresDataModificationEvents() {
        return true;
    }

    @Override
    public Object keyFrom(Object object, AbstractSession abstractSession) {
        if (this.keyMapping != null) {
            return null;
        }
        return super.keyFrom(object, abstractSession);
    }

    @Override
    public void setKeyField(DatabaseField databaseField, ClassDescriptor classDescriptor) {
        if (this.keyMapping == null) {
            DirectToFieldMapping directToFieldMapping = new DirectToFieldMapping();
            directToFieldMapping.setField(databaseField);
            directToFieldMapping.setDescriptor(classDescriptor);
            this.setKeyMapping(directToFieldMapping);
        }
        if (((DatabaseMapping)((Object)this.keyMapping)).isDirectToFieldMapping()) {
            ((DirectToFieldMapping)this.keyMapping).setField(databaseField);
        }
    }

    @Override
    public void setDescriptorForKeyMapping(ClassDescriptor classDescriptor) {
        ((DatabaseMapping)((Object)this.keyMapping)).setDescriptor(classDescriptor);
    }

    @Override
    public void setKeyConverter(Converter converter, DirectMapMapping directMapMapping) {
        if (!((DatabaseMapping)((Object)this.keyMapping)).isDirectToFieldMapping()) {
            throw DescriptorException.cannotSetConverterForNonDirectMapping(directMapMapping.getDescriptor(), directMapMapping, converter.getClass().getName());
        }
        ((DirectToFieldMapping)this.keyMapping).setConverter(converter);
    }

    @Override
    public void setKeyConverterClassName(String string, DirectMapMapping directMapMapping) {
        if (!((DatabaseMapping)((Object)this.keyMapping)).isDirectToFieldMapping()) {
            throw DescriptorException.cannotSetConverterForNonDirectMapping(directMapMapping.getDescriptor(), directMapMapping, string);
        }
        ((DirectToFieldMapping)this.keyMapping).setConverterClassName(string);
    }

    public void setKeyMapping(MapKeyMapping mapKeyMapping) {
        if (((DatabaseMapping)((Object)mapKeyMapping)).isForeignReferenceMapping() && ((ForeignReferenceMapping)((Object)mapKeyMapping)).getIndirectionPolicy().usesIndirection()) {
            throw ValidationException.mapKeyCannotUseIndirection((DatabaseMapping)((Object)mapKeyMapping));
        }
        this.keyMapping = mapKeyMapping;
    }

    public void setKeyQuery(DatabaseQuery databaseQuery) {
        this.keyQuery = databaseQuery;
    }

    @Override
    public void setValueField(DatabaseField databaseField, Converter converter) {
    }

    public void setValueMapping(MapComponentMapping mapComponentMapping) {
        this.valueMapping = mapComponentMapping;
    }

    @Override
    public boolean shouldIncludeKeyInDeleteEvent() {
        return ((DatabaseMapping)((Object)this.keyMapping)).isPrivateOwned();
    }

    @Override
    public boolean shouldUpdateForeignKeysPostInsert() {
        return true;
    }

    @Override
    public Object unwrapKey(Object object, AbstractSession abstractSession) {
        return this.keyMapping.unwrapKey(object, abstractSession);
    }
}

