/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.sessions;

import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Vector;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.descriptors.VersionLockingPolicy;
import org.eclipse.persistence.exceptions.OptimisticLockException;
import org.eclipse.persistence.exceptions.QueryException;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.internal.descriptors.ObjectBuilder;
import org.eclipse.persistence.internal.helper.linkedlist.LinkedNode;
import org.eclipse.persistence.internal.identitymaps.CacheKey;
import org.eclipse.persistence.internal.localization.ExceptionLocalization;
import org.eclipse.persistence.internal.queries.ContainerPolicy;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.internal.sessions.ObjectChangeSet;
import org.eclipse.persistence.internal.sessions.UnitOfWorkChangeSet;
import org.eclipse.persistence.internal.sessions.UnitOfWorkImpl;
import org.eclipse.persistence.internal.sessions.remote.ObjectDescriptor;
import org.eclipse.persistence.internal.sessions.remote.RemoteUnitOfWork;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.DoesExistQuery;
import org.eclipse.persistence.queries.ObjectLevelReadQuery;
import org.eclipse.persistence.queries.ReadObjectQuery;
import org.eclipse.persistence.sessions.remote.RemoteSession;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MergeManager {
    protected AbstractSession session;
    protected Map objectDescriptors;
    protected Map objectsAlreadyMerged;
    protected IdentityHashMap mergedNewObjects;
    protected ArrayList<CacheKey> acquiredLocks;
    protected CacheKey writeLockQueued;
    protected LinkedNode queueNode;
    protected int mergePolicy;
    protected static final int WORKING_COPY_INTO_ORIGINAL = 1;
    protected static final int ORIGINAL_INTO_WORKING_COPY = 2;
    protected static final int CLONE_INTO_WORKING_COPY = 3;
    protected static final int WORKING_COPY_INTO_REMOTE = 4;
    protected static final int REFRESH_REMOTE_OBJECT = 5;
    protected static final int CHANGES_INTO_DISTRIBUTED_CACHE = 6;
    protected static final int CLONE_WITH_REFS_INTO_WORKING_COPY = 7;
    protected int cascadePolicy;
    public static final int NO_CASCADE = 1;
    public static final int CASCADE_PRIVATE_PARTS = 2;
    public static final int CASCADE_ALL_PARTS = 3;
    public static final int CASCADE_BY_MAPPING = 4;
    public static boolean LOCK_ON_MERGE = true;
    protected long systemTime = 0L;
    protected boolean forceCascade;
    protected boolean isTransitionedToDeferredLocks = false;
    protected Thread lockThread;

    public MergeManager(AbstractSession abstractSession) {
        this.session = abstractSession;
        this.mergedNewObjects = new IdentityHashMap();
        this.objectsAlreadyMerged = new IdentityHashMap();
        this.cascadePolicy = 3;
        this.mergePolicy = 1;
        this.acquiredLocks = new ArrayList();
    }

    protected Map buildIdentitySet(Object object, ContainerPolicy containerPolicy, boolean bl) {
        IdentityHashMap<Object, Object> identityHashMap = new IdentityHashMap<Object, Object>(containerPolicy.sizeFor(object) + 1);
        Object object2 = containerPolicy.iteratorFor(object);
        while (containerPolicy.hasNext(object2)) {
            Object object3 = containerPolicy.next(object2, this.getSession());
            if (bl) {
                identityHashMap.put(this.getTargetVersionOfSourceObject(object3), object3);
                continue;
            }
            identityHashMap.put(object3, object3);
        }
        return identityHashMap;
    }

    public void cascadeAllParts() {
        this.setCascadePolicy(3);
    }

    public void cascadePrivateParts() {
        this.setCascadePolicy(2);
    }

    public void dontCascadeParts() {
        this.setCascadePolicy(1);
    }

    public ArrayList<CacheKey> getAcquiredLocks() {
        return this.acquiredLocks;
    }

    public int getCascadePolicy() {
        return this.cascadePolicy;
    }

    protected int getMergePolicy() {
        return this.mergePolicy;
    }

    public Map getObjectDescriptors() {
        if (this.objectDescriptors == null) {
            this.objectDescriptors = new IdentityHashMap();
        }
        return this.objectDescriptors;
    }

    public Map getObjectsAlreadyMerged() {
        return this.objectsAlreadyMerged;
    }

    public Object getObjectToMerge(Object object) {
        if (this.shouldMergeOriginalIntoWorkingCopy()) {
            return this.getTargetVersionOfSourceObject(object);
        }
        return object;
    }

    public LinkedNode getQueueNode() {
        return this.queueNode;
    }

    public AbstractSession getSession() {
        return this.session;
    }

    public long getSystemTime() {
        if (this.systemTime == 0L) {
            this.systemTime = System.currentTimeMillis();
        }
        return this.systemTime;
    }

    public Object getTargetVersionOfSourceObject(Object object) {
        if (this.shouldMergeWorkingCopyIntoOriginal() || this.shouldMergeWorkingCopyIntoRemote()) {
            return ((UnitOfWorkImpl)this.getSession()).getOriginalVersionOfObject(object);
        }
        if (this.shouldMergeCloneIntoWorkingCopy() || this.shouldMergeOriginalIntoWorkingCopy() || this.shouldMergeCloneWithReferencesIntoWorkingCopy()) {
            return this.registerObjectForMergeCloneIntoWorkingCopy(object);
        }
        if (this.shouldRefreshRemoteObject()) {
            ClassDescriptor classDescriptor = this.getSession().getDescriptor(object);
            Vector vector = classDescriptor.getObjectBuilder().extractPrimaryKeyFromObject(object, this.getSession());
            return this.getSession().getIdentityMapAccessorInstance().getFromIdentityMap(vector, object.getClass(), classDescriptor);
        }
        throw ValidationException.invalidMergePolicy();
    }

    public CacheKey getWriteLockQueued() {
        return this.writeLockQueued;
    }

    public boolean isTransitionedToDeferredLocks() {
        return this.isTransitionedToDeferredLocks;
    }

    public Object mergeChanges(Object object, ObjectChangeSet objectChangeSet) throws ValidationException {
        Object object2;
        if (object == null) {
            return object;
        }
        if (this.getSession().isClassReadOnly(object.getClass())) {
            return object;
        }
        if (this.getObjectsAlreadyMerged().containsKey(object)) {
            return object;
        }
        this.getObjectsAlreadyMerged().put(object, object);
        if (this.shouldMergeWorkingCopyIntoOriginal()) {
            object2 = this.mergeChangesOfWorkingCopyIntoOriginal(object, objectChangeSet);
        } else if (this.shouldMergeChangesIntoDistributedCache()) {
            object2 = this.mergeChangesIntoDistributedCache(object, objectChangeSet);
        } else if (this.shouldMergeCloneIntoWorkingCopy() || this.shouldMergeCloneWithReferencesIntoWorkingCopy()) {
            object2 = this.mergeChangesOfCloneIntoWorkingCopy(object);
        } else if (this.shouldMergeOriginalIntoWorkingCopy()) {
            object2 = this.mergeChangesOfOriginalIntoWorkingCopy(object);
        } else if (this.shouldMergeWorkingCopyIntoRemote()) {
            object2 = this.mergeChangesOfWorkingCopyIntoRemote(object);
        } else if (this.shouldRefreshRemoteObject()) {
            object2 = this.mergeChangesForRefreshingRemoteObject(object);
        } else {
            throw ValidationException.invalidMergePolicy();
        }
        return object2;
    }

    protected Object mergeChangesForRefreshingRemoteObject(Object object) {
        ClassDescriptor classDescriptor = this.getSession().getDescriptor(object);
        Vector vector = classDescriptor.getObjectBuilder().extractPrimaryKeyFromObject(object, this.getSession());
        Object object2 = this.getSession().getIdentityMapAccessorInstance().getFromIdentityMap(vector, object.getClass(), classDescriptor);
        if (object2 == null) {
            Cloneable cloneable;
            ObjectDescriptor objectDescriptor = (ObjectDescriptor)this.getObjectDescriptors().get(object);
            if (objectDescriptor == null) {
                objectDescriptor = new ObjectDescriptor();
                objectDescriptor.setKey(vector);
                objectDescriptor.setObject(object);
                cloneable = classDescriptor.getOptimisticLockingPolicy();
                if (cloneable == null) {
                    objectDescriptor.setWriteLockValue(null);
                } else {
                    objectDescriptor.setWriteLockValue(cloneable.getBaseValue());
                }
            }
            cloneable = new ReadObjectQuery();
            ((DatabaseQuery)cloneable).setCascadePolicy(this.getCascadePolicy());
            this.getSession().getIdentityMapAccessorInstance().putInIdentityMap(object, vector, objectDescriptor.getWriteLockValue(), objectDescriptor.getReadTime(), classDescriptor);
            classDescriptor.getObjectBuilder().fixObjectReferences(object, this.getObjectDescriptors(), this.getObjectsAlreadyMerged(), (ObjectLevelReadQuery)cloneable, (RemoteSession)this.getSession());
            object2 = object;
        } else {
            Cloneable cloneable;
            classDescriptor.getObjectBuilder().mergeIntoObject(object2, false, object, this);
            ObjectDescriptor objectDescriptor = (ObjectDescriptor)this.getObjectDescriptors().get(object);
            if (objectDescriptor == null) {
                objectDescriptor = new ObjectDescriptor();
                objectDescriptor.setKey(vector);
                objectDescriptor.setObject(object);
                cloneable = classDescriptor.getOptimisticLockingPolicy();
                if (cloneable == null) {
                    objectDescriptor.setWriteLockValue(null);
                } else {
                    objectDescriptor.setWriteLockValue(cloneable.getBaseValue());
                }
            }
            if ((cloneable = this.getSession().getIdentityMapAccessorInstance().getCacheKeyForObjectForLock(vector, object2.getClass(), classDescriptor)) != null) {
                ((CacheKey)cloneable).setReadTime(objectDescriptor.getReadTime());
            }
            if (classDescriptor.usesOptimisticLocking()) {
                this.getSession().getIdentityMapAccessor().updateWriteLockValue(vector, object2.getClass(), objectDescriptor.getWriteLockValue());
            }
        }
        return object2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void mergeChangesFromChangeSet(UnitOfWorkChangeSet unitOfWorkChangeSet) {
        this.getSession().startOperationProfile("distributed merge");
        this.getSession().getIdentityMapAccessorInstance().acquireWriteLock();
        this.getSession().log(2, "propagation", "received_updates_from_remote_server");
        this.getSession().getEventManager().preDistributedMergeUnitOfWorkChangeSet(unitOfWorkChangeSet);
        try {
            this.getSession().getIdentityMapAccessorInstance().getWriteLockManager().acquireRequiredLocks(this, unitOfWorkChangeSet);
            for (Object object : unitOfWorkChangeSet.getAllChangeSets().keySet()) {
                Object object2 = ((ObjectChangeSet)object).getTargetVersionOfSourceObject(this.getSession(), false);
                Object object3 = this.mergeChanges(object2, (ObjectChangeSet)object);
                if (object3 == null && ((ObjectChangeSet)object).isNew()) {
                    object3 = this.mergeNewObjectIntoCache((ObjectChangeSet)object);
                }
                if (object3 == null) {
                    this.getSession().incrementProfile("ChangesNotProcessed");
                    continue;
                }
                this.getSession().incrementProfile("ChangesProcessed");
            }
            if (unitOfWorkChangeSet.hasDeletedObjects()) {
                for (Object object2 : unitOfWorkChangeSet.getDeletedObjects().values()) {
                    ((ObjectChangeSet)object2).removeFromIdentityMap(this.getSession());
                    this.getSession().incrementProfile("deleted object");
                }
            }
        }
        catch (RuntimeException runtimeException) {
            this.getSession().handleException(runtimeException);
        }
        finally {
            this.getSession().getIdentityMapAccessorInstance().getWriteLockManager().releaseAllAcquiredLocks(this);
            this.getSession().getIdentityMapAccessorInstance().releaseWriteLock();
            this.getSession().getEventManager().postDistributedMergeUnitOfWorkChangeSet(unitOfWorkChangeSet);
            this.getSession().endOperationProfile("distributed merge");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object mergeChangesIntoDistributedCache(Object object, ObjectChangeSet objectChangeSet) {
        AbstractSession abstractSession = this.getSession();
        Class clazz = objectChangeSet.getClassType(abstractSession);
        ClassDescriptor classDescriptor = abstractSession.getDescriptor(clazz);
        if (objectChangeSet.getSynchronizationType() == 2) {
            this.getSession().getIdentityMapAccessorInstance().invalidateObject(objectChangeSet.getPrimaryKeys(), clazz);
            return object;
        }
        if (object != null && classDescriptor.usesOptimisticLocking()) {
            int n;
            if (abstractSession.getCommandManager() != null && abstractSession.getCommandManager().getCommandConverter() != null) {
                objectChangeSet.rebuildWriteLockValueFromUserFormat(classDescriptor, abstractSession);
            }
            if ((n = classDescriptor.getOptimisticLockingPolicy().getVersionDifference(objectChangeSet.getWriteLockValue(), object, objectChangeSet.getPrimaryKeys(), abstractSession)) < 0) {
                this.getSession().log(1, "propagation", "change_from_remote_server_older_than_current_version", objectChangeSet.getClassName(), objectChangeSet.getPrimaryKeys());
                return object;
            }
            if (n > 1) {
                this.getSession().log(1, "propagation", "current_version_much_older_than_change_from_remote_server", objectChangeSet.getClassName(), objectChangeSet.getPrimaryKeys());
                abstractSession.refreshObject(object);
                return object;
            }
        }
        this.getSession().log(1, "propagation", "Merging_from_remote_server", objectChangeSet.getClassName(), objectChangeSet.getPrimaryKeys());
        if (objectChangeSet.getSynchronizationType() != 4) {
            classDescriptor.getObjectBuilder().mergeChangesIntoObject(object, objectChangeSet, null, this, false);
            Vector vector = objectChangeSet.getPrimaryKeys();
            CacheKey cacheKey = abstractSession.getIdentityMapAccessorInstance().acquireLock(vector, object.getClass(), classDescriptor);
            try {
                if (classDescriptor.usesOptimisticLocking() && classDescriptor.getOptimisticLockingPolicy().isChildWriteLockValueGreater(abstractSession, vector, object.getClass(), objectChangeSet)) {
                    cacheKey.setWriteLockValue(objectChangeSet.getWriteLockValue());
                }
                cacheKey.setObject(object);
                if (classDescriptor.getCacheInvalidationPolicy().shouldUpdateReadTimeOnUpdate()) {
                    cacheKey.setReadTime(this.getSystemTime());
                }
            }
            finally {
                cacheKey.updateAccess();
                cacheKey.release();
            }
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object mergeChangesOfCloneIntoWorkingCopy(Object object) {
        Object object2 = this.registerObjectForMergeCloneIntoWorkingCopy(object);
        if (object2 == object && !this.shouldForceCascade()) {
            return object;
        }
        ClassDescriptor classDescriptor = this.getSession().getDescriptor(object);
        try {
            Object object3;
            VersionLockingPolicy versionLockingPolicy;
            ObjectBuilder objectBuilder = classDescriptor.getObjectBuilder();
            if (object2 != object && classDescriptor.usesVersionLocking() && !this.mergedNewObjects.containsKey(object2) && (versionLockingPolicy = (VersionLockingPolicy)classDescriptor.getOptimisticLockingPolicy()).isStoredInObject() && versionLockingPolicy.isNewerVersion(object3 = objectBuilder.extractValueFromObjectForField(object2, versionLockingPolicy.getWriteLockField(), this.session), object, this.session.keyFromObject(object), this.session)) {
                throw OptimisticLockException.objectChangedSinceLastMerge(object);
            }
            classDescriptor.getObjectChangePolicy().dissableEventProcessing(object2);
            boolean bl = false;
            if (object2 == object || this.mergedNewObjects.containsKey(object2)) {
                bl = true;
            }
            objectBuilder.mergeIntoObject(object2, false, object, this, bl, false);
        }
        finally {
            classDescriptor.getObjectChangePolicy().enableEventProcessing(object2);
        }
        return object2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object mergeChangesOfOriginalIntoWorkingCopy(Object object) {
        ClassDescriptor classDescriptor = this.getSession().getDescriptor(object);
        Object object2 = ((UnitOfWorkImpl)this.getSession()).getOriginalVersionOfObjectOrNull(object, classDescriptor);
        if (object2 == null) {
            return object;
        }
        classDescriptor.getObjectChangePolicy().dissableEventProcessing(object);
        try {
            classDescriptor.getObjectBuilder().mergeIntoObject(object, false, object2, this);
        }
        finally {
            classDescriptor.getObjectChangePolicy().enableEventProcessing(object);
        }
        classDescriptor.getObjectChangePolicy().revertChanges(object, classDescriptor, (UnitOfWorkImpl)this.getSession(), ((UnitOfWorkImpl)this.getSession()).getCloneMapping());
        Vector vector = this.getSession().keyFromObject(object);
        if (classDescriptor.usesOptimisticLocking()) {
            classDescriptor.getOptimisticLockingPolicy().mergeIntoParentCache((UnitOfWorkImpl)this.getSession(), vector, object);
        }
        CacheKey cacheKey = ((UnitOfWorkImpl)this.getSession()).getParent().getIdentityMapAccessorInstance().getCacheKeyForObjectForLock(vector, object.getClass(), classDescriptor);
        CacheKey cacheKey2 = this.getSession().getIdentityMapAccessorInstance().getCacheKeyForObjectForLock(vector, object.getClass(), classDescriptor);
        if (cacheKey != null && cacheKey2 != null) {
            cacheKey2.setReadTime(cacheKey.getReadTime());
        }
        return object;
    }

    protected Object mergeChangesOfWorkingCopyIntoOriginal(Object object, ObjectChangeSet objectChangeSet) {
        Object object2;
        UnitOfWorkImpl unitOfWorkImpl = (UnitOfWorkImpl)this.getSession();
        AbstractSession abstractSession = unitOfWorkImpl.getParent();
        if (unitOfWorkImpl.isObjectDeleted(object)) {
            return object;
        }
        boolean bl = false;
        if (unitOfWorkImpl.isNestedUnitOfWork() && (object2 = unitOfWorkImpl.getOriginalVersionOfNewObject(object)) != null && !((UnitOfWorkImpl)abstractSession).isCloneNewObject(object2) && !unitOfWorkImpl.isUnregisteredNewObjectInParent(object2)) {
            bl = true;
        }
        object2 = unitOfWorkImpl.getDescriptor(object.getClass());
        ObjectBuilder objectBuilder = ((ClassDescriptor)object2).getObjectBuilder();
        Object object3 = unitOfWorkImpl.getOriginalVersionOfObjectOrNull(object, objectChangeSet, (ClassDescriptor)object2);
        try {
            if (object3 == null) {
                object3 = unitOfWorkImpl.buildOriginal(object);
                if (objectChangeSet == null) {
                    objectBuilder.mergeIntoObject(object3, true, object, this, false, !((ClassDescriptor)object2).getCopyPolicy().buildsNewInstance());
                } else if (!objectChangeSet.isNew()) {
                    object3 = abstractSession.getIdentityMapAccessorInstance().getWriteLockManager().appendLock(objectChangeSet.getPrimaryKeys(), object3, (ClassDescriptor)object2, this, abstractSession);
                    objectBuilder.mergeIntoObject(object3, true, object, this, false, !((ClassDescriptor)object2).getCopyPolicy().buildsNewInstance());
                } else {
                    objectBuilder.mergeChangesIntoObject(object3, objectChangeSet, object, this, !((ClassDescriptor)object2).getCopyPolicy().buildsNewInstance());
                    objectBuilder.clearPrimaryKey(object3);
                }
                this.updateCacheKeyProperties(unitOfWorkImpl, object3, object, objectChangeSet, (ClassDescriptor)object2);
            } else if (objectChangeSet == null) {
                if (unitOfWorkImpl.isCloneNewObject(object)) {
                    objectBuilder.mergeIntoObject(object3, true, object, this, false, !((ClassDescriptor)object2).getCopyPolicy().buildsNewInstance());
                    this.updateCacheKeyProperties(unitOfWorkImpl, object3, object, objectChangeSet, (ClassDescriptor)object2);
                }
            } else {
                if (objectChangeSet.shouldInvalidateObject(object3, abstractSession)) {
                    abstractSession.getIdentityMapAccessor().invalidateObject(object3);
                }
                if (objectChangeSet.isNew()) {
                    objectBuilder.clearPrimaryKey(object3);
                }
                if (objectChangeSet.hasChanges()) {
                    objectBuilder.mergeChangesIntoObject(object3, objectChangeSet, object, this, false);
                    this.updateCacheKeyProperties(unitOfWorkImpl, object3, object, objectChangeSet, (ClassDescriptor)object2);
                }
            }
        }
        catch (QueryException queryException) {
            if (unitOfWorkImpl.shouldPerformNoValidation() || ((ClassDescriptor)object2).hasWrapperPolicy()) {
                if (queryException.getErrorCode() != 6066 && queryException.getErrorCode() != 6004 && queryException.getErrorCode() != 6005) {
                    throw queryException;
                }
                return object;
            }
            throw queryException;
        }
        if (bl) {
            Object object4 = objectBuilder.buildNewInstance();
            Object object5 = objectBuilder.buildNewInstance();
            ((UnitOfWorkImpl)abstractSession).registerOriginalNewObjectFromNestedUnitOfWork(object3, object4, object5, (ClassDescriptor)object2);
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object mergeChangesOfWorkingCopyIntoRemote(Object object) throws ValidationException {
        Object object2;
        Object object3;
        UnitOfWorkImpl unitOfWorkImpl = (UnitOfWorkImpl)this.getSession();
        Object object4 = unitOfWorkImpl.getOriginalVersionOfObject(object);
        ClassDescriptor classDescriptor = unitOfWorkImpl.getDescriptor(object);
        classDescriptor.getObjectBuilder().mergeIntoObject(object4, false, object, this);
        if (((RemoteUnitOfWork)unitOfWorkImpl.getParent()).getUnregisteredNewObjectsCache().contains(object4)) {
            object3 = classDescriptor.getObjectBuilder().buildNewInstance();
            object2 = classDescriptor.getObjectBuilder().buildNewInstance();
            ((UnitOfWorkImpl)unitOfWorkImpl.getParent()).registerOriginalNewObjectFromNestedUnitOfWork(object4, object3, object2, classDescriptor);
        }
        object3 = classDescriptor.getObjectBuilder().extractPrimaryKeyFromObject(object, unitOfWorkImpl);
        object2 = unitOfWorkImpl.getParent().getIdentityMapAccessorInstance().acquireLock((Vector)object3, object4.getClass(), classDescriptor);
        try {
            if (classDescriptor.usesOptimisticLocking()) {
                ((CacheKey)object2).setObject(object4);
                ((CacheKey)object2).setWriteLockValue(unitOfWorkImpl.getIdentityMapAccessor().getWriteLockValue(object4));
            } else {
                ((CacheKey)object2).setObject(object4);
            }
        }
        finally {
            ((CacheKey)object2).updateAccess();
            ((CacheKey)object2).release();
        }
        return object;
    }

    public void mergeCloneIntoWorkingCopy() {
        this.setMergePolicy(3);
    }

    public void mergeCloneWithReferencesIntoWorkingCopy() {
        this.setMergePolicy(7);
    }

    public void mergeIntoDistributedCache() {
        this.setMergePolicy(6);
    }

    public Object mergeNewObjectIntoCache(ObjectChangeSet objectChangeSet) {
        if (objectChangeSet.isNew()) {
            Class clazz = objectChangeSet.getClassType(this.session);
            ClassDescriptor classDescriptor = this.getSession().getDescriptor(clazz);
            Object object = objectChangeSet.getTargetVersionOfSourceObject(this.getSession(), false);
            if (object == null) {
                if (!this.getObjectsAlreadyMerged().containsKey(objectChangeSet)) {
                    object = classDescriptor.getObjectBuilder().buildNewInstance();
                    this.getObjectsAlreadyMerged().put(objectChangeSet, object);
                } else {
                    object = this.getObjectsAlreadyMerged().get(objectChangeSet);
                }
            } else {
                object = objectChangeSet.getTargetVersionOfSourceObject(this.getSession(), true);
            }
            this.mergeChanges(object, objectChangeSet);
            Object object2 = classDescriptor.getObjectBuilder().unwrapObject(object, this.getSession());
            return this.getSession().getIdentityMapAccessorInstance().putInIdentityMap(object2, classDescriptor.getObjectBuilder().extractPrimaryKeyFromObject(object2, this.getSession()), objectChangeSet.getWriteLockValue(), this.getSystemTime(), classDescriptor);
        }
        return null;
    }

    public void mergeOriginalIntoWorkingCopy() {
        this.setMergePolicy(2);
    }

    public void mergeWorkingCopyIntoOriginal() {
        this.setMergePolicy(1);
    }

    public void mergeWorkingCopyIntoRemote() {
        this.setMergePolicy(4);
    }

    public void refreshRemoteObject() {
        this.setMergePolicy(5);
    }

    protected Object registerObjectForMergeCloneIntoWorkingCopy(Object object) {
        UnitOfWorkImpl unitOfWorkImpl = (UnitOfWorkImpl)this.getSession();
        ClassDescriptor classDescriptor = unitOfWorkImpl.getDescriptor(object.getClass());
        Vector vector = classDescriptor.getObjectBuilder().extractPrimaryKeyFromObject(object, unitOfWorkImpl);
        Object object2 = unitOfWorkImpl.getIdentityMapAccessorInstance().getFromIdentityMap(vector, classDescriptor.getJavaClass(), false, classDescriptor);
        if (object2 == null) {
            object2 = unitOfWorkImpl.checkIfAlreadyRegistered(object, classDescriptor);
        }
        if (object2 != null) {
            if (unitOfWorkImpl.getNewObjectsCloneToOriginal().containsKey(object2)) {
                this.mergedNewObjects.put(object2, object2);
            }
            if (unitOfWorkImpl.isObjectDeleted(object2) && (this.shouldMergeCloneIntoWorkingCopy() || this.shouldMergeCloneWithReferencesIntoWorkingCopy())) {
                throw new IllegalArgumentException(ExceptionLocalization.buildMessage("cannot_merge_removed_entity", new Object[]{object}));
            }
            return object2;
        }
        DoesExistQuery doesExistQuery = classDescriptor.getQueryManager().getDoesExistQuery();
        if (doesExistQuery.shouldCheckCacheForDoesExist()) {
            Object object3 = unitOfWorkImpl.internalRegisterObject(object, classDescriptor);
            if (unitOfWorkImpl.hasNewObjects() && unitOfWorkImpl.getNewObjectsOriginalToClone().containsKey(object)) {
                this.mergedNewObjects.put(object3, object3);
            }
            return object3;
        }
        Boolean bl = (Boolean)doesExistQuery.checkEarlyReturn(object, vector, unitOfWorkImpl, null);
        if (bl == Boolean.FALSE) {
            Object object4 = unitOfWorkImpl.internalRegisterObject(object, classDescriptor);
            this.mergedNewObjects.put(object4, object4);
            return object4;
        }
        Object object5 = unitOfWorkImpl.readObject(object);
        if (object5 == null) {
            object5 = unitOfWorkImpl.cloneAndRegisterNewObject(object);
            this.mergedNewObjects.put(object5, object5);
        }
        return object5;
    }

    public void registerRemovedNewObjectIfRequired(Object object) {
        if (this.getSession().isUnitOfWork()) {
            UnitOfWorkImpl unitOfWorkImpl = (UnitOfWorkImpl)this.getSession();
            if (this.shouldMergeWorkingCopyIntoOriginal() && unitOfWorkImpl.getParent().isUnitOfWork() && unitOfWorkImpl.isCloneNewObject(object)) {
                Object object2 = unitOfWorkImpl.getOriginalVersionOfObject(object);
                unitOfWorkImpl.addRemovedObject(object2);
            }
        }
    }

    public void setCascadePolicy(int n) {
        this.cascadePolicy = n;
    }

    protected void setMergePolicy(int n) {
        this.mergePolicy = n;
    }

    public void setForceCascade(boolean bl) {
        this.forceCascade = bl;
    }

    public void setObjectDescriptors(Map map) {
        this.objectDescriptors = map;
    }

    protected void setObjectsAlreadyMerged(Map map) {
        this.objectsAlreadyMerged = map;
    }

    public void setQueueNode(LinkedNode linkedNode) {
        this.queueNode = linkedNode;
    }

    protected void setSession(AbstractSession abstractSession) {
        this.session = abstractSession;
    }

    public void setWriteLockQueued(CacheKey cacheKey) {
        this.writeLockQueued = cacheKey;
    }

    public boolean shouldCascadeByMapping() {
        return this.getCascadePolicy() == 4;
    }

    public boolean shouldCascadeAllParts() {
        return this.getCascadePolicy() == 3;
    }

    public boolean shouldCascadeParts() {
        return this.getCascadePolicy() != 1;
    }

    public boolean shouldCascadePrivateParts() {
        return this.getCascadePolicy() == 2 || this.getCascadePolicy() == 3;
    }

    public boolean shouldCascadeReferences() {
        return !this.shouldMergeCloneIntoWorkingCopy();
    }

    public boolean shouldMergeChangesIntoDistributedCache() {
        return this.getMergePolicy() == 6;
    }

    public boolean shouldMergeCloneIntoWorkingCopy() {
        return this.getMergePolicy() == 3;
    }

    public boolean shouldMergeCloneWithReferencesIntoWorkingCopy() {
        return this.getMergePolicy() == 7;
    }

    public boolean shouldMergeOriginalIntoWorkingCopy() {
        return this.getMergePolicy() == 2;
    }

    public boolean shouldMergeWorkingCopyIntoOriginal() {
        return this.getMergePolicy() == 1;
    }

    public boolean shouldMergeWorkingCopyIntoRemote() {
        return this.getMergePolicy() == 4;
    }

    public boolean shouldRefreshRemoteObject() {
        return this.getMergePolicy() == 5;
    }

    public boolean shouldForceCascade() {
        return this.forceCascade;
    }

    public IdentityHashMap getMergedNewObjects() {
        return this.mergedNewObjects;
    }

    public void transitionToDeferredLocks() {
        this.isTransitionedToDeferredLocks = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateCacheKeyProperties(UnitOfWorkImpl unitOfWorkImpl, Object object, Object object2, ObjectChangeSet objectChangeSet, ClassDescriptor classDescriptor) {
        if (!unitOfWorkImpl.isNestedUnitOfWork()) {
            CacheKey cacheKey = null;
            if (objectChangeSet != null) {
                cacheKey = objectChangeSet.getActiveCacheKey();
            }
            boolean bl = false;
            if (cacheKey == null || !cacheKey.isAcquired()) {
                Vector vector = classDescriptor.getObjectBuilder().extractPrimaryKeyFromObject(object, unitOfWorkImpl);
                cacheKey = unitOfWorkImpl.getParent().getIdentityMapAccessorInstance().acquireLock(vector, object.getClass(), classDescriptor);
                bl = true;
            }
            try {
                if (classDescriptor.usesOptimisticLocking() && classDescriptor.getOptimisticLockingPolicy().isStoredInCache()) {
                    cacheKey.setWriteLockValue(unitOfWorkImpl.getIdentityMapAccessor().getWriteLockValue(object2));
                }
                cacheKey.setObject(object);
                if (classDescriptor.getCacheInvalidationPolicy().shouldUpdateReadTimeOnUpdate() || objectChangeSet != null && objectChangeSet.isNew()) {
                    cacheKey.setReadTime(this.getSystemTime());
                }
                cacheKey.updateAccess();
            }
            finally {
                if (bl) {
                    cacheKey.release();
                }
            }
        }
    }

    public Thread getLockThread() {
        return this.lockThread;
    }

    public void setLockThread(Thread thread) {
        this.lockThread = thread;
    }
}

