/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.weaving;

import org.eclipse.persistence.internal.libraries.asm.Attribute;
import org.eclipse.persistence.internal.libraries.asm.CodeAdapter;
import org.eclipse.persistence.internal.libraries.asm.CodeVisitor;
import org.eclipse.persistence.internal.libraries.asm.Constants;
import org.eclipse.persistence.internal.libraries.asm.Label;
import org.eclipse.persistence.internal.weaving.AttributeDetails;
import org.eclipse.persistence.internal.weaving.ClassWeaver;

public class MethodWeaver
extends CodeAdapter
implements Constants {
    protected ClassWeaver tcw;
    protected String methodName;
    protected String methodDescriptor = null;
    protected boolean methodStarted = false;

    public MethodWeaver(ClassWeaver classWeaver, String string, String string2, CodeVisitor codeVisitor) {
        super(codeVisitor);
        this.tcw = classWeaver;
        this.methodName = string;
        this.methodDescriptor = string2;
    }

    public void visitInsn(int n) {
        this.weaveBeginningOfMethodIfRequired();
        if (n == 177) {
            this.weaveEndOfMethodIfRequired();
        }
        super.visitInsn(n);
    }

    public void visitIntInsn(int n, int n2) {
        this.weaveBeginningOfMethodIfRequired();
        this.cv.visitIntInsn(n, n2);
    }

    public void visitVarInsn(int n, int n2) {
        this.weaveBeginningOfMethodIfRequired();
        this.cv.visitVarInsn(n, n2);
    }

    public void visitTypeInsn(int n, String string) {
        this.weaveBeginningOfMethodIfRequired();
        this.cv.visitTypeInsn(n, string);
    }

    public void visitFieldInsn(int n, String string, String string2, String string3) {
        this.weaveBeginningOfMethodIfRequired();
        this.weaveAttributesIfRequired(n, string, string2, string3);
    }

    public void visitMethodInsn(int n, String string, String string2, String string3) {
        this.weaveBeginningOfMethodIfRequired();
        String string4 = "";
        if (string3.length() > 3) {
            string4 = string3.substring(3, string3.length() - 1);
        }
        if (this.tcw.classDetails.shouldWeaveInternal() && string2.equals("clone") && this.tcw.classDetails.isInSuperclassHierarchy(string) && this.tcw.classDetails.isInMetadataHierarchy(string4) && this.tcw.classDetails.getNameOfSuperclassImplementingCloneMethod() == null) {
            super.visitMethodInsn(n, string, string2, string3);
            super.visitTypeInsn(192, this.tcw.classDetails.getClassName());
            super.visitMethodInsn(182, this.tcw.classDetails.getClassName(), "_persistence_post_clone", "()Ljava/lang/Object;");
        } else {
            super.visitMethodInsn(n, string, string2, string3);
        }
    }

    public void visitJumpInsn(int n, Label label) {
        this.weaveBeginningOfMethodIfRequired();
        this.cv.visitJumpInsn(n, label);
    }

    public void visitLabel(Label label) {
        this.weaveBeginningOfMethodIfRequired();
        this.cv.visitLabel(label);
    }

    public void visitLdcInsn(Object object) {
        this.weaveBeginningOfMethodIfRequired();
        this.cv.visitLdcInsn(object);
    }

    public void visitIincInsn(int n, int n2) {
        this.weaveBeginningOfMethodIfRequired();
        this.cv.visitIincInsn(n, n2);
    }

    public void visitTableSwitchInsn(int n, int n2, Label label, Label[] labelArray) {
        this.weaveBeginningOfMethodIfRequired();
        this.cv.visitTableSwitchInsn(n, n2, label, labelArray);
    }

    public void visitLookupSwitchInsn(Label label, int[] nArray, Label[] labelArray) {
        this.weaveBeginningOfMethodIfRequired();
        this.cv.visitLookupSwitchInsn(label, nArray, labelArray);
    }

    public void visitMultiANewArrayInsn(String string, int n) {
        this.weaveBeginningOfMethodIfRequired();
        this.cv.visitMultiANewArrayInsn(string, n);
    }

    public void visitTryCatchBlock(Label label, Label label2, Label label3, String string) {
        this.weaveBeginningOfMethodIfRequired();
        this.cv.visitTryCatchBlock(label, label2, label3, string);
    }

    public void visitMaxs(int n, int n2) {
        this.weaveBeginningOfMethodIfRequired();
        this.cv.visitMaxs(0, 0);
    }

    public void visitLocalVariable(String string, String string2, Label label, Label label2, int n) {
        this.weaveBeginningOfMethodIfRequired();
        this.cv.visitLocalVariable(string, string2, label, label2, n);
    }

    public void visitLineNumber(int n, Label label) {
        this.weaveBeginningOfMethodIfRequired();
        this.cv.visitLineNumber(n, label);
    }

    public void visitAttribute(Attribute attribute) {
        this.weaveBeginningOfMethodIfRequired();
        this.cv.visitAttribute(attribute);
    }

    public void weaveAttributesIfRequired(int n, String string, String string2, String string3) {
        AttributeDetails attributeDetails = this.tcw.classDetails.getAttributeDetailsFromClassOrSuperClass(string2);
        if (attributeDetails == null || !attributeDetails.hasField() || !this.tcw.classDetails.isInMetadataHierarchy(string)) {
            super.visitFieldInsn(n, string, string2, string3);
            return;
        }
        if (n == 180) {
            if (attributeDetails.weaveValueHolders() || this.tcw.classDetails.shouldWeaveFetchGroups()) {
                this.cv.visitMethodInsn(182, this.tcw.classDetails.getClassName(), "_persistence_get" + string2, "()" + attributeDetails.getReferenceClassType().getDescriptor());
            } else {
                super.visitFieldInsn(n, string, string2, string3);
            }
        } else if (n == 181) {
            if (attributeDetails.weaveValueHolders() || this.tcw.classDetails.shouldWeaveChangeTracking() || this.tcw.classDetails.shouldWeaveFetchGroups()) {
                this.cv.visitMethodInsn(182, this.tcw.classDetails.getClassName(), "_persistence_set" + string2, "(" + attributeDetails.getReferenceClassType().getDescriptor() + ")V");
            } else {
                super.visitFieldInsn(n, string, string2, string3);
            }
        } else {
            super.visitFieldInsn(n, string, string2, string3);
        }
    }

    public void weaveBeginningOfMethodIfRequired() {
        boolean bl;
        if (this.methodStarted) {
            return;
        }
        this.methodStarted = true;
        AttributeDetails attributeDetails = (AttributeDetails)this.tcw.classDetails.getGetterMethodToAttributeDetails().get(this.methodName);
        boolean bl2 = bl = attributeDetails != null && this.methodDescriptor.startsWith("()");
        if (bl && !attributeDetails.hasField()) {
            if (this.tcw.classDetails.shouldWeaveFetchGroups()) {
                this.cv.visitVarInsn(25, 0);
                this.cv.visitLdcInsn((Object)attributeDetails.getAttributeName());
                this.cv.visitMethodInsn(182, this.tcw.classDetails.getClassName(), "_persistence_checkFetched", "(Ljava/lang/String;)V");
            }
            if (attributeDetails.weaveValueHolders()) {
                this.cv.visitVarInsn(25, 0);
                this.cv.visitMethodInsn(182, this.tcw.classDetails.getClassName(), "_persistence_initialize_" + attributeDetails.getAttributeName() + "_vh", "()V");
                this.cv.visitVarInsn(25, 0);
                this.cv.visitFieldInsn(180, this.tcw.classDetails.getClassName(), "_persistence_" + attributeDetails.getAttributeName() + "_vh", "Lorg/eclipse/persistence/indirection/WeavedAttributeValueHolderInterface;");
                this.cv.visitMethodInsn(185, "org/eclipse/persistence/indirection/WeavedAttributeValueHolderInterface", "isInstantiated", "()Z");
                Label label = new Label();
                this.cv.visitJumpInsn(154, label);
                if (this.tcw.classDetails.shouldWeaveChangeTracking()) {
                    this.cv.visitVarInsn(25, 0);
                    this.cv.visitFieldInsn(180, this.tcw.classDetails.getClassName(), "_persistence_listener", "Ljava/beans/PropertyChangeListener;");
                    this.cv.visitVarInsn(58, 4);
                    this.cv.visitVarInsn(25, 0);
                    this.cv.visitInsn(1);
                    this.cv.visitFieldInsn(181, this.tcw.classDetails.getClassName(), "_persistence_listener", "Ljava/beans/PropertyChangeListener;");
                }
                this.cv.visitVarInsn(25, 0);
                this.cv.visitVarInsn(25, 0);
                this.cv.visitFieldInsn(180, this.tcw.classDetails.getClassName(), "_persistence_" + attributeDetails.getAttributeName() + "_vh", "Lorg/eclipse/persistence/indirection/WeavedAttributeValueHolderInterface;");
                this.cv.visitMethodInsn(185, "org/eclipse/persistence/indirection/WeavedAttributeValueHolderInterface", "getValue", "()Ljava/lang/Object;");
                this.cv.visitTypeInsn(192, attributeDetails.getReferenceClassName().replace('.', '/'));
                this.cv.visitMethodInsn(182, this.tcw.classDetails.getClassName(), attributeDetails.getSetterMethodName(), "(" + attributeDetails.getReferenceClassType().getDescriptor() + ")V");
                if (this.tcw.classDetails.shouldWeaveChangeTracking()) {
                    this.cv.visitVarInsn(25, 0);
                    this.cv.visitVarInsn(25, 4);
                    this.cv.visitFieldInsn(181, this.tcw.classDetails.getClassName(), "_persistence_listener", "Ljava/beans/PropertyChangeListener;");
                }
                this.cv.visitLabel(label);
            }
        } else {
            boolean bl3;
            attributeDetails = (AttributeDetails)this.tcw.classDetails.getSetterMethodToAttributeDetails().get(this.methodName);
            boolean bl4 = bl3 = attributeDetails != null && this.methodDescriptor.equals(attributeDetails.getSetterMethodSignature());
            if (bl3 && !attributeDetails.hasField() && this.tcw.classDetails.shouldWeaveChangeTracking()) {
                String string = ClassWeaver.wrapperFor(attributeDetails.getReferenceClassType().getSort());
                if (string != null) {
                    this.cv.visitTypeInsn(187, string);
                    this.cv.visitInsn(89);
                }
                this.cv.visitVarInsn(25, 0);
                this.cv.visitMethodInsn(182, this.tcw.classDetails.getClassName(), attributeDetails.getGetterMethodName(), "()" + attributeDetails.getReferenceClassType().getDescriptor());
                if (string != null) {
                    this.cv.visitMethodInsn(183, string, "<init>", "(" + attributeDetails.getReferenceClassType().getDescriptor() + ")V");
                    this.cv.visitVarInsn(58, 3);
                } else {
                    this.cv.visitVarInsn(58, 2);
                }
            }
        }
    }

    public void weaveEndOfMethodIfRequired() {
        boolean bl;
        AttributeDetails attributeDetails = (AttributeDetails)this.tcw.classDetails.getSetterMethodToAttributeDetails().get(this.methodName);
        boolean bl2 = bl = attributeDetails != null && this.methodDescriptor.equals(attributeDetails.getSetterMethodSignature());
        if (bl && !attributeDetails.hasField()) {
            if (attributeDetails.weaveValueHolders()) {
                if (this.tcw.classDetails.shouldWeaveChangeTracking()) {
                    this.cv.visitVarInsn(25, 0);
                    this.cv.visitLdcInsn((Object)attributeDetails.getAttributeName());
                    this.cv.visitVarInsn(25, 2);
                    this.cv.visitVarInsn(25, 1);
                    this.cv.visitMethodInsn(182, this.tcw.classDetails.getClassName(), "_persistence_propertyChange", "(Ljava/lang/String;Ljava/lang/Object;Ljava/lang/Object;)V");
                }
                this.cv.visitVarInsn(25, 0);
                this.cv.visitMethodInsn(182, this.tcw.classDetails.getClassName(), "_persistence_initialize_" + attributeDetails.getAttributeName() + "_vh", "()V");
                this.cv.visitVarInsn(25, 0);
                this.cv.visitFieldInsn(180, this.tcw.classDetails.getClassName(), "_persistence_" + attributeDetails.getAttributeName() + "_vh", "Lorg/eclipse/persistence/indirection/WeavedAttributeValueHolderInterface;");
                this.cv.visitVarInsn(25, 1);
                this.cv.visitMethodInsn(185, "org/eclipse/persistence/indirection/WeavedAttributeValueHolderInterface", "setValue", "(Ljava/lang/Object;)V");
                this.cv.visitVarInsn(25, 0);
                this.cv.visitFieldInsn(180, this.tcw.classDetails.getClassName(), "_persistence_" + attributeDetails.getAttributeName() + "_vh", "Lorg/eclipse/persistence/indirection/WeavedAttributeValueHolderInterface;");
                this.cv.visitInsn(4);
                this.cv.visitMethodInsn(185, "org/eclipse/persistence/indirection/WeavedAttributeValueHolderInterface", "setIsCoordinatedWithProperty", "(Z)V");
            } else if (this.tcw.classDetails.shouldWeaveChangeTracking()) {
                this.cv.visitVarInsn(25, 0);
                this.cv.visitLdcInsn((Object)attributeDetails.getAttributeName());
                String string = ClassWeaver.wrapperFor(attributeDetails.getReferenceClassType().getSort());
                int n = attributeDetails.getReferenceClassType().getOpcode(21);
                if (string != null) {
                    this.cv.visitVarInsn(25, 3);
                    this.cv.visitTypeInsn(187, string);
                    this.cv.visitInsn(89);
                } else {
                    this.cv.visitVarInsn(25, 2);
                }
                this.cv.visitVarInsn(n, 1);
                if (string != null) {
                    this.cv.visitMethodInsn(183, string, "<init>", "(" + attributeDetails.getReferenceClassType().getDescriptor() + ")V");
                }
                this.cv.visitMethodInsn(182, this.tcw.classDetails.getClassName(), "_persistence_propertyChange", "(Ljava/lang/String;Ljava/lang/Object;Ljava/lang/Object;)V");
            }
        }
    }
}

