/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.logging;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.FieldPosition;
import java.text.MessageFormat;
import java.util.Date;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.SimpleFormatter;
import org.eclipse.persistence.internal.security.PrivilegedAccessHelper;
import org.eclipse.persistence.logging.EclipseLinkLogRecord;

public class LogFormatter
extends SimpleFormatter {
    Date dat = new Date();
    private static final String format = "{0,date} {0,time}";
    private MessageFormat formatter;
    private Object[] args = new Object[1];
    private String lineSeparator = PrivilegedAccessHelper.getLineSeparator();

    public synchronized String format(LogRecord logRecord) {
        CharSequence charSequence;
        if (!(logRecord instanceof EclipseLinkLogRecord)) {
            return super.format(logRecord);
        }
        EclipseLinkLogRecord eclipseLinkLogRecord = (EclipseLinkLogRecord)logRecord;
        StringBuffer stringBuffer = new StringBuffer();
        if (eclipseLinkLogRecord.shouldPrintDate()) {
            this.dat.setTime(eclipseLinkLogRecord.getMillis());
            this.args[0] = this.dat;
            charSequence = new StringBuffer();
            if (this.formatter == null) {
                this.formatter = new MessageFormat(format);
            }
            this.formatter.format(this.args, (StringBuffer)charSequence, (FieldPosition)null);
            stringBuffer.append((StringBuffer)charSequence);
            stringBuffer.append(" ");
        }
        if (eclipseLinkLogRecord.getSourceClassName() != null) {
            stringBuffer.append(eclipseLinkLogRecord.getSourceClassName());
        } else {
            stringBuffer.append(eclipseLinkLogRecord.getLoggerName());
        }
        if (eclipseLinkLogRecord.getSourceMethodName() != null) {
            stringBuffer.append(" ");
            stringBuffer.append(eclipseLinkLogRecord.getSourceMethodName());
        }
        if (eclipseLinkLogRecord.getSessionString() != null) {
            stringBuffer.append(" ");
            stringBuffer.append(eclipseLinkLogRecord.getSessionString());
        }
        if (eclipseLinkLogRecord.getConnection() != null) {
            stringBuffer.append(" ");
            stringBuffer.append("Connection(" + String.valueOf(System.identityHashCode(eclipseLinkLogRecord.getConnection())) + ")");
        }
        if (eclipseLinkLogRecord.shouldPrintThread()) {
            stringBuffer.append(" ");
            stringBuffer.append("Thread(" + String.valueOf(eclipseLinkLogRecord.getThreadID()) + ")");
        }
        stringBuffer.append(this.lineSeparator);
        charSequence = this.formatMessage(eclipseLinkLogRecord);
        stringBuffer.append(eclipseLinkLogRecord.getLevel().getLocalizedName());
        stringBuffer.append(": ");
        stringBuffer.append((String)charSequence);
        stringBuffer.append(this.lineSeparator);
        if (eclipseLinkLogRecord.getThrown() != null) {
            try {
                StringWriter stringWriter = new StringWriter();
                PrintWriter printWriter = new PrintWriter(stringWriter);
                if (eclipseLinkLogRecord.getLevel().intValue() == Level.SEVERE.intValue()) {
                    eclipseLinkLogRecord.getThrown().printStackTrace(printWriter);
                } else if (eclipseLinkLogRecord.getLevel().intValue() <= Level.WARNING.intValue()) {
                    if (eclipseLinkLogRecord.shouldLogExceptionStackTrace()) {
                        eclipseLinkLogRecord.getThrown().printStackTrace(printWriter);
                    } else {
                        printWriter.write(eclipseLinkLogRecord.getThrown().toString());
                        printWriter.write(this.lineSeparator);
                    }
                }
                printWriter.close();
                stringBuffer.append(stringWriter.toString());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return stringBuffer.toString();
    }
}

