/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.mappings;

import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.eclipse.persistence.exceptions.ConversionException;
import org.eclipse.persistence.exceptions.DatabaseException;
import org.eclipse.persistence.exceptions.DescriptorException;
import org.eclipse.persistence.exceptions.OptimisticLockException;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.history.AsOfClause;
import org.eclipse.persistence.history.HistoryPolicy;
import org.eclipse.persistence.internal.databaseaccess.DatasourcePlatform;
import org.eclipse.persistence.internal.databaseaccess.Platform;
import org.eclipse.persistence.internal.expressions.DataExpression;
import org.eclipse.persistence.internal.expressions.ObjectExpression;
import org.eclipse.persistence.internal.expressions.QueryKeyExpression;
import org.eclipse.persistence.internal.expressions.SQLDeleteStatement;
import org.eclipse.persistence.internal.expressions.SQLInsertStatement;
import org.eclipse.persistence.internal.expressions.SQLModifyStatement;
import org.eclipse.persistence.internal.expressions.SQLStatement;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.helper.DatabaseTable;
import org.eclipse.persistence.internal.helper.NonSynchronizedVector;
import org.eclipse.persistence.internal.identitymaps.CacheKey;
import org.eclipse.persistence.internal.queries.ContainerPolicy;
import org.eclipse.persistence.internal.sessions.AbstractRecord;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.internal.sessions.ObjectChangeSet;
import org.eclipse.persistence.internal.sessions.UnitOfWorkChangeSet;
import org.eclipse.persistence.internal.sessions.UnitOfWorkImpl;
import org.eclipse.persistence.mappings.CollectionMapping;
import org.eclipse.persistence.mappings.RelationalMapping;
import org.eclipse.persistence.mappings.foundation.MapComponentMapping;
import org.eclipse.persistence.queries.Call;
import org.eclipse.persistence.queries.ComplexQueryResult;
import org.eclipse.persistence.queries.DataModifyQuery;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.DeleteObjectQuery;
import org.eclipse.persistence.queries.InsertObjectQuery;
import org.eclipse.persistence.queries.ObjectBuildingQuery;
import org.eclipse.persistence.queries.ObjectLevelModifyQuery;
import org.eclipse.persistence.queries.ObjectLevelReadQuery;
import org.eclipse.persistence.queries.ReadAllQuery;
import org.eclipse.persistence.queries.ReadQuery;
import org.eclipse.persistence.queries.WriteObjectQuery;
import org.eclipse.persistence.sessions.DatabaseRecord;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ManyToManyMapping
extends CollectionMapping
implements RelationalMapping,
MapComponentMapping {
    protected static final String PostInsert = "postInsert";
    protected static final String ObjectRemoved = "objectRemoved";
    protected static final String ObjectAdded = "objectAdded";
    protected transient DatabaseTable relationTable;
    protected transient Vector<DatabaseField> sourceKeyFields;
    protected transient Vector<DatabaseField> targetKeyFields;
    protected transient Vector<DatabaseField> sourceRelationKeyFields;
    protected transient Vector<DatabaseField> targetRelationKeyFields;
    protected transient DataModifyQuery deleteQuery;
    protected transient boolean hasCustomDeleteQuery = false;
    protected transient DataModifyQuery insertQuery = new DataModifyQuery();
    protected transient boolean hasCustomInsertQuery = false;
    protected HistoryPolicy historyPolicy;

    public ManyToManyMapping() {
        this.deleteQuery = new DataModifyQuery();
        this.sourceRelationKeyFields = NonSynchronizedVector.newInstance(1);
        this.targetRelationKeyFields = NonSynchronizedVector.newInstance(1);
        this.sourceKeyFields = NonSynchronizedVector.newInstance(1);
        this.targetKeyFields = NonSynchronizedVector.newInstance(1);
    }

    @Override
    public boolean isRelationalMapping() {
        return true;
    }

    public void addSourceRelationKeyField(DatabaseField databaseField, DatabaseField databaseField2) {
        this.getSourceRelationKeyFields().addElement(databaseField);
        this.getSourceKeyFields().addElement(databaseField2);
    }

    public void addSourceRelationKeyFieldName(String string, String string2) {
        this.addSourceRelationKeyField(new DatabaseField(string), new DatabaseField(string2));
    }

    public void addTargetRelationKeyField(DatabaseField databaseField, DatabaseField databaseField2) {
        this.getTargetRelationKeyFields().addElement(databaseField);
        this.getTargetKeyFields().addElement(databaseField2);
    }

    public void addTargetRelationKeyFieldName(String string, String string2) {
        this.addTargetRelationKeyField(new DatabaseField(string), new DatabaseField(string2));
    }

    @Override
    public Object clone() {
        ManyToManyMapping manyToManyMapping = (ManyToManyMapping)super.clone();
        manyToManyMapping.setTargetKeyFields(this.cloneFields(this.getTargetKeyFields()));
        manyToManyMapping.setSourceKeyFields(this.cloneFields(this.getSourceKeyFields()));
        manyToManyMapping.setTargetRelationKeyFields(this.cloneFields(this.getTargetRelationKeyFields()));
        manyToManyMapping.setSourceRelationKeyFields(this.cloneFields(this.getSourceRelationKeyFields()));
        return manyToManyMapping;
    }

    @Override
    public Object createMapComponentFromRow(AbstractRecord abstractRecord, ObjectBuildingQuery objectBuildingQuery, AbstractSession abstractSession) {
        return abstractSession.executeQuery((DatabaseQuery)this.getSelectionQuery(), abstractRecord);
    }

    protected Vector extractKeyFromRelationRow(AbstractRecord abstractRecord, AbstractSession abstractSession) {
        Vector<Object> vector = new Vector<Object>(this.getSourceRelationKeyFields().size());
        for (int i = 0; i < this.getSourceRelationKeyFields().size(); ++i) {
            DatabaseField databaseField = this.getSourceRelationKeyFields().elementAt(i);
            DatabaseField databaseField2 = this.getSourceKeyFields().elementAt(i);
            Object object = abstractRecord.get(databaseField);
            try {
                object = abstractSession.getDatasourcePlatform().getConversionManager().convertObject(object, this.getDescriptor().getObjectBuilder().getFieldClassification(databaseField2));
            }
            catch (ConversionException conversionException) {
                throw ConversionException.couldNotBeConverted((Object)this, this.getDescriptor(), conversionException);
            }
            vector.addElement(object);
        }
        return vector;
    }

    protected Vector extractPrimaryKeyFromRow(AbstractRecord abstractRecord, AbstractSession abstractSession) {
        Vector<Object> vector = new Vector<Object>(this.getSourceKeyFields().size());
        Enumeration<DatabaseField> enumeration = this.getSourceKeyFields().elements();
        while (enumeration.hasMoreElements()) {
            DatabaseField databaseField = enumeration.nextElement();
            Object object = abstractRecord.get(databaseField);
            try {
                object = abstractSession.getDatasourcePlatform().getConversionManager().convertObject(object, this.getDescriptor().getObjectBuilder().getFieldClassification(databaseField));
            }
            catch (ConversionException conversionException) {
                throw ConversionException.couldNotBeConverted((Object)this, this.getDescriptor(), conversionException);
            }
            vector.addElement(object);
        }
        return vector;
    }

    @Override
    protected void postPrepareNestedBatchQuery(ReadQuery readQuery, ReadAllQuery readAllQuery) {
        ReadAllQuery readAllQuery2 = (ReadAllQuery)readQuery;
        readAllQuery2.setShouldIncludeData(true);
        Object object = this.getSourceRelationKeyFields().elements();
        while (object.hasMoreElements()) {
            readAllQuery2.getAdditionalFields().addElement(readAllQuery2.getExpressionBuilder().getTable(this.getRelationTable()).getField((DatabaseField)object.nextElement()));
        }
        if (this.getHistoryPolicy() != null) {
            object = readAllQuery2.getExpressionBuilder();
            Expression expression = readQuery.getSelectionCriteria();
            if (readAllQuery.getSession().getAsOfClause() != null) {
                ((DataExpression)object).asOf(readAllQuery.getSession().getAsOfClause());
            } else if (((DataExpression)object).getAsOfClause() == null) {
                ((DataExpression)object).asOf(AsOfClause.NO_CLAUSE);
            }
            expression = expression.and(this.getHistoryPolicy().additionalHistoryExpression((ObjectExpression)object));
            readAllQuery2.setSelectionCriteria(expression);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object extractResultFromBatchQuery(DatabaseQuery databaseQuery, AbstractRecord abstractRecord, AbstractSession abstractSession, AbstractRecord abstractRecord2) {
        Hashtable<CacheKey, Object> hashtable = null;
        ContainerPolicy containerPolicy = this.getContainerPolicy();
        DatabaseQuery databaseQuery2 = databaseQuery;
        synchronized (databaseQuery2) {
            hashtable = this.getBatchReadObjects(databaseQuery, abstractSession);
            containerPolicy = this.getContainerPolicy();
            if (hashtable == null) {
                ReadAllQuery readAllQuery = (ReadAllQuery)databaseQuery;
                ComplexQueryResult complexQueryResult = (ComplexQueryResult)abstractSession.executeQuery((DatabaseQuery)readAllQuery, abstractRecord2);
                Object object = complexQueryResult.getResult();
                hashtable = new Hashtable<CacheKey, Object>();
                Enumeration enumeration = ((Vector)complexQueryResult.getData()).elements();
                ContainerPolicy containerPolicy2 = readAllQuery.getContainerPolicy();
                Object object2 = containerPolicy2.iteratorFor(object);
                while (containerPolicy2.hasNext(object2)) {
                    Object object3 = containerPolicy2.next(object2, abstractSession);
                    CacheKey cacheKey = new CacheKey(this.extractKeyFromRelationRow((AbstractRecord)enumeration.nextElement(), abstractSession));
                    if (!hashtable.containsKey(cacheKey)) {
                        hashtable.put(cacheKey, containerPolicy.containerInstance());
                    }
                    containerPolicy.addInto(object3, hashtable.get(cacheKey), abstractSession);
                }
                this.setBatchReadObjects(hashtable, databaseQuery, abstractSession);
            }
        }
        databaseQuery2 = hashtable.get(new CacheKey(this.extractPrimaryKeyFromRow(abstractRecord, abstractSession)));
        if (databaseQuery2 == null) {
            return containerPolicy.containerInstance();
        }
        return databaseQuery2;
    }

    protected DataModifyQuery getDeleteQuery() {
        return this.deleteQuery;
    }

    protected DataModifyQuery getInsertQuery() {
        return this.insertQuery;
    }

    @Override
    public Expression getJoinCriteria(QueryKeyExpression queryKeyExpression) {
        if (this.getHistoryPolicy() != null) {
            Expression expression = super.getJoinCriteria(queryKeyExpression);
            Expression expression2 = this.getHistoryPolicy().additionalHistoryExpression(queryKeyExpression);
            if (expression != null) {
                return expression.and(expression2);
            }
            if (expression2 != null) {
                return expression2;
            }
            return null;
        }
        return super.getJoinCriteria(queryKeyExpression);
    }

    public HistoryPolicy getHistoryPolicy() {
        return this.historyPolicy;
    }

    public DatabaseTable getRelationTable() {
        return this.relationTable;
    }

    public String getRelationTableName() {
        if (this.relationTable == null) {
            return null;
        }
        return this.relationTable.getName();
    }

    public String getRelationTableQualifiedName() {
        if (this.relationTable == null) {
            return null;
        }
        return this.relationTable.getQualifiedName();
    }

    @Override
    public Expression getSelectionCriteria() {
        return this.getSelectionQuery().getSelectionCriteria();
    }

    @Override
    public ReadQuery getSelectionQuery() {
        return this.selectionQuery;
    }

    public Vector getSourceKeyFieldNames() {
        Vector<String> vector = new Vector<String>(this.getSourceKeyFields().size());
        Enumeration<DatabaseField> enumeration = this.getSourceKeyFields().elements();
        while (enumeration.hasMoreElements()) {
            vector.addElement(enumeration.nextElement().getQualifiedName());
        }
        return vector;
    }

    public Vector<DatabaseField> getSourceKeyFields() {
        return this.sourceKeyFields;
    }

    public Vector getSourceRelationKeyFieldNames() {
        Vector<String> vector = new Vector<String>(this.getSourceRelationKeyFields().size());
        Enumeration<DatabaseField> enumeration = this.getSourceRelationKeyFields().elements();
        while (enumeration.hasMoreElements()) {
            vector.addElement(enumeration.nextElement().getQualifiedName());
        }
        return vector;
    }

    public Vector<DatabaseField> getSourceRelationKeyFields() {
        return this.sourceRelationKeyFields;
    }

    public Vector getTargetKeyFieldNames() {
        Vector<String> vector = new Vector<String>(this.getTargetKeyFields().size());
        Enumeration<DatabaseField> enumeration = this.getTargetKeyFields().elements();
        while (enumeration.hasMoreElements()) {
            vector.addElement(enumeration.nextElement().getQualifiedName());
        }
        return vector;
    }

    public Vector<DatabaseField> getTargetKeyFields() {
        return this.targetKeyFields;
    }

    public Vector getTargetRelationKeyFieldNames() {
        Vector<String> vector = new Vector<String>(this.getTargetRelationKeyFields().size());
        Enumeration<DatabaseField> enumeration = this.getTargetRelationKeyFields().elements();
        while (enumeration.hasMoreElements()) {
            vector.addElement(enumeration.nextElement().getQualifiedName());
        }
        return vector;
    }

    public Vector<DatabaseField> getTargetRelationKeyFields() {
        return this.targetRelationKeyFields;
    }

    protected boolean hasCustomDeleteQuery() {
        return this.hasCustomDeleteQuery;
    }

    protected boolean hasCustomInsertQuery() {
        return this.hasCustomInsertQuery;
    }

    @Override
    public boolean hasDependency() {
        return this.isPrivateOwned() || !this.isReadOnly();
    }

    @Override
    public void initialize(AbstractSession abstractSession) throws DescriptorException {
        super.initialize(abstractSession);
        this.initializeRelationTable(abstractSession);
        this.initializeSourceRelationKeys(abstractSession);
        this.initializeTargetRelationKeys(abstractSession);
        if (this.isSingleSourceRelationKeySpecified()) {
            this.initializeSourceKeysWithDefaults(abstractSession);
        } else {
            this.initializeSourceKeys(abstractSession);
        }
        if (this.isSingleTargetRelationKeySpecified()) {
            this.initializeTargetKeysWithDefaults(abstractSession);
        } else {
            this.initializeTargetKeys(abstractSession);
        }
        if (this.getRelationTable().getName().indexOf(32) != -1) {
            String string = ((DatasourcePlatform)abstractSession.getDatasourcePlatform()).getIdentifierQuoteCharacter();
            if (this.getRelationTable().getName().indexOf(string) == -1) {
                this.getRelationTable().setName(string + this.getRelationTable().getName() + string);
            }
        }
        this.getContainerPolicy().initialize(abstractSession, this.getRelationTable());
        if (this.shouldInitializeSelectionCriteria()) {
            if (this.shouldForceInitializationOfSelectionCriteria()) {
                this.initializeSelectionCriteriaAndAddFieldsToQuery(abstractSession, null);
            } else {
                this.initializeSelectionCriteriaAndAddFieldsToQuery(abstractSession, this.getSelectionCriteria());
            }
        }
        if (!this.getSelectionQuery().hasSessionName()) {
            this.getSelectionQuery().setSessionName(abstractSession.getName());
        }
        this.initializeDeleteAllQuery(abstractSession);
        this.initializeInsertQuery(abstractSession);
        this.initializeDeleteQuery(abstractSession);
        if (this.getHistoryPolicy() != null) {
            this.getHistoryPolicy().initialize(abstractSession);
        }
        if (this.getReferenceDescriptor() != null && this.getReferenceDescriptor().hasTablePerClassPolicy()) {
            this.getReferenceDescriptor().getTablePerClassPolicy().prepareChildrenSelectionQuery(this, abstractSession);
        }
    }

    protected void initializeDeleteAllQuery(AbstractSession abstractSession) {
        if (!this.getDeleteAllQuery().hasSessionName()) {
            this.getDeleteAllQuery().setSessionName(abstractSession.getName());
        }
        if (this.hasCustomDeleteAllQuery()) {
            return;
        }
        Expression expression = null;
        ExpressionBuilder expressionBuilder = new ExpressionBuilder();
        SQLDeleteStatement sQLDeleteStatement = new SQLDeleteStatement();
        for (int i = 0; i < this.getSourceRelationKeyFields().size(); ++i) {
            DatabaseField databaseField = this.getSourceRelationKeyFields().elementAt(i);
            DatabaseField databaseField2 = this.getSourceKeyFields().elementAt(i);
            Expression expression2 = ((Expression)expressionBuilder).getField(databaseField).equal(expressionBuilder.getParameter(databaseField2));
            expression = expression2.and(expression);
        }
        sQLDeleteStatement.setWhereClause(expression);
        sQLDeleteStatement.setTable(this.getRelationTable());
        this.getDeleteAllQuery().setSQLStatement(sQLDeleteStatement);
    }

    protected void initializeDeleteQuery(AbstractSession abstractSession) {
        Expression expression;
        Cloneable cloneable;
        if (!this.getDeleteQuery().hasSessionName()) {
            this.getDeleteQuery().setSessionName(abstractSession.getName());
        }
        if (this.hasCustomDeleteQuery()) {
            return;
        }
        Expression expression2 = null;
        ExpressionBuilder expressionBuilder = new ExpressionBuilder();
        Enumeration<DatabaseField> enumeration = this.getSourceRelationKeyFields().elements();
        while (enumeration.hasMoreElements()) {
            cloneable = enumeration.nextElement();
            expression = ((Expression)expressionBuilder).getField((DatabaseField)cloneable).equal(expressionBuilder.getParameter((DatabaseField)cloneable));
            expression2 = expression.and(expression2);
        }
        enumeration = this.getTargetRelationKeyFields().elements();
        while (enumeration.hasMoreElements()) {
            cloneable = enumeration.nextElement();
            expression = ((Expression)expressionBuilder).getField((DatabaseField)cloneable).equal(expressionBuilder.getParameter((DatabaseField)cloneable));
            expression2 = expression.and(expression2);
        }
        cloneable = new SQLDeleteStatement();
        ((SQLModifyStatement)cloneable).setTable(this.getRelationTable());
        ((SQLStatement)cloneable).setWhereClause(expression2);
        this.getDeleteQuery().setSQLStatement((SQLStatement)cloneable);
    }

    protected void initializeInsertQuery(AbstractSession abstractSession) {
        if (!this.getInsertQuery().hasSessionName()) {
            this.getInsertQuery().setSessionName(abstractSession.getName());
        }
        if (this.hasCustomInsertQuery()) {
            return;
        }
        SQLInsertStatement sQLInsertStatement = new SQLInsertStatement();
        sQLInsertStatement.setTable(this.getRelationTable());
        DatabaseRecord databaseRecord = new DatabaseRecord();
        Enumeration<DatabaseField> enumeration = this.getTargetRelationKeyFields().elements();
        while (enumeration.hasMoreElements()) {
            databaseRecord.put(enumeration.nextElement(), (Object)null);
        }
        enumeration = this.getSourceRelationKeyFields().elements();
        while (enumeration.hasMoreElements()) {
            databaseRecord.put(enumeration.nextElement(), (Object)null);
        }
        this.getContainerPolicy().addFieldsForMapKey(databaseRecord);
        sQLInsertStatement.setModifyRow(databaseRecord);
        this.getInsertQuery().setSQLStatement(sQLInsertStatement);
        this.getInsertQuery().setModifyRow(databaseRecord);
    }

    protected void initializeRelationTable(AbstractSession abstractSession) throws DescriptorException {
        Platform platform = abstractSession.getDatasourcePlatform();
        if (this.getRelationTable() == null || this.getRelationTableName().length() == 0) {
            throw DescriptorException.noRelationTable(this);
        }
        if (platform.getTableQualifier().length() > 0 && this.getRelationTable().getTableQualifier().length() == 0) {
            this.getRelationTable().setTableQualifier(platform.getTableQualifier());
        }
    }

    protected void initializeSelectionCriteria(AbstractSession abstractSession) {
        this.initializeSelectionCriteriaAndAddFieldsToQuery(abstractSession, this.getSelectionCriteria());
    }

    protected void initializeSelectionCriteriaAndAddFieldsToQuery(AbstractSession abstractSession, Expression expression) {
        Expression expression2;
        Expression expression3;
        Expression expression4;
        DatabaseField databaseField;
        Expression expression5 = expression;
        ExpressionBuilder expressionBuilder = new ExpressionBuilder();
        Expression expression6 = null;
        Enumeration<DatabaseField> enumeration = this.getTargetKeyFields().elements();
        Enumeration<DatabaseField> enumeration2 = this.getTargetRelationKeyFields().elements();
        while (enumeration.hasMoreElements()) {
            databaseField = enumeration2.nextElement();
            DatabaseField databaseField2 = enumeration.nextElement();
            if (expression6 == null) {
                expression6 = ((Expression)expressionBuilder).getTable(databaseField.getTable());
            }
            expression4 = ((Expression)expressionBuilder).getField(databaseField2);
            expression3 = expression6.getField(databaseField);
            expression2 = expression4.equal(expression3);
            expression5 = expression5 == null ? expression2 : expression2.and(expression5);
            this.setSelectionCriteria(expression5);
        }
        enumeration2 = this.getSourceRelationKeyFields().elements();
        Enumeration<DatabaseField> enumeration3 = this.getSourceKeyFields().elements();
        while (enumeration2.hasMoreElements()) {
            databaseField = enumeration2.nextElement();
            DatabaseField databaseField3 = enumeration3.nextElement();
            expression4 = expression6.getField(databaseField);
            expression3 = expressionBuilder.getParameter(databaseField3);
            expression2 = expression4.equal(expression3);
            expression5 = expression5 == null ? expression2 : expression2.and(expression5);
            this.getContainerPolicy().addAdditionalFieldsToQuery(this.getSelectionQuery(), expression6);
            this.setSelectionCriteria(expression5);
        }
    }

    protected void initializeSourceKeys(AbstractSession abstractSession) {
        for (int i = 0; i < this.getSourceKeyFields().size(); ++i) {
            DatabaseField databaseField = this.getDescriptor().buildField(this.getSourceKeyFields().get(i));
            this.getSourceKeyFields().set(i, databaseField);
        }
    }

    protected void initializeSourceKeysWithDefaults(AbstractSession abstractSession) {
        List<DatabaseField> list = this.getDescriptor().getPrimaryKeyFields();
        for (int i = 0; i < list.size(); ++i) {
            this.getSourceKeyFields().addElement(list.get(i));
        }
    }

    protected void initializeSourceRelationKeys(AbstractSession abstractSession) throws DescriptorException {
        if (this.getSourceRelationKeyFields().size() == 0) {
            throw DescriptorException.noSourceRelationKeysSpecified(this);
        }
        Enumeration<DatabaseField> enumeration = this.getSourceRelationKeyFields().elements();
        while (enumeration.hasMoreElements()) {
            DatabaseField databaseField = enumeration.nextElement();
            if (databaseField.hasTableName() && !databaseField.getTableName().equals(this.getRelationTable().getName())) {
                throw DescriptorException.relationKeyFieldNotProperlySpecified(databaseField, this);
            }
            databaseField.setTable(this.getRelationTable());
        }
    }

    protected void initializeTargetKeys(AbstractSession abstractSession) {
        for (int i = 0; i < this.getTargetKeyFields().size(); ++i) {
            DatabaseField databaseField = this.getReferenceDescriptor().buildField(this.getTargetKeyFields().get(i));
            this.getTargetKeyFields().set(i, databaseField);
        }
    }

    protected void initializeTargetKeysWithDefaults(AbstractSession abstractSession) {
        List<DatabaseField> list = this.getReferenceDescriptor().getPrimaryKeyFields();
        for (int i = 0; i < list.size(); ++i) {
            this.getTargetKeyFields().addElement(list.get(i));
        }
    }

    protected void initializeTargetRelationKeys(AbstractSession abstractSession) {
        if (this.getTargetRelationKeyFields().size() == 0) {
            throw DescriptorException.noTargetRelationKeysSpecified(this);
        }
        Enumeration<DatabaseField> enumeration = this.getTargetRelationKeyFields().elements();
        while (enumeration.hasMoreElements()) {
            DatabaseField databaseField = enumeration.nextElement();
            if (databaseField.hasTableName() && !databaseField.getTableName().equals(this.getRelationTable().getName())) {
                throw DescriptorException.relationKeyFieldNotProperlySpecified(databaseField, this);
            }
            databaseField.setTable(this.getRelationTable());
        }
    }

    protected void insertAddedObjectEntry(ObjectLevelModifyQuery objectLevelModifyQuery, Object object) throws DatabaseException, OptimisticLockException {
        Object object2;
        DatabaseField databaseField;
        DatabaseField databaseField2;
        int n;
        this.prepareTranslationRow(objectLevelModifyQuery.getTranslationRow(), objectLevelModifyQuery.getObject(), objectLevelModifyQuery.getSession());
        DatabaseRecord databaseRecord = new DatabaseRecord();
        for (n = 0; n < this.getSourceRelationKeyFields().size(); ++n) {
            databaseField2 = this.getSourceRelationKeyFields().elementAt(n);
            databaseField = this.getSourceKeyFields().elementAt(n);
            object2 = objectLevelModifyQuery.getTranslationRow().get(databaseField);
            databaseRecord.put(databaseField2, object2);
        }
        for (n = 0; n < this.getTargetRelationKeyFields().size(); ++n) {
            databaseField2 = this.getTargetRelationKeyFields().elementAt(n);
            databaseField = this.getTargetKeyFields().elementAt(n);
            object2 = this.getReferenceDescriptor().getObjectBuilder().extractValueFromObjectForField(this.containerPolicy.unwrapIteratorResult(object), databaseField, objectLevelModifyQuery.getSession());
            databaseRecord.put(databaseField2, object2);
        }
        ContainerPolicy.copyMapDataToRow(this.getContainerPolicy().getKeyMappingDataForWriteQuery(object, objectLevelModifyQuery.getSession()), databaseRecord);
        objectLevelModifyQuery.getSession().executeQuery((DatabaseQuery)this.getInsertQuery(), databaseRecord);
        if (this.getHistoryPolicy() != null && this.getHistoryPolicy().shouldHandleWrites()) {
            this.getHistoryPolicy().mappingLogicalInsert(this.getInsertQuery(), databaseRecord, objectLevelModifyQuery.getSession());
        }
    }

    public void insertIntoRelationTable(WriteObjectQuery writeObjectQuery) throws DatabaseException {
        Object object;
        Object object2;
        Object object3;
        if (this.isReadOnly()) {
            return;
        }
        ContainerPolicy containerPolicy = this.getContainerPolicy();
        if (containerPolicy.isEmpty(object3 = this.getRealCollectionAttributeValueFromObject(writeObjectQuery.getObject(), writeObjectQuery.getSession()))) {
            return;
        }
        this.prepareTranslationRow(writeObjectQuery.getTranslationRow(), writeObjectQuery.getObject(), writeObjectQuery.getSession());
        DatabaseRecord databaseRecord = new DatabaseRecord();
        for (int i = 0; i < this.getSourceRelationKeyFields().size(); ++i) {
            object2 = this.getSourceRelationKeyFields().elementAt(i);
            object = this.getSourceKeyFields().elementAt(i);
            Object object4 = writeObjectQuery.getTranslationRow().get((DatabaseField)object);
            databaseRecord.put((DatabaseField)object2, object4);
        }
        Object object5 = containerPolicy.iteratorFor(object3);
        while (containerPolicy.hasNext(object5)) {
            object2 = containerPolicy.nextEntry(object5, writeObjectQuery.getSession());
            object = containerPolicy.unwrapIteratorResult(object2);
            for (int i = 0; i < this.getTargetRelationKeyFields().size(); ++i) {
                DatabaseField databaseField = this.getTargetRelationKeyFields().elementAt(i);
                DatabaseField databaseField2 = this.getTargetKeyFields().elementAt(i);
                Object object6 = this.getReferenceDescriptor().getObjectBuilder().extractValueFromObjectForField(object, databaseField2, writeObjectQuery.getSession());
                databaseRecord.put(databaseField, object6);
            }
            ContainerPolicy.copyMapDataToRow(containerPolicy.getKeyMappingDataForWriteQuery(object2, writeObjectQuery.getSession()), databaseRecord);
            writeObjectQuery.getSession().executeQuery((DatabaseQuery)this.getInsertQuery(), databaseRecord);
            if (this.getHistoryPolicy() == null || !this.getHistoryPolicy().shouldHandleWrites()) continue;
            this.getHistoryPolicy().mappingLogicalInsert(this.getInsertQuery(), databaseRecord, writeObjectQuery.getSession());
        }
    }

    public void insertTargetObjects(WriteObjectQuery writeObjectQuery) throws DatabaseException, OptimisticLockException {
        if (!this.shouldObjectModifyCascadeToParts(writeObjectQuery)) {
            return;
        }
        if (writeObjectQuery.shouldCascadeOnlyDependentParts()) {
            return;
        }
        Object object = this.getRealCollectionAttributeValueFromObject(writeObjectQuery.getObject(), writeObjectQuery.getSession());
        ContainerPolicy containerPolicy = this.getContainerPolicy();
        if (containerPolicy.isEmpty(object)) {
            return;
        }
        Object object2 = containerPolicy.iteratorFor(object);
        while (containerPolicy.hasNext(object2)) {
            Serializable serializable;
            Object object3 = containerPolicy.next(object2, writeObjectQuery.getSession());
            if (this.isPrivateOwned()) {
                serializable = new InsertObjectQuery();
                serializable.setIsExecutionClone(true);
                serializable.setObject(object3);
                serializable.setCascadePolicy(writeObjectQuery.getCascadePolicy());
                writeObjectQuery.getSession().executeQuery((DatabaseQuery)serializable);
                continue;
            }
            serializable = null;
            UnitOfWorkChangeSet unitOfWorkChangeSet = null;
            if (writeObjectQuery.getSession().isUnitOfWork() && ((UnitOfWorkImpl)writeObjectQuery.getSession()).getUnitOfWorkChangeSet() != null) {
                unitOfWorkChangeSet = (UnitOfWorkChangeSet)((UnitOfWorkImpl)writeObjectQuery.getSession()).getUnitOfWorkChangeSet();
                serializable = (ObjectChangeSet)unitOfWorkChangeSet.getObjectChangeSetForClone(object3);
            }
            WriteObjectQuery writeObjectQuery2 = new WriteObjectQuery();
            writeObjectQuery2.setIsExecutionClone(true);
            writeObjectQuery2.setObject(object3);
            writeObjectQuery2.setObjectChangeSet((ObjectChangeSet)serializable);
            writeObjectQuery2.setCascadePolicy(writeObjectQuery.getCascadePolicy());
            writeObjectQuery.getSession().executeQuery(writeObjectQuery2);
        }
    }

    @Override
    public boolean isJoiningSupported() {
        return true;
    }

    @Override
    public boolean isManyToManyMapping() {
        return true;
    }

    protected boolean isSingleSourceRelationKeySpecified() {
        return this.getSourceKeyFields().isEmpty();
    }

    protected boolean isSingleTargetRelationKeySpecified() {
        return this.getTargetKeyFields().isEmpty();
    }

    @Override
    protected void objectAddedDuringUpdate(ObjectLevelModifyQuery objectLevelModifyQuery, Object object, ObjectChangeSet objectChangeSet, Map map) throws DatabaseException, OptimisticLockException {
        super.objectAddedDuringUpdate(objectLevelModifyQuery, object, objectChangeSet, map);
        if (objectLevelModifyQuery.shouldCascadeOnlyDependentParts()) {
            Object[] objectArray = new Object[]{ObjectAdded, objectLevelModifyQuery, object};
            objectLevelModifyQuery.getSession().getCommitManager().addDataModificationEvent(this, objectArray);
        } else {
            this.insertAddedObjectEntry(objectLevelModifyQuery, object);
        }
    }

    @Override
    protected void objectRemovedDuringUpdate(ObjectLevelModifyQuery objectLevelModifyQuery, Object object, Map map) throws DatabaseException, OptimisticLockException {
        Object object2;
        DatabaseField databaseField;
        DatabaseRecord databaseRecord = new DatabaseRecord();
        for (int i = 0; i < this.getSourceRelationKeyFields().size(); ++i) {
            DatabaseField databaseField2 = this.getSourceRelationKeyFields().elementAt(i);
            databaseField = this.getSourceKeyFields().elementAt(i);
            object2 = objectLevelModifyQuery.getTranslationRow().get(databaseField);
            databaseRecord.put(databaseField2, object2);
        }
        Object object3 = this.getContainerPolicy().unwrapIteratorResult(object);
        for (int i = 0; i < this.getTargetRelationKeyFields().size(); ++i) {
            databaseField = this.getTargetRelationKeyFields().elementAt(i);
            object2 = this.getTargetKeyFields().elementAt(i);
            Object object4 = this.getReferenceDescriptor().getObjectBuilder().extractValueFromObjectForField(object3, (DatabaseField)object2, objectLevelModifyQuery.getSession());
            databaseRecord.put(databaseField, object4);
        }
        if (objectLevelModifyQuery.shouldCascadeOnlyDependentParts()) {
            Object[] objectArray = new Object[]{ObjectRemoved, this.getDeleteQuery(), databaseRecord};
            objectLevelModifyQuery.getSession().getCommitManager().addDataModificationEvent(this, objectArray);
        } else {
            objectLevelModifyQuery.getSession().executeQuery((DatabaseQuery)this.getDeleteQuery(), databaseRecord);
            if (this.getHistoryPolicy() != null && this.getHistoryPolicy().shouldHandleWrites()) {
                this.getHistoryPolicy().mappingLogicalDelete(this.getDeleteQuery(), databaseRecord, objectLevelModifyQuery.getSession());
            }
        }
        super.objectRemovedDuringUpdate(objectLevelModifyQuery, object, map);
    }

    @Override
    public void performDataModificationEvent(Object[] objectArray, AbstractSession abstractSession) throws DatabaseException, DescriptorException {
        if (objectArray[0] == PostInsert) {
            this.insertIntoRelationTable((WriteObjectQuery)objectArray[1]);
        } else if (objectArray[0] == ObjectRemoved) {
            abstractSession.executeQuery((DatabaseQuery)((DataModifyQuery)objectArray[1]), (AbstractRecord)objectArray[2]);
            if (this.getHistoryPolicy() != null && this.getHistoryPolicy().shouldHandleWrites()) {
                this.getHistoryPolicy().mappingLogicalDelete((DataModifyQuery)objectArray[1], (AbstractRecord)objectArray[2], abstractSession);
            }
        } else if (objectArray[0] == ObjectAdded) {
            this.insertAddedObjectEntry((WriteObjectQuery)objectArray[1], objectArray[2]);
        } else {
            throw DescriptorException.invalidDataModificationEventCode(objectArray[0], this);
        }
    }

    @Override
    public void postInsert(WriteObjectQuery writeObjectQuery) throws DatabaseException {
        this.insertTargetObjects(writeObjectQuery);
        if (writeObjectQuery.shouldCascadeOnlyDependentParts()) {
            Object[] objectArray = new Object[]{PostInsert, writeObjectQuery};
            writeObjectQuery.getSession().getCommitManager().addDataModificationEvent(this, objectArray);
        } else {
            this.insertIntoRelationTable(writeObjectQuery);
        }
    }

    @Override
    public void postUpdate(WriteObjectQuery writeObjectQuery) throws DatabaseException {
        if (this.isReadOnly()) {
            return;
        }
        if (!this.isAttributeValueInstantiatedOrChanged(writeObjectQuery.getObject())) {
            return;
        }
        Object object = this.getRealCollectionAttributeValueFromObject(writeObjectQuery.getObject(), writeObjectQuery.getSession());
        Object object2 = this.readPrivateOwnedForObject(writeObjectQuery);
        if (object2 == null) {
            object2 = this.getContainerPolicy().containerInstance(1);
        }
        this.compareObjectsAndWrite(object2, object, writeObjectQuery);
    }

    @Override
    public void preDelete(DeleteObjectQuery deleteObjectQuery) throws DatabaseException {
        Object object = null;
        ContainerPolicy containerPolicy = this.getContainerPolicy();
        if (this.isReadOnly()) {
            return;
        }
        Object object2 = this.getRealCollectionAttributeValueFromObject(deleteObjectQuery.getObject(), deleteObjectQuery.getSession());
        if (this.shouldObjectModifyCascadeToParts(deleteObjectQuery)) {
            object = containerPolicy.iteratorFor(object2);
        }
        this.prepareTranslationRow(deleteObjectQuery.getTranslationRow(), deleteObjectQuery.getObject(), deleteObjectQuery.getSession());
        deleteObjectQuery.getSession().executeQuery((DatabaseQuery)this.getDeleteAllQuery(), deleteObjectQuery.getTranslationRow());
        if (this.getHistoryPolicy() != null && this.getHistoryPolicy().shouldHandleWrites()) {
            this.getHistoryPolicy().mappingLogicalDelete(this.getDeleteAllQuery(), deleteObjectQuery.getTranslationRow(), deleteObjectQuery.getSession());
        }
        if (this.shouldObjectModifyCascadeToParts(deleteObjectQuery) && object2 != null) {
            while (containerPolicy.hasNext(object)) {
                DeleteObjectQuery deleteObjectQuery2 = new DeleteObjectQuery();
                deleteObjectQuery2.setIsExecutionClone(true);
                deleteObjectQuery2.setObject(containerPolicy.next(object, deleteObjectQuery.getSession()));
                deleteObjectQuery2.setCascadePolicy(deleteObjectQuery.getCascadePolicy());
                deleteObjectQuery.getSession().executeQuery(deleteObjectQuery2);
            }
        }
    }

    @Override
    protected void prepareTranslationRow(AbstractRecord abstractRecord, Object object, AbstractSession abstractSession) {
        Enumeration<DatabaseField> enumeration = this.getSourceKeyFields().elements();
        while (enumeration.hasMoreElements()) {
            DatabaseField databaseField = enumeration.nextElement();
            if (abstractRecord.containsKey(databaseField)) continue;
            Object object2 = this.getDescriptor().getObjectBuilder().extractValueFromObjectForField(object, databaseField, abstractSession);
            abstractRecord.put(databaseField, object2);
        }
    }

    public void setCustomDeleteQuery(DataModifyQuery dataModifyQuery) {
        this.setDeleteQuery(dataModifyQuery);
        this.setHasCustomDeleteQuery(true);
    }

    public void setCustomInsertQuery(DataModifyQuery dataModifyQuery) {
        this.setInsertQuery(dataModifyQuery);
        this.setHasCustomInsertQuery(true);
    }

    protected void setDeleteQuery(DataModifyQuery dataModifyQuery) {
        this.deleteQuery = dataModifyQuery;
    }

    public void setDeleteSQLString(String string) {
        DataModifyQuery dataModifyQuery = new DataModifyQuery();
        dataModifyQuery.setSQLString(string);
        this.setCustomDeleteQuery(dataModifyQuery);
    }

    public void setDeleteCall(Call call) {
        DataModifyQuery dataModifyQuery = new DataModifyQuery();
        dataModifyQuery.setCall(call);
        this.setCustomDeleteQuery(dataModifyQuery);
    }

    protected void setHasCustomDeleteQuery(boolean bl) {
        this.hasCustomDeleteQuery = bl;
    }

    protected void setHasCustomInsertQuery(boolean bl) {
        this.hasCustomInsertQuery = bl;
    }

    protected void setInsertQuery(DataModifyQuery dataModifyQuery) {
        this.insertQuery = dataModifyQuery;
    }

    public void setInsertSQLString(String string) {
        DataModifyQuery dataModifyQuery = new DataModifyQuery();
        dataModifyQuery.setSQLString(string);
        this.setCustomInsertQuery(dataModifyQuery);
    }

    public void setInsertCall(Call call) {
        DataModifyQuery dataModifyQuery = new DataModifyQuery();
        dataModifyQuery.setCall(call);
        this.setCustomInsertQuery(dataModifyQuery);
    }

    public void setRelationTable(DatabaseTable databaseTable) {
        this.relationTable = databaseTable;
    }

    public void setHistoryPolicy(HistoryPolicy historyPolicy) {
        this.historyPolicy = historyPolicy;
        if (historyPolicy != null) {
            historyPolicy.setMapping(this);
        }
    }

    public void setRelationTableName(String string) {
        this.relationTable = new DatabaseTable(string);
    }

    @Override
    public void setSessionName(String string) {
        super.setSessionName(string);
        this.getInsertQuery().setSessionName(string);
        this.getDeleteQuery().setSessionName(string);
    }

    public void setSourceKeyFieldNames(Vector vector) {
        NonSynchronizedVector nonSynchronizedVector = NonSynchronizedVector.newInstance(vector.size());
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            ((Vector)nonSynchronizedVector).addElement(new DatabaseField((String)enumeration.nextElement()));
        }
        this.setSourceKeyFields(nonSynchronizedVector);
    }

    public void setSourceKeyFields(Vector<DatabaseField> vector) {
        this.sourceKeyFields = vector;
    }

    public void setSourceRelationKeyFieldName(String string) {
        this.getSourceRelationKeyFields().addElement(new DatabaseField(string));
    }

    public void setSourceRelationKeyFieldNames(Vector vector) {
        NonSynchronizedVector nonSynchronizedVector = NonSynchronizedVector.newInstance(vector.size());
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            ((Vector)nonSynchronizedVector).addElement(new DatabaseField((String)enumeration.nextElement()));
        }
        this.setSourceRelationKeyFields(nonSynchronizedVector);
    }

    public void setSourceRelationKeyFields(Vector<DatabaseField> vector) {
        this.sourceRelationKeyFields = vector;
    }

    public void setTargetKeyFieldNames(Vector vector) {
        NonSynchronizedVector nonSynchronizedVector = NonSynchronizedVector.newInstance(vector.size());
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            ((Vector)nonSynchronizedVector).addElement(new DatabaseField((String)enumeration.nextElement()));
        }
        this.setTargetKeyFields(nonSynchronizedVector);
    }

    public void setTargetKeyFields(Vector<DatabaseField> vector) {
        this.targetKeyFields = vector;
    }

    public void setTargetRelationKeyFieldName(String string) {
        this.getTargetRelationKeyFields().addElement(new DatabaseField(string));
    }

    public void setTargetRelationKeyFieldNames(Vector vector) {
        NonSynchronizedVector nonSynchronizedVector = NonSynchronizedVector.newInstance(vector.size());
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            ((Vector)nonSynchronizedVector).addElement(new DatabaseField((String)enumeration.nextElement()));
        }
        this.setTargetRelationKeyFields(nonSynchronizedVector);
    }

    public void setTargetRelationKeyFields(Vector<DatabaseField> vector) {
        this.targetRelationKeyFields = vector;
    }

    @Override
    protected ReadQuery prepareHistoricalQuery(ReadQuery readQuery, ObjectBuildingQuery objectBuildingQuery, AbstractSession abstractSession) {
        if (this.getHistoryPolicy() != null) {
            if (readQuery == this.getSelectionQuery()) {
                readQuery = (ObjectLevelReadQuery)readQuery.clone();
                readQuery.setIsExecutionClone(true);
            }
            if (readQuery.getSelectionCriteria() == this.getSelectionQuery().getSelectionCriteria()) {
                readQuery.setSelectionCriteria((Expression)readQuery.getSelectionCriteria().clone());
            }
            if (objectBuildingQuery.getSession().getAsOfClause() != null) {
                ((ObjectLevelReadQuery)readQuery).setAsOfClause(objectBuildingQuery.getSession().getAsOfClause());
            } else if (((ObjectLevelReadQuery)readQuery).getAsOfClause() == null) {
                ((ObjectLevelReadQuery)readQuery).setAsOfClause(AsOfClause.NO_CLAUSE);
            }
            Expression expression = this.getHistoryPolicy().additionalHistoryExpression(readQuery.getSelectionCriteria().getBuilder());
            readQuery.setSelectionCriteria(readQuery.getSelectionCriteria().and(expression));
        }
        return readQuery;
    }
}

