/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.mappings.foundation;

import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Map;
import java.util.Vector;
import org.eclipse.persistence.exceptions.ConversionException;
import org.eclipse.persistence.exceptions.DatabaseException;
import org.eclipse.persistence.exceptions.DescriptorException;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.indirection.ValueHolderInterface;
import org.eclipse.persistence.internal.databaseaccess.DatabasePlatform;
import org.eclipse.persistence.internal.databaseaccess.FieldTypeDefinition;
import org.eclipse.persistence.internal.descriptors.DescriptorIterator;
import org.eclipse.persistence.internal.descriptors.FieldTransformation;
import org.eclipse.persistence.internal.descriptors.InstanceVariableAttributeAccessor;
import org.eclipse.persistence.internal.descriptors.MethodAttributeAccessor;
import org.eclipse.persistence.internal.descriptors.MethodBasedFieldTransformation;
import org.eclipse.persistence.internal.descriptors.TransformerBasedFieldTransformation;
import org.eclipse.persistence.internal.helper.ClassConstants;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.internal.helper.NonSynchronizedVector;
import org.eclipse.persistence.internal.indirection.BasicIndirectionPolicy;
import org.eclipse.persistence.internal.indirection.ContainerIndirectionPolicy;
import org.eclipse.persistence.internal.indirection.IndirectionPolicy;
import org.eclipse.persistence.internal.indirection.NoIndirectionPolicy;
import org.eclipse.persistence.internal.indirection.UnitOfWorkTransformerValueHolder;
import org.eclipse.persistence.internal.indirection.UnitOfWorkValueHolder;
import org.eclipse.persistence.internal.queries.JoinedAttributeManager;
import org.eclipse.persistence.internal.security.PrivilegedAccessHelper;
import org.eclipse.persistence.internal.security.PrivilegedClassForName;
import org.eclipse.persistence.internal.security.PrivilegedNewInstanceFromClass;
import org.eclipse.persistence.internal.sessions.AbstractRecord;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.internal.sessions.ChangeRecord;
import org.eclipse.persistence.internal.sessions.MergeManager;
import org.eclipse.persistence.internal.sessions.ObjectChangeSet;
import org.eclipse.persistence.internal.sessions.TransformationMappingChangeRecord;
import org.eclipse.persistence.internal.sessions.UnitOfWorkImpl;
import org.eclipse.persistence.internal.sessions.remote.RemoteValueHolder;
import org.eclipse.persistence.mappings.Association;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.transformers.AttributeTransformer;
import org.eclipse.persistence.mappings.transformers.FieldTransformer;
import org.eclipse.persistence.mappings.transformers.MethodBasedAttributeTransformer;
import org.eclipse.persistence.mappings.transformers.MethodBasedFieldTransformer;
import org.eclipse.persistence.queries.ObjectBuildingQuery;
import org.eclipse.persistence.queries.ObjectLevelReadQuery;
import org.eclipse.persistence.queries.ReadObjectQuery;
import org.eclipse.persistence.queries.WriteObjectQuery;
import org.eclipse.persistence.sessions.DatabaseRecord;
import org.eclipse.persistence.sessions.ObjectCopyingPolicy;
import org.eclipse.persistence.sessions.Project;
import org.eclipse.persistence.sessions.remote.DistributedSession;
import org.eclipse.persistence.sessions.remote.RemoteSession;

public abstract class AbstractTransformationMapping
extends DatabaseMapping {
    protected String attributeTransformerClassName;
    protected AttributeTransformer attributeTransformer;
    protected Vector fieldTransformations = NonSynchronizedVector.newInstance();
    protected Vector fieldToTransformers = NonSynchronizedVector.newInstance();
    protected boolean isMutable;
    protected IndirectionPolicy indirectionPolicy;

    public AbstractTransformationMapping() {
        this.setIsMutable(true);
        this.dontUseIndirection();
    }

    public void addFieldTransformation(DatabaseField databaseField, String string) {
        MethodBasedFieldTransformation methodBasedFieldTransformation = new MethodBasedFieldTransformation();
        methodBasedFieldTransformation.setField(databaseField);
        methodBasedFieldTransformation.setMethodName(string);
        this.getFieldTransformations().addElement(methodBasedFieldTransformation);
    }

    public void addFieldTransformation(String string, String string2) {
        this.addFieldTransformation(new DatabaseField(string), string2);
    }

    public void addFieldTransformerClassName(String string, String string2) {
        this.addFieldTransformerClassName(new DatabaseField(string), string2);
    }

    public void addFieldTransformerClassName(DatabaseField databaseField, String string) {
        TransformerBasedFieldTransformation transformerBasedFieldTransformation = new TransformerBasedFieldTransformation();
        transformerBasedFieldTransformation.setField(databaseField);
        transformerBasedFieldTransformation.setTransformerClassName(string);
        this.getFieldTransformations().addElement(transformerBasedFieldTransformation);
    }

    public void addFieldTransformer(String string, FieldTransformer fieldTransformer) {
        this.addFieldTransformer(new DatabaseField(string), fieldTransformer);
    }

    public void addFieldTransformer(DatabaseField databaseField, FieldTransformer fieldTransformer) {
        TransformerBasedFieldTransformation transformerBasedFieldTransformation = new TransformerBasedFieldTransformation(fieldTransformer);
        transformerBasedFieldTransformation.setField(databaseField);
        this.getFieldTransformations().addElement(transformerBasedFieldTransformation);
    }

    protected boolean areObjectsToBeProcessedInstantiated(Object object) {
        return this.getIndirectionPolicy().objectIsInstantiated(this.getAttributeValueFromObject(object));
    }

    public void buildBackupClone(Object object, Object object2, UnitOfWorkImpl unitOfWorkImpl) {
        if (this.isWriteOnly()) {
            return;
        }
        Object object3 = this.getAttributeValueFromObject(object);
        if (!this.isMutable()) {
            this.setAttributeValueInObject(object2, object3);
            return;
        }
        Object object4 = this.isReadOnly() ? object3 : this.getIndirectionPolicy().backupCloneAttribute(object3, object, object2, unitOfWorkImpl);
        this.setAttributeValueInObject(object2, object4);
    }

    protected AbstractRecord buildPhantomRowFrom(Object object, AbstractSession abstractSession) {
        DatabaseRecord databaseRecord = new DatabaseRecord(this.getFieldToTransformers().size());
        Enumeration enumeration = this.getFieldToTransformers().elements();
        while (enumeration.hasMoreElements()) {
            Object[] objectArray = (Object[])enumeration.nextElement();
            DatabaseField databaseField = (DatabaseField)objectArray[0];
            FieldTransformer fieldTransformer = (FieldTransformer)objectArray[1];
            Object object2 = this.invokeFieldTransformer(databaseField, fieldTransformer, object, abstractSession);
            databaseRecord.put(databaseField, object2);
        }
        return databaseRecord;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void buildShallowOriginalFromRow(AbstractRecord abstractRecord, Object object, JoinedAttributeManager joinedAttributeManager, ObjectBuildingQuery objectBuildingQuery, AbstractSession abstractSession) {
        UnitOfWorkImpl unitOfWorkImpl = (UnitOfWorkImpl)objectBuildingQuery.getSession();
        objectBuildingQuery.setSession(unitOfWorkImpl.getParent());
        try {
            this.readFromRowIntoObject(abstractRecord, joinedAttributeManager, object, objectBuildingQuery, abstractSession);
        }
        finally {
            objectBuildingQuery.setSession(unitOfWorkImpl);
        }
    }

    public Object buildBackupCloneForPartObject(Object object, Object object2, Object object3, UnitOfWorkImpl unitOfWorkImpl) {
        if (!this.isMutable()) {
            return object;
        }
        AbstractRecord abstractRecord = this.buildPhantomRowFrom(object2, unitOfWorkImpl);
        return this.invokeAttributeTransformer(abstractRecord, object3, unitOfWorkImpl);
    }

    public void buildClone(Object object, Object object2, UnitOfWorkImpl unitOfWorkImpl) {
        if (this.isWriteOnly()) {
            return;
        }
        Object object3 = this.getAttributeValueFromObject(object);
        Object object4 = this.isReadOnly() || !this.isMutable() ? object3 : this.getIndirectionPolicy().cloneAttribute(object3, object, object2, unitOfWorkImpl, false);
        this.setAttributeValueInObject(object2, object4);
    }

    public void buildCloneFromRow(AbstractRecord abstractRecord, JoinedAttributeManager joinedAttributeManager, Object object, ObjectBuildingQuery objectBuildingQuery, UnitOfWorkImpl unitOfWorkImpl, AbstractSession abstractSession) {
        if (this.isWriteOnly()) {
            return;
        }
        Object object2 = this.readFromRowIntoObject(abstractRecord, joinedAttributeManager, object, objectBuildingQuery, abstractSession);
        Object object3 = this.isReadOnly() || !this.isMutable() ? object2 : this.getIndirectionPolicy().cloneAttribute(object2, null, object, unitOfWorkImpl, true);
        this.setAttributeValueInObject(object, object3);
    }

    public Object buildCloneForPartObject(Object object, Object object2, Object object3, UnitOfWorkImpl unitOfWorkImpl, boolean bl) {
        return this.buildBackupCloneForPartObject(object, object2, object3, unitOfWorkImpl);
    }

    public void buildCopy(Object object, Object object2, ObjectCopyingPolicy objectCopyingPolicy) {
        Object object3;
        if (this.isWriteOnly()) {
            return;
        }
        Object object4 = this.getAttributeValueFromObject(object2);
        if (this.isReadOnly() || !this.isMutable()) {
            object3 = object4;
        } else {
            AbstractRecord abstractRecord = this.buildPhantomRowFrom(object2, objectCopyingPolicy.getSession());
            object3 = this.invokeAttributeTransformer(abstractRecord, object, objectCopyingPolicy.getSession());
        }
        this.setAttributeValueInObject(object, object3);
    }

    public void cascadePerformRemoveIfRequired(Object object, UnitOfWorkImpl unitOfWorkImpl, Map map) {
    }

    public void cascadeRegisterNewIfRequired(Object object, UnitOfWorkImpl unitOfWorkImpl, Map map) {
    }

    public Object clone() {
        AbstractTransformationMapping abstractTransformationMapping = (AbstractTransformationMapping)super.clone();
        abstractTransformationMapping.setFieldToTransformers(NonSynchronizedVector.newInstance(this.getFieldToTransformers().size() + 1));
        Enumeration enumeration = this.getFieldToTransformers().elements();
        while (enumeration.hasMoreElements()) {
            Object[] objectArray = new Object[2];
            Object[] objectArray2 = (Object[])enumeration.nextElement();
            objectArray[0] = objectArray2[0];
            objectArray[1] = objectArray2[1];
            abstractTransformationMapping.getFieldToTransformers().addElement(objectArray);
        }
        abstractTransformationMapping.setIndirectionPolicy((IndirectionPolicy)this.indirectionPolicy.clone());
        return abstractTransformationMapping;
    }

    protected Vector collectFields() {
        Vector<Object> vector = new Vector<Object>(this.getFieldToTransformers().size());
        Enumeration enumeration = this.getFieldToTransformers().elements();
        while (enumeration.hasMoreElements()) {
            vector.addElement(((Object[])enumeration.nextElement())[0]);
        }
        return vector;
    }

    public ChangeRecord compareForChange(Object object, Object object2, ObjectChangeSet objectChangeSet, AbstractSession abstractSession) {
        if (this.isReadOnly() || this.isWriteOnly()) {
            return null;
        }
        Object object3 = this.getAttributeValueFromObject(object);
        Object object4 = null;
        if (object3 != null && !this.getIndirectionPolicy().objectIsInstantiated(object3)) {
            return null;
        }
        boolean bl = false;
        if (objectChangeSet.isNew()) {
            bl = true;
        } else {
            if (object2 != null) {
                object4 = this.getAttributeValueFromObject(object2);
            }
            boolean bl2 = object4 == null || this.getIndirectionPolicy().objectIsInstantiated(object4);
            Enumeration enumeration = this.getFieldToTransformers().elements();
            while (enumeration.hasMoreElements()) {
                Object[] objectArray = (Object[])enumeration.nextElement();
                DatabaseField databaseField = (DatabaseField)objectArray[0];
                FieldTransformer fieldTransformer = (FieldTransformer)objectArray[1];
                Object object5 = null;
                Object object6 = null;
                if (object != null) {
                    object5 = this.invokeFieldTransformer(databaseField, fieldTransformer, object, abstractSession);
                }
                if (bl2 && object2 != null) {
                    object6 = this.invokeFieldTransformer(databaseField, fieldTransformer, object2, abstractSession);
                }
                if (object5 == null && object6 == null || object5 != null && object5.equals(object6)) continue;
                bl = true;
                break;
            }
        }
        if (bl) {
            return this.buildChangeRecord(object, objectChangeSet, abstractSession);
        }
        return null;
    }

    public ChangeRecord buildChangeRecord(Object object, ObjectChangeSet objectChangeSet, AbstractSession abstractSession) {
        TransformationMappingChangeRecord transformationMappingChangeRecord = new TransformationMappingChangeRecord(objectChangeSet);
        transformationMappingChangeRecord.setRow(this.buildPhantomRowFrom(object, abstractSession));
        transformationMappingChangeRecord.setAttribute(this.getAttributeName());
        transformationMappingChangeRecord.setMapping(this);
        return transformationMappingChangeRecord;
    }

    public boolean compareObjects(Object object, Object object2, AbstractSession abstractSession) {
        Enumeration enumeration = this.getFieldToTransformers().elements();
        while (enumeration.hasMoreElements()) {
            Object[] objectArray = (Object[])enumeration.nextElement();
            DatabaseField databaseField = (DatabaseField)objectArray[0];
            FieldTransformer fieldTransformer = (FieldTransformer)objectArray[1];
            Object object3 = this.invokeFieldTransformer(databaseField, fieldTransformer, object, abstractSession);
            Object object4 = this.invokeFieldTransformer(databaseField, fieldTransformer, object2, abstractSession);
            if (object3 == null && object4 == null) continue;
            if (object3 == null || object4 == null) {
                return false;
            }
            if (object3.equals(object4)) continue;
            return false;
        }
        return true;
    }

    public void convertClassNamesToClasses(ClassLoader classLoader) {
        Class clazz;
        block13: {
            super.convertClassNamesToClasses(classLoader);
            if (this.attributeTransformerClassName == null) {
                return;
            }
            clazz = null;
            try {
                if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
                    try {
                        clazz = (Class)AccessController.doPrivileged(new PrivilegedClassForName(this.attributeTransformerClassName, true, classLoader));
                        break block13;
                    }
                    catch (PrivilegedActionException privilegedActionException) {
                        throw ValidationException.classNotFoundWhileConvertingClassNames(this.attributeTransformerClassName, privilegedActionException.getException());
                    }
                }
                clazz = PrivilegedAccessHelper.getClassForName(this.attributeTransformerClassName, true, classLoader);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw ValidationException.classNotFoundWhileConvertingClassNames(this.attributeTransformerClassName, classNotFoundException);
            }
        }
        this.setAttributeTransformerClass(clazz);
        Enumeration enumeration = this.getFieldTransformations().elements();
        while (enumeration.hasMoreElements()) {
            Class clazz2;
            TransformerBasedFieldTransformation transformerBasedFieldTransformation;
            block14: {
                FieldTransformation fieldTransformation = (FieldTransformation)enumeration.nextElement();
                if (!(fieldTransformation instanceof TransformerBasedFieldTransformation)) continue;
                transformerBasedFieldTransformation = (TransformerBasedFieldTransformation)fieldTransformation;
                String string = transformerBasedFieldTransformation.getTransformerClassName();
                if (string == null) {
                    return;
                }
                clazz2 = null;
                try {
                    if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
                        try {
                            clazz2 = (Class)AccessController.doPrivileged(new PrivilegedClassForName(string, true, classLoader));
                            break block14;
                        }
                        catch (PrivilegedActionException privilegedActionException) {
                            throw ValidationException.classNotFoundWhileConvertingClassNames(string, privilegedActionException.getException());
                        }
                    }
                    clazz2 = PrivilegedAccessHelper.getClassForName(string, true, classLoader);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw ValidationException.classNotFoundWhileConvertingClassNames(string, classNotFoundException);
                }
            }
            transformerBasedFieldTransformation.setTransformerClass(clazz2);
        }
    }

    public UnitOfWorkValueHolder createUnitOfWorkValueHolder(ValueHolderInterface valueHolderInterface, Object object, Object object2, AbstractRecord abstractRecord, UnitOfWorkImpl unitOfWorkImpl, boolean bl) {
        return new UnitOfWorkTransformerValueHolder(valueHolderInterface, object, object2, this, unitOfWorkImpl);
    }

    public void dontUseIndirection() {
        this.setIndirectionPolicy(new NoIndirectionPolicy());
    }

    public void fixObjectReferences(Object object, Map map, Map map2, ObjectLevelReadQuery objectLevelReadQuery, RemoteSession remoteSession) {
        this.getIndirectionPolicy().fixObjectReferences(object, map, map2, objectLevelReadQuery, remoteSession);
    }

    public AttributeTransformer getAttributeTransformer() {
        return this.attributeTransformer;
    }

    public String getAttributeMethodName() {
        if (this.getAttributeTransformer() instanceof MethodBasedAttributeTransformer) {
            return ((MethodBasedAttributeTransformer)this.getAttributeTransformer()).getMethodName();
        }
        return null;
    }

    public Class getAttributeTransformerClass() {
        if (this.getAttributeTransformer() == null || this.getAttributeTransformer() instanceof MethodBasedAttributeTransformer) {
            return null;
        }
        return this.getAttributeTransformer().getClass();
    }

    public void setAttributeTransformerClass(Class clazz) {
        if (clazz == null) {
            return;
        }
        try {
            Object object = null;
            if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
                try {
                    object = AccessController.doPrivileged(new PrivilegedNewInstanceFromClass(clazz));
                }
                catch (PrivilegedActionException privilegedActionException) {
                    throw (Exception)privilegedActionException.getCause();
                }
            } else {
                object = PrivilegedAccessHelper.newInstanceFromClass(clazz);
            }
            this.setAttributeTransformer((AttributeTransformer)object);
        }
        catch (Exception exception) {
            throw DescriptorException.attributeTransformerClassInvalid(this.getAttributeTransformerClassName(), this, exception);
        }
    }

    public String getAttributeTransformerClassName() {
        return this.attributeTransformerClassName;
    }

    public Object getAttributeValueFromObject(Object object) throws DescriptorException {
        if (this.isWriteOnly()) {
            return null;
        }
        Object object2 = super.getAttributeValueFromObject(object);
        return this.getIndirectionPolicy().validateAttributeOfInstantiatedObject(object2);
    }

    public Vector getFieldTransformations() {
        return this.fieldTransformations;
    }

    public Vector getFieldToTransformers() {
        return this.fieldToTransformers;
    }

    public IndirectionPolicy getIndirectionPolicy() {
        return this.indirectionPolicy;
    }

    public Object getRealAttributeValueFromAttribute(Object object, Object object2, AbstractSession abstractSession) {
        return this.indirectionPolicy.getRealAttributeValueFromObject(object2, object);
    }

    public void instantiateAttribute(Object object, AbstractSession abstractSession) {
        this.getIndirectionPolicy().instantiateObject(object, this.getAttributeValueFromObject(object));
    }

    public Object getValueFromRemoteValueHolder(RemoteValueHolder remoteValueHolder) {
        return this.getIndirectionPolicy().getValueFromRemoteValueHolder(remoteValueHolder);
    }

    public void initialize(AbstractSession abstractSession) throws DescriptorException {
        super.initialize(abstractSession);
        this.initializeAttributeTransformer(abstractSession);
        this.initializeFieldToTransformers(abstractSession);
        this.setFields(this.collectFields());
        this.getIndirectionPolicy().initialize();
    }

    protected void initializeAttributeTransformer(AbstractSession abstractSession) throws DescriptorException {
        if (this.isWriteOnly()) {
            return;
        }
        this.getAttributeTransformer().initialize(this);
    }

    public Hashtable getFieldNameToMethodNames() {
        Hashtable<String, String> hashtable = new Hashtable<String, String>(this.getFieldTransformations().size());
        for (FieldTransformation fieldTransformation : this.getFieldTransformations()) {
            if (!(fieldTransformation instanceof MethodBasedFieldTransformation)) continue;
            hashtable.put(fieldTransformation.getField().getQualifiedName(), ((MethodBasedFieldTransformation)fieldTransformation).getMethodName());
        }
        return hashtable;
    }

    protected void initializeFieldToTransformers(AbstractSession abstractSession) throws DescriptorException {
        Object object;
        Enumeration enumeration = this.getFieldToTransformers().elements();
        while (enumeration.hasMoreElements()) {
            object = (Object[])enumeration.nextElement();
            object[0] = this.getDescriptor().buildField((DatabaseField)object[0]);
            ((FieldTransformer)object[1]).initialize(this);
        }
        enumeration = this.getFieldTransformations().elements();
        while (enumeration.hasMoreElements()) {
            object = (FieldTransformation)enumeration.nextElement();
            DatabaseField databaseField = this.getDescriptor().buildField(((FieldTransformation)object).getField());
            String string = "MethodBasedFieldTransformer";
            FieldTransformer fieldTransformer = null;
            try {
                fieldTransformer = ((FieldTransformation)object).buildTransformer();
            }
            catch (ConversionException conversionException) {
                if (object instanceof TransformerBasedFieldTransformation) {
                    string = ((TransformerBasedFieldTransformation)object).getTransformerClassName();
                }
                throw DescriptorException.fieldTransformerClassNotFound(string, this, conversionException);
            }
            catch (Exception exception) {
                if (object instanceof TransformerBasedFieldTransformation) {
                    string = ((TransformerBasedFieldTransformation)object).getTransformerClassName();
                }
                throw DescriptorException.fieldTransformerClassInvalid(string, this, exception);
            }
            fieldTransformer.initialize(this);
            if (databaseField.getType() == null) {
                if (fieldTransformer instanceof MethodBasedFieldTransformer) {
                    databaseField.setType(((MethodBasedFieldTransformer)fieldTransformer).getFieldType());
                } else if (databaseField.getColumnDefinition() != null && abstractSession.getDatasourcePlatform() instanceof DatabasePlatform) {
                    for (Map.Entry entry : abstractSession.getPlatform().getFieldTypes().entrySet()) {
                        if (!((FieldTypeDefinition)entry.getValue()).getName().equals(databaseField.getColumnDefinition())) continue;
                        databaseField.setType((Class)entry.getKey());
                        break;
                    }
                }
            }
            Object[] objectArray = new Object[]{databaseField, fieldTransformer};
            this.getFieldToTransformers().addElement(objectArray);
        }
    }

    public Object invokeAttributeTransformer(AbstractRecord abstractRecord, Object object, AbstractSession abstractSession) throws DescriptorException {
        return this.getAttributeTransformer().buildAttributeValue(abstractRecord, object, abstractSession);
    }

    protected Object invokeFieldTransformer(DatabaseField databaseField, FieldTransformer fieldTransformer, Object object, AbstractSession abstractSession) throws DescriptorException {
        return fieldTransformer.buildFieldValue(object, databaseField.getName(), abstractSession);
    }

    protected Object invokeFieldTransformer(DatabaseField databaseField, Object object, AbstractSession abstractSession) {
        Enumeration enumeration = this.getFieldToTransformers().elements();
        while (enumeration.hasMoreElements()) {
            Object[] objectArray = (Object[])enumeration.nextElement();
            if (!databaseField.equals(objectArray[0])) continue;
            return this.invokeFieldTransformer(databaseField, (FieldTransformer)objectArray[1], object, abstractSession);
        }
        return null;
    }

    public boolean isMutable() {
        return this.isMutable;
    }

    public boolean isReadOnly() {
        if (super.isReadOnly()) {
            return true;
        }
        return this.getFieldTransformations().isEmpty() && this.getFieldToTransformers().isEmpty();
    }

    public boolean isTransformationMapping() {
        return true;
    }

    public boolean isWriteOnly() {
        return this.getAttributeName() == null && this.getAttributeTransformer() == null && this.getAttributeTransformerClassName() == null;
    }

    public void iterate(DescriptorIterator descriptorIterator) {
        Object object = this.getAttributeValueFromObject(descriptorIterator.getVisitedParent());
        this.getIndirectionPolicy().iterateOnAttributeValue(descriptorIterator, object);
    }

    public void iterateOnRealAttributeValue(DescriptorIterator descriptorIterator, Object object) {
        descriptorIterator.iteratePrimitiveForMapping(object, this);
    }

    public void mergeChangesIntoObject(Object object, ChangeRecord changeRecord, Object object2, MergeManager mergeManager) {
        if (this.isWriteOnly()) {
            return;
        }
        if (!this.isMutable()) {
            this.setRealAttributeValueInObject(object, this.getRealAttributeValueFromObject(object2, mergeManager.getSession()));
            return;
        }
        AbstractRecord abstractRecord = (AbstractRecord)((TransformationMappingChangeRecord)changeRecord).getRecord();
        Object object3 = this.invokeAttributeTransformer(abstractRecord, object, mergeManager.getSession());
        this.setRealAttributeValueInObject(object, object3);
    }

    public void mergeIntoObject(Object object, boolean bl, Object object2, MergeManager mergeManager) {
        if (this.isWriteOnly()) {
            return;
        }
        if (mergeManager.shouldRefreshRemoteObject() && this.usesIndirection()) {
            this.getIndirectionPolicy().mergeRemoteValueHolder(object, object2, mergeManager);
            return;
        }
        if (mergeManager.shouldMergeOriginalIntoWorkingCopy() ? !this.areObjectsToBeProcessedInstantiated(object) : !this.areObjectsToBeProcessedInstantiated(object2)) {
            return;
        }
        if (bl && mergeManager.shouldMergeWorkingCopyIntoOriginal() && !this.areObjectsToBeProcessedInstantiated(object2)) {
            this.setAttributeValueInObject(object, this.getIndirectionPolicy().getOriginalIndirectionObject(this.getAttributeValueFromObject(object2), mergeManager.getSession()));
            return;
        }
        if (this.isReadOnly()) {
            this.setRealAttributeValueInObject(object, this.getRealAttributeValueFromObject(object2, mergeManager.getSession()));
            return;
        }
        if (!this.isMutable()) {
            Object object3 = this.getRealAttributeValueFromObject(object2, mergeManager.getSession());
            if (this.descriptor.getObjectChangePolicy().isObjectChangeTrackingPolicy()) {
                Object object4 = this.getRealAttributeValueFromObject(object, mergeManager.getSession());
                if ((mergeManager.shouldMergeCloneIntoWorkingCopy() || mergeManager.shouldMergeCloneWithReferencesIntoWorkingCopy()) && (object4 == null && object3 != null || object4 != null && !object4.equals(object3))) {
                    this.descriptor.getObjectChangePolicy().raiseInternalPropertyChangeEvent(object, this.getAttributeName(), object4, object3);
                }
            }
            this.setRealAttributeValueInObject(object, object3);
            return;
        }
        AbstractRecord abstractRecord = this.buildPhantomRowFrom(object2, mergeManager.getSession());
        Object object5 = this.invokeAttributeTransformer(abstractRecord, object2, mergeManager.getSession());
        AbstractRecord abstractRecord2 = this.buildPhantomRowFrom(object, mergeManager.getSession());
        this.setRealAttributeValueInObject(object, object5);
        if (this.descriptor.getObjectChangePolicy().isObjectChangeTrackingPolicy()) {
            Enumeration enumeration = abstractRecord2.keys();
            while (enumeration.hasMoreElements()) {
                Object e = enumeration.nextElement();
                if (!mergeManager.shouldMergeCloneIntoWorkingCopy() && !mergeManager.shouldMergeCloneWithReferencesIntoWorkingCopy() || abstractRecord.get(e).equals(abstractRecord2.get(e))) continue;
                this.descriptor.getObjectChangePolicy().raiseInternalPropertyChangeEvent(object, this.getAttributeName(), this.invokeAttributeTransformer(abstractRecord2, object2, mergeManager.getSession()), object5);
                break;
            }
        }
    }

    public void preInitialize(AbstractSession abstractSession) throws DescriptorException {
        if (this.isWriteOnly()) {
            return;
        }
        super.preInitialize(abstractSession);
        if (this.getAttributeClassification() != null && (this.getAttributeClassification().isPrimitive() || Helper.isPrimitiveWrapper(this.getAttributeClassification()) || this.getAttributeClassification().equals(ClassConstants.STRING) || this.getAttributeClassification().equals(ClassConstants.BIGDECIMAL) || this.getAttributeClassification().equals(ClassConstants.NUMBER))) {
            this.setIsMutable(false);
        }
    }

    public Object readFromReturnRowIntoObject(AbstractRecord abstractRecord, Object object, ReadObjectQuery readObjectQuery, Collection collection) throws DatabaseException {
        DatabaseRecord databaseRecord = new DatabaseRecord(this.getFields().size());
        for (int i = 0; i < this.getFields().size(); ++i) {
            DatabaseField databaseField = this.getFields().elementAt(i);
            Object object2 = abstractRecord.containsKey(databaseField) ? abstractRecord.get(databaseField) : this.valueFromObject(object, databaseField, readObjectQuery.getSession());
            databaseRecord.add(databaseField, object2);
        }
        Object object3 = this.readFromRowIntoObject(databaseRecord, null, object, readObjectQuery, readObjectQuery.getSession());
        if (collection != null) {
            collection.add(this);
        }
        return object3;
    }

    public Object readFromRowIntoObject(AbstractRecord abstractRecord, JoinedAttributeManager joinedAttributeManager, Object object, ObjectBuildingQuery objectBuildingQuery, AbstractSession abstractSession) throws DatabaseException {
        if (this.isWriteOnly()) {
            return null;
        }
        Object object2 = this.getIndirectionPolicy().valueFromMethod(object, abstractRecord, objectBuildingQuery.getSession());
        try {
            this.getAttributeAccessor().setAttributeValueInObject(object, object2);
        }
        catch (DescriptorException descriptorException) {
            descriptorException.setMapping(this);
            throw descriptorException;
        }
        return object2;
    }

    public Vector getFieldNameToMethodNameAssociations() {
        Vector<Association> vector = new Vector<Association>();
        for (FieldTransformation fieldTransformation : this.getFieldTransformations()) {
            if (!(fieldTransformation instanceof MethodBasedFieldTransformation)) continue;
            Association association = new Association();
            association.setKey(fieldTransformation.getField().getQualifiedName());
            association.setValue(((MethodBasedFieldTransformation)fieldTransformation).getMethodName());
            vector.addElement(association);
        }
        return vector;
    }

    public void setFieldNameToMethodNameAssociations(Vector vector) {
        this.setFieldTransformations(NonSynchronizedVector.newInstance(vector.size()));
        for (Association association : vector) {
            MethodBasedFieldTransformation methodBasedFieldTransformation = new MethodBasedFieldTransformation();
            methodBasedFieldTransformation.setField(new DatabaseField((String)association.getKey()));
            methodBasedFieldTransformation.setMethodName((String)association.getValue());
            this.getFieldTransformations().addElement(methodBasedFieldTransformation);
        }
    }

    public void remoteInitialization(DistributedSession distributedSession) {
        this.setFieldToTransformers(new Vector());
        if (!this.isWriteOnly()) {
            super.remoteInitialization(distributedSession);
            this.initializeAttributeTransformer(distributedSession);
        }
        this.initializeFieldToTransformers(distributedSession);
    }

    public void setAttributeTransformer(AttributeTransformer attributeTransformer) {
        this.attributeTransformer = attributeTransformer;
        if (attributeTransformer != null && !(attributeTransformer instanceof MethodBasedAttributeTransformer)) {
            this.attributeTransformerClassName = attributeTransformer.getClass().getName();
        }
    }

    public void setAttributeTransformerClassName(String string) {
        this.attributeTransformerClassName = string;
    }

    public void setAttributeTransformation(String string) {
        if (string != null && string != "") {
            this.setAttributeTransformer(new MethodBasedAttributeTransformer(string));
        } else {
            this.setAttributeTransformer(null);
        }
    }

    public void setAttributeValueInObject(Object object, Object object2) {
        if (this.isWriteOnly()) {
            return;
        }
        super.setAttributeValueInObject(object, object2);
    }

    public void setIsMutable(boolean bl) {
        this.isMutable = bl;
    }

    public void setRealAttributeValueInObject(Object object, Object object2) throws DescriptorException {
        if (this.isWriteOnly()) {
            return;
        }
        this.getIndirectionPolicy().setRealAttributeValueInObject(object, object2);
    }

    public void setFieldTransformations(Vector vector) {
        this.fieldTransformations = vector;
    }

    protected void setFieldToTransformers(Vector vector) {
        this.fieldToTransformers = vector;
    }

    public void setIndirectionPolicy(IndirectionPolicy indirectionPolicy) {
        this.indirectionPolicy = indirectionPolicy;
        indirectionPolicy.setMapping(this);
    }

    public void setUsesIndirection(boolean bl) {
        if (bl) {
            this.useBasicIndirection();
        } else {
            this.dontUseIndirection();
        }
    }

    public boolean shouldMergeCascadeParts(MergeManager mergeManager) {
        return mergeManager.shouldCascadeAllParts() || mergeManager.shouldCascadePrivateParts() && this.isPrivateOwned();
    }

    protected boolean shouldMergeCascadeReference(MergeManager mergeManager) {
        if (mergeManager.shouldCascadeReferences()) {
            return true;
        }
        return this.shouldMergeCascadeParts(mergeManager);
    }

    public void updateChangeRecord(Object object, Object object2, Object object3, ObjectChangeSet objectChangeSet, UnitOfWorkImpl unitOfWorkImpl) {
        TransformationMappingChangeRecord transformationMappingChangeRecord = (TransformationMappingChangeRecord)objectChangeSet.getChangesForAttributeNamed(this.getAttributeName());
        if (!this.isWriteOnly()) {
            if (transformationMappingChangeRecord == null) {
                objectChangeSet.addChange(this.buildChangeRecord(object, objectChangeSet, unitOfWorkImpl));
            } else {
                transformationMappingChangeRecord.setRow(this.buildPhantomRowFrom(object, unitOfWorkImpl));
            }
        }
    }

    public boolean isChangeTrackingSupported(Project project) {
        return !this.isMutable();
    }

    public void useBasicIndirection() {
        this.setIndirectionPolicy(new BasicIndirectionPolicy());
    }

    public void useContainerIndirection(Class clazz) {
        ContainerIndirectionPolicy containerIndirectionPolicy = new ContainerIndirectionPolicy();
        containerIndirectionPolicy.setContainerClass(clazz);
        this.setIndirectionPolicy(containerIndirectionPolicy);
    }

    public void useIndirection() {
        this.useBasicIndirection();
    }

    public boolean usesIndirection() {
        return this.getIndirectionPolicy().usesIndirection();
    }

    public void validateBeforeInitialization(AbstractSession abstractSession) throws DescriptorException {
        super.validateBeforeInitialization(abstractSession);
        if (this.isWriteOnly()) {
            return;
        }
        if (this.getAttributeTransformer() == null && this.getAttributeTransformerClassName() == null) {
            abstractSession.getIntegrityChecker().handleError(DescriptorException.noAttributeTransformationMethod(this));
        }
        if (this.getAttributeAccessor() instanceof InstanceVariableAttributeAccessor) {
            Class clazz = ((InstanceVariableAttributeAccessor)this.getAttributeAccessor()).getAttributeType();
            this.getIndirectionPolicy().validateDeclaredAttributeType(clazz, abstractSession.getIntegrityChecker());
        } else if (this.getAttributeAccessor().isMethodAttributeAccessor()) {
            Class clazz = ((MethodAttributeAccessor)this.getAttributeAccessor()).getGetMethodReturnType();
            this.getIndirectionPolicy().validateGetMethodReturnType(clazz, abstractSession.getIntegrityChecker());
            Class clazz2 = ((MethodAttributeAccessor)this.getAttributeAccessor()).getSetMethodParameterType();
            this.getIndirectionPolicy().validateSetMethodParameterType(clazz2, abstractSession.getIntegrityChecker());
        }
    }

    public Object valueFromObject(Object object, DatabaseField databaseField, AbstractSession abstractSession) {
        return this.invokeFieldTransformer(databaseField, object, abstractSession);
    }

    public void writeFromObjectIntoRow(Object object, AbstractRecord abstractRecord, AbstractSession abstractSession) {
        if (this.isReadOnly()) {
            return;
        }
        Enumeration enumeration = this.getFieldToTransformers().elements();
        while (enumeration.hasMoreElements()) {
            Object[] objectArray = (Object[])enumeration.nextElement();
            DatabaseField databaseField = (DatabaseField)objectArray[0];
            FieldTransformer fieldTransformer = (FieldTransformer)objectArray[1];
            Object object2 = this.invokeFieldTransformer(databaseField, fieldTransformer, object, abstractSession);
            abstractRecord.put(databaseField, object2);
        }
    }

    public void writeFromObjectIntoRowWithChangeRecord(ChangeRecord changeRecord, AbstractRecord abstractRecord, AbstractSession abstractSession) {
        if (this.isReadOnly()) {
            return;
        }
        Enumeration enumeration = this.getFieldToTransformers().elements();
        while (enumeration.hasMoreElements()) {
            Object[] objectArray = (Object[])enumeration.nextElement();
            DatabaseField databaseField = (DatabaseField)objectArray[0];
            Object v = ((TransformationMappingChangeRecord)changeRecord).getRecord().get(databaseField);
            abstractRecord.put(databaseField, v);
        }
    }

    public void writeFromObjectIntoRowForUpdate(WriteObjectQuery writeObjectQuery, AbstractRecord abstractRecord) {
        if (!this.areObjectsToBeProcessedInstantiated(writeObjectQuery.getObject())) {
            return;
        }
        if (writeObjectQuery.getSession().isUnitOfWork() && this.compareObjects(writeObjectQuery.getBackupClone(), writeObjectQuery.getObject(), writeObjectQuery.getSession())) {
            return;
        }
        this.writeFromObjectIntoRow(writeObjectQuery.getObject(), abstractRecord, writeObjectQuery.getSession());
    }

    public void writeInsertFieldsIntoRow(AbstractRecord abstractRecord, AbstractSession abstractSession) {
        if (this.isReadOnly()) {
            return;
        }
        Enumeration enumeration = this.getFieldToTransformers().elements();
        while (enumeration.hasMoreElements()) {
            DatabaseField databaseField = (DatabaseField)((Object[])enumeration.nextElement())[0];
            abstractRecord.put(databaseField, (Object)null);
        }
    }
}

