/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.oxm.record;

import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.xml.namespace.QName;
import org.eclipse.persistence.exceptions.XMLMarshalException;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.internal.oxm.UnmarshalXPathEngine;
import org.eclipse.persistence.internal.oxm.XMLConversionManager;
import org.eclipse.persistence.internal.oxm.XPathEngine;
import org.eclipse.persistence.internal.sessions.AbstractRecord;
import org.eclipse.persistence.oxm.NamespaceResolver;
import org.eclipse.persistence.oxm.XMLField;
import org.eclipse.persistence.oxm.record.XMLRecord;
import org.eclipse.persistence.platform.xml.XMLNamespaceResolver;
import org.eclipse.persistence.platform.xml.XMLParser;
import org.eclipse.persistence.platform.xml.XMLPlatform;
import org.eclipse.persistence.platform.xml.XMLPlatformFactory;
import org.eclipse.persistence.platform.xml.XMLTransformer;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DOMRecord
extends XMLRecord {
    private Node dom;
    private XMLField lastUpdatedField;

    public DOMRecord() {
    }

    public DOMRecord(String string) {
        this(string, (NamespaceResolver)null);
    }

    public DOMRecord(String string, NamespaceResolver namespaceResolver) {
        this();
        String string2 = this.resolveNamespace(namespaceResolver, string);
        this.setDOM(this.createNewDocument(string, string2));
    }

    public DOMRecord(String string, String string2) {
        this();
        this.setDOM(this.createNewDocument(string, string2));
    }

    public DOMRecord(String string, Node node) {
        this(string, null, node);
    }

    public DOMRecord(String string, NamespaceResolver namespaceResolver, Node node) {
        this();
        Document document = node instanceof Document ? (Document)node : node.getOwnerDocument();
        String string2 = this.resolveNamespace(namespaceResolver, string);
        Element element = document.createElementNS(string2, string);
        node.appendChild(element);
        this.setDOM(element);
    }

    public DOMRecord(Element element) {
        this();
        this.setDOM(element);
    }

    public DOMRecord(Node node) {
        this();
        this.setDOM(node);
    }

    public DOMRecord(Document document) {
        this();
        this.setDOM(document.getDocumentElement());
    }

    public String getLocalName() {
        String string = this.getDOM().getLocalName();
        if (null != string) {
            return string;
        }
        return this.getDOM().getNodeName();
    }

    public String getNamespaceURI() {
        return this.getDOM().getNamespaceURI();
    }

    public void add(DatabaseField databaseField, Object object) {
        Object object2 = this.convertToNodeValue(object);
        XPathEngine.getInstance().create(this.convertToXMLField(databaseField), this.dom, object2, this.session);
    }

    private Object convertToNodeValue(Object object) {
        if (object instanceof Vector) {
            Vector vector = (Vector)object;
            Vector<Object> vector2 = new Vector<Object>(vector.size());
            for (int i = 0; i < vector.size(); ++i) {
                Object e = vector.get(i);
                vector2.add(this.convertToNodeValue(e));
            }
            return vector2;
        }
        if (object instanceof DOMRecord) {
            return ((DOMRecord)object).getDOM();
        }
        return object;
    }

    public void clear() {
        if (this.getDOM() instanceof Element) {
            String string = ((Element)this.getDOM()).getTagName();
            this.dom = this.createNewDocument(string, null);
        }
    }

    public Object clone() {
        DOMRecord dOMRecord = (DOMRecord)super.clone();
        if (dOMRecord != null) {
            dOMRecord.setDOM((Element)this.dom.cloneNode(true));
        }
        return dOMRecord;
    }

    public Node createNewDocument(String string) {
        return this.createNewDocument(string, null);
    }

    public Node createNewDocument(String string, String string2) {
        XMLPlatform xMLPlatform = XMLPlatformFactory.getInstance().getXMLPlatform();
        Document document = xMLPlatform.createDocument();
        if (string != null) {
            Element element = document.createElementNS(string2, string);
            document.appendChild(element);
            return document.getDocumentElement();
        }
        DocumentFragment documentFragment = document.createDocumentFragment();
        return documentFragment;
    }

    public Document getDocument() {
        return this.getDOM().getOwnerDocument();
    }

    public boolean containsKey(DatabaseField databaseField) {
        XMLField xMLField = this.convertToXMLField(databaseField);
        NodeList nodeList = UnmarshalXPathEngine.getInstance().selectNodes(this.dom, xMLField, (XMLNamespaceResolver)xMLField.getNamespaceResolver());
        return nodeList.getLength() > 0;
    }

    public boolean contains(Object object) {
        return this.values().contains(object);
    }

    public Object get(DatabaseField databaseField) {
        Object object = this.getIndicatingNoEntry(databaseField);
        if (object == noEntry) {
            return null;
        }
        return object;
    }

    public Object getIndicatingNoEntry(DatabaseField databaseField) {
        return this.getIndicatingNoEntry(databaseField, false);
    }

    public Object getIndicatingNoEntry(DatabaseField databaseField, boolean bl) {
        XMLField xMLField = this.convertToXMLField(databaseField);
        if (xMLField.isSelfField()) {
            return this;
        }
        Object object = UnmarshalXPathEngine.getInstance().selectSingleNode(this.dom, xMLField, (XMLNamespaceResolver)xMLField.getNamespaceResolver());
        if (object == noEntry) {
            if (bl) {
                return null;
            }
            return noEntry;
        }
        Node node = (Node)object;
        if (bl) {
            return node;
        }
        if (null == node) {
            return null;
        }
        if (1 != node.getNodeType()) {
            if (node.getNodeType() == 2) {
                this.getValueFromAttribute((Attr)node, xMLField);
            }
            return this.getValueFromElement((Element)node.getParentNode(), node, xMLField);
        }
        return this.buildNestedRow((Element)node);
    }

    public Object getValues(String string) {
        Object object = this.getValuesIndicatingNoEntry(new XMLField(string));
        if (object == AbstractRecord.noEntry) {
            return null;
        }
        return object;
    }

    public Object getValues(DatabaseField databaseField) {
        Object object = this.getValuesIndicatingNoEntry(databaseField);
        if (object == AbstractRecord.noEntry) {
            return null;
        }
        return object;
    }

    public Object getValuesIndicatingNoEntry(DatabaseField databaseField) {
        return this.getValuesIndicatingNoEntry(databaseField, false);
    }

    public Object getValuesIndicatingNoEntry(DatabaseField databaseField, boolean bl) {
        XMLField xMLField = this.convertToXMLField(databaseField);
        NodeList nodeList = UnmarshalXPathEngine.getInstance().selectNodes(this.dom, xMLField, (XMLNamespaceResolver)xMLField.getNamespaceResolver());
        if (null == nodeList) {
            return null;
        }
        int n = nodeList.getLength();
        Vector<Object> vector = new Vector<Object>(n);
        if (n == 0) {
            return vector;
        }
        if (bl) {
            for (int i = 0; i < n; ++i) {
                vector.add(nodeList.item(i));
            }
            return vector;
        }
        Node node = nodeList.item(0);
        if (node == null || node.getNodeType() != 1) {
            if (xMLField.usesSingleNode() && n == 1) {
                Node node2 = nodeList.item(0);
                if (node2 == null) {
                    vector.add(null);
                } else {
                    Vector<Object> vector2 = new Vector<Object>();
                    String string = node2.getNodeValue();
                    StringTokenizer stringTokenizer = new StringTokenizer(string, " ");
                    while (stringTokenizer.hasMoreElements()) {
                        String string2 = stringTokenizer.nextToken();
                        Object object = this.convertValue((Element)node2.getParentNode(), xMLField, string2);
                        vector2.add(object);
                    }
                    return vector2;
                }
            }
            for (int i = 0; i < n; ++i) {
                Node node3 = nodeList.item(i);
                if (node3 == null) {
                    vector.add(null);
                    continue;
                }
                vector.add(this.getValueFromElement((Element)node3.getParentNode(), node3, xMLField));
            }
        } else {
            for (int i = 0; i < n; ++i) {
                vector.add(this.buildNestedRow((Element)nodeList.item(i)));
            }
        }
        return vector;
    }

    private Object getValueFromAttribute(Attr attr, XMLField xMLField) {
        return xMLField.convertValueBasedOnSchemaType(attr.getNodeValue(), (XMLConversionManager)this.session.getDatasourcePlatform().getConversionManager());
    }

    private Object getValueFromElement(Element element, Node node, XMLField xMLField) {
        String string = node.getNodeValue();
        return this.convertValue(element, xMLField, string);
    }

    private Object convertValue(Element element, XMLField xMLField, Object object) {
        String string;
        XMLConversionManager xMLConversionManager = (XMLConversionManager)this.session.getDatasourcePlatform().getConversionManager();
        if (xMLField.isTypedTextField() && element != null && null != (string = element.getAttributeNS("http://www.w3.org/2001/XMLSchema-instance", "type")) && !string.equals("")) {
            QName qName = null;
            int n = string.indexOf(58);
            if (n == -1) {
                qName = new QName(string);
                Class clazz = xMLField.getJavaClass(qName);
                return xMLConversionManager.convertObject(object, clazz);
            }
            String string2 = string.substring(0, n);
            String string3 = string.substring(n + 1);
            XMLPlatform xMLPlatform = XMLPlatformFactory.getInstance().getXMLPlatform();
            String string4 = xMLPlatform.resolveNamespacePrefix(element, string2);
            qName = new QName(string4, string3);
            Class clazz = xMLField.getJavaClass(qName);
            return xMLConversionManager.convertObject(object, clazz, qName);
        }
        return xMLField.convertValueBasedOnSchemaType(object, xMLConversionManager);
    }

    public XMLRecord buildNestedRow(Element element) {
        DOMRecord dOMRecord = new DOMRecord(element);
        dOMRecord.setUnmarshaller(this.getUnmarshaller());
        dOMRecord.setOwningObject(this.getCurrentObject());
        dOMRecord.setDocPresPolicy(this.getDocPresPolicy());
        return dOMRecord;
    }

    public Node getDOM() {
        return this.dom;
    }

    public Object put(DatabaseField databaseField, Object object) {
        XMLField xMLField = this.convertToXMLField(databaseField);
        Object object2 = this.convertToNodeValue(object);
        NodeList nodeList = null;
        boolean bl = false;
        if (object2 instanceof Collection) {
            bl = ((Collection)object2).size() == 0;
            nodeList = XPathEngine.getInstance().replaceCollection(this.convertToXMLField(databaseField), this.dom, (Collection)object2, this.session);
        } else {
            nodeList = XPathEngine.getInstance().replaceValue(this.convertToXMLField(databaseField), this.dom, object2, this.session);
        }
        if (nodeList.getLength() == 0) {
            XPathEngine.getInstance().create(this.convertToXMLField(databaseField), this.dom, object2, this.lastUpdatedField, this.getDocPresPolicy(), this.session);
        } else if (nodeList.item(0) == this.getDOM()) {
            this.setDOM(this.getDocument().getDocumentElement());
        }
        if (!(xMLField.getXPathFragment().isAttribute() || xMLField.getXPathFragment().nameIsText() || object == null || bl)) {
            this.lastUpdatedField = xMLField;
        }
        return nodeList;
    }

    public Object remove(DatabaseField databaseField) {
        return XPathEngine.getInstance().remove(this.convertToXMLField(databaseField), this.dom, true);
    }

    public void replaceAt(Object object, int n) {
        throw XMLMarshalException.operationNotSupported("replaceAt(Object value, int index)");
    }

    public Set entrySet() {
        int n = this.size();
        HashMap hashMap = new HashMap(n);
        Vector vector = this.getFields();
        Vector vector2 = this.getValues();
        for (int i = 0; i < n; ++i) {
            hashMap.put(vector.elementAt(i), vector2.elementAt(i));
        }
        return hashMap.entrySet();
    }

    protected void setFields(Vector vector) throws XMLMarshalException {
        throw XMLMarshalException.operationNotSupported("setField(Vector fields)");
    }

    public Vector getFields() {
        int n = this.getDOM().getChildNodes().getLength();
        Node node = null;
        if (n > 0) {
            node = this.getDOM().getChildNodes().item(0);
        }
        Vector<DatabaseField> vector = new Vector<DatabaseField>(n);
        while (node != null) {
            vector.add(new DatabaseField(node.getNodeName()));
            node = node.getNextSibling();
        }
        return vector;
    }

    public Vector getValues() {
        int n = this.getDOM().getChildNodes().getLength();
        Node node = null;
        if (n > 0) {
            node = this.getDOM().getFirstChild();
        }
        Vector<Node> vector = new Vector<Node>(n);
        while (node != null) {
            vector.add(node);
            node = node.getNextSibling();
        }
        return vector;
    }

    protected void setValues(Vector vector) throws XMLMarshalException {
        throw XMLMarshalException.operationNotSupported("setValues(Vector values)");
    }

    public void setDOM(Node node) {
        this.dom = node;
        this.getNamespaceResolver().setDOM(node);
    }

    public void setDOM(Element element) {
        this.dom = element;
        this.getNamespaceResolver().setDOM(element);
    }

    public String toString() {
        StringWriter stringWriter = new StringWriter();
        stringWriter.write(Helper.getShortClassName(this.getClass()));
        stringWriter.write("(");
        this.transformToWriter(stringWriter);
        stringWriter.write(")");
        return stringWriter.toString();
    }

    public Set keySet() {
        int n = this.getDOM().getChildNodes().getLength();
        HashSet<String> hashSet = new HashSet<String>(n);
        for (int i = 0; i < n; ++i) {
            hashSet.add(this.getDOM().getChildNodes().item(i).getNodeName());
        }
        return hashSet;
    }

    public Collection values() {
        int n = this.getDOM().getChildNodes().getLength();
        Vector<Node> vector = new Vector<Node>(n);
        for (int i = 0; i < n; ++i) {
            vector.add(this.getDOM().getChildNodes().item(i));
        }
        return vector;
    }

    public int size() {
        return this.getDOM().getAttributes().getLength() + this.getDOM().getChildNodes().getLength();
    }

    public void transformFromXML(String string) {
        StringReader stringReader = new StringReader(string);
        this.transformFromXML(stringReader);
    }

    private String resolveNamespace(NamespaceResolver namespaceResolver, String string) {
        if (string == null) {
            return null;
        }
        int n = string.indexOf(58);
        if (n < 0) {
            if (namespaceResolver != null) {
                return namespaceResolver.getDefaultNamespaceURI();
            }
            return null;
        }
        if (namespaceResolver == null) {
            throw XMLMarshalException.namespaceResolverNotSpecified(string);
        }
        String string2 = string.substring(0, n);
        String string3 = namespaceResolver.resolveNamespacePrefix(string2);
        if (string3 == null) {
            throw XMLMarshalException.namespaceNotFound(string2);
        }
        return string3;
    }

    public void transformFromXML(Reader reader) {
        XMLParser xMLParser = XMLPlatformFactory.getInstance().getXMLPlatform().newXMLParser();
        Document document = xMLParser.parse(reader);
        this.setDOM(document.getDocumentElement());
    }

    public String transformToXML() {
        StringWriter stringWriter = new StringWriter();
        this.transformToWriter(stringWriter);
        return stringWriter.toString();
    }

    public void transformToWriter(Writer writer) {
        XMLTransformer xMLTransformer = XMLPlatformFactory.getInstance().getXMLPlatform().newXMLTransformer();
        xMLTransformer.transform(this.getDOM(), writer);
    }

    public String resolveNamespacePrefix(String string) {
        XMLPlatform xMLPlatform = XMLPlatformFactory.getInstance().getXMLPlatform();
        return xMLPlatform.resolveNamespacePrefix(this.getDOM(), string);
    }
}

