/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.platform.database;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Hashtable;
import java.util.Vector;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.expressions.ExpressionOperator;
import org.eclipse.persistence.internal.databaseaccess.FieldTypeDefinition;
import org.eclipse.persistence.internal.expressions.ParameterExpression;
import org.eclipse.persistence.internal.helper.BasicTypeHelperImpl;
import org.eclipse.persistence.internal.helper.ClassConstants;
import org.eclipse.persistence.internal.helper.DatabaseTable;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.platform.database.DatabasePlatform;
import org.eclipse.persistence.queries.SQLCall;
import org.eclipse.persistence.queries.ValueReadQuery;

public class DB2Platform
extends DatabasePlatform {
    public DB2Platform() {
        this.pingSQL = "VALUES(1)";
    }

    protected void appendByteArray(byte[] byArray, Writer writer) throws IOException {
        if (this.usesNativeSQL()) {
            writer.write("BLOB(x'");
            Helper.writeHexString(byArray, writer);
            writer.write("')");
        } else {
            super.appendByteArray(byArray, writer);
        }
    }

    protected void appendDate(Date date, Writer writer) throws IOException {
        if (this.usesNativeSQL()) {
            this.appendDB2Date(date, writer);
        } else {
            super.appendDate(date, writer);
        }
    }

    protected void appendDB2Date(Date date, Writer writer) throws IOException {
        writer.write("'");
        Calendar calendar = Helper.allocateCalendar();
        calendar.setTime(date);
        if (calendar.get(2) + 1 < 10) {
            writer.write(48);
        }
        writer.write(Integer.toString(calendar.get(2) + 1));
        writer.write(47);
        if (calendar.get(5) < 10) {
            writer.write(48);
        }
        writer.write(Integer.toString(calendar.get(5)));
        writer.write(47);
        writer.write(Integer.toString(calendar.get(1)));
        writer.write("'");
        Helper.releaseCalendar(calendar);
    }

    protected void appendDB2Timestamp(Timestamp timestamp, Writer writer) throws IOException {
        Calendar calendar = Helper.allocateCalendar();
        calendar.setTime(timestamp);
        writer.write(Helper.printDate(calendar));
        writer.write(45);
        if (calendar.get(11) < 10) {
            writer.write(48);
        }
        writer.write(Integer.toString(calendar.get(11)));
        writer.write(46);
        if (calendar.get(12) < 10) {
            writer.write(48);
        }
        writer.write(Integer.toString(calendar.get(12)));
        writer.write(46);
        if (calendar.get(13) < 10) {
            writer.write(48);
        }
        writer.write(Integer.toString(calendar.get(13)));
        writer.write(46);
        Helper.releaseCalendar(calendar);
        String string = Integer.toString(timestamp.getNanos());
        int n = 0;
        for (int i = Math.min(9 - string.length(), 6); i > 0; --i) {
            writer.write(48);
            ++n;
        }
        if (string.length() + n > 6) {
            string = string.substring(0, 6 - n);
        }
        writer.write(string);
    }

    protected void appendDB2Calendar(Calendar calendar, Writer writer) throws IOException {
        int n;
        int n2;
        int n3;
        Object object;
        if (!Helper.getDefaultTimeZone().equals(calendar.getTimeZone())) {
            object = Helper.allocateCalendar();
            ((Calendar)object).setTimeInMillis(calendar.getTimeInMillis());
            n3 = calendar.get(11);
            n2 = calendar.get(12);
            n = calendar.get(13);
            Helper.releaseCalendar((Calendar)object);
        } else {
            n3 = calendar.get(11);
            n2 = calendar.get(12);
            n = calendar.get(13);
        }
        writer.write(Helper.printDate(calendar));
        writer.write(45);
        if (n3 < 10) {
            writer.write(48);
        }
        writer.write(Integer.toString(n3));
        writer.write(46);
        if (n2 < 10) {
            writer.write(48);
        }
        writer.write(Integer.toString(n2));
        writer.write(46);
        if (n < 10) {
            writer.write(48);
        }
        writer.write(Integer.toString(n));
        writer.write(46);
        object = Integer.toString(calendar.get(14));
        int n4 = 0;
        for (int i = Math.min(3 - ((String)object).length(), 3); i > 0; --i) {
            writer.write(48);
            ++n4;
        }
        if (((String)object).length() + n4 > 3) {
            object = ((String)object).substring(0, 3 - n4);
        }
        writer.write((String)object);
    }

    protected void appendTime(Time time, Writer writer) throws IOException {
        if (this.usesNativeSQL()) {
            writer.write("'");
            writer.write(Helper.printTime(time));
            writer.write("'");
        } else {
            super.appendTime(time, writer);
        }
    }

    protected void appendTimestamp(Timestamp timestamp, Writer writer) throws IOException {
        if (this.usesNativeSQL()) {
            writer.write("'");
            this.appendDB2Timestamp(timestamp, writer);
            writer.write("'");
        } else {
            super.appendTimestamp(timestamp, writer);
        }
    }

    protected void appendCalendar(Calendar calendar, Writer writer) throws IOException {
        if (this.usesNativeSQL()) {
            writer.write("'");
            this.appendDB2Calendar(calendar, writer);
            writer.write("'");
        } else {
            super.appendCalendar(calendar, writer);
        }
    }

    protected Hashtable buildFieldTypes() {
        Hashtable<Class<Timestamp>, FieldTypeDefinition> hashtable = new Hashtable<Class<Timestamp>, FieldTypeDefinition>();
        hashtable.put(Boolean.class, new FieldTypeDefinition("SMALLINT DEFAULT 0", false));
        hashtable.put(Integer.class, new FieldTypeDefinition("INTEGER", false));
        hashtable.put(Long.class, new FieldTypeDefinition("INTEGER", false));
        hashtable.put(Float.class, new FieldTypeDefinition("FLOAT", false));
        hashtable.put(Double.class, new FieldTypeDefinition("FLOAT", false));
        hashtable.put(Short.class, new FieldTypeDefinition("SMALLINT", false));
        hashtable.put(Byte.class, new FieldTypeDefinition("SMALLINT", false));
        hashtable.put(BigInteger.class, new FieldTypeDefinition("BIGINT", false));
        hashtable.put(BigDecimal.class, new FieldTypeDefinition("DECIMAL", 15));
        hashtable.put(Number.class, new FieldTypeDefinition("DECIMAL", 15));
        hashtable.put(String.class, new FieldTypeDefinition("VARCHAR", 255));
        hashtable.put(Character.class, new FieldTypeDefinition("CHAR", 1));
        hashtable.put(Byte[].class, new FieldTypeDefinition("BLOB", 64000));
        hashtable.put(Character[].class, new FieldTypeDefinition("CLOB", 64000));
        hashtable.put(byte[].class, new FieldTypeDefinition("BLOB", 64000));
        hashtable.put(char[].class, new FieldTypeDefinition("CLOB", 64000));
        hashtable.put(Blob.class, new FieldTypeDefinition("BLOB", 64000));
        hashtable.put(Clob.class, new FieldTypeDefinition("CLOB", 64000));
        hashtable.put(Date.class, new FieldTypeDefinition("DATE", false));
        hashtable.put(Time.class, new FieldTypeDefinition("TIME", false));
        hashtable.put(Timestamp.class, new FieldTypeDefinition("TIMESTAMP", false));
        return hashtable;
    }

    public int getMaxFieldNameSize() {
        return 128;
    }

    public int getMaxForeignKeyNameSize() {
        return 18;
    }

    public Vector getNativeTableInfo(String string, String string2, AbstractSession abstractSession) {
        String string3 = "SELECT * FROM SYSIBM.SYSTABLES WHERE TBCREATOR NOT IN ('SYS', 'SYSTEM')";
        if (string != null) {
            string3 = string.indexOf(37) != -1 ? string3 + " AND TBNAME LIKE " + string : string3 + " AND TBNAME = " + string;
        }
        if (string2 != null) {
            string3 = string2.indexOf(37) != -1 ? string3 + " AND TBCREATOR LIKE " + string2 : string3 + " AND TBCREATOR = " + string2;
        }
        return abstractSession.executeSelectingCall(new SQLCall(string3));
    }

    public String getProcedureCallHeader() {
        return "CALL ";
    }

    public String getSelectForUpdateString() {
        return " FOR UPDATE";
    }

    public String getProcedureEndString() {
        return "END";
    }

    public String getProcedureBeginString() {
        return "BEGIN";
    }

    public String getProcedureAsString() {
        return "";
    }

    public boolean shouldPrintOutputTokenAtStart() {
        return true;
    }

    public ValueReadQuery getTimestampQuery() {
        if (this.timestampQuery == null) {
            this.timestampQuery = new ValueReadQuery();
            this.timestampQuery.setSQLString("SELECT DISTINCT CURRENT TIMESTAMP FROM SYSIBM.SYSTABLES");
        }
        return this.timestampQuery;
    }

    protected void initializePlatformOperators() {
        super.initializePlatformOperators();
        this.addOperator(ExpressionOperator.simpleFunction(28, "UCASE"));
        this.addOperator(ExpressionOperator.simpleFunction(29, "LCASE"));
        this.addOperator(this.concatOperator());
        this.addOperator(ExpressionOperator.simpleTwoArgumentFunction(34, "Locate"));
        this.addOperator(ExpressionOperator.simpleFunction(42, "DECIMAL"));
        this.addOperator(ExpressionOperator.simpleFunction(114, "CHAR"));
        this.addOperator(ExpressionOperator.simpleFunction(48, "CHAR"));
        this.addOperator(ExpressionOperator.simpleFunction(53, "DATE"));
    }

    public boolean isDB2() {
        return true;
    }

    public Hashtable maximumNumericValues() {
        Hashtable<Class, Number> hashtable = new Hashtable<Class, Number>();
        hashtable.put(Integer.class, new Integer(Integer.MAX_VALUE));
        hashtable.put(Long.class, new Long(Integer.MAX_VALUE));
        hashtable.put(Float.class, new Float(1.2345679E8f));
        hashtable.put(Double.class, new Double(3.4028234663852886E38));
        hashtable.put(Short.class, new Short(Short.MAX_VALUE));
        hashtable.put(Byte.class, new Byte(127));
        hashtable.put(BigInteger.class, new BigInteger("999999999999999"));
        hashtable.put(BigDecimal.class, new BigDecimal("0.999999999999999"));
        return hashtable;
    }

    public Hashtable minimumNumericValues() {
        Hashtable<Class, Number> hashtable = new Hashtable<Class, Number>();
        hashtable.put(Integer.class, new Integer(Integer.MIN_VALUE));
        hashtable.put(Long.class, new Long(Integer.MIN_VALUE));
        hashtable.put(Float.class, new Float(-1.2345679E8f));
        hashtable.put(Double.class, new Double(1.4E-45f));
        hashtable.put(Short.class, new Short(Short.MIN_VALUE));
        hashtable.put(Byte.class, new Byte(-128));
        hashtable.put(BigInteger.class, new BigInteger("-999999999999999"));
        hashtable.put(BigDecimal.class, new BigDecimal("-0.999999999999999"));
        return hashtable;
    }

    public boolean shouldIgnoreException(SQLException sQLException) {
        if (sQLException.getMessage().equals("No data found") || sQLException.getMessage().equals("No row was found for FETCH, UPDATE or DELETE; or the result of a query is an empty table") || sQLException.getErrorCode() == 100) {
            return true;
        }
        return super.shouldIgnoreException(sQLException);
    }

    public boolean shouldUseJDBCOuterJoinSyntax() {
        return false;
    }

    private ExpressionOperator concatOperator() {
        ExpressionOperator expressionOperator = new ExpressionOperator();
        expressionOperator.setType(5);
        expressionOperator.setSelector(31);
        Vector<String> vector = new Vector<String>(5);
        vector.addElement("VARCHAR(");
        vector.addElement(" || ");
        vector.addElement(")");
        expressionOperator.printsAs(vector);
        expressionOperator.bePrefix();
        expressionOperator.setNodeClass(ClassConstants.FunctionExpression_Class);
        return expressionOperator;
    }

    public ValueReadQuery buildSelectQueryForIdentity() {
        ValueReadQuery valueReadQuery = new ValueReadQuery();
        StringWriter stringWriter = new StringWriter();
        stringWriter.write("SELECT IDENTITY_VAL_LOCAL() FROM SYSIBM.SYSDUMMY1");
        valueReadQuery.setSQLString(stringWriter.toString());
        return valueReadQuery;
    }

    public void printFieldIdentityClause(Writer writer) throws ValidationException {
        try {
            writer.write(" GENERATED ALWAYS AS IDENTITY");
        }
        catch (IOException iOException) {
            throw ValidationException.fileError(iOException);
        }
    }

    public boolean supportsIdentity() {
        return true;
    }

    public boolean supportsGlobalTempTables() {
        return true;
    }

    protected String getCreateTempTableSqlPrefix() {
        return "DECLARE GLOBAL TEMPORARY TABLE ";
    }

    public DatabaseTable getTempTableForTable(DatabaseTable databaseTable) {
        DatabaseTable databaseTable2 = super.getTempTableForTable(databaseTable);
        databaseTable2.setTableQualifier("session");
        return databaseTable2;
    }

    protected String getCreateTempTableSqlSuffix() {
        return " ON COMMIT DELETE ROWS NOT LOGGED";
    }

    protected String getCreateTempTableSqlBodyForTable(DatabaseTable databaseTable) {
        return " LIKE " + databaseTable.getQualifiedName();
    }

    public boolean dontBindUpdateAllQueryUsingTempTables() {
        return true;
    }

    public boolean isNullAllowedInSelectClause() {
        return false;
    }

    public void writeParameterMarker(Writer writer, ParameterExpression parameterExpression) throws IOException {
        String string = "?";
        Object object = parameterExpression.getType();
        if (object != null) {
            BasicTypeHelperImpl basicTypeHelperImpl = BasicTypeHelperImpl.getInstance();
            String string2 = null;
            if (basicTypeHelperImpl.isBooleanType(object) || basicTypeHelperImpl.isByteType(object) || basicTypeHelperImpl.isShortType(object)) {
                string2 = "SMALLINT";
            } else if (basicTypeHelperImpl.isIntType(object)) {
                string2 = "INTEGER";
            } else if (basicTypeHelperImpl.isLongType(object)) {
                string2 = "BIGINT";
            } else if (basicTypeHelperImpl.isFloatType(object)) {
                string2 = "REAL";
            } else if (basicTypeHelperImpl.isDoubleType(object)) {
                string2 = "DOUBLE";
            } else if (basicTypeHelperImpl.isStringType(object)) {
                string2 = "VARCHAR(32672)";
            }
            if (string2 != null) {
                string = "CAST (? AS " + string2 + " )";
            }
        }
        writer.write(string);
    }

    public boolean shouldBindLiterals() {
        return false;
    }
}

