/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.platform.database;

import java.io.Writer;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Hashtable;
import org.eclipse.persistence.internal.databaseaccess.FieldTypeDefinition;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.platform.database.DatabasePlatform;

public class DBasePlatform
extends DatabasePlatform {
    protected Hashtable buildFieldTypes() {
        Hashtable<Class<Timestamp>, FieldTypeDefinition> hashtable = new Hashtable<Class<Timestamp>, FieldTypeDefinition>();
        hashtable.put(Boolean.class, new FieldTypeDefinition("NUMBER", 1));
        hashtable.put(Integer.class, new FieldTypeDefinition("NUMBER", 11));
        hashtable.put(Long.class, new FieldTypeDefinition("NUMBER", 19));
        hashtable.put(Float.class, new FieldTypeDefinition("NUMBER", 12, 5).setLimits(19, 0, 19));
        hashtable.put(Double.class, new FieldTypeDefinition("NUMBER", 10, 5).setLimits(19, 0, 19));
        hashtable.put(Short.class, new FieldTypeDefinition("NUMBER", 6));
        hashtable.put(Byte.class, new FieldTypeDefinition("NUMBER", 4));
        hashtable.put(BigInteger.class, new FieldTypeDefinition("NUMBER", 19));
        hashtable.put(BigDecimal.class, new FieldTypeDefinition("NUMBER", 19).setLimits(19, 0, 9));
        hashtable.put(Number.class, new FieldTypeDefinition("NUMBER", 19).setLimits(19, 0, 9));
        hashtable.put(String.class, new FieldTypeDefinition("CHAR", 255));
        hashtable.put(Character.class, new FieldTypeDefinition("CHAR", 1));
        hashtable.put(Byte[].class, new FieldTypeDefinition("BINARY"));
        hashtable.put(Character[].class, new FieldTypeDefinition("MEMO"));
        hashtable.put(byte[].class, new FieldTypeDefinition("BINARY"));
        hashtable.put(char[].class, new FieldTypeDefinition("MEMO"));
        hashtable.put(Blob.class, new FieldTypeDefinition("BINARY"));
        hashtable.put(Clob.class, new FieldTypeDefinition("MEMO"));
        hashtable.put(Date.class, new FieldTypeDefinition("DATE", false));
        hashtable.put(Time.class, new FieldTypeDefinition("CHAR", 15));
        hashtable.put(Timestamp.class, new FieldTypeDefinition("CHAR", 25));
        return hashtable;
    }

    public Object convertToDatabaseType(Object object) {
        Object object2 = super.convertToDatabaseType(object);
        if (object2 instanceof Time || object2 instanceof Timestamp) {
            object2 = object2.toString();
        }
        return object2;
    }

    public void setParameterValueInDatabaseCall(Object object, PreparedStatement preparedStatement, int n, AbstractSession abstractSession) throws SQLException {
        Object object2 = super.convertToDatabaseType(object);
        if (object2 instanceof Time || object2 instanceof Timestamp) {
            object2 = object2.toString();
        }
        super.setParameterValueInDatabaseCall(object2, preparedStatement, n, abstractSession);
    }

    public int getMaxFieldNameSize() {
        return 10;
    }

    public String getSelectForUpdateString() {
        return " FOR UPDATE OF *";
    }

    public boolean isDBase() {
        return true;
    }

    public Hashtable maximumNumericValues() {
        Hashtable<Class, Number> hashtable = new Hashtable<Class, Number>();
        hashtable.put(Integer.class, new Integer(Integer.MAX_VALUE));
        hashtable.put(Long.class, Long.valueOf("922337203685478000"));
        hashtable.put(Double.class, new Double("99999999.999999999"));
        hashtable.put(Short.class, new Short(Short.MIN_VALUE));
        hashtable.put(Byte.class, new Byte(-128));
        hashtable.put(Float.class, new Float("99999999.999999999"));
        hashtable.put(BigInteger.class, new BigInteger("922337203685478000"));
        hashtable.put(BigDecimal.class, new BigDecimal("999999.999999999"));
        return hashtable;
    }

    public Hashtable minimumNumericValues() {
        Hashtable<Class, Number> hashtable = new Hashtable<Class, Number>();
        hashtable.put(Integer.class, new Integer(Integer.MIN_VALUE));
        hashtable.put(Long.class, Long.valueOf("-922337203685478000"));
        hashtable.put(Double.class, new Double("-99999999.999999999"));
        hashtable.put(Short.class, new Short(Short.MIN_VALUE));
        hashtable.put(Byte.class, new Byte(-128));
        hashtable.put(Float.class, new Float("-99999999.999999999"));
        hashtable.put(BigInteger.class, new BigInteger("-922337203685478000"));
        hashtable.put(BigDecimal.class, new BigDecimal("-999999.999999999"));
        return hashtable;
    }

    public void printFieldNotNullClause(Writer writer) {
    }

    public boolean shouldUseJDBCOuterJoinSyntax() {
        return false;
    }

    public boolean supportsForeignKeyConstraints() {
        return false;
    }

    public boolean supportsPrimaryKeyConstraint() {
        return false;
    }
}

