/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.platform.database;

import java.io.IOException;
import java.io.Writer;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.expressions.ExpressionOperator;
import org.eclipse.persistence.internal.databaseaccess.FieldTypeDefinition;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.helper.DatabaseTable;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.platform.database.DB2Platform;
import org.eclipse.persistence.queries.ValueReadQuery;

public class DerbyPlatform
extends DB2Platform {
    protected void appendByteArray(byte[] byArray, Writer writer) throws IOException {
        super.appendByteArray(byArray, writer);
    }

    public ValueReadQuery getTimestampQuery() {
        if (this.timestampQuery == null) {
            this.timestampQuery = new ValueReadQuery();
            this.timestampQuery.setSQLString("VALUES CURRENT_TIMESTAMP");
        }
        return this.timestampQuery;
    }

    public Vector getNativeTableInfo(String string, String string2, AbstractSession abstractSession) {
        throw new RuntimeException("Should never reach here");
    }

    public String getProcedureEndString() {
        return this.getBatchEndString();
    }

    public String getProcedureBeginString() {
        return this.getBatchBeginString();
    }

    public String getInOutputProcedureToken() {
        return "INOUT";
    }

    public boolean shouldPrintOutputTokenAtStart() {
        return false;
    }

    public boolean isDerby() {
        return true;
    }

    public boolean isDB2() {
        return false;
    }

    public String getSelectForUpdateString() {
        return " FOR UPDATE WITH RS";
    }

    public boolean shouldIgnoreException(SQLException sQLException) {
        return false;
    }

    protected String getCreateTempTableSqlSuffix() {
        return " ON COMMIT DELETE ROWS NOT LOGGED";
    }

    public ValueReadQuery buildSelectQueryForIdentity() {
        ValueReadQuery valueReadQuery = new ValueReadQuery();
        valueReadQuery.setSQLString("values IDENTITY_VAL_LOCAL()");
        return valueReadQuery;
    }

    protected boolean shouldTempTableSpecifyPrimaryKeys() {
        return false;
    }

    protected String getCreateTempTableSqlBodyForTable(DatabaseTable databaseTable) {
        return null;
    }

    public void writeUpdateOriginalFromTempTableSql(Writer writer, DatabaseTable databaseTable, Collection collection, Collection collection2) throws IOException {
        writer.write("UPDATE ");
        String string = databaseTable.getQualifiedName();
        writer.write(string);
        writer.write(" SET ");
        String string2 = this.getTempTableForTable(databaseTable).getQualifiedName();
        boolean bl = true;
        Iterator iterator = collection2.iterator();
        while (iterator.hasNext()) {
            if (bl) {
                bl = false;
            } else {
                writer.write(", ");
            }
            DatabaseField databaseField = (DatabaseField)iterator.next();
            String string3 = databaseField.getName();
            writer.write(string3);
            writer.write(" = (SELECT ");
            writer.write(string3);
            writer.write(" FROM ");
            writer.write(string2);
            DerbyPlatform.writeAutoJoinWhereClause(writer, null, string, collection);
            writer.write(")");
        }
        writer.write(" WHERE EXISTS(SELECT ");
        writer.write(((DatabaseField)collection.iterator().next()).getName());
        writer.write(" FROM ");
        writer.write(string2);
        DerbyPlatform.writeAutoJoinWhereClause(writer, null, string, collection);
        writer.write(")");
    }

    public void printFieldIdentityClause(Writer writer) throws ValidationException {
        try {
            writer.write(" GENERATED ALWAYS AS IDENTITY");
        }
        catch (IOException iOException) {
            throw ValidationException.fileError(iOException);
        }
    }

    protected Hashtable buildFieldTypes() {
        Hashtable<Class<Timestamp>, FieldTypeDefinition> hashtable = new Hashtable<Class<Timestamp>, FieldTypeDefinition>();
        hashtable.put(Boolean.class, new FieldTypeDefinition("SMALLINT DEFAULT 0", false));
        hashtable.put(Integer.class, new FieldTypeDefinition("INTEGER", false));
        hashtable.put(Long.class, new FieldTypeDefinition("BIGINT", false));
        hashtable.put(Float.class, new FieldTypeDefinition("FLOAT", false));
        hashtable.put(Double.class, new FieldTypeDefinition("FLOAT", false));
        hashtable.put(Short.class, new FieldTypeDefinition("SMALLINT", false));
        hashtable.put(Byte.class, new FieldTypeDefinition("SMALLINT", false));
        hashtable.put(BigInteger.class, new FieldTypeDefinition("BIGINT", false));
        hashtable.put(BigDecimal.class, new FieldTypeDefinition("DECIMAL", 15));
        hashtable.put(Number.class, new FieldTypeDefinition("DECIMAL", 15));
        hashtable.put(String.class, new FieldTypeDefinition("VARCHAR", 255));
        hashtable.put(Character.class, new FieldTypeDefinition("CHAR", 1));
        hashtable.put(Byte[].class, new FieldTypeDefinition("BLOB", 64000));
        hashtable.put(Character[].class, new FieldTypeDefinition("CLOB", 64000));
        hashtable.put(byte[].class, new FieldTypeDefinition("BLOB", 64000));
        hashtable.put(char[].class, new FieldTypeDefinition("CLOB", 64000));
        hashtable.put(Blob.class, new FieldTypeDefinition("BLOB", 64000));
        hashtable.put(Clob.class, new FieldTypeDefinition("CLOB", 64000));
        hashtable.put(Date.class, new FieldTypeDefinition("DATE", false));
        hashtable.put(Time.class, new FieldTypeDefinition("TIME", false));
        hashtable.put(Timestamp.class, new FieldTypeDefinition("TIMESTAMP", false));
        return hashtable;
    }

    protected void initializePlatformOperators() {
        super.initializePlatformOperators();
        this.addOperator(ExpressionOperator.simpleFunction(42, "DOUBLE"));
    }
}

