/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.platform.database;

import java.io.CharArrayWriter;
import java.io.IOException;
import java.io.Writer;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Hashtable;
import java.util.Vector;
import org.eclipse.persistence.exceptions.DatabaseException;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.expressions.ExpressionOperator;
import org.eclipse.persistence.internal.databaseaccess.DatabaseCall;
import org.eclipse.persistence.internal.databaseaccess.FieldTypeDefinition;
import org.eclipse.persistence.internal.expressions.ExpressionSQLPrinter;
import org.eclipse.persistence.internal.expressions.FunctionExpression;
import org.eclipse.persistence.internal.expressions.RelationExpression;
import org.eclipse.persistence.internal.expressions.SQLSelectStatement;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.internal.helper.NonSynchronizedVector;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.platform.database.DatabasePlatform;
import org.eclipse.persistence.queries.SQLCall;
import org.eclipse.persistence.queries.ValueReadQuery;

public class OraclePlatform
extends DatabasePlatform {
    protected boolean supportsIdentity;
    private static final String SELECT = "SELECT * FROM (SELECT ";
    private static final String HINT = "/*+ FIRST_ROWS */ ";
    private static final String FROM = "a.*, ROWNUM rnum  FROM (";
    private static final String END_FROM = ") a ";
    private static final String MAX_ROW = "WHERE ROWNUM <= ";
    private static final String MIN_ROW = ") WHERE rnum > ";

    public OraclePlatform() {
        this.pingSQL = "SELECT 1 FROM DUAL";
    }

    public boolean allowsSizeInProcedureArguments() {
        return false;
    }

    protected void appendByteArray(byte[] byArray, Writer writer) throws IOException {
        if (this.usesNativeSQL()) {
            writer.write(39);
            Helper.writeHexString(byArray, writer);
            writer.write(39);
        } else {
            super.appendByteArray(byArray, writer);
        }
    }

    protected void appendDate(Date date, Writer writer) throws IOException {
        if (this.usesNativeSQL()) {
            writer.write("to_date('");
            writer.write(Helper.printDate(date));
            writer.write("','yyyy-mm-dd')");
        } else {
            super.appendDate(date, writer);
        }
    }

    protected void appendTime(Time time, Writer writer) throws IOException {
        if (this.usesNativeSQL()) {
            writer.write("to_date('");
            writer.write(Helper.printTime(time));
            writer.write("','hh24:mi:ss')");
        } else {
            super.appendTime(time, writer);
        }
    }

    protected void appendTimestamp(Timestamp timestamp, Writer writer) throws IOException {
        if (this.usesNativeSQL()) {
            writer.write("to_date('");
            writer.write(Helper.printTimestampWithoutNanos(timestamp));
            writer.write("','yyyy-mm-dd hh24:mi:ss')");
        } else {
            super.appendTimestamp(timestamp, writer);
        }
    }

    protected void appendCalendar(Calendar calendar, Writer writer) throws IOException {
        if (this.usesNativeSQL()) {
            writer.write("to_date('");
            writer.write(Helper.printCalendarWithoutNanos(calendar));
            writer.write("','yyyy-mm-dd hh24:mi:ss')");
        } else {
            super.appendCalendar(calendar, writer);
        }
    }

    public ExpressionOperator atan2Operator() {
        return ExpressionOperator.simpleTwoArgumentFunction(91, "ATAN2");
    }

    protected Hashtable buildFieldTypes() {
        Hashtable<Class<java.util.Date>, FieldTypeDefinition> hashtable = new Hashtable<Class<java.util.Date>, FieldTypeDefinition>();
        hashtable.put(Boolean.class, new FieldTypeDefinition("NUMBER(1) default 0", false));
        hashtable.put(Integer.class, new FieldTypeDefinition("NUMBER", 10));
        hashtable.put(Long.class, new FieldTypeDefinition("NUMBER", 19));
        hashtable.put(Float.class, new FieldTypeDefinition("NUMBER", 19, 4));
        hashtable.put(Double.class, new FieldTypeDefinition("NUMBER", 19, 4));
        hashtable.put(Short.class, new FieldTypeDefinition("NUMBER", 5));
        hashtable.put(Byte.class, new FieldTypeDefinition("NUMBER", 3));
        hashtable.put(BigInteger.class, new FieldTypeDefinition("NUMBER", 38));
        hashtable.put(BigDecimal.class, new FieldTypeDefinition("NUMBER", 38).setLimits(38, -38, 38));
        hashtable.put(Number.class, new FieldTypeDefinition("NUMBER", 38).setLimits(38, -38, 38));
        hashtable.put(String.class, new FieldTypeDefinition("VARCHAR2", 255));
        hashtable.put(Character.class, new FieldTypeDefinition("CHAR", 1));
        hashtable.put(Byte[].class, new FieldTypeDefinition("BLOB", false));
        hashtable.put(Character[].class, new FieldTypeDefinition("CLOB", false));
        hashtable.put(byte[].class, new FieldTypeDefinition("BLOB", false));
        hashtable.put(char[].class, new FieldTypeDefinition("CLOB", false));
        hashtable.put(Blob.class, new FieldTypeDefinition("BLOB", false));
        hashtable.put(Clob.class, new FieldTypeDefinition("CLOB", false));
        hashtable.put(Date.class, new FieldTypeDefinition("DATE", false));
        hashtable.put(Time.class, new FieldTypeDefinition("TIMESTAMP", false));
        hashtable.put(Timestamp.class, new FieldTypeDefinition("TIMESTAMP", false));
        hashtable.put(Calendar.class, new FieldTypeDefinition("TIMESTAMP"));
        hashtable.put(java.util.Date.class, new FieldTypeDefinition("TIMESTAMP"));
        return hashtable;
    }

    public DatabaseCall buildCallWithReturning(SQLCall sQLCall, Vector vector) {
        SQLCall sQLCall2 = new SQLCall();
        sQLCall2.setParameters(sQLCall.getParameters());
        sQLCall2.setParameterTypes(sQLCall.getParameterTypes());
        CharArrayWriter charArrayWriter = new CharArrayWriter(200);
        try {
            DatabaseField databaseField;
            int n;
            charArrayWriter.write("BEGIN ");
            charArrayWriter.write(sQLCall.getSQLString());
            charArrayWriter.write(" RETURNING ");
            for (n = 0; n < vector.size(); ++n) {
                databaseField = (DatabaseField)vector.elementAt(n);
                charArrayWriter.write(databaseField.getName());
                if (n + 1 >= vector.size()) continue;
                charArrayWriter.write(", ");
            }
            charArrayWriter.write(" INTO ");
            for (n = 0; n < vector.size(); ++n) {
                databaseField = (DatabaseField)vector.elementAt(n);
                sQLCall2.appendOut(charArrayWriter, databaseField);
                if (n + 1 >= vector.size()) continue;
                charArrayWriter.write(", ");
            }
            charArrayWriter.write("; END;");
            sQLCall2.setQueryString(((Object)charArrayWriter).toString());
        }
        catch (IOException iOException) {
            throw ValidationException.fileError(iOException);
        }
        return sQLCall2;
    }

    public boolean canBuildCallWithReturning() {
        return true;
    }

    public String getAssignmentString() {
        return ":= ";
    }

    public String getDeclareBeginString() {
        return "DECLARE ";
    }

    public String getBatchBeginString() {
        return "BEGIN ";
    }

    public String getBatchEndString() {
        return "END;";
    }

    public int getMaxFieldNameSize() {
        return 30;
    }

    public Vector getNativeTableInfo(String string, String string2, AbstractSession abstractSession) {
        String string3 = "SELECT * FROM ALL_TABLES WHERE OWNER NOT IN ('SYS', 'SYSTEM')";
        if (string != null) {
            string3 = string.indexOf(37) != -1 ? string3 + " AND TABLE_NAME LIKE " + string : string3 + " AND TABLE_NAME = " + string;
        }
        if (string2 != null) {
            string3 = string2.indexOf(37) != -1 ? string3 + " AND OWNER LIKE " + string2 : string3 + " AND OWNER = " + string2;
        }
        return abstractSession.executeSelectingCall(new SQLCall(string3));
    }

    public String getProcedureArgumentSetter() {
        return "=>";
    }

    public String getProcedureCallHeader() {
        return "BEGIN ";
    }

    public String getProcedureCallTail() {
        return "; END;";
    }

    public String getSelectForUpdateString() {
        return " FOR UPDATE";
    }

    public String getSelectForUpdateWaitString(Integer n) {
        return " FOR UPDATE WAIT " + n;
    }

    public String getStoredProcedureParameterPrefix() {
        return "P_";
    }

    public String getStoredProcedureTerminationToken() {
        return "";
    }

    public ValueReadQuery getSystemChangeNumberQuery() {
        ValueReadQuery valueReadQuery = new ValueReadQuery();
        valueReadQuery.setSQLString("SELECT DBMS_FLASHBACK.GET_SYSTEM_CHANGE_NUMBER FROM DUAL");
        return valueReadQuery;
    }

    public ValueReadQuery getTimestampQuery() {
        if (this.timestampQuery == null) {
            this.timestampQuery = new ValueReadQuery();
            this.timestampQuery.setSQLString("SELECT SYSDATE FROM DUAL");
        }
        return this.timestampQuery;
    }

    public Object getObjectFromResultSet(ResultSet resultSet, int n, int n2, AbstractSession abstractSession) throws SQLException {
        if (n2 == 93 || n2 == 91) {
            return resultSet.getTimestamp(n);
        }
        return super.getObjectFromResultSet(resultSet, n, n2, abstractSession);
    }

    protected void initializePlatformOperators() {
        super.initializePlatformOperators();
        this.addOperator(this.operatorOuterJoin());
        this.addOperator(this.logOperator());
        this.addOperator(ExpressionOperator.simpleTwoArgumentFunction(31, "CONCAT"));
        this.addOperator(this.todayOperator());
        this.addOperator(this.currentDateOperator());
        this.addOperator(this.currentTimeOperator());
        this.addOperator(ExpressionOperator.truncateDate());
        this.addOperator(ExpressionOperator.newTime());
        this.addOperator(ExpressionOperator.ifNull());
        this.addOperator(this.atan2Operator());
        this.addOperator(ExpressionOperator.oracleDateName());
        this.addOperator(this.operatorLocate());
        this.addOperator(this.operatorLocate2());
    }

    public boolean isOracle() {
        return true;
    }

    protected ExpressionOperator logOperator() {
        ExpressionOperator expressionOperator = new ExpressionOperator();
        expressionOperator.setSelector(66);
        NonSynchronizedVector nonSynchronizedVector = NonSynchronizedVector.newInstance(2);
        ((Vector)nonSynchronizedVector).addElement("LOG(10,");
        ((Vector)nonSynchronizedVector).addElement(")");
        expressionOperator.printsAs(nonSynchronizedVector);
        expressionOperator.bePrefix();
        expressionOperator.setNodeClass(FunctionExpression.class);
        return expressionOperator;
    }

    public Hashtable maximumNumericValues() {
        Hashtable<Class, Number> hashtable = new Hashtable<Class, Number>();
        hashtable.put(Integer.class, new Integer(Integer.MAX_VALUE));
        hashtable.put(Long.class, new Long(Long.MAX_VALUE));
        hashtable.put(Double.class, new Double(9.9999E125));
        hashtable.put(Short.class, new Short(Short.MAX_VALUE));
        hashtable.put(Byte.class, new Byte(127));
        hashtable.put(Float.class, new Float(Float.MAX_VALUE));
        hashtable.put(BigInteger.class, new BigInteger("0"));
        hashtable.put(BigDecimal.class, new BigDecimal(new BigInteger("0"), 38));
        return hashtable;
    }

    public Hashtable minimumNumericValues() {
        Hashtable<Class, Number> hashtable = new Hashtable<Class, Number>();
        hashtable.put(Integer.class, new Integer(Integer.MIN_VALUE));
        hashtable.put(Long.class, new Long(Long.MIN_VALUE));
        hashtable.put(Double.class, new Double(-1.0E-129));
        hashtable.put(Short.class, new Short(Short.MIN_VALUE));
        hashtable.put(Byte.class, new Byte(-128));
        hashtable.put(Float.class, new Float(Float.MIN_VALUE));
        hashtable.put(BigInteger.class, new BigInteger("0"));
        hashtable.put(BigDecimal.class, new BigDecimal(new BigInteger("0"), 38));
        return hashtable;
    }

    public ValueReadQuery buildSelectQueryForSequenceObject(String string, Integer n) {
        return new ValueReadQuery("SELECT " + this.getQualifiedName(string) + ".NEXTVAL FROM DUAL");
    }

    public ValueReadQuery buildSelectQueryForIdentity(String string, Integer n) {
        return new ValueReadQuery("SELECT " + this.getQualifiedName(string) + ".CURRVAL FROM DUAL");
    }

    protected ExpressionOperator operatorOuterJoin() {
        ExpressionOperator expressionOperator = new ExpressionOperator();
        expressionOperator.setSelector(6);
        NonSynchronizedVector nonSynchronizedVector = NonSynchronizedVector.newInstance(2);
        ((Vector)nonSynchronizedVector).addElement(" (+) = ");
        expressionOperator.printsAs(nonSynchronizedVector);
        expressionOperator.bePostfix();
        expressionOperator.setNodeClass(RelationExpression.class);
        return expressionOperator;
    }

    protected ExpressionOperator operatorLocate() {
        ExpressionOperator expressionOperator = new ExpressionOperator();
        expressionOperator.setSelector(112);
        NonSynchronizedVector nonSynchronizedVector = NonSynchronizedVector.newInstance(2);
        ((Vector)nonSynchronizedVector).addElement("INSTR(");
        ((Vector)nonSynchronizedVector).addElement(", ");
        ((Vector)nonSynchronizedVector).addElement(")");
        expressionOperator.printsAs(nonSynchronizedVector);
        expressionOperator.bePrefix();
        expressionOperator.setNodeClass(RelationExpression.class);
        return expressionOperator;
    }

    protected ExpressionOperator operatorLocate2() {
        ExpressionOperator expressionOperator = new ExpressionOperator();
        expressionOperator.setSelector(113);
        NonSynchronizedVector nonSynchronizedVector = NonSynchronizedVector.newInstance(2);
        ((Vector)nonSynchronizedVector).addElement("INSTR(");
        ((Vector)nonSynchronizedVector).addElement(", ");
        ((Vector)nonSynchronizedVector).addElement(", ");
        ((Vector)nonSynchronizedVector).addElement(")");
        expressionOperator.printsAs(nonSynchronizedVector);
        expressionOperator.bePrefix();
        expressionOperator.setNodeClass(RelationExpression.class);
        return expressionOperator;
    }

    public void printFieldNullClause(Writer writer) throws ValidationException {
        try {
            writer.write(" NULL");
        }
        catch (IOException iOException) {
            throw ValidationException.fileError(iOException);
        }
    }

    public String serverTimestampString() {
        return "SYSDATE";
    }

    public boolean shouldPrintOuterJoinInWhereClause() {
        return true;
    }

    public boolean shouldUseJDBCOuterJoinSyntax() {
        return false;
    }

    public boolean supportsSequenceObjects() {
        return true;
    }

    public boolean supportsIdentity() {
        return this.supportsIdentity;
    }

    public void setSupportsIdentity(boolean bl) {
        this.supportsIdentity = bl;
    }

    public boolean supportsStoredFunctions() {
        return true;
    }

    public boolean supportsSelectForUpdateNoWait() {
        return true;
    }

    protected ExpressionOperator todayOperator() {
        return ExpressionOperator.simpleFunctionNoParentheses(54, "SYSDATE");
    }

    protected ExpressionOperator currentDateOperator() {
        return ExpressionOperator.simpleFunctionNoParentheses(123, "TO_DATE(CURRENT_DATE)");
    }

    protected ExpressionOperator currentTimeOperator() {
        return ExpressionOperator.simpleFunctionNoParentheses(128, "SYSDATE");
    }

    public boolean canUnwrapOracleConnection() {
        return false;
    }

    public Connection unwrapOracleConnection(Connection connection) {
        return connection;
    }

    public void printSQLSelectStatement(DatabaseCall databaseCall, ExpressionSQLPrinter expressionSQLPrinter, SQLSelectStatement sQLSelectStatement) {
        int n = 0;
        int n2 = 0;
        if (sQLSelectStatement.getQuery() != null) {
            n = sQLSelectStatement.getQuery().getMaxRows();
            n2 = sQLSelectStatement.getQuery().getFirstResult();
        }
        if (!this.shouldUseRownumFiltering() || n <= 0 && n2 <= 0) {
            super.printSQLSelectStatement(databaseCall, expressionSQLPrinter, sQLSelectStatement);
            return;
        }
        if (n > 0) {
            sQLSelectStatement.setUseUniqueFieldAliases(true);
            expressionSQLPrinter.printString(SELECT);
            expressionSQLPrinter.printString(HINT);
            expressionSQLPrinter.printString(FROM);
            databaseCall.setFields(sQLSelectStatement.printSQL(expressionSQLPrinter));
            expressionSQLPrinter.printString(END_FROM);
            expressionSQLPrinter.printString(MAX_ROW);
            expressionSQLPrinter.printParameter(DatabaseCall.MAXROW_FIELD);
            expressionSQLPrinter.printString(MIN_ROW);
            expressionSQLPrinter.printParameter(DatabaseCall.FIRSTRESULT_FIELD);
        } else {
            sQLSelectStatement.setUseUniqueFieldAliases(true);
            expressionSQLPrinter.printString(SELECT);
            expressionSQLPrinter.printString(FROM);
            databaseCall.setFields(sQLSelectStatement.printSQL(expressionSQLPrinter));
            expressionSQLPrinter.printString(END_FROM);
            expressionSQLPrinter.printString(MIN_ROW);
            expressionSQLPrinter.printParameter(DatabaseCall.FIRSTRESULT_FIELD);
        }
        databaseCall.setIgnoreFirstRowMaxResultsSettings(true);
    }

    public Writer buildSequenceObjectCreationWriter(Writer writer, String string, int n, int n2) throws IOException {
        writer.write("CREATE SEQUENCE ");
        writer.write(string);
        if (n != 1) {
            writer.write(" INCREMENT BY " + n);
        }
        writer.write(" START WITH " + n2);
        return writer;
    }

    public Writer buildSequenceObjectDeletionWriter(Writer writer, String string) throws IOException {
        writer.write("DROP SEQUENCE ");
        writer.write(string);
        return writer;
    }

    public Writer buildSequenceObjectAlterIncrementWriter(Writer writer, String string, int n) throws IOException {
        writer.write("ALTER SEQUENCE ");
        writer.write(string);
        writer.write(" INCREMENT BY " + n);
        return writer;
    }

    public boolean isAlterSequenceObjectSupported() {
        return true;
    }

    public boolean isLockTimeoutException(DatabaseException databaseException) {
        return databaseException.getInternalException() instanceof SQLException && ((SQLException)databaseException.getInternalException()).getErrorCode() == 30006;
    }

    public boolean wasFailureCommunicationBased(SQLException sQLException, Connection connection, AbstractSession abstractSession) {
        if (sQLException != null) {
            if (sQLException.getErrorCode() == 17410) {
                return true;
            }
            if (sQLException.getErrorCode() == 17002) {
                return true;
            }
            if (sQLException.getErrorCode() == 2399) {
                return true;
            }
            if (sQLException.getErrorCode() == 2396) {
                return true;
            }
        }
        return super.wasFailureCommunicationBased(sQLException, connection, abstractSession);
    }
}

