/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.platform.database;

import java.io.IOException;
import java.io.Writer;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Hashtable;
import java.util.Vector;
import org.eclipse.persistence.expressions.ExpressionOperator;
import org.eclipse.persistence.internal.databaseaccess.FieldTypeDefinition;
import org.eclipse.persistence.internal.expressions.ParameterExpression;
import org.eclipse.persistence.internal.expressions.RelationExpression;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.internal.helper.NonSynchronizedVector;
import org.eclipse.persistence.platform.database.DatabasePlatform;
import org.eclipse.persistence.queries.ValueReadQuery;

public class TimesTenPlatform
extends DatabasePlatform {
    private boolean supportsForeignKeyConstraints = true;

    protected void appendByteArray(byte[] byArray, Writer writer) throws IOException {
        if (this.usesNativeSQL()) {
            writer.write("Ox");
            Helper.writeHexString(byArray, writer);
        } else {
            super.appendByteArray(byArray, writer);
        }
    }

    protected void appendDate(Date date, Writer writer) throws IOException {
        if (this.usesNativeSQL()) {
            writer.write("DATE '");
            writer.write(Helper.printDate(date));
            writer.write("'");
        } else {
            super.appendDate(date, writer);
        }
    }

    protected void appendTime(Time time, Writer writer) throws IOException {
        if (this.usesNativeSQL()) {
            writer.write("TIME '");
            writer.write(Helper.printTime(time));
            writer.write("'");
        } else {
            super.appendTime(time, writer);
        }
    }

    protected void appendTimestamp(Timestamp timestamp, Writer writer) throws IOException {
        if (this.usesNativeSQL()) {
            writer.write("TIMESTAMP '");
            writer.write(Helper.printTimestampWithoutNanos(timestamp));
            writer.write("'");
        } else {
            super.appendTimestamp(timestamp, writer);
        }
    }

    protected void appendCalendar(Calendar calendar, Writer writer) throws IOException {
        if (this.usesNativeSQL()) {
            writer.write("TIMESTAMP '");
            writer.write(Helper.printCalendarWithoutNanos(calendar));
            writer.write("'");
        } else {
            super.appendCalendar(calendar, writer);
        }
    }

    protected Hashtable buildFieldTypes() {
        Hashtable<Class<Timestamp>, FieldTypeDefinition> hashtable = new Hashtable<Class<Timestamp>, FieldTypeDefinition>();
        hashtable.put(Boolean.class, new FieldTypeDefinition("TINYINT", false));
        hashtable.put(Integer.class, new FieldTypeDefinition("INTEGER", false));
        hashtable.put(Long.class, new FieldTypeDefinition("BIGINT", false));
        hashtable.put(Float.class, new FieldTypeDefinition("FLOAT", false));
        hashtable.put(Double.class, new FieldTypeDefinition("DOUBLE", false));
        hashtable.put(Short.class, new FieldTypeDefinition("SMALLINT", false));
        hashtable.put(Byte.class, new FieldTypeDefinition("TINYINT", false));
        hashtable.put(BigInteger.class, new FieldTypeDefinition("BIGINT", false));
        hashtable.put(BigDecimal.class, new FieldTypeDefinition("DECIMAL(38)", false));
        hashtable.put(Number.class, new FieldTypeDefinition("DECIMAL(38)", false));
        hashtable.put(String.class, new FieldTypeDefinition("VARCHAR", 255));
        hashtable.put(Character.class, new FieldTypeDefinition("CHAR", 1));
        hashtable.put(Byte[].class, new FieldTypeDefinition("VARBINARY", 64000));
        hashtable.put(Character[].class, new FieldTypeDefinition("VARCHAR", 64000));
        hashtable.put(byte[].class, new FieldTypeDefinition("VARBINARY", 64000));
        hashtable.put(char[].class, new FieldTypeDefinition("VARCHAR", 64000));
        hashtable.put(Blob.class, new FieldTypeDefinition("VARBINARY", 64000));
        hashtable.put(Clob.class, new FieldTypeDefinition("VARCHAR", 64000));
        hashtable.put(Date.class, new FieldTypeDefinition("DATE", false));
        hashtable.put(Time.class, new FieldTypeDefinition("TIME", false));
        hashtable.put(Timestamp.class, new FieldTypeDefinition("TIMESTAMP", false));
        return hashtable;
    }

    public ValueReadQuery buildSelectQueryForSequenceObject(String string, Integer n) {
        return new ValueReadQuery("SELECT " + this.getQualifiedName(string) + ".NEXTVAL FROM DUAL");
    }

    public String getCreateViewString() {
        return "CREATE MATERIALIZED VIEW ";
    }

    protected String getQualifiedSequenceName(String string) {
        if (this.getTableQualifier().equals("")) {
            return string;
        }
        return this.getTableQualifier() + "." + string;
    }

    public String getSelectForUpdateString() {
        return " FOR UPDATE";
    }

    public ValueReadQuery getTimestampQuery() {
        if (this.timestampQuery == null) {
            this.timestampQuery = new ValueReadQuery();
            this.timestampQuery.setSQLString("SELECT SYSDATE FROM DUAL");
        }
        return this.timestampQuery;
    }

    protected void initializePlatformOperators() {
        super.initializePlatformOperators();
        this.addOperator(ExpressionOperator.simpleTwoArgumentFunction(31, "CONCAT"));
        this.addOperator(this.operatorOuterJoin());
        this.addOperator(ExpressionOperator.ifNull());
    }

    public boolean isTimesTen() {
        return true;
    }

    protected ExpressionOperator operatorOuterJoin() {
        ExpressionOperator expressionOperator = new ExpressionOperator();
        expressionOperator.setSelector(6);
        NonSynchronizedVector nonSynchronizedVector = NonSynchronizedVector.newInstance(2);
        ((Vector)nonSynchronizedVector).addElement(" (+) = ");
        expressionOperator.printsAs(nonSynchronizedVector);
        expressionOperator.bePostfix();
        expressionOperator.setNodeClass(RelationExpression.class);
        return expressionOperator;
    }

    public boolean shouldPrintOuterJoinInWhereClause() {
        return true;
    }

    public boolean supportsSequenceObjects() {
        return true;
    }

    public boolean supportsForeignKeyConstraints() {
        return this.supportsForeignKeyConstraints;
    }

    public void setSupportsForeignKeyConstraints(boolean bl) {
        this.supportsForeignKeyConstraints = bl;
    }

    public Writer buildSequenceObjectCreationWriter(Writer writer, String string, int n, int n2) throws IOException {
        writer.write("CREATE SEQUENCE ");
        writer.write(string);
        if (n != 1) {
            writer.write(" INCREMENT BY " + n);
        }
        writer.write(" START WITH " + n2);
        return writer;
    }

    public Writer buildSequenceObjectDeletionWriter(Writer writer, String string) throws IOException {
        writer.write("DROP SEQUENCE ");
        writer.write(string);
        return writer;
    }

    public void writeParameterMarker(Writer writer, ParameterExpression parameterExpression) throws IOException {
        FieldTypeDefinition fieldTypeDefinition;
        String string = "?";
        Object object = parameterExpression.getType();
        if (object != null && (fieldTypeDefinition = this.getFieldTypeDefinition((Class)object)) != null) {
            string = "CAST (? AS " + fieldTypeDefinition.getName() + " )";
        }
        writer.write(string);
    }

    public boolean shouldBindLiterals() {
        return false;
    }
}

