/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.queries;

import java.util.Enumeration;
import java.util.Vector;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.descriptors.DescriptorEvent;
import org.eclipse.persistence.exceptions.DatabaseException;
import org.eclipse.persistence.exceptions.OptimisticLockException;
import org.eclipse.persistence.exceptions.QueryException;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.internal.sessions.AbstractRecord;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.internal.sessions.UnitOfWorkImpl;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.ModifyAllQuery;
import org.eclipse.persistence.queries.QueryRedirector;

public class DeleteAllQuery
extends ModifyAllQuery {
    protected Vector objects;

    public DeleteAllQuery() {
    }

    public DeleteAllQuery(Class clazz) {
        super(clazz);
    }

    public DeleteAllQuery(Class clazz, Expression expression) {
        super(clazz, expression);
    }

    public boolean isDeleteAllQuery() {
        return true;
    }

    public Object executeInUnitOfWork(UnitOfWorkImpl unitOfWorkImpl, AbstractRecord abstractRecord) throws DatabaseException, OptimisticLockException {
        if (this.getObjects() != null) {
            if (unitOfWorkImpl.isAfterWriteChangesButBeforeCommit()) {
                throw ValidationException.illegalOperationForUnitOfWorkLifecycle(unitOfWorkImpl.getLifecycle(), "executeQuery(DeleteAllQuery)");
            }
            if (!unitOfWorkImpl.getCommitManager().isActive()) {
                return unitOfWorkImpl.getParent().executeQuery((DatabaseQuery)this, abstractRecord);
            }
            this.result = (Integer)super.execute(unitOfWorkImpl, abstractRecord);
            return this.result;
        }
        return super.executeInUnitOfWork(unitOfWorkImpl, abstractRecord);
    }

    public Object executeDatabaseQuery() throws DatabaseException {
        if (this.getObjects() != null) {
            if (this.isExpressionQuery() && this.getSelectionCriteria() == null) {
                throw QueryException.deleteAllQuerySpecifiesObjectsButNotSelectionCriteria(this.getDescriptor(), this, this.getObjects().toString());
            }
            try {
                Object object;
                Enumeration enumeration;
                this.getSession().beginTransaction();
                if (this.getDescriptor().getEventManager().hasAnyEventListeners()) {
                    enumeration = this.getObjects().elements();
                    while (enumeration.hasMoreElements()) {
                        object = new DescriptorEvent(enumeration.nextElement());
                        ((DescriptorEvent)object).setEventCode(2);
                        ((DescriptorEvent)object).setSession(this.getSession());
                        ((DescriptorEvent)object).setQuery(this);
                        this.getDescriptor().getEventManager().executeEvent((DescriptorEvent)object);
                    }
                }
                this.result = this.getQueryMechanism().deleteAll();
                if (this.getDescriptor().getEventManager().hasAnyEventListeners()) {
                    enumeration = this.getObjects().elements();
                    while (enumeration.hasMoreElements()) {
                        object = new DescriptorEvent(enumeration.nextElement());
                        ((DescriptorEvent)object).setEventCode(3);
                        ((DescriptorEvent)object).setSession(this.getSession());
                        ((DescriptorEvent)object).setQuery(this);
                        this.getDescriptor().getEventManager().executeEvent((DescriptorEvent)object);
                    }
                }
                if (this.shouldMaintainCache()) {
                    enumeration = this.getObjects().elements();
                    while (enumeration.hasMoreElements()) {
                        object = enumeration.nextElement();
                        if (this.getSession().isUnitOfWork()) {
                            object = this.getDescriptor().getObjectBuilder().unwrapObject(object, this.getSession());
                            ((UnitOfWorkImpl)this.getSession()).addObjectDeletedDuringCommit(object, this.getDescriptor());
                            continue;
                        }
                        this.getSession().getIdentityMapAccessor().removeFromIdentityMap(object);
                    }
                }
                this.getSession().commitTransaction();
            }
            catch (RuntimeException runtimeException) {
                this.getSession().rollbackTransaction();
                throw runtimeException;
            }
        } else {
            this.result = this.getQueryMechanism().deleteAll();
            this.mergeChangesIntoSharedCache();
        }
        return this.result;
    }

    public void executeDeleteAll(AbstractSession abstractSession, AbstractRecord abstractRecord, Vector vector) throws DatabaseException {
        this.checkPrepare(abstractSession, abstractRecord);
        DeleteAllQuery deleteAllQuery = (DeleteAllQuery)this.clone();
        deleteAllQuery.setTranslationRow(abstractRecord);
        deleteAllQuery.setSession(abstractSession);
        deleteAllQuery.setObjects(vector);
        deleteAllQuery.prepareForExecution();
        deleteAllQuery.executeDatabaseQuery();
    }

    protected QueryRedirector getDefaultRedirector() {
        return this.descriptor.getDefaultDeleteObjectQueryRedirector();
    }

    public Vector getObjects() {
        return this.objects;
    }

    protected void prepare() throws QueryException {
        super.prepare();
        if (this.getReferenceClass() == null) {
            throw QueryException.referenceClassMissing(this);
        }
        if (this.getDescriptor() == null) {
            ClassDescriptor classDescriptor = this.getSession().getDescriptor(this.getReferenceClass());
            if (classDescriptor == null) {
                throw QueryException.descriptorIsMissing(this.getReferenceClass(), this);
            }
            this.setDescriptor(classDescriptor);
        }
        if (this.getDescriptor().isAggregateDescriptor()) {
            throw QueryException.aggregateObjectCannotBeDeletedOrWritten(this.getDescriptor(), this);
        }
        this.getQueryMechanism().prepareDeleteAll();
    }

    public void setObjects(Vector vector) {
        this.objects = vector;
    }
}

