/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.sequencing;

import java.io.Serializable;
import java.util.Vector;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.internal.databaseaccess.Accessor;
import org.eclipse.persistence.internal.databaseaccess.DatasourcePlatform;
import org.eclipse.persistence.internal.databaseaccess.Platform;
import org.eclipse.persistence.internal.sessions.AbstractSession;

public abstract class Sequence
implements Serializable,
Cloneable {
    protected String name = "";
    protected int size = 50;
    protected Platform platform;
    protected int initialValue = 1;
    protected int depth;

    public Sequence() {
    }

    public Sequence(String string) {
        this();
        this.setName(string);
    }

    public Sequence(String string, int n) {
        this();
        this.setName(string);
        this.setPreallocationSize(n);
    }

    public Sequence(String string, int n, int n2) {
        this();
        this.setName(string);
        this.setPreallocationSize(n);
        this.setInitialValue(n2);
    }

    public boolean isNative() {
        return false;
    }

    public boolean isTable() {
        return false;
    }

    public boolean isUnaryTable() {
        return false;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public int getPreallocationSize() {
        return this.size;
    }

    public void setPreallocationSize(int n) {
        this.size = n;
    }

    public int getInitialValue() {
        return this.initialValue;
    }

    public void setInitialValue(int n) {
        this.initialValue = n;
    }

    public Object clone() {
        try {
            Sequence sequence = (Sequence)super.clone();
            if (this.isConnected()) {
                sequence.depth = 1;
                sequence.onDisconnect(this.getDatasourcePlatform());
            }
            return sequence;
        }
        catch (Exception exception) {
            throw new InternalError("Clone failed");
        }
    }

    public boolean equals(Object object) {
        if (object instanceof Sequence) {
            return Sequence.equalNameAndSize(this, (Sequence)object);
        }
        return false;
    }

    public static boolean equalNameAndSize(Sequence sequence, Sequence sequence2) {
        if (sequence == sequence2) {
            return true;
        }
        return sequence.getName().equals(sequence2.getName()) && sequence.getPreallocationSize() == sequence2.getPreallocationSize();
    }

    protected void setDatasourcePlatform(Platform platform) {
        this.platform = platform;
    }

    public Platform getDatasourcePlatform() {
        return this.platform;
    }

    public abstract boolean shouldAcquireValueAfterInsert();

    public boolean shouldUsePreallocation() {
        return !this.shouldAcquireValueAfterInsert();
    }

    public abstract boolean shouldUseTransaction();

    public abstract Object getGeneratedValue(Accessor var1, AbstractSession var2, String var3);

    public Object getGeneratedValue(Accessor accessor, AbstractSession abstractSession) {
        return this.getGeneratedValue(accessor, abstractSession, this.getName());
    }

    public abstract Vector getGeneratedVector(Accessor var1, AbstractSession var2, String var3, int var4);

    public Vector getGeneratedVector(Accessor accessor, AbstractSession abstractSession) {
        return this.getGeneratedVector(accessor, abstractSession, this.getName(), this.getPreallocationSize());
    }

    public void onConnect(Platform platform) {
        this.setDatasourcePlatform(platform);
        this.onConnect();
        ++this.depth;
    }

    protected abstract void onConnect();

    public void onDisconnect(Platform platform) {
        if (this.isConnected()) {
            --this.depth;
        }
    }

    protected abstract void onDisconnect();

    public boolean isConnected() {
        return this.platform != null;
    }

    protected void verifyPlatform(Platform platform) {
        if (this.getDatasourcePlatform() != platform) {
            String string = Integer.toString(System.identityHashCode(this.getDatasourcePlatform()));
            String string2 = ((DatasourcePlatform)this.getDatasourcePlatform()).toString() + '(' + string + ')';
            String string3 = Integer.toString(System.identityHashCode(platform));
            String string4 = ((DatasourcePlatform)platform).toString() + '(' + string3 + ')';
            throw ValidationException.sequenceCannotBeConnectedToTwoPlatforms(this.getName(), string2, string4);
        }
    }
}

