/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.sequencing;

import java.io.StringWriter;
import org.eclipse.persistence.queries.DataModifyQuery;
import org.eclipse.persistence.queries.ValueReadQuery;
import org.eclipse.persistence.sequencing.QuerySequence;

public class UnaryTableSequence
extends QuerySequence {
    protected String counterFieldName = "SEQUENCE";
    protected String updateString1;
    protected String updateString2;
    protected String selectString1;
    protected String selectString2;
    protected int updateStringBufferSize;
    protected int selectStringBufferSize;
    protected String qualifier = "";

    public UnaryTableSequence() {
        super(false, true);
    }

    public UnaryTableSequence(String string) {
        super(string, false, true);
    }

    public UnaryTableSequence(String string, int n) {
        super(string, n, false, true);
    }

    public UnaryTableSequence(String string, String string2) {
        this(string);
        this.setCounterFieldName(string2);
    }

    public UnaryTableSequence(String string, int n, String string2) {
        this(string, n);
        this.setCounterFieldName(string2);
    }

    public boolean isUnaryTable() {
        return true;
    }

    public boolean equals(Object object) {
        if (object instanceof UnaryTableSequence) {
            UnaryTableSequence unaryTableSequence = (UnaryTableSequence)object;
            if (UnaryTableSequence.equalNameAndSize(this, unaryTableSequence)) {
                return this.getCounterFieldName().equals(unaryTableSequence.getCounterFieldName());
            }
            return false;
        }
        return false;
    }

    public void setCounterFieldName(String string) {
        this.counterFieldName = string;
    }

    public String getCounterFieldName() {
        return this.counterFieldName;
    }

    public void onConnect() {
        this.qualifier = this.getDatasourcePlatform().getTableQualifier();
        super.onConnect();
        this.initialize();
    }

    public void onDisconnect() {
        this.clear();
        super.onDisconnect();
        this.qualifier = "";
    }

    protected ValueReadQuery buildSelectQuery(String string, Integer n) {
        ValueReadQuery valueReadQuery = new ValueReadQuery();
        valueReadQuery.dontBindAllParameters();
        StringWriter stringWriter = new StringWriter(this.selectStringBufferSize + string.length());
        stringWriter.write(this.selectString1);
        stringWriter.write(string);
        valueReadQuery.setSQLString(stringWriter.toString());
        return valueReadQuery;
    }

    protected DataModifyQuery buildUpdateQuery(String string, Number number) {
        DataModifyQuery dataModifyQuery = new DataModifyQuery();
        dataModifyQuery.dontBindAllParameters();
        String string2 = number.toString();
        StringWriter stringWriter = new StringWriter(this.updateStringBufferSize + string.length() + string2.length());
        stringWriter.write(this.updateString1);
        stringWriter.write(string);
        stringWriter.write(this.updateString2);
        stringWriter.write(string2);
        dataModifyQuery.setSQLString(stringWriter.toString());
        return dataModifyQuery;
    }

    protected void initialize() {
        if (this.getSelectQuery() == null) {
            this.buildSelectString1();
            this.selectStringBufferSize = this.selectString1.length();
        }
        if (this.getUpdateQuery() == null && !this.shouldSkipUpdate()) {
            this.buildUpdateString1();
            this.buildUpdateString2();
            this.updateStringBufferSize = this.updateString1.length() + this.updateString2.length();
        }
    }

    protected void buildUpdateString1() {
        this.updateString1 = "UPDATE ";
        if (this.qualifier != "") {
            this.updateString1 = this.updateString1 + this.qualifier + '.';
        }
    }

    protected void buildUpdateString2() {
        StringWriter stringWriter = new StringWriter();
        stringWriter.write(" SET ");
        stringWriter.write(this.getCounterFieldName());
        stringWriter.write(" = ");
        stringWriter.write(this.getCounterFieldName());
        stringWriter.write(" + ");
        this.updateString2 = stringWriter.toString();
    }

    protected void buildSelectString1() {
        this.selectString1 = "SELECT * FROM ";
        if (this.qualifier != "") {
            this.selectString1 = this.selectString1 + this.qualifier + '.';
        }
    }

    protected void clear() {
        this.updateString1 = null;
        this.updateString2 = null;
        this.selectString1 = null;
        this.selectString2 = null;
        this.updateStringBufferSize = 0;
        this.selectStringBufferSize = 0;
    }
}

