/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.sessions.coordination;

import java.net.InetAddress;
import org.eclipse.persistence.exceptions.RemoteCommandManagerException;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.internal.localization.LoggingLocalization;
import org.eclipse.persistence.internal.localization.TraceLocalization;
import org.eclipse.persistence.internal.sessions.DatabaseSessionImpl;
import org.eclipse.persistence.internal.sessions.coordination.CommandPropagator;
import org.eclipse.persistence.internal.sessions.coordination.ProfileMessageReceiveCommand;
import org.eclipse.persistence.internal.sessions.coordination.ProfileMessageSentCommand;
import org.eclipse.persistence.internal.sessions.coordination.ProfileRemoteChangeSetCommand;
import org.eclipse.persistence.internal.sessions.coordination.RCMCommand;
import org.eclipse.persistence.internal.sessions.coordination.RemoteConnection;
import org.eclipse.persistence.platform.server.ServerPlatform;
import org.eclipse.persistence.sessions.Session;
import org.eclipse.persistence.sessions.coordination.Command;
import org.eclipse.persistence.sessions.coordination.CommandConverter;
import org.eclipse.persistence.sessions.coordination.CommandManager;
import org.eclipse.persistence.sessions.coordination.CommandProcessor;
import org.eclipse.persistence.sessions.coordination.DiscoveryManager;
import org.eclipse.persistence.sessions.coordination.ServiceId;
import org.eclipse.persistence.sessions.coordination.TransportManager;
import org.eclipse.persistence.sessions.coordination.rmi.RMITransportManager;

public class RemoteCommandManager
implements CommandManager {
    public static final String DEFAULT_CHANNEL = "TopLinkCommandChannel";
    public static final boolean DEFAULT_ASYNCHRONOUS_MODE = true;
    protected ServiceId serviceId = new ServiceId();
    protected DiscoveryManager discoveryManager;
    protected TransportManager transportManager;
    protected CommandProcessor commandProcessor;
    protected CommandConverter commandConverter;
    protected boolean isAsynchronous;
    protected boolean isTopLinkSession;
    protected ServerPlatform serverPlatform;
    protected boolean isStopped = true;

    public RemoteCommandManager(CommandProcessor commandProcessor) {
        this.setCommandProcessor(commandProcessor);
        this.transportManager = new RMITransportManager(this);
        this.discoveryManager = this.transportManager.createDiscoveryManager();
        this.serviceId.setChannel(DEFAULT_CHANNEL);
        this.isAsynchronous = true;
        commandProcessor.setCommandManager(this);
    }

    public RemoteCommandManager(CommandProcessor commandProcessor, TransportManager transportManager) {
        this(commandProcessor);
        this.transportManager = transportManager;
        this.discoveryManager = this.transportManager.createDiscoveryManager();
    }

    public void initialize() {
        Object[] objectArray = new Object[]{this.getServiceId()};
        this.logDebug("starting_rcm", objectArray);
        if (this.getUrl().indexOf("$HOST") >= 0) {
            try {
                String string = InetAddress.getLocalHost().getHostAddress();
                this.replaceLocalHostIPAddress(string);
            }
            catch (Exception exception) {
                throw RemoteCommandManagerException.errorDiscoveringLocalHostIPAddress(exception);
            }
        }
        this.isStopped = false;
        if (this.discoveryManager != null) {
            this.discoveryManager.startDiscovery();
        } else {
            this.transportManager.createConnections();
        }
    }

    public boolean isStopped() {
        return this.isStopped;
    }

    public void shutdown() {
        Object[] objectArray = new Object[]{this.getServiceId()};
        this.logDebug("stopping_rcm", objectArray);
        if (this.discoveryManager != null) {
            this.discoveryManager.stopDiscovery();
            DiscoveryManager discoveryManager = this.transportManager.createDiscoveryManager();
            discoveryManager.shallowCopy(this.discoveryManager);
            this.discoveryManager = discoveryManager;
        }
        this.isStopped = true;
        this.transportManager.discardConnections();
    }

    public void propagateCommand(Object object) {
        Command command;
        if (this.commandConverter != null) {
            Object[] objectArray = new Object[]{object};
            this.logDebug("converting_to_toplink_command", objectArray);
            if (this.isCommandProcessorASession()) {
                this.getCommandProcessor().processCommand(new ProfileMessageSentCommand());
            }
            command = this.commandConverter.convertToTopLinkCommand(object);
        } else if (object instanceof Command) {
            command = (Command)object;
        } else {
            Object[] objectArray = new Object[]{object};
            this.logWarning("missing_converter", objectArray);
            return;
        }
        command.setServiceId(this.getServiceId());
        CommandPropagator commandPropagator = new CommandPropagator(this, command);
        if (this.shouldPropagateAsynchronously()) {
            commandPropagator.asynchronousPropagateCommand();
        } else {
            commandPropagator.synchronousPropagateCommand();
        }
    }

    public void processCommandFromRemoteConnection(Command command) {
        Object[] objectArray = new Object[]{command.getClass().getName(), command.getServiceId()};
        this.logDebug("received_remote_command", objectArray);
        if (this.isCommandProcessorASession()) {
            this.getCommandProcessor().processCommand(new ProfileMessageReceiveCommand());
        }
        if (command.isInternalCommand() || command instanceof RCMCommand) {
            this.logDebug("processing_internal_command", objectArray);
            ((RCMCommand)command).executeWithRCM(this);
            return;
        }
        Object object = command;
        if (this.commandConverter != null) {
            this.logDebug("converting_to_user_command", objectArray);
            object = this.commandConverter.convertToUserCommand(command);
        }
        this.logDebug("processing_remote_command", objectArray);
        this.commandProcessor.processCommand(object);
        if (this.isCommandProcessorASession()) {
            this.getCommandProcessor().processCommand(new ProfileRemoteChangeSetCommand());
        }
    }

    public CommandProcessor getCommandProcessor() {
        return this.commandProcessor;
    }

    public void setCommandProcessor(CommandProcessor commandProcessor) {
        this.commandProcessor = commandProcessor;
        if (commandProcessor instanceof Session) {
            this.isTopLinkSession = true;
        }
    }

    public TransportManager getTransportManager() {
        return this.transportManager;
    }

    public void setTransportManager(TransportManager transportManager) {
        this.transportManager = transportManager;
        this.discoveryManager = this.transportManager.createDiscoveryManager();
    }

    public void handleException(RuntimeException runtimeException) {
        this.commandProcessor.handleException(runtimeException);
    }

    public void newServiceDiscovered(ServiceId serviceId) {
        RemoteConnection remoteConnection = this.transportManager.createConnection(serviceId);
        this.transportManager.addConnectionToExternalService(remoteConnection);
    }

    public DiscoveryManager getDiscoveryManager() {
        return this.discoveryManager;
    }

    public CommandConverter getCommandConverter() {
        return this.commandConverter;
    }

    public void setCommandConverter(CommandConverter commandConverter) {
        this.commandConverter = commandConverter;
    }

    public boolean shouldLogMessage(int n) {
        return this.commandProcessor.shouldLogMessages(n);
    }

    public boolean shouldLogDebugMessage() {
        return this.commandProcessor.shouldLogMessages(4);
    }

    public boolean shouldLogWarningMessage() {
        return this.commandProcessor.shouldLogMessages(2);
    }

    public void logMessage(int n, String string, Object[] objectArray) {
        if (this.commandProcessor.shouldLogMessages(n)) {
            this.logMessageWithoutLevelCheck(n, string, objectArray);
        }
    }

    public void logMessageWithoutLevelCheck(int n, String string, Object[] objectArray) {
        String string2 = string;
        if (n == 1 || n == 2) {
            string2 = LoggingLocalization.buildMessage(string, objectArray);
        } else if (n == 3 || n == 4) {
            string2 = TraceLocalization.buildMessage(string, objectArray);
        }
        this.commandProcessor.logMessage(n, string2);
    }

    public void logDebug(String string, Object[] objectArray) {
        this.logMessage(4, string, objectArray);
    }

    public void logDebugWithoutLevelCheck(String string, Object[] objectArray) {
        this.logMessageWithoutLevelCheck(4, string, objectArray);
    }

    public void logInfo(String string, Object[] objectArray) {
        this.logMessage(3, string, objectArray);
    }

    public void logWarning(String string, Object[] objectArray) {
        this.logMessage(2, string, objectArray);
    }

    public void logWarningWithoutLevelCheck(String string, Object[] objectArray) {
        this.logMessageWithoutLevelCheck(2, string, objectArray);
    }

    public void logError(String string, Object[] objectArray) {
        this.logMessage(1, string, objectArray);
    }

    public ServiceId getServiceId() {
        return this.serviceId;
    }

    public String getChannel() {
        return this.getServiceId().getChannel();
    }

    public void setChannel(String string) {
        this.getServiceId().setChannel(string);
    }

    public boolean isCommandProcessorASession() {
        return this.isTopLinkSession;
    }

    public String getUrl() {
        return this.getServiceId().getURL();
    }

    public void setUrl(String string) {
        this.getServiceId().setURL(string);
    }

    public boolean shouldPropagateAsynchronously() {
        return this.isAsynchronous;
    }

    public void setShouldPropagateAsynchronously(boolean bl) {
        this.isAsynchronous = bl;
    }

    public void replaceLocalHostIPAddress(String string) {
        String string2 = Helper.replaceFirstSubString(this.getUrl(), "$HOST", string);
        if (string2 != null) {
            this.setUrl(string2);
        }
    }

    public void replaceTransportPortNumber(String string) {
        String string2 = Helper.replaceFirstSubString(this.getUrl(), "$PORT", string);
        if (string2 != null) {
            this.setUrl(string2);
        }
    }

    public ServerPlatform getServerPlatform() {
        if (this.isCommandProcessorASession()) {
            return ((DatabaseSessionImpl)this.getCommandProcessor()).getServerPlatform();
        }
        if (this.serverPlatform != null) {
            return this.serverPlatform;
        }
        throw RemoteCommandManagerException.errorGettingServerPlatform();
    }

    public void setServerPlatform(ServerPlatform serverPlatform) {
        this.serverPlatform = serverPlatform;
    }
}

