/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.schemaframework;

import java.io.Serializable;
import java.io.StringWriter;
import java.io.Writer;
import org.eclipse.persistence.exceptions.EclipseLinkException;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.queries.SQLCall;

public abstract class DatabaseObjectDefinition
implements Cloneable,
Serializable {
    public String name = "";
    public String qualifier = "";

    public abstract Writer buildCreationWriter(AbstractSession var1, Writer var2) throws ValidationException;

    public abstract Writer buildDeletionWriter(AbstractSession var1, Writer var2) throws ValidationException;

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    public void createObject(AbstractSession abstractSession, Writer writer) throws EclipseLinkException {
        if (writer == null) {
            this.createOnDatabase(abstractSession);
        } else {
            this.buildCreationWriter(abstractSession, writer);
        }
    }

    public void createOnDatabase(AbstractSession abstractSession) throws EclipseLinkException {
        abstractSession.executeNonSelectingCall(new SQLCall(this.buildCreationWriter(abstractSession, new StringWriter()).toString()));
    }

    public void dropFromDatabase(AbstractSession abstractSession) throws EclipseLinkException {
        abstractSession.executeNonSelectingCall(new SQLCall(this.buildDeletionWriter(abstractSession, new StringWriter()).toString()));
    }

    public void dropObject(AbstractSession abstractSession, Writer writer) throws EclipseLinkException {
        if (writer == null) {
            this.dropFromDatabase(abstractSession);
        } else {
            this.buildDeletionWriter(abstractSession, writer);
        }
    }

    public String getFullName() {
        if (this.getQualifier().equals("")) {
            return this.getName();
        }
        return this.getQualifier() + "." + this.getName();
    }

    public String getName() {
        return this.name;
    }

    public String getQualifier() {
        return this.qualifier;
    }

    public void setName(String string) {
        this.name = string;
    }

    public void setQualifier(String string) {
        this.qualifier = string;
    }

    public String toString() {
        return Helper.getShortClassName(this.getClass()) + "(" + this.getFullName() + ")";
    }
}

