/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.application;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.faces.event.AfterAddToParentEvent;
import javax.faces.event.AfterAddToViewEvent;
import javax.faces.event.AfterValidateEvent;
import javax.faces.event.BeforeRenderEvent;
import javax.faces.event.BeforeValidateEvent;
import javax.faces.event.SystemEvent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NamedEventManager {
    private Map<String, Class<? extends SystemEvent>> namedEvents = new ConcurrentHashMap<String, Class<? extends SystemEvent>>();
    private Map<String, Set<Class<? extends SystemEvent>>> duplicateNames = new ConcurrentHashMap<String, Set<Class<? extends SystemEvent>>>();

    public NamedEventManager() {
        this.namedEvents.put("javax.faces.event.beforeRender", BeforeRenderEvent.class);
        this.namedEvents.put("javax.faces.event.afterAddToParent", AfterAddToParentEvent.class);
        this.namedEvents.put("javax.faces.event.afterAddToView", AfterAddToViewEvent.class);
        this.namedEvents.put("javax.faces.event.BeforeValidate", BeforeValidateEvent.class);
        this.namedEvents.put("javax.faces.event.AfterValidate", AfterValidateEvent.class);
        this.namedEvents.put("beforeRender", BeforeRenderEvent.class);
        this.namedEvents.put("afterAddToParent", AfterAddToParentEvent.class);
        this.namedEvents.put("afterAddToView", AfterAddToViewEvent.class);
        this.namedEvents.put("beforeValidate", BeforeValidateEvent.class);
        this.namedEvents.put("afterValidate", AfterValidateEvent.class);
    }

    public void addNamedEvent(String name, Class<? extends SystemEvent> event) {
        this.namedEvents.put(name, event);
    }

    public Class<? extends SystemEvent> getNamedEvent(String name) {
        String foo = this.namedEvents.toString();
        Class<? extends SystemEvent> namedEvent = this.namedEvents.get(name);
        return namedEvent;
    }

    public void addDuplicateName(String name, Class<? extends SystemEvent> event) {
        Class<? extends SystemEvent> registeredEvent = this.namedEvents.remove(name);
        Set<Class<? extends SystemEvent>> events = this.duplicateNames.get(name);
        if (events == null) {
            events = new HashSet<Class<? extends SystemEvent>>();
            this.duplicateNames.put(name, events);
        }
        events.add(event);
        if (registeredEvent != null) {
            events.add(registeredEvent);
        }
    }

    public boolean isDuplicateNamedEvent(String name) {
        return this.namedEvents.get(name) != null || this.duplicateNames.get(name) != null;
    }
}

