/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.transaction.jts;

import com.sun.enterprise.config.serverbeans.TransactionService;
import com.sun.enterprise.transaction.JavaEETransactionImpl;
import com.sun.enterprise.transaction.JavaEETransactionManagerSimplified;
import com.sun.enterprise.transaction.api.JavaEETransaction;
import com.sun.enterprise.transaction.api.JavaEETransactionManager;
import com.sun.enterprise.transaction.api.XAResourceWrapper;
import com.sun.enterprise.transaction.jts.OracleXAResource;
import com.sun.enterprise.transaction.jts.SybaseXAResource;
import com.sun.enterprise.transaction.spi.JavaEETransactionManagerDelegate;
import com.sun.enterprise.transaction.spi.TransactionInternal;
import com.sun.enterprise.transaction.spi.TransactionalResource;
import com.sun.enterprise.util.i18n.StringManager;
import com.sun.jts.CosTransactions.AdminUtil;
import com.sun.jts.CosTransactions.Configuration;
import com.sun.jts.CosTransactions.DelegatedRecoveryManager;
import com.sun.jts.CosTransactions.RWLock;
import com.sun.jts.CosTransactions.RecoveryManager;
import com.sun.jts.jta.TransactionManagerImpl;
import java.util.Arrays;
import java.util.Collections;
import java.util.Hashtable;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.resource.spi.XATerminator;
import javax.resource.spi.work.WorkException;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.InvalidTransactionException;
import javax.transaction.NotSupportedException;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.PostConstruct;

@Service
public class JavaEETransactionManagerJTSDelegate
implements JavaEETransactionManagerDelegate,
PostConstruct {
    private JavaEETransactionManager javaEETM;
    @Inject
    private TransactionService txnService;
    private TransactionManager tm;
    private Hashtable globalTransactions;
    private Hashtable<String, XAResourceWrapper> xaresourcewrappers = new Hashtable();
    private Logger _logger;
    private static StringManager sm = StringManager.getManager(JavaEETransactionManagerSimplified.class);
    private boolean lao = true;
    private static final ReadWriteLock lock = new ReadWriteLock();

    public JavaEETransactionManagerJTSDelegate() {
        this.globalTransactions = new Hashtable();
    }

    public void postConstruct() {
        if (this.javaEETM != null) {
            this.javaEETM.setDelegate((JavaEETransactionManagerDelegate)this);
        }
        this.initTransactionProperties();
    }

    public boolean useLAO() {
        return this.lao;
    }

    public void setUseLAO(boolean b) {
        this.lao = b;
    }

    public void commitDistributedTransaction() throws RollbackException, HeuristicMixedException, HeuristicRollbackException, SecurityException, IllegalStateException, SystemException {
        if (this._logger.isLoggable(Level.FINE)) {
            this._logger.log(Level.FINE, "TM: commit");
        }
        this.validateTransactionManager();
        Transaction obj = this.tm.getTransaction();
        JavaEETransactionManagerSimplified javaEETMS = (JavaEETransactionManagerSimplified)this.javaEETM;
        if (javaEETMS.isInvocationStackEmpty()) {
            try {
                this.tm.commit();
                javaEETMS.monitorTxCompleted0((Object)obj, true);
            }
            catch (RollbackException e) {
                javaEETMS.monitorTxCompleted0((Object)obj, false);
                throw e;
            }
            catch (HeuristicRollbackException e) {
                javaEETMS.monitorTxCompleted0((Object)obj, false);
                throw e;
            }
            catch (HeuristicMixedException e) {
                javaEETMS.monitorTxCompleted0((Object)obj, true);
                throw e;
            }
        }
        try {
            javaEETMS.setTransactionCompeting(true);
            this.tm.commit();
            javaEETMS.monitorTxCompleted0((Object)obj, true);
        }
        catch (RollbackException e) {
            javaEETMS.monitorTxCompleted0((Object)obj, false);
            throw e;
        }
        catch (HeuristicRollbackException e) {
            javaEETMS.monitorTxCompleted0((Object)obj, false);
            throw e;
        }
        catch (HeuristicMixedException e) {
            javaEETMS.monitorTxCompleted0((Object)obj, true);
            throw e;
        }
        finally {
            javaEETMS.setTransactionCompeting(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rollbackDistributedTransaction() throws IllegalStateException, SecurityException, SystemException {
        if (this._logger.isLoggable(Level.FINE)) {
            this._logger.log(Level.FINE, "TM: rollback");
        }
        this.validateTransactionManager();
        Transaction obj = this.tm.getTransaction();
        JavaEETransactionManagerSimplified javaEETMS = (JavaEETransactionManagerSimplified)this.javaEETM;
        if (javaEETMS.isInvocationStackEmpty()) {
            this.tm.rollback();
        } else {
            try {
                javaEETMS.setTransactionCompeting(true);
                this.tm.rollback();
            }
            finally {
                javaEETMS.setTransactionCompeting(false);
            }
        }
        javaEETMS.monitorTxCompleted0((Object)obj, false);
    }

    public int getStatus() throws SystemException {
        JavaEETransaction tx = this.javaEETM.getCurrentTransaction();
        if (tx != null && tx.isLocalTx()) {
            return tx.getStatus();
        }
        if (this.tm != null) {
            return this.tm.getStatus();
        }
        return 6;
    }

    public Transaction getTransaction() throws SystemException {
        JavaEETransaction tx = this.javaEETM.getCurrentTransaction();
        if (tx != null) {
            return tx;
        }
        TransactionInternal jtsTx = null;
        if (this.tm != null) {
            jtsTx = (TransactionInternal)this.tm.getTransaction();
        }
        if (jtsTx == null) {
            return null;
        }
        tx = (JavaEETransaction)this.globalTransactions.get(jtsTx);
        if (tx == null) {
            tx = ((JavaEETransactionManagerSimplified)this.javaEETM).createImportedTransaction(jtsTx);
            this.globalTransactions.put(jtsTx, tx);
        }
        this.javaEETM.setCurrentTransaction(tx);
        return tx;
    }

    public boolean enlistDistributedNonXAResource(Transaction tx, TransactionalResource h) throws RollbackException, IllegalStateException, SystemException {
        if (this.useLAO()) {
            if (((JavaEETransactionManagerSimplified)this.javaEETM).resourceEnlistable(h)) {
                XAResource res = h.getXAResource();
                boolean result = tx.enlistResource(res);
                if (!h.isEnlisted()) {
                    h.enlistedInTransaction(tx);
                }
                return result;
            }
            return true;
        }
        throw new IllegalStateException(sm.getString("enterprise_distributedtx.nonxa_usein_jts"));
    }

    public boolean enlistLAOResource(Transaction tran, TransactionalResource h) throws RollbackException, IllegalStateException, SystemException {
        JavaEETransactionImpl tx = (JavaEETransactionImpl)tran;
        ((JavaEETransactionManagerSimplified)this.javaEETM).startJTSTx((JavaEETransaction)tx);
        if (this.useLAO() && h != null && tx.getLAOResource() == null) {
            tx.setLAOResource(h);
            if (h.isTransactional()) {
                XAResource res = h.getXAResource();
                return tran.enlistResource(res);
            }
        }
        return true;
    }

    public void setRollbackOnlyDistributedTransaction() throws IllegalStateException, SystemException {
        if (this._logger.isLoggable(Level.FINE)) {
            this._logger.log(Level.FINE, "TM: setRollbackOnly");
        }
        this.validateTransactionManager();
        this.tm.setRollbackOnly();
    }

    public Transaction suspend(JavaEETransaction tx) throws SystemException {
        if (tx != null) {
            if (!tx.isLocalTx()) {
                this.suspendInternal();
            }
            this.javaEETM.setCurrentTransaction(null);
            return tx;
        }
        return this.suspendInternal();
    }

    public void resume(Transaction tx) throws InvalidTransactionException, IllegalStateException, SystemException {
        if (this._logger.isLoggable(Level.FINE)) {
            this._logger.log(Level.FINE, "TM: resume");
        }
        this.tm.resume(tx);
    }

    public void removeTransaction(Transaction tx) {
        this.globalTransactions.remove(tx);
    }

    public int getOrder() {
        return 3;
    }

    public void setTransactionManager(JavaEETransactionManager tm) {
        this.javaEETM = tm;
        this._logger = ((JavaEETransactionManagerSimplified)this.javaEETM).getLogger();
    }

    public TransactionInternal startJTSTx(JavaEETransaction tran, boolean isAssociatedTimeout) throws RollbackException, IllegalStateException, SystemException {
        this.initTransactionManager();
        JavaEETransactionImpl tx = (JavaEETransactionImpl)tran;
        try {
            if (isAssociatedTimeout) {
                int timeout = tx.cancelTimerTask();
                int newtimeout = (int)((System.currentTimeMillis() - tx.getStartTime()) / 1000L);
                newtimeout = timeout - newtimeout;
                this.beginJTS(newtimeout);
            } else {
                this.beginJTS(((JavaEETransactionManagerSimplified)this.javaEETM).getEffectiveTimeout());
            }
        }
        catch (NotSupportedException ex) {
            throw new RuntimeException(sm.getString("enterprise_distributedtx.lazy_transaction_notstarted"), ex);
        }
        TransactionInternal jtsTx = (TransactionInternal)this.tm.getTransaction();
        this.globalTransactions.put(jtsTx, tx);
        return jtsTx;
    }

    public void recover(XAResource[] resourceList) {
        this.initTransactionManager();
        TransactionManagerImpl.recover(Collections.enumeration(Arrays.asList(resourceList)));
    }

    public void release(Xid xid) throws WorkException {
        this.initTransactionManager();
        TransactionManagerImpl.release(xid);
    }

    public void recreate(Xid xid, long timeout) throws WorkException {
        this.initTransactionManager();
        TransactionManagerImpl.recreate(xid, timeout);
    }

    public XATerminator getXATerminator() {
        this.initTransactionManager();
        return TransactionManagerImpl.getXATerminator();
    }

    private Transaction suspendInternal() throws SystemException {
        if (this._logger.isLoggable(Level.FINE)) {
            this._logger.log(Level.FINE, "TM: suspend");
        }
        this.validateTransactionManager();
        return this.tm.suspend();
    }

    private void validateTransactionManager() throws IllegalStateException {
        if (this.tm == null) {
            throw new IllegalStateException(sm.getString("enterprise_distributedtx.transaction_notactive"));
        }
    }

    private void initTransactionManager() {
        if (this.tm == null) {
            this.tm = TransactionManagerImpl.getTransactionManagerImpl();
        }
    }

    public XAResourceWrapper getXAResourceWrapper(String clName) {
        XAResourceWrapper rc = this.xaresourcewrappers.get(clName);
        if (rc != null) {
            return rc.getInstance();
        }
        return null;
    }

    public void handlePropertyUpdate(String name, Object value) {
        if (name.equals("keypoint-interval")) {
            Configuration.setKeypointTrigger(Integer.parseInt((String)value, 10));
        } else if (name.equals("retry-timeout-in-seconds")) {
            Configuration.setCommitRetryVar((String)value);
        }
    }

    public boolean recoverIncompleteTx(boolean delegated, String logPath, XAResource[] xaresArray) throws Exception {
        boolean result = false;
        if (!delegated) {
            RecoveryManager.recoverIncompleteTx(xaresArray);
            result = true;
        } else {
            result = DelegatedRecoveryManager.delegated_recover(logPath, xaresArray);
        }
        return result;
    }

    public void beginJTS(int timeout) throws NotSupportedException, SystemException {
        ((TransactionManagerImpl)this.tm).begin(timeout);
        ((JavaEETransactionManagerSimplified)this.javaEETM).monitorTxBegin(this.tm.getTransaction());
    }

    public boolean supportsXAResource() {
        return true;
    }

    public void initTransactionProperties() {
        if (this.txnService != null) {
            String value = this.txnService.getPropertyValue("use-last-agent-optimization");
            if (value != null && "false".equals(value)) {
                this.setUseLAO(false);
                if (this._logger.isLoggable(Level.FINE)) {
                    this._logger.log(Level.FINE, "TM: LAO is disabled");
                }
            }
            if ((value = this.txnService.getPropertyValue("oracle-xa-recovery-workaround")) == null || "true".equals(value)) {
                this.xaresourcewrappers.put("oracle.jdbc.xa.client.OracleXADataSource", new OracleXAResource());
            }
            if ((value = this.txnService.getPropertyValue("sybase-xa-recovery-workaround")) != null && "true".equals(value)) {
                this.xaresourcewrappers.put("com.sybase.jdbc2.jdbc.SybXADataSource", new SybaseXAResource());
            }
        }
    }

    public Lock getReadLock() {
        return lock;
    }

    public void acquireWriteLock() {
        if (AdminUtil.isFrozenAll()) {
            return;
        }
        AdminUtil.freezeAll();
        JavaEETransactionManagerJTSDelegate.lock.acquireWriteLock();
    }

    public void releaseWriteLock() {
        if (AdminUtil.isFrozenAll()) {
            AdminUtil.unfreezeAll();
        }
        JavaEETransactionManagerJTSDelegate.lock.releaseWriteLock();
    }

    public boolean isWriteLocked() {
        return AdminUtil.isFrozenAll();
    }

    private static class ReadWriteLock
    implements Lock {
        private static final RWLock freezeLock = new RWLock();

        private ReadWriteLock() {
        }

        public void lock() {
            freezeLock.acquireReadLock();
        }

        public void unlock() {
            freezeLock.releaseReadLock();
        }

        private void acquireWriteLock() {
            freezeLock.acquireWriteLock();
        }

        private void releaseWriteLock() {
            freezeLock.releaseWriteLock();
        }

        public void lockInterruptibly() throws InterruptedException {
            throw new UnsupportedOperationException();
        }

        public boolean tryLock() {
            throw new UnsupportedOperationException();
        }

        public boolean tryLock(long timeout, TimeUnit unit) throws InterruptedException {
            throw new UnsupportedOperationException();
        }

        public Condition newCondition() {
            throw new UnsupportedOperationException();
        }
    }
}

