/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.persistence.jpa;

import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.PersistenceUnitDescriptor;
import com.sun.logging.LogDomains;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.spi.PersistenceProvider;
import javax.persistence.spi.PersistenceUnitInfo;
import org.glassfish.api.deployment.ApplicationContainer;
import org.glassfish.api.deployment.ApplicationContext;
import org.glassfish.api.deployment.DeploymentContext;
import org.glassfish.persistence.common.Java2DBProcessorHelper;
import org.glassfish.persistence.jpa.JPAJava2DBProcessor;
import org.glassfish.persistence.jpa.PersistenceUnitInfoImpl;
import org.glassfish.persistence.jpa.ProviderContainerContractInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JPAApplication
implements ApplicationContainer {
    Collection<PersistenceUnitDescriptor> referencedPus = new ArrayList<PersistenceUnitDescriptor>();
    ProviderContainerContractInfo providerContainerContractInfo;
    Collection<EntityManagerFactory> loadedEMFs = new ArrayList<EntityManagerFactory>();
    Collection<EntityManagerFactory> java2dbEMFs = new ArrayList<EntityManagerFactory>();
    JPAJava2DBProcessor processor;
    private static Logger logger = LogDomains.getLogger(JPAApplication.class, (String)"javax.enterprise.system.core.classloading");
    private static Map<String, String> baseIntegrationProperties;
    private static Map<String, String> integrationPropertiesWithJava2DB;
    private static Map<String, String> integrationPropertiesWithoutJava2DB;

    JPAApplication(Collection<PersistenceUnitDescriptor> allReferencedPus, ProviderContainerContractInfo providerContainerContractInfo) {
        this.referencedPus = allReferencedPus;
        this.providerContainerContractInfo = providerContainerContractInfo;
        this.setSystemPropertyToEnableDoPrivilegedInEclipseLink();
        this.loadAllPus();
    }

    private void setSystemPropertyToEnableDoPrivilegedInEclipseLink() {
        String PROPERTY_NAME = "eclipselink.security.usedoprivileged";
        if (System.getProperty("eclipselink.security.usedoprivileged") == null) {
            System.setProperty("eclipselink.security.usedoprivileged", String.valueOf(Boolean.TRUE));
        }
    }

    public Object getDescriptor() {
        return null;
    }

    public boolean start(ApplicationContext startupContxt) {
        return true;
    }

    public boolean stop(ApplicationContext stopContext) {
        this.closeAllEMFs();
        return true;
    }

    public boolean suspend() {
        return false;
    }

    public boolean resume() {
        return false;
    }

    public ClassLoader getClassLoader() {
        return null;
    }

    private void loadAllPus() {
        Java2DBProcessorHelper helper;
        boolean isDeploy;
        String applicationLocation = this.providerContainerContractInfo.getApplicationLocation();
        boolean fineMsgLoggable = logger.isLoggable(Level.FINE);
        if (fineMsgLoggable) {
            logger.fine("Loading persistence units for application: " + applicationLocation);
        }
        if (isDeploy = (helper = new Java2DBProcessorHelper(this.providerContainerContractInfo.getDeploymentContext())).isDeploy()) {
            this.processor = new JPAJava2DBProcessor(helper);
        }
        for (PersistenceUnitDescriptor pu : this.referencedPus) {
            EntityManagerFactory emf = this.loadPU(pu);
            this.loadedEMFs.add(emf);
        }
        if (fineMsgLoggable) {
            logger.fine("Finished loading persistence units for application: " + applicationLocation);
        }
    }

    private EntityManagerFactory loadPU(PersistenceUnitDescriptor pud) {
        PersistenceProvider provider;
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("loading pud " + pud.getPuRoot());
        }
        PersistenceUnitInfoImpl pInfo = new PersistenceUnitInfoImpl(pud, this.providerContainerContractInfo);
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("PersistenceInfo for this pud is :\n" + pInfo);
        }
        try {
            provider = (PersistenceProvider)PersistenceProvider.class.cast(((ClassLoader)ClassLoader.class.cast(this.providerContainerContractInfo.getClassLoader())).loadClass(pInfo.getPersistenceProviderClassName()).newInstance());
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
        catch (InstantiationException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        boolean isJava2DB = this.processor == null ? false : this.processor.isJava2DbPU(pud);
        Map<String, String> overrides = isJava2DB ? integrationPropertiesWithJava2DB : integrationPropertiesWithoutJava2DB;
        EntityManagerFactory emf = provider.createContainerEntityManagerFactory((PersistenceUnitInfo)pInfo, overrides);
        logger.logp(Level.FINE, "JPAApplication", "loadPU", "emf = {0}", emf);
        Application application = (Application)this.providerContainerContractInfo.getDeploymentContext().getModuleMetaData(Application.class);
        application.addEntityManagerFactory(pInfo.getPersistenceUnitName(), pud.getPuRoot(), emf);
        if (isJava2DB) {
            this.java2dbEMFs.add(emf);
        }
        return emf;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doJava2DB(DeploymentContext ctx) {
        if (this.java2dbEMFs.size() == 0) {
            return;
        }
        boolean fineMsgLoggable = logger.isLoggable(Level.FINE);
        for (EntityManagerFactory emf : this.java2dbEMFs) {
            EntityManager em = null;
            try {
                if (fineMsgLoggable) {
                    logger.fine("<--- To Create EM");
                }
                em = emf.createEntityManager();
            }
            catch (Throwable e) {
                logger.log(Level.WARNING, e.getMessage(), e);
            }
            finally {
                if (em != null) {
                    em.close();
                }
            }
            if (!fineMsgLoggable) continue;
            logger.fine("---> Done Create EM");
        }
        if (fineMsgLoggable) {
            logger.fine("<--- To Create Tables");
        }
        this.processor.createTablesInDB();
        if (fineMsgLoggable) {
            logger.fine("---> Done Create Tables");
        }
    }

    private void closeAllEMFs() {
        String applicationLocation = this.providerContainerContractInfo.getApplicationLocation();
        boolean fineMsgLoggable = logger.isLoggable(Level.FINE);
        if (fineMsgLoggable) {
            logger.fine("Unloading persistence units for application: " + applicationLocation);
            logger.logp(Level.FINE, "JPAApplication", "closeEMFs", "loadedEMFs.size() = {0}", this.loadedEMFs.size());
        }
        for (EntityManagerFactory emf : this.loadedEMFs) {
            try {
                logger.logp(Level.FINE, "JPAApplication", "closeEMFs", "emf = {0}", emf);
                emf.close();
            }
            catch (Exception e) {
                logger.log(Level.WARNING, e.getMessage(), e);
            }
        }
        if (fineMsgLoggable) {
            logger.fine("Finished unloading persistence units for application: " + applicationLocation);
        }
    }

    static {
        HashMap<String, String> props = new HashMap<String, String>();
        String ECLIPSELINK_SERVER_PLATFORM_CLASS_NAME_PROPERTY = "eclipselink.target-server";
        props.put("eclipselink.target-server", System.getProperty("eclipselink.target-server", "SunAS9"));
        String TOPLINK_SERVER_PLATFORM_CLASS_NAME_PROPERTY = "toplink.target-server";
        props.put("toplink.target-server", System.getProperty("toplink.target-server", "SunAS9"));
        String HIBERNATE_TRANSACTION_MANAGER_LOOKUP_CLASS_PROPERTY = "hibernate.transaction.manager_lookup_class";
        props.put("hibernate.transaction.manager_lookup_class", System.getProperty("hibernate.transaction.manager_lookup_class", "org.hibernate.transaction.SunONETransactionManagerLookup"));
        baseIntegrationProperties = Collections.unmodifiableMap(props);
        HashMap<String, String> java2dbProps = new HashMap<String, String>(props);
        String DROP_AND_CREATE = "drop-and-create-tables";
        String TOPLINK_DDL_GENERATION = "toplink.ddl-generation";
        java2dbProps.put("toplink.ddl-generation", "drop-and-create-tables");
        String ECLIPSELINK_DDL_GENERATION = "eclipselink.ddl-generation";
        java2dbProps.put("eclipselink.ddl-generation", "drop-and-create-tables");
        String DDL_SQL_SCRIPT_GENERATION = "sql-script";
        String TOPLINK_DDL_GENERATION_MODE = "toplink.ddl-generation.output-mode";
        java2dbProps.put("toplink.ddl-generation.output-mode", "sql-script");
        String ECLIPSELINK_DDL_GENERATION_MODE = "eclipselink.ddl-generation.output-mode";
        java2dbProps.put("eclipselink.ddl-generation.output-mode", "sql-script");
        integrationPropertiesWithJava2DB = Collections.unmodifiableMap(java2dbProps);
        HashMap<String, String> nonjava2dbProps = new HashMap<String, String>(props);
        String ECLIPSELINK_DDL_GENERATION_MODE_PROPERTY = "eclipselink.ddl-generation.output-mode";
        nonjava2dbProps.put("eclipselink.ddl-generation.output-mode", System.getProperty("eclipselink.ddl-generation.output-mode", "none"));
        String TOPLINK_DDL_GENERATION_MODE_PROPERTY = "toplink.ddl-generation.output-mode";
        nonjava2dbProps.put("toplink.ddl-generation.output-mode", System.getProperty("toplink.ddl-generation.output-mode", "none"));
        integrationPropertiesWithoutJava2DB = Collections.unmodifiableMap(nonjava2dbProps);
    }
}

