/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.deployment.client;

import com.sun.enterprise.cli.framework.CommandException;
import com.sun.enterprise.util.HostAndPort;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.enterprise.deploy.shared.ModuleType;
import javax.enterprise.deploy.spi.Target;
import javax.enterprise.deploy.spi.TargetModuleID;
import javax.enterprise.deploy.spi.status.ClientConfiguration;
import org.glassfish.deployapi.ProgressObjectImpl;
import org.glassfish.deployapi.TargetImpl;
import org.glassfish.deployapi.TargetModuleIDImpl;
import org.glassfish.deployment.client.DFDeploymentStatus;
import org.glassfish.deployment.client.DFProgressObject;
import org.glassfish.deployment.client.DeploymentFacility;
import org.glassfish.deployment.client.RemoteDeploymentFacility;
import org.glassfish.deployment.client.ServerConnectionIdentifier;
import org.glassfish.deployment.client.TargetOwner;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractDeploymentFacility
implements DeploymentFacility,
TargetOwner {
    private static final String DEFAULT_SERVER_NAME = "server";
    protected static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(RemoteDeploymentFacility.class);
    private static final String LIST_COMMAND = "list";
    private static final String LIST_SUB_COMPONENTS_COMMAND = "list-sub-components";
    private static final String GET_CLIENT_STUBS_COMMAND = "get-client-stubs";
    private static final String GET_COMMAND = "get";
    private boolean connected;
    private TargetImpl domain;
    private ServerConnectionIdentifier targetDAS;
    private Map<String, String> targetModuleWebURLs = new HashMap<String, String>();

    protected abstract DFCommandRunner getDFCommandRunner(String var1, Map<String, Object> var2, String[] var3) throws CommandException;

    protected DFProgressObject changeState(Target[] targets, String moduleID, String commandName, String successStatusKey, String successStatusDefaultMessage, String failureStatusKey, String failureStatusDefaultMessage) {
        this.ensureConnected();
        targets = this.prepareTargets(targets);
        String targetsParam = this.createTargetsParam(targets);
        HashMap<String, Object> commandParams = new HashMap<String, Object>();
        commandParams.put("target", targetsParam);
        ProgressObjectImpl po = new ProgressObjectImpl(targets);
        try {
            DFCommandRunner commandRunner = this.getDFCommandRunner(commandName, commandParams, new String[]{moduleID});
            DFDeploymentStatus ds = commandRunner.run();
            DFDeploymentStatus mainStatus = ds.getMainStatus();
            if (mainStatus.getStatus() != DFDeploymentStatus.Status.FAILURE) {
                TargetModuleIDImpl[] targetModuleIDs = new TargetModuleIDImpl[targets.length];
                int i = 0;
                for (TargetImpl ti : ProgressObjectImpl.toTargetImpl(targets)) {
                    targetModuleIDs[i++] = new TargetModuleIDImpl(ti, moduleID);
                }
                po.setupForNormalExit(localStrings.getLocalString(successStatusKey, successStatusDefaultMessage, new Object[]{moduleID}), this.domain, mainStatus, targetModuleIDs);
            } else {
                po.setupForAbnormalExit(localStrings.getLocalString(failureStatusKey, failureStatusDefaultMessage, new Object[]{mainStatus.getStageStatusMessage()}), this.domain, mainStatus);
            }
            return po;
        }
        catch (Throwable ioex) {
            po.setupForAbnormalExit(localStrings.getLocalString(failureStatusKey, failureStatusDefaultMessage, new Object[]{ioex.toString()}), this.domain, ioex);
            return po;
        }
    }

    protected abstract boolean doConnect();

    @Override
    public boolean connect(ServerConnectionIdentifier targetDAS) {
        this.connected = true;
        this.targetDAS = targetDAS;
        this.domain = new TargetImpl(this, "domain", localStrings.getLocalString("enterprise.deployment.client.administrative_domain", "administrative-domain"));
        return this.doConnect();
    }

    protected abstract boolean doDisconnect();

    @Override
    public boolean disconnect() {
        this.connected = false;
        this.domain = null;
        this.targetDAS = null;
        return this.doDisconnect();
    }

    @Override
    public DFProgressObject createAppRef(Target[] targets, String moduleID, Map options) {
        throw new UnsupportedOperationException("Not supported in v3 prelude");
    }

    @Override
    public Target createTarget(String name) {
        return new TargetImpl(this, name, "");
    }

    @Override
    public Target[] createTargets(String[] targets) {
        if (targets == null) {
            targets = new String[]{};
        }
        Target[] result = new TargetImpl[targets.length];
        int i = 0;
        for (String name : targets) {
            result[i++] = new TargetImpl(this, name, "");
        }
        return result;
    }

    protected String createTargetsParam(Target[] targets) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < targets.length; ++i) {
            sb.append(targets[i].getName());
            if (i == targets.length - 1) continue;
            sb.append(",");
        }
        return sb.toString();
    }

    @Override
    public DFProgressObject deleteAppRef(Target[] targets, String moduleID, Map options) {
        throw new UnsupportedOperationException("Not supported in v3");
    }

    @Override
    public DFProgressObject deploy(Target[] targets, URI source, URI deploymentPlan, Map deploymentOptions) {
        this.ensureConnected();
        targets = this.prepareTargets(targets);
        String targetsParam = this.createTargetsParam(targets);
        deploymentOptions.put("target", targetsParam);
        ProgressObjectImpl po = new ProgressObjectImpl(targets);
        if (source == null) {
            po.setupForAbnormalExit(localStrings.getLocalString("enterprise.deployment.client.archive_not_specified", "Archive to be deployed is not specified at all."), this.domain);
            return po;
        }
        File tmpFile = new File(source);
        if (!tmpFile.exists()) {
            po.setupForAbnormalExit(localStrings.getLocalString("enterprise.deployment.client.archive_not_in_location", "Unable to find the archive to be deployed in specified location."), this.domain);
            return po;
        }
        if (!tmpFile.canRead()) {
            po.setupForAbnormalExit(localStrings.getLocalString("enterprise.deployment.client.archive_no_read_permission", "Archive to be deployed does not have read permission."), this.domain);
            return po;
        }
        boolean isDirectoryDeploy = tmpFile.isDirectory();
        try {
            DFCommandRunner commandRunner;
            DFDeploymentStatus ds;
            DFDeploymentStatus mainStatus;
            if (deploymentPlan != null) {
                File dp = new File(deploymentPlan);
                if (!dp.exists()) {
                    po.setupForAbnormalExit(localStrings.getLocalString("enterprise.deployment.client.plan_not_in_location", "Unable to find the deployment plan in specified location."), this.domain);
                    return po;
                }
                if (!dp.canRead()) {
                    po.setupForAbnormalExit(localStrings.getLocalString("enterprise.deployment.client.plan_no_read_permission", "Deployment plan does not have read permission."), this.domain);
                    return po;
                }
                deploymentOptions.put("deploymentplan", dp.getAbsolutePath());
            }
            if ((mainStatus = (ds = (commandRunner = this.getDFCommandRunner("deploy", deploymentOptions, new String[]{tmpFile.getAbsolutePath()})).run()).getMainStatus()).getStatus() != DFDeploymentStatus.Status.FAILURE) {
                String moduleID = mainStatus.getProperty("name");
                TargetModuleIDImpl[] targetModuleIDs = new TargetModuleIDImpl[targets.length];
                int i = 0;
                for (TargetImpl ti : ProgressObjectImpl.toTargetImpl(targets)) {
                    targetModuleIDs[i++] = new TargetModuleIDImpl(ti, moduleID);
                }
                po.setupForNormalExit(localStrings.getLocalString("enterprise.deployment.client.deploy_application", "Deployment of application {0}", new Object[]{moduleID}), this.domain, mainStatus, targetModuleIDs);
            } else {
                po.setupForAbnormalExit(localStrings.getLocalString("enterprise.deployment.client.deploy_application_failed", "Deployment of application failed - {0}", new Object[]{mainStatus.getStageStatusMessage()}), this.domain, mainStatus);
            }
            return po;
        }
        catch (Throwable ioex) {
            po.setupForAbnormalExit(localStrings.getLocalString("enterprise.deployment.client.deploy_application_failed", "Deployment of application failed - {0} ", new Object[]{ioex.toString()}), this.domain, ioex);
            return po;
        }
    }

    @Override
    public DFProgressObject disable(Target[] targets, String moduleID) {
        return this.changeState(targets, moduleID, "disable", "enterprise.deployment.client.disable_application", "Application {0} disabled successfully", "enterprise.deployment.client.disable_application_failed", "Attempt to disable application {0} failed");
    }

    @Override
    public String downloadFile(File location, String moduleID, String moduleURI) throws IOException {
        throw new UnsupportedOperationException("Not supported in v3");
    }

    @Override
    public DFProgressObject enable(Target[] targets, String moduleID) {
        return this.changeState(targets, moduleID, "enable", "enterprise.deployment.client.enable_application", "Application {0} enabled successfully", "enterprise.deployment.client.enable_application_failed", "Attempt to enable application {0} failed");
    }

    private void ensureConnected() {
        if (!this.isConnected()) {
            throw new IllegalStateException(localStrings.getLocalString("enterprise.deployment.client.disconnected_state", "Not connected to the Domain Admin Server"));
        }
    }

    @Override
    public ClientConfiguration getClientConfiguration(TargetModuleID targetModuleID) {
        throw new UnsupportedOperationException("Not supported");
    }

    @Override
    public boolean isConnected() {
        return this.connected;
    }

    @Override
    public List<String> getSubModuleInfoForJ2EEApplication(String appName) throws IOException {
        this.ensureConnected();
        String commandName = LIST_SUB_COMPONENTS_COMMAND;
        HashMap<String, Object> commandParams = new HashMap<String, Object>();
        commandParams.put("appName", appName);
        DFDeploymentStatus mainStatus = null;
        IOException commandExecutionException = null;
        try {
            DFCommandRunner commandRunner = this.getDFCommandRunner(commandName, commandParams, null);
            DFDeploymentStatus ds = commandRunner.run();
            mainStatus = ds.getMainStatus();
            ArrayList<String> subModuleInfoList = new ArrayList<String>();
            if (mainStatus.getStatus() != DFDeploymentStatus.Status.FAILURE) {
                Iterator subIter = ds.getSubStages();
                while (subIter.hasNext()) {
                    DFDeploymentStatus subStage = (DFDeploymentStatus)subIter.next();
                    Iterator subIter2 = subStage.getSubStages();
                    while (subIter2.hasNext()) {
                        DFDeploymentStatus subStage2 = (DFDeploymentStatus)subIter2.next();
                        subModuleInfoList.add(subStage2.getStageStatusMessage());
                    }
                }
            } else {
                commandExecutionException = new IOException("remote command execution failed on the server");
                commandExecutionException.initCause(new RuntimeException(mainStatus.getAllStageMessages()));
                throw commandExecutionException;
            }
            return subModuleInfoList;
        }
        catch (Throwable ex) {
            if (commandExecutionException == null) {
                throw new RuntimeException("error submitting remote command", ex);
            }
            throw (IOException)ex;
        }
    }

    @Override
    public String getContextRoot(String moduleName) throws IOException {
        this.ensureConnected();
        String commandName = GET_COMMAND;
        HashMap<String, Object> commandParams = new HashMap<String, Object>();
        String patternParam = "applications.application." + moduleName + ".context-root";
        commandParams.put("pattern", patternParam);
        DFDeploymentStatus mainStatus = null;
        IOException commandExecutionException = null;
        try {
            DFCommandRunner commandRunner = this.getDFCommandRunner(commandName, commandParams, null);
            DFDeploymentStatus ds = commandRunner.run();
            mainStatus = ds.getMainStatus();
            String contextRoot = null;
            if (mainStatus.getStatus() != DFDeploymentStatus.Status.FAILURE) {
                Iterator subIter = ds.getSubStages();
                while (subIter.hasNext()) {
                    DFDeploymentStatus subStage = (DFDeploymentStatus)subIter.next();
                    Iterator subIter2 = subStage.getSubStages();
                    while (subIter2.hasNext()) {
                        DFDeploymentStatus subStage2 = (DFDeploymentStatus)subIter2.next();
                        String result = subStage2.getStageStatusMessage();
                        contextRoot = this.getValueFromDottedNameGetResult(result);
                    }
                }
            } else {
                commandExecutionException = new IOException("remote command execution failed on the server");
                commandExecutionException.initCause(new RuntimeException(mainStatus.getAllStageMessages()));
                throw commandExecutionException;
            }
            return contextRoot;
        }
        catch (Throwable ex) {
            if (commandExecutionException == null) {
                throw new RuntimeException("error submitting remote command", ex);
            }
            throw (IOException)ex;
        }
    }

    @Override
    public ModuleType getModuleType(String moduleName) throws IOException {
        this.ensureConnected();
        String commandName = GET_COMMAND;
        HashMap<String, Object> commandParams = new HashMap<String, Object>();
        String patternParam = "applications.application." + moduleName + ".*";
        commandParams.put("pattern", patternParam);
        DFDeploymentStatus mainStatus = null;
        IOException commandExecutionException = null;
        try {
            DFCommandRunner commandRunner = this.getDFCommandRunner(commandName, commandParams, null);
            DFDeploymentStatus ds = commandRunner.run();
            mainStatus = ds.getMainStatus();
            ArrayList<String> resultList = new ArrayList<String>();
            if (mainStatus.getStatus() != DFDeploymentStatus.Status.FAILURE) {
                Iterator subIter = ds.getSubStages();
                while (subIter.hasNext()) {
                    DFDeploymentStatus subStage = (DFDeploymentStatus)subIter.next();
                    Iterator subIter2 = subStage.getSubStages();
                    while (subIter2.hasNext()) {
                        DFDeploymentStatus subStage2 = (DFDeploymentStatus)subIter2.next();
                        resultList.add(subStage2.getStageStatusMessage());
                    }
                }
                return this.getJavaEEModuleTypeFromResult(resultList);
            }
            commandExecutionException = new IOException("remote command execution failed on the server");
            commandExecutionException.initCause(new RuntimeException(mainStatus.getAllStageMessages()));
            throw commandExecutionException;
        }
        catch (Throwable ex) {
            if (commandExecutionException == null) {
                throw new RuntimeException("error submitting remote command", ex);
            }
            throw (IOException)ex;
        }
    }

    @Override
    public Target[] listTargets() throws IOException {
        this.ensureConnected();
        String commandName = LIST_COMMAND;
        HashMap<String, Object> commandParams = new HashMap<String, Object>();
        commandParams.put("pattern", "servers.server");
        DFDeploymentStatus mainStatus = null;
        IOException commandExecutionException = null;
        try {
            DFCommandRunner commandRunner = this.getDFCommandRunner(commandName, commandParams, null);
            DFDeploymentStatus ds = commandRunner.run();
            mainStatus = ds.getMainStatus();
            ArrayList<Target> targets = new ArrayList<Target>();
            if (mainStatus.getStatus() != DFDeploymentStatus.Status.FAILURE) {
                Iterator subIter = ds.getSubStages();
                while (subIter.hasNext()) {
                    DFDeploymentStatus subStage = (DFDeploymentStatus)subIter.next();
                    Iterator subIter2 = subStage.getSubStages();
                    while (subIter2.hasNext()) {
                        DFDeploymentStatus subStage2 = (DFDeploymentStatus)subIter2.next();
                        String result = subStage2.getStageStatusMessage();
                        String targetName = this.getValueFromDottedNameListResult(result);
                        targets.add(this.createTarget(targetName));
                    }
                }
                Target[] result = new Target[targets.size()];
                return targets.toArray(result);
            }
            commandExecutionException = new IOException("remote command execution failed on the server");
            commandExecutionException.initCause(new RuntimeException(mainStatus.getAllStageMessages()));
            throw commandExecutionException;
        }
        catch (Throwable ex) {
            if (commandExecutionException == null) {
                throw new RuntimeException("error submitting remote command", ex);
            }
            throw (IOException)ex;
        }
    }

    @Override
    public void getClientStubs(String location, String moduleID) throws IOException {
        this.ensureConnected();
        String commandName = GET_CLIENT_STUBS_COMMAND;
        HashMap<String, Object> commandParams = new HashMap<String, Object>();
        commandParams.put("appName", moduleID);
        commandParams.put("localDir", location);
        DFDeploymentStatus mainStatus = null;
        IOException commandExecutionException = null;
        try {
            DFCommandRunner commandRunner = this.getDFCommandRunner(commandName, commandParams, null);
            DFDeploymentStatus ds = commandRunner.run();
            mainStatus = ds.getMainStatus();
            if (mainStatus.getStatus() == DFDeploymentStatus.Status.FAILURE) {
                commandExecutionException = new IOException("remote command execution failed on the server");
                commandExecutionException.initCause(new RuntimeException(mainStatus.getAllStageMessages()));
                throw commandExecutionException;
            }
        }
        catch (Throwable ex) {
            if (commandExecutionException == null) {
                throw new RuntimeException("error submitting remote command", ex);
            }
            throw (IOException)ex;
        }
    }

    @Override
    public HostAndPort getHostAndPort(String target) throws IOException {
        return this.getHostAndPort(target, false);
    }

    @Override
    public HostAndPort getHostAndPort(String target, boolean securityEnabled) throws IOException {
        return this.getHostAndPort(target, null, securityEnabled);
    }

    @Override
    public HostAndPort getVirtualServerHostAndPort(String target, String virtualServer, boolean securityEnabled) throws IOException {
        return this.getHostAndPort(target, null, virtualServer, securityEnabled);
    }

    @Override
    public HostAndPort getHostAndPort(String target, String moduleId, boolean securityEnabled) throws IOException {
        return this.getHostAndPort(target, moduleId, null, securityEnabled);
    }

    private HostAndPort getHostAndPort(String target, String moduleId, String virtualServer, boolean securityEnabled) throws IOException {
        this.ensureConnected();
        String commandName = "get-host-and-port";
        HashMap<String, Object> commandParams = new HashMap<String, Object>();
        commandParams.put("target", target);
        if (moduleId != null) {
            commandParams.put("moduleId", moduleId);
        }
        if (virtualServer != null) {
            commandParams.put("virtualServer", virtualServer);
        }
        commandParams.put("securityEnabled", new Boolean(securityEnabled));
        DFDeploymentStatus mainStatus = null;
        IOException commandExecutionException = null;
        try {
            DFCommandRunner commandRunner = this.getDFCommandRunner(commandName, commandParams, null);
            DFDeploymentStatus ds = commandRunner.run();
            mainStatus = ds.getMainStatus();
            HostAndPort hap = null;
            if (mainStatus.getStatus() != DFDeploymentStatus.Status.FAILURE) {
                Iterator iter = ds.getSubStages();
                while (iter.hasNext()) {
                    DFDeploymentStatus subStage = (DFDeploymentStatus)iter.next();
                    String hostPortStr = subStage.getStageStatusMessage();
                    if (hostPortStr == null || hostPortStr.trim().equals("")) continue;
                    hap = new HostAndPort(hostPortStr);
                    break;
                }
                return hap;
            }
            commandExecutionException = new IOException("remote command execution failed on the server");
            commandExecutionException.initCause(new RuntimeException(mainStatus.getAllStageMessages()));
            throw commandExecutionException;
        }
        catch (Throwable ex) {
            if (commandExecutionException == null) {
                throw new RuntimeException("error submitting remote command", ex);
            }
            throw (IOException)ex;
        }
    }

    @Override
    public TargetModuleID[] listAppRefs(String[] targets) throws IOException {
        return this.listAppRefs(targets, "all");
    }

    @Override
    public TargetModuleID[] listAppRefs(String[] targets, String state) throws IOException {
        return this.listAppRefs(targets, state, null);
    }

    @Override
    public TargetModuleID[] listAppRefs(String[] targets, String state, String type) throws IOException {
        Target[] targetImpls = this.prepareTargets(this.createTargets(targets));
        return this.listAppRefs(targetImpls, state, type);
    }

    @Override
    public TargetModuleID[] listAppRefs(Target[] targets, String state, String type) throws IOException {
        this.ensureConnected();
        String commandName = "list-app-refs";
        String targetsParam = this.createTargetsParam(targets);
        HashMap<String, Object> commandParams = new HashMap<String, Object>();
        commandParams.put("target", targetsParam);
        commandParams.put("state", state);
        if (type != null) {
            commandParams.put("type", type);
        }
        DFDeploymentStatus mainStatus = null;
        IOException commandExecutionException = null;
        try {
            DFCommandRunner commandRunner = this.getDFCommandRunner(commandName, commandParams, null);
            DFDeploymentStatus ds = commandRunner.run();
            mainStatus = ds.getMainStatus();
            ArrayList<TargetModuleIDImpl> targetModuleIDList = new ArrayList<TargetModuleIDImpl>();
            if (mainStatus.getStatus() != DFDeploymentStatus.Status.FAILURE) {
                Iterator targetIter = ds.getSubStages();
                block2: while (targetIter.hasNext()) {
                    DFDeploymentStatus targetSubStage = (DFDeploymentStatus)targetIter.next();
                    String targetName = targetSubStage.getStageStatusMessage();
                    for (Target target : targets) {
                        if (!target.getName().equals(targetName)) continue;
                        Iterator appRefIter = targetSubStage.getSubStages();
                        while (appRefIter.hasNext()) {
                            DFDeploymentStatus appRefSubStage = (DFDeploymentStatus)appRefIter.next();
                            String moduleID = appRefSubStage.getStageStatusMessage();
                            if (!(target instanceof TargetImpl)) continue;
                            TargetModuleIDImpl targetModuleID = new TargetModuleIDImpl((TargetImpl)target, moduleID);
                            targetModuleIDList.add(targetModuleID);
                        }
                        continue block2;
                    }
                }
                TargetModuleIDImpl[] result = new TargetModuleIDImpl[targetModuleIDList.size()];
                return targetModuleIDList.toArray(result);
            }
            commandExecutionException = new IOException("remote command execution failed on the server");
            commandExecutionException.initCause(new RuntimeException(mainStatus.getAllStageMessages()));
            throw commandExecutionException;
        }
        catch (Throwable ex) {
            if (commandExecutionException == null) {
                throw new RuntimeException("error submitting remote command", ex);
            }
            throw (IOException)ex;
        }
    }

    private Target[] prepareTargets(Target[] targets) {
        if (targets == null || targets.length == 0) {
            targets = new Target[]{this.targetForDefaultServer()};
        }
        if (targets.length > 1) {
            throw new UnsupportedOperationException("Multiple targets not supported in v3");
        }
        return targets;
    }

    private Target targetForDefaultServer() {
        TargetImpl t = new TargetImpl(this, DEFAULT_SERVER_NAME, localStrings.getLocalString("enterprise.deployment.client.default_server_description", "default server"));
        return t;
    }

    @Override
    public DFProgressObject undeploy(Target[] targets, String moduleID) {
        return this.undeploy(targets, moduleID, null);
    }

    @Override
    public DFProgressObject undeploy(Target[] targets, String moduleID, Map undeploymentOptions) {
        this.ensureConnected();
        targets = this.prepareTargets(targets);
        String targetsParam = this.createTargetsParam(targets);
        undeploymentOptions.put("target", targetsParam);
        ProgressObjectImpl po = new ProgressObjectImpl(targets);
        try {
            DFCommandRunner commandRunner = this.getDFCommandRunner("undeploy", undeploymentOptions, new String[]{moduleID});
            DFDeploymentStatus ds = commandRunner.run();
            DFDeploymentStatus mainStatus = ds.getMainStatus();
            if (mainStatus.getStatus() != DFDeploymentStatus.Status.FAILURE) {
                TargetModuleIDImpl[] targetModuleIDs = new TargetModuleIDImpl[targets.length];
                int i = 0;
                for (TargetImpl ti : ProgressObjectImpl.toTargetImpl(targets)) {
                    targetModuleIDs[i++] = new TargetModuleIDImpl(ti, moduleID);
                }
                po.setupForNormalExit(localStrings.getLocalString("enterprise.deployment.client.undeploy_application", "Undeployment of application {0}", new Object[]{moduleID}), this.domain, mainStatus, targetModuleIDs);
            } else {
                po.setupForAbnormalExit(localStrings.getLocalString("enterprise.deployment.client.undeploy_application_failed", "Undeployment failed - {0} ", new Object[]{mainStatus.getStageStatusMessage()}), this.domain, mainStatus);
            }
            return po;
        }
        catch (Throwable ioex) {
            po.setupForAbnormalExit(localStrings.getLocalString("enterprise.deployment.client.undeploy_application_failed", "Undeployment failed - {0} ", new Object[]{ioex.toString()}), this.domain, ioex);
            return po;
        }
    }

    @Override
    public DFDeploymentStatus waitFor(DFProgressObject po) {
        return po.waitFor();
    }

    @Override
    public String getWebURL(TargetModuleID tmid) {
        return this.targetModuleWebURLs.get(tmid.getModuleID());
    }

    @Override
    public void setWebURL(TargetModuleID tmid, String webURL) {
        this.targetModuleWebURLs.put(tmid.getModuleID(), webURL);
    }

    protected ServerConnectionIdentifier getTargetDAS() {
        return this.targetDAS;
    }

    private String getValueFromDottedNameListResult(String result) {
        int index = result.lastIndexOf(".");
        return result.substring(index + 1);
    }

    private String getValueFromDottedNameGetResult(String result) {
        int index = result.lastIndexOf("=");
        return result.substring(index + 1);
    }

    private ModuleType getJavaEEModuleTypeFromResult(List<String> resultList) {
        ArrayList<String> sniffersFound = new ArrayList<String>();
        for (String result : resultList) {
            if (result.endsWith("property.isComposite=true")) {
                return ModuleType.EAR;
            }
            if (result.endsWith("engine.web.sniffer=web")) {
                sniffersFound.add("web");
                continue;
            }
            if (result.endsWith("engine.ejb.sniffer=ejb")) {
                sniffersFound.add("ejb");
                continue;
            }
            if (result.endsWith("engine.connector.sniffer=connector")) {
                sniffersFound.add("rar");
                continue;
            }
            if (!result.endsWith("engine.appclient.sniffer=appclient")) continue;
            sniffersFound.add("car");
        }
        if (sniffersFound.contains("web")) {
            return ModuleType.WAR;
        }
        if (sniffersFound.contains("ejb")) {
            return ModuleType.EJB;
        }
        if (sniffersFound.contains("rar")) {
            return ModuleType.RAR;
        }
        if (sniffersFound.contains("car")) {
            return ModuleType.CAR;
        }
        return null;
    }

    public static interface DFCommandRunner {
        public DFDeploymentStatus run() throws CommandException;
    }
}

