/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.cli;

import com.sun.enterprise.admin.cli.ListCommandsCommand;
import com.sun.enterprise.admin.cli.remote.CLIRemoteCommand;
import com.sun.enterprise.cli.framework.CLILogger;
import com.sun.enterprise.cli.framework.CLIMain;
import com.sun.enterprise.cli.framework.CommandException;
import com.sun.enterprise.cli.framework.CommandValidationException;
import com.sun.enterprise.cli.framework.InvalidCommandException;
import com.sun.enterprise.universal.i18n.LocalStringsImpl;
import java.net.ConnectException;
import java.util.Hashtable;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AsadminMain {
    private static final int ERROR = 1;
    private static final int CONNECTION_ERROR = 2;
    private static final int INVALID_COMMAND_ERROR = 3;
    private static final int SUCCESS = 0;
    private static final LocalStringsImpl strings = new LocalStringsImpl(AsadminMain.class);
    private static String[] copyOfArgs;

    public static void main(String[] args) {
        AsadminMain main = new AsadminMain();
        int exitCode = 1;
        if (args.length <= 0) {
            String msg = strings.get("AsadminUsageMessage");
            System.out.println(msg);
            System.exit(0);
        }
        copyOfArgs = new String[args.length];
        System.arraycopy(args, 0, copyOfArgs, 0, args.length);
        String command = args[0];
        try {
            exitCode = main.local(args);
        }
        catch (InvalidCommandException e) {
            if (args[0].equals("help")) {
                exitCode = main.remote(new String[]{args[1], "--help"});
                command = args[1];
            }
            CLILogger.getInstance().printDebugMessage(e.getMessage());
            exitCode = main.remote(args);
        }
        if (exitCode == 0) {
            CLILogger.getInstance().printDetailMessage(strings.get("CommandSuccessful", new Object[]{command}));
        }
        if (exitCode == 1) {
            CLILogger.getInstance().printDetailMessage(strings.get("CommandUnSuccessful", new Object[]{command}));
        }
        if (exitCode == 3) {
            try {
                CLIMain.displayClosestMatch(command, main.getRemoteCommands(), strings.get("ClosestMatchedLocalAndRemoteCommands"));
            }
            catch (InvalidCommandException e) {
                // empty catch block
            }
            CLILogger.getInstance().printDetailMessage(strings.get("CommandUnSuccessful", new Object[]{command}));
        }
        if (exitCode == 2) {
            try {
                CLIMain.displayClosestMatch(command, null, strings.get("ClosestMatchedLocalCommands"));
            }
            catch (InvalidCommandException e) {
                CLILogger.getInstance().printMessage(strings.get("InvalidRemoteCommand", new Object[]{command}));
            }
            CLILogger.getInstance().printDetailMessage(strings.get("CommandUnSuccessful", new Object[]{command}));
        }
        System.exit(exitCode);
    }

    static String[] getArgs() {
        return copyOfArgs;
    }

    private Map<String, String> getRemoteCommands() {
        try {
            ListCommandsCommand lcc = new ListCommandsCommand();
            String[] remoteCommands = lcc.getRemoteCommands();
            Hashtable<String, String> remoteCommandsMap = new Hashtable<String, String>();
            for (String rc : remoteCommands) {
                remoteCommandsMap.put(rc, "remote command");
            }
            return remoteCommandsMap;
        }
        catch (CommandException ce) {
            return null;
        }
    }

    private int local(String[] args) throws InvalidCommandException {
        try {
            CLIMain cli = new CLIMain();
            cli.invokeCommand(args);
            return 0;
        }
        catch (CommandException ce) {
            CLILogger.getInstance().printError(ce.getMessage());
            return 1;
        }
        catch (CommandValidationException cve) {
            CLILogger.getInstance().printError(cve.getMessage());
            return 1;
        }
        catch (NoClassDefFoundError ncdfe) {
            CLILogger.getInstance().printError(ncdfe.toString());
            return 1;
        }
        catch (InvalidCommandException ice) {
            throw ice;
        }
        catch (Throwable ex) {
            CLILogger.getInstance().printExceptionStackTrace(ex);
            CLILogger.getInstance().printError(ex.toString());
            return 1;
        }
    }

    private int remote(String[] args) {
        try {
            CLIRemoteCommand rc = new CLIRemoteCommand(args);
            rc.runCommand();
            return 0;
        }
        catch (Throwable ex) {
            CLILogger.getInstance().printExceptionStackTrace(ex);
            CLILogger.getInstance().printMessage(ex.getMessage());
            if (ex.getCause() instanceof ConnectException) {
                return 2;
            }
            if (ex.getCause() instanceof InvalidCommandException) {
                return 3;
            }
            return 1;
        }
    }
}

