/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.resource.pool;

import com.sun.enterprise.connectors.ConnectorRuntime;
import com.sun.enterprise.resource.listener.PoolLifeCycle;
import com.sun.enterprise.resource.pool.PoolManager;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.component.Singleton;

@Scoped(value=Singleton.class)
public class PoolLifeCycleRegistry
implements PoolLifeCycle {
    protected Map<String, List<PoolLifeCycle>> lifecycleListenersMap;
    private static PoolLifeCycleRegistry __poolLifeCycleRegistry = new PoolLifeCycleRegistry();

    public static PoolLifeCycleRegistry getRegistry() {
        if (__poolLifeCycleRegistry == null) {
            throw new RuntimeException("PoolLifeCycleRegistry not initialized");
        }
        return __poolLifeCycleRegistry;
    }

    public void registerPoolLifeCycle(String poolName, PoolLifeCycle listener) {
        if (this.lifecycleListenersMap == null) {
            this.lifecycleListenersMap = Collections.synchronizedMap(new HashMap());
        }
        if (!this.lifecycleListenersMap.containsKey(poolName)) {
            ArrayList listenersList = new ArrayList();
            this.lifecycleListenersMap.put(poolName, listenersList);
        }
        List<PoolLifeCycle> list = this.lifecycleListenersMap.get(poolName);
        list.add(listener);
        if (list.size() <= 1) {
            PoolManager poolMgr = ConnectorRuntime.getRuntime().getPoolManager();
            poolMgr.registerPoolLifeCycleListener(this);
        }
    }

    public void unRegisterPoolLifeCycle(String poolName, PoolLifeCycle listener) {
        if (this.lifecycleListenersMap.containsKey(poolName)) {
            List<PoolLifeCycle> list = this.lifecycleListenersMap.get(poolName);
            if (list != null && !list.isEmpty()) {
                list.remove(listener);
            }
            if (list.isEmpty()) {
                // empty if block
            }
        }
    }

    public void poolCreated(String poolName) {
        if (this.lifecycleListenersMap.containsKey(poolName)) {
            List<PoolLifeCycle> list = this.lifecycleListenersMap.get(poolName);
            for (PoolLifeCycle listener : list) {
                listener.poolCreated(poolName);
            }
        }
    }

    public void poolDestroyed(String poolName) {
        if (this.lifecycleListenersMap.containsKey(poolName)) {
            List<PoolLifeCycle> list = this.lifecycleListenersMap.get(poolName);
            for (PoolLifeCycle listener : list) {
                listener.poolDestroyed(poolName);
            }
        }
    }
}

