/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.enterprise.iiop.api;

import java.rmi.Remote;
import java.util.Properties;
import org.glassfish.api.admin.ProcessEnvironment;
import org.glassfish.api.naming.GlassfishNamingManager;
import org.glassfish.enterprise.iiop.api.GlassFishORBFactory;
import org.glassfish.enterprise.iiop.api.ProtocolManager;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.Habitat;
import org.jvnet.hk2.component.PostConstruct;
import org.omg.CORBA.ORB;

@Service
public class GlassFishORBHelper
implements PostConstruct {
    public static final String JNDI_CORBA_ORB_PROPERTY = "java.naming.corba.orb";
    public static final String OMG_ORB_INIT_HOST_PROPERTY = "org.omg.CORBA.ORBInitialHost";
    public static final String OMG_ORB_INIT_PORT_PROPERTY = "org.omg.CORBA.ORBInitialPort";
    public static final String DEFAULT_ORB_INIT_HOST = "localhost";
    public static final String DEFAULT_ORB_INIT_PORT = "3700";
    public static final String ORB_SSL_SERVER_REQUIRED = "com.sun.CSIV2.ssl.server.required";
    public static final String ORB_CLIENT_AUTH_REQUIRED = "com.sun.CSIV2.client.auth.required";
    public static final String ORB_SSL_CLIENT_REQUIRED = "com.sun.CSIV2.ssl.client.required";
    @Inject
    private Habitat habitat;
    @Inject
    private ProcessEnvironment processEnv;
    private GlassFishORBFactory orbFactory;
    private volatile ORB orb;
    private volatile ProtocolManager protocolManager;

    public void postConstruct() {
        this.orbFactory = (GlassFishORBFactory)this.habitat.getByContract(GlassFishORBFactory.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ORB getORB() {
        if (this.orb == null) {
            GlassFishORBHelper glassFishORBHelper = this;
            synchronized (glassFishORBHelper) {
                if (this.orb == null) {
                    try {
                        Properties props = new Properties();
                        ORB tempOrb = this.orbFactory.createORB(props);
                        if (this.processEnv.getProcessType() == ProcessEnvironment.ProcessType.Server) {
                            ProtocolManager tempProtocolManager = (ProtocolManager)this.habitat.getByContract(ProtocolManager.class);
                            tempProtocolManager.initialize(tempOrb);
                            tempProtocolManager.initializeNaming();
                            tempProtocolManager.initializePOAs();
                            GlassfishNamingManager namingManager = (GlassfishNamingManager)this.habitat.getByContract(GlassfishNamingManager.class);
                            Remote remoteSerialProvider = namingManager.initializeRemoteNamingSupport(tempOrb);
                            tempProtocolManager.initializeRemoteNaming(remoteSerialProvider);
                            this.protocolManager = tempProtocolManager;
                        }
                        this.orb = tempOrb;
                    }
                    catch (Exception e) {
                        throw new RuntimeException("Orb initialization erorr", e);
                    }
                }
            }
        }
        return this.orb;
    }

    public ProtocolManager getProtocolManager() {
        if (this.processEnv.getProcessType() != ProcessEnvironment.ProcessType.Server) {
            return null;
        }
        if (this.protocolManager == null) {
            this.getORB();
        }
        return this.protocolManager;
    }

    public int getCSIv2PolicyType() {
        return this.orbFactory.getCSIv2PolicyType();
    }

    public Properties getCSIv2Props() {
        return this.orbFactory.getCSIv2Props();
    }

    public void setCSIv2Prop(String name, String value) {
        this.orbFactory.setCSIv2Prop(name, value);
    }

    public int getORBInitialPort() {
        return this.orbFactory.getORBInitialPort();
    }

    public String getORBHost(ORB orb) {
        return this.orbFactory.getORBHost(orb);
    }

    public int getORBPort(ORB orb) {
        return this.orbFactory.getORBPort(orb);
    }
}

