/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.internal.data;

import com.sun.enterprise.config.serverbeans.Application;
import com.sun.enterprise.config.serverbeans.Module;
import java.beans.PropertyVetoException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.logging.Logger;
import org.glassfish.api.container.Container;
import org.glassfish.api.container.Sniffer;
import org.glassfish.api.deployment.ApplicationContext;
import org.glassfish.api.deployment.DeploymentContext;
import org.glassfish.api.deployment.archive.ReadableArchive;
import org.glassfish.api.event.EventListener;
import org.glassfish.api.event.Events;
import org.glassfish.internal.data.EngineRef;
import org.glassfish.internal.data.ModuleInfo;
import org.glassfish.internal.data.ProgressTracker;
import org.glassfish.internal.deployment.Deployment;
import org.glassfish.internal.deployment.ExtendedDeploymentContext;
import org.jvnet.hk2.config.TransactionFailure;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ApplicationInfo {
    private final Collection<ModuleInfo> modules = new LinkedList<ModuleInfo>();
    private final String name;
    private final ReadableArchive source;
    private final Events events;
    private final Map<Class<? extends Object>, Object> metaData = new HashMap<Class<? extends Object>, Object>();
    private String libraries;

    public ApplicationInfo(Events events, ReadableArchive source, String name) {
        this.name = name;
        this.source = source;
        this.events = events;
    }

    public void addMetaData(Object o) {
        this.metaData.put(o.getClass(), o);
    }

    public <T> T getMetaData(Class<T> c) {
        return c.cast(this.metaData.get(c));
    }

    public String getName() {
        return this.name;
    }

    public String getLibraries() {
        return this.libraries;
    }

    public void setLibraries(String libraries) {
        this.libraries = libraries;
    }

    public ReadableArchive getSource() {
        return this.source;
    }

    public Collection<ModuleInfo> getModuleInfos() {
        return this.modules;
    }

    public Collection<Sniffer> getSniffers() {
        ArrayList<Sniffer> sniffers = new ArrayList<Sniffer>();
        for (ModuleInfo module : this.modules) {
            sniffers.addAll(module.getSniffers());
        }
        return sniffers;
    }

    public <T extends Container> Collection<EngineRef> getEngineRefsForContainer(Class<T> type) {
        LinkedHashSet<EngineRef> refs = new LinkedHashSet<EngineRef>();
        for (ModuleInfo info : this.modules) {
            EngineRef ref = null;
            try {
                ref = info.getEngineRefForContainer(type);
            }
            catch (Exception e) {
                // empty catch block
            }
            if (ref == null) continue;
            refs.add(ref);
        }
        return refs;
    }

    public void load(ExtendedDeploymentContext context, ProgressTracker tracker) throws Exception {
        context.setPhase(ExtendedDeploymentContext.Phase.LOAD);
        for (ModuleInfo module : this.modules) {
            module.load(context, tracker);
        }
        if (this.events != null) {
            this.events.send(new EventListener.Event(Deployment.APPLICATION_LOADED, (Object)this), false);
        }
    }

    public void start(DeploymentContext context, ProgressTracker tracker) throws Exception {
        for (ModuleInfo module : this.getModuleInfos()) {
            module.start(context, tracker);
        }
        if (this.events != null) {
            this.events.send(new EventListener.Event(Deployment.APPLICATION_STARTED, (Object)this), false);
        }
    }

    public void stop(ApplicationContext context, Logger logger) {
        for (ModuleInfo module : this.getModuleInfos()) {
            module.stop(context, logger);
        }
        if (this.events != null) {
            this.events.send(new EventListener.Event(Deployment.APPLICATION_STOPPED, (Object)this), false);
        }
    }

    public void unload(ExtendedDeploymentContext context) {
        for (ModuleInfo module : this.getModuleInfos()) {
            module.unload(context);
        }
        if (this.events != null) {
            this.events.send(new EventListener.Event(Deployment.APPLICATION_UNLOADED, (Object)this), false);
        }
    }

    public boolean suspend(Logger logger) {
        boolean isSuccess = true;
        for (ModuleInfo module : this.modules) {
            if (module.suspend(logger)) continue;
            isSuccess = false;
        }
        return isSuccess;
    }

    public boolean resume(Logger logger) {
        boolean isSuccess = true;
        for (ModuleInfo module : this.modules) {
            if (module.resume(logger)) continue;
            isSuccess = false;
        }
        return isSuccess;
    }

    public void clean(ExtendedDeploymentContext context) throws Exception {
        for (ModuleInfo info : this.modules) {
            info.clean(context);
        }
        if (this.events != null) {
            this.events.send(new EventListener.Event(Deployment.APPLICATION_CLEANED, (Object)context), false);
        }
    }

    public void save(Application app) throws TransactionFailure, PropertyVetoException {
        for (ModuleInfo module : this.modules) {
            Module modConfig = (Module)app.createChild(Module.class);
            app.getModule().add(modConfig);
            module.save(modConfig);
        }
    }

    public void addModule(ModuleInfo info) {
        this.modules.add(info);
    }
}

