/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.connectors.work.context;

import com.sun.appserv.connectors.internal.api.ConnectorRuntime;
import com.sun.enterprise.connectors.work.WorkCoordinator;
import com.sun.enterprise.connectors.work.context.ConnectorCallbackHandler;
import com.sun.enterprise.connectors.work.context.CustomWorkContext_A;
import com.sun.enterprise.connectors.work.context.CustomWorkContext_B;
import com.sun.enterprise.connectors.work.context.CustomWorkContext_D;
import com.sun.enterprise.transaction.api.JavaEETransactionManager;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import javax.resource.spi.work.ExecutionContext;
import javax.resource.spi.work.HintsContext;
import javax.resource.spi.work.SecurityContext;
import javax.resource.spi.work.TransactionContext;
import javax.resource.spi.work.Work;
import javax.resource.spi.work.WorkCompletedException;
import javax.resource.spi.work.WorkContext;
import javax.resource.spi.work.WorkContextLifecycleListener;
import javax.resource.spi.work.WorkContextProvider;
import javax.resource.spi.work.WorkException;
import javax.resource.spi.work.WorkRejectedException;
import javax.security.auth.Subject;
import org.glassfish.security.common.Group;
import org.glassfish.security.common.PrincipalImpl;
import org.jvnet.hk2.annotations.Service;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service
public class WorkContextHandler
implements com.sun.appserv.connectors.internal.api.WorkContextHandler {
    private static final List<Class<? extends WorkContext>> containerSupportedContexts = new ArrayList<Class<? extends WorkContext>>();
    private ConnectorRuntime runtime = null;
    private Set<WorkContext> validContexts = new HashSet<WorkContext>();

    public WorkContextHandler() {
    }

    public WorkContextHandler(ConnectorRuntime runtime) {
        this.runtime = runtime;
    }

    public boolean isContextSupported(boolean strict, String workContextClassName) {
        boolean result = false;
        result = strict ? WorkContextHandler.canContainerHandleSameContextType(workContextClassName) : WorkContextHandler.canContainerHandleContext(workContextClassName);
        return result;
    }

    private static boolean canContainerHandleSameContextType(String workContextClassName) {
        boolean result = false;
        for (Class<? extends WorkContext> workContextClass : containerSupportedContexts) {
            Class clz = null;
            try {
                clz = WorkContextHandler.loadClass(workContextClassName);
            }
            catch (ClassNotFoundException cnfe) {
                WorkContextHandler.debug(cnfe.toString());
                cnfe.printStackTrace();
                break;
            }
            if (!workContextClass.equals(clz)) continue;
            result = true;
            WorkContextHandler.debug("Container can handle the context [Strict] : " + workContextClassName);
            break;
        }
        return result;
    }

    public static boolean canContainerHandleContext(String contextClassName) {
        boolean result = false;
        if (!WorkContextHandler.canContainerHandleSameContextType(contextClassName)) {
            Class context = null;
            try {
                context = WorkContextHandler.loadClass(contextClassName);
            }
            catch (ClassNotFoundException e) {
                WorkContextHandler.debug("Container cannot load the context class [isAssignable] : " + contextClassName + " ");
            }
            for (Class<? extends WorkContext> workContextClass : containerSupportedContexts) {
                if (!workContextClass.isAssignableFrom(context)) continue;
                result = true;
                WorkContextHandler.debug("Container can handle the context [isAssignable] : " + contextClassName);
                break;
            }
        } else {
            result = true;
        }
        return result;
    }

    private static Class loadClass(String contextClassName) throws ClassNotFoundException {
        return Thread.currentThread().getContextClassLoader().loadClass(contextClassName);
    }

    public void validateWork(Work work, ExecutionContext ec) throws WorkCompletedException, WorkRejectedException {
        if (work instanceof WorkContextProvider) {
            if (ec != null && WorkContextHandler.getExecutionContext(work) != ec) {
                String errorMsg = "Work is an WorkContextProvider and ExecutionContext [ " + ec + " ] is not null";
                WorkContextHandler.debug(errorMsg);
                throw new WorkRejectedException(errorMsg);
            }
            WorkContextProvider icp = (WorkContextProvider)((Object)work);
            List<WorkContext> contexts = icp.getWorkContexts();
            for (WorkContext ic : contexts) {
                WorkContextLifecycleListener listener = this.getListener(ic);
                if (this.isContextSupported(false, ic.getClass().getName())) {
                    if (this.isUniqueSubmission(ic, this.validContexts)) {
                        this.validContexts.add(ic);
                        continue;
                    }
                    WorkCompletedException wce = new WorkCompletedException("duplicate work context for type : " + ic.getClass().getName());
                    wce.setErrorCode("2");
                    WorkContextHandler.debug(wce.getMessage());
                    this.notifyContextSetupFailure(listener, "2");
                    throw wce;
                }
                WorkCompletedException wce = new WorkCompletedException("Connector runtime cannot handle the following work context : " + ic.getClass().getName());
                wce.setErrorCode("1");
                WorkContextHandler.debug(wce.getMessage());
                this.notifyContextSetupFailure(listener, "1");
                throw wce;
            }
        }
    }

    private boolean isUniqueSubmission(WorkContext ic, Collection<WorkContext> supportedContexts) {
        for (WorkContext workContext : supportedContexts) {
            String icName;
            String workContextName = workContext.getClass().getName().toLowerCase();
            if (!workContextName.equalsIgnoreCase(icName = ic.getClass().getName().toLowerCase())) continue;
            WorkContextHandler.debug("Not a unique workContext submission : " + workContext.getClass().getName());
            return false;
        }
        return true;
    }

    public void setupContext(ExecutionContext ec, WorkCoordinator wc) {
        boolean useExecutionContext = true;
        for (WorkContext ic : this.validContexts) {
            WorkContextLifecycleListener listener = this.getListener(ic);
            if (ic instanceof TransactionContext) {
                useExecutionContext = false;
                this.setupTransactionWorkContext((TransactionContext)ic, listener);
                continue;
            }
            if (ic instanceof SecurityContext) {
                this.setupSecurityWorkContext((SecurityContext)ic, listener, wc.getRAName());
                continue;
            }
            if (ic instanceof HintsContext) continue;
            Class<? extends WorkContext> claz = null;
            String className = ic.getClass().getName();
            if (!this.isContextSupported(true, className) && (claz = this.getMostSpecificWorkContextSupported(ic)) == null) {
                WorkContextHandler.debug("Cannot handle work context [ " + className + " ]");
                continue;
            }
            this.setupCustomWorkContext(ic, listener, claz);
        }
        if (useExecutionContext) {
            try {
                this.setupExecutionContext(ec);
            }
            catch (WorkException we) {
                wc.setException(we);
            }
            catch (Exception e) {
                wc.setException(e);
            }
        }
    }

    private WorkContextLifecycleListener getListener(WorkContext wc) {
        WorkContextLifecycleListener listener = null;
        if (wc instanceof WorkContextLifecycleListener) {
            listener = (WorkContextLifecycleListener)((Object)wc);
        }
        return listener;
    }

    private void setupCustomWorkContext(WorkContext ic, WorkContextLifecycleListener listener, Class<? extends WorkContext> claz) {
        if (claz != null) {
            WorkContextHandler.debug("setting customWorkContext for WorkContext [ " + ic.getClass().getName() + " ]" + " using most specific support " + "Work Context [ " + claz.getName() + " ]");
        } else {
            WorkContextHandler.debug("setting exact customWorkContext for WorkContext [ " + ic.getClass().getName() + " ]  ");
        }
        this.notifyContextSetupComplete(listener);
    }

    private Class<? extends WorkContext> getMostSpecificWorkContextSupported(WorkContext ic) {
        List<Class> assignableClasses = new ArrayList<Class>();
        for (Class<? extends WorkContext> icClass : containerSupportedContexts) {
            if (!icClass.isAssignableFrom(ic.getClass())) continue;
            assignableClasses.add(icClass);
        }
        assignableClasses = this.sortBasedOnInheritence(assignableClasses);
        WorkContextHandler.debug("most specific work context for [ " + ic.getClass().getName() + " ] " + "supported by container is [ " + assignableClasses.get(0).getName() + " ]");
        return assignableClasses.get(0);
    }

    private List<Class> sortBasedOnInheritence(List<Class> assignableClasses) {
        int size = assignableClasses.size();
        Class[] sortedClassesArray = new Class[size];
        for (Class claz : assignableClasses) {
            int count = this.getNumberOfAssignableClasses(claz, assignableClasses);
            sortedClassesArray[count - 1] = claz;
        }
        return Arrays.asList(sortedClassesArray);
    }

    private int getNumberOfAssignableClasses(Class claz, List<Class> assignableClasses) {
        int count = 0;
        for (Class assignableClass : assignableClasses) {
            if (!claz.isAssignableFrom(assignableClass)) continue;
            ++count;
        }
        return count;
    }

    private void setupSecurityWorkContext(SecurityContext securityWorkContext, WorkContextLifecycleListener listener, String raName) {
        try {
            Subject executionSubject = new Subject();
            Subject serviceSubject = new Subject();
            Map securityMap = this.getSecurityWorkContextMap(raName);
            ConnectorCallbackHandler handler = new ConnectorCallbackHandler(executionSubject, this.runtime.getCallbackHandler(), securityMap);
            securityWorkContext.setupSecurityContext(handler, executionSubject, serviceSubject);
            this.notifyContextSetupComplete(listener);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.notifyContextSetupFailure(listener, "3");
        }
    }

    private Map getSecurityWorkContextMap(String raName) {
        String groupsMap;
        HashMap<Object, Object> eisASMap = new HashMap<Object, Object>();
        String principalsMap = System.getProperty(raName + "-principals-map");
        if (principalsMap != null) {
            StringTokenizer tokenizer = new StringTokenizer(principalsMap, ",");
            while (tokenizer.hasMoreElements()) {
                String nameValue = (String)tokenizer.nextElement();
                if (nameValue == null || !nameValue.contains("=")) continue;
                int delimiterLocation = nameValue.indexOf("=");
                String eisPrincipal = nameValue.substring(0, delimiterLocation);
                String appserverPrincipal = nameValue.substring(delimiterLocation + 1);
                eisASMap.put(new PrincipalImpl(eisPrincipal), new PrincipalImpl(appserverPrincipal));
            }
        }
        if ((groupsMap = System.getProperty(raName + "-groups-map")) != null) {
            StringTokenizer tokenizer = new StringTokenizer(groupsMap, ",");
            while (tokenizer.hasMoreElements()) {
                String nameValue = (String)tokenizer.nextElement();
                if (nameValue == null || !nameValue.contains("=")) continue;
                int delimiterLocation = nameValue.indexOf("=");
                String eisGroup = nameValue.substring(0, delimiterLocation);
                String appserverGroup = nameValue.substring(delimiterLocation + 1);
                eisASMap.put(new Group(eisGroup), new Group(appserverGroup));
            }
            return eisASMap;
        }
        return null;
    }

    private void notifyContextSetupFailure(WorkContextLifecycleListener listener, String errorCode) {
        if (listener != null) {
            WorkContextHandler.debug("notifying context setup failure");
            listener.contextSetupFailed(errorCode);
        }
    }

    private void notifyContextSetupComplete(WorkContextLifecycleListener listener) {
        if (listener != null) {
            WorkContextHandler.debug("notifying context setup complete");
            listener.contextSetupComplete();
        }
    }

    private void setupTransactionWorkContext(TransactionContext tic, WorkContextLifecycleListener listener) {
        try {
            this.setupExecutionContext(tic);
            this.notifyContextSetupComplete(listener);
        }
        catch (Exception e) {
            this.notifyContextSetupFailure(listener, "3");
        }
    }

    private void setupExecutionContext(ExecutionContext ec) throws WorkException {
        JavaEETransactionManager tm = this.runtime.getTransactionManager();
        if (ec != null && ec.getXid() != null) {
            tm.recreate(ec.getXid(), ec.getTransactionTimeout());
        }
    }

    public static void debug(String message) {
        System.out.println("JSR-322 [Connector Container] [WorkContextHandler]: " + message);
    }

    public static ExecutionContext getExecutionContext(Work work) {
        TransactionContext ec = null;
        if (work instanceof WorkContextProvider) {
            WorkContextProvider icp = (WorkContextProvider)((Object)work);
            List<WorkContext> icList = icp.getWorkContexts();
            for (WorkContext ic : icList) {
                if (!(ic instanceof TransactionContext)) continue;
                ec = (TransactionContext)ic;
                break;
            }
        }
        return ec;
    }

    public boolean isContextSupported(Class contextClass) {
        return WorkContextHandler.canContainerHandleSameContextType(contextClass.getClass().getName());
    }

    static {
        containerSupportedContexts.add(TransactionContext.class);
        containerSupportedContexts.add(SecurityContext.class);
        containerSupportedContexts.add(HintsContext.class);
        containerSupportedContexts.add(CustomWorkContext_A.class);
        containerSupportedContexts.add(CustomWorkContext_B.class);
        containerSupportedContexts.add(CustomWorkContext_D.class);
    }
}

