/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.deployment.osgi;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.persistence.exceptions.EntityManagerSetupException;
import org.eclipse.persistence.internal.jpa.deployment.JPAInitializer;
import org.eclipse.persistence.internal.jpa.deployment.PersistenceInitializationHelper;
import org.eclipse.persistence.internal.jpa.deployment.osgi.BundleProxyClassLoader;
import org.eclipse.persistence.internal.jpa.deployment.osgi.OSGiInitializer;
import org.eclipse.persistence.internal.localization.LoggingLocalization;
import org.eclipse.persistence.logging.AbstractSessionLog;
import org.osgi.framework.Bundle;

public class OSGiPersistenceInitializationHelper
extends PersistenceInitializationHelper {
    private String initializerClassName = null;
    public static final String EQUINOX_INITIALIZER_NAME = "org.eclipse.persistence.internal.jpa.deployment.osgi.equinox.EquinoxInitializer";
    private static Map<String, Bundle> puToBundle = Collections.synchronizedMap(new HashMap());
    private static Map<Bundle, String[]> bundleToPUs = Collections.synchronizedMap(new HashMap());

    public static void addBundle(Bundle bundle, String[] stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            puToBundle.put(string, bundle);
        }
        bundleToPUs.put(bundle, stringArray);
    }

    public static void removeBundle(Bundle bundle) {
        String[] stringArray = bundleToPUs.remove(bundle);
        if (stringArray != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                String string = stringArray[i];
                puToBundle.remove(string);
            }
        }
    }

    public OSGiPersistenceInitializationHelper(String string) {
        this.initializerClassName = string;
    }

    public ClassLoader getClassLoader(String string, Map map) {
        ClassLoader classLoader = null;
        if (map != null) {
            classLoader = (ClassLoader)map.get("eclipselink.classloader");
        }
        if (classLoader == null) {
            Bundle bundle = puToBundle.get(string);
            if (bundle == null) {
                throw EntityManagerSetupException.couldNotFindPersistenceUnitBundle((String)string);
            }
            classLoader = new BundleProxyClassLoader(bundle);
        }
        return classLoader;
    }

    public JPAInitializer getInitializer(ClassLoader classLoader, Map map) {
        if (this.initializerClassName != null) {
            try {
                Class<?> clazz = Class.forName(this.initializerClassName);
                Class[] classArray = new Class[]{ClassLoader.class, Map.class, PersistenceInitializationHelper.class};
                Object[] objectArray = new Object[]{classLoader, map, this};
                JPAInitializer jPAInitializer = (JPAInitializer)clazz.getConstructor(classArray).newInstance(objectArray);
                return jPAInitializer;
            }
            catch (Exception exception) {
                AbstractSessionLog.getLog().log(1, LoggingLocalization.buildMessage((String)"osgi_initializer_failed", (Object[])new Object[]{this.initializerClassName, exception}));
            }
        }
        return new OSGiInitializer(classLoader);
    }
}

