/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.deployment.xml.parser;

import org.eclipse.persistence.internal.jpa.deployment.xml.parser.XMLNodeList;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class XPathEngine {
    private static final String ATTRIBUTE = "@";
    private static final String TEXT = "text()";
    private static final String ALL_CHILDREN = "child::*";
    private static final String NAMESPACE_URI = "http://java.sun.com/xml/ns/persistence/orm";
    private static XPathEngine instance = null;

    private XPathEngine() {
    }

    public static XPathEngine getInstance() {
        if (instance == null) {
            instance = new XPathEngine();
        }
        return instance;
    }

    public Node selectSingleNode(Node node, String[] stringArray) {
        if (node == null) {
            return null;
        }
        return this.selectSingleNode(node, stringArray, 0);
    }

    private Node selectSingleNode(Node node, String[] stringArray, int n) {
        Node node2 = this.getSingleNode(node, stringArray[n]);
        if (node2 == null || stringArray.length == n + 1) {
            return node2;
        }
        return this.selectSingleNode(node2, stringArray, n + 1);
    }

    public NodeList selectNodes(Node node, String[] stringArray) {
        if (node == null) {
            return null;
        }
        return this.selectNodes(node, stringArray, 0);
    }

    private NodeList selectNodes(Node node, String[] stringArray, int n) {
        NodeList nodeList = this.getNodes(node, stringArray[n]);
        if (stringArray.length != n + 1) {
            XMLNodeList xMLNodeList = new XMLNodeList();
            int n2 = nodeList.getLength();
            for (int i = 0; i < n2; ++i) {
                Node node2 = nodeList.item(i);
                xMLNodeList.addAll(this.selectNodes(node2, stringArray, n + 1));
            }
            return xMLNodeList;
        }
        return nodeList;
    }

    private Node getSingleNode(Node node, String string) {
        if (string.startsWith(ATTRIBUTE)) {
            return this.selectSingleAttribute(node, string);
        }
        if (TEXT.equals(string)) {
            return this.selectSingleText(node);
        }
        return this.selectSingleElement(node, string);
    }

    private NodeList getNodes(Node node, String string) {
        if (string.startsWith(ATTRIBUTE)) {
            return this.selectAttributeNodes(node, string);
        }
        if (TEXT.equals(string)) {
            return this.selectTextNodes(node);
        }
        if (string.equals(ALL_CHILDREN)) {
            return this.selectChildElements(node);
        }
        return this.selectElementNodes(node, string);
    }

    private Node selectSingleAttribute(Node node, String string) {
        Element element = (Element)node;
        return element.getAttributeNode(string.substring(1));
    }

    private NodeList selectAttributeNodes(Node node, String string) {
        XMLNodeList xMLNodeList = new XMLNodeList();
        Node node2 = this.selectSingleAttribute(node, string);
        if (null != node2) {
            xMLNodeList.add(node2);
        }
        return xMLNodeList;
    }

    private Node selectSingleElement(Node node, String string) {
        for (Node node2 = node.getFirstChild(); null != node2; node2 = node2.getNextSibling()) {
            if (node2.getNodeType() != 1 || !this.sameName(node2, string) || !this.sameNamespaceURI(node2, NAMESPACE_URI)) continue;
            return node2;
        }
        return null;
    }

    private NodeList selectChildElements(Node node) {
        XMLNodeList xMLNodeList = new XMLNodeList();
        for (Node node2 = node.getFirstChild(); node2 != null; node2 = node2.getNextSibling()) {
            if (node2.getNodeType() != 1) continue;
            xMLNodeList.add(node2);
        }
        return xMLNodeList;
    }

    private NodeList selectElementNodes(Node node, String string) {
        XMLNodeList xMLNodeList = new XMLNodeList();
        for (Node node2 = node.getFirstChild(); null != node2; node2 = node2.getNextSibling()) {
            if (node2.getNodeType() != 1 || !this.sameName(node2, string) || !this.sameNamespaceURI(node2, NAMESPACE_URI)) continue;
            xMLNodeList.add(node2);
        }
        return xMLNodeList;
    }

    private Node selectSingleText(Node node) {
        NodeList nodeList = node.getChildNodes();
        if (nodeList.getLength() == 0) {
            return null;
        }
        if (nodeList.getLength() == 1) {
            Node node2 = nodeList.item(0);
            if (node2.getNodeType() == 3) {
                return node2;
            }
            return null;
        }
        String string = null;
        for (int i = 0; i < nodeList.getLength(); ++i) {
            String string2;
            Node node3 = nodeList.item(i);
            if (node3.getNodeType() != 3 || (string2 = ((Text)node3).getNodeValue()) == null) continue;
            if (string == null) {
                string = new String();
            }
            string = string + string2;
        }
        if (string != null) {
            return node.getOwnerDocument().createTextNode(string);
        }
        return null;
    }

    private NodeList selectTextNodes(Node node) {
        Node node2 = this.selectSingleText(node);
        XMLNodeList xMLNodeList = new XMLNodeList();
        if (node2 != null) {
            xMLNodeList.add(node2);
        }
        return xMLNodeList;
    }

    private boolean sameNamespaceURI(Node node, String string) {
        String string2 = node.getNamespaceURI();
        if (string2 == string) {
            return true;
        }
        if (string2 == null && string.equals("")) {
            return true;
        }
        if (string == null && string2.equals("")) {
            return true;
        }
        return null != string2 && string2.equals(string);
    }

    private boolean sameName(Node node, String string) {
        return string.equals(node.getLocalName()) || string.equals(node.getNodeName());
    }
}

