/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.metadata.accessors.mappings;

import java.lang.annotation.Annotation;
import java.util.List;
import java.util.StringTokenizer;
import javax.persistence.FetchType;
import javax.persistence.MapKey;
import javax.persistence.MapKeyClass;
import javax.persistence.MapKeyColumn;
import javax.persistence.OrderBy;
import javax.persistence.OrderColumn;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.internal.jpa.metadata.MetadataDescriptor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.classes.ClassAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.mappings.MappingAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.mappings.MetadataHelper;
import org.eclipse.persistence.internal.jpa.metadata.accessors.mappings.RelationshipAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataAccessibleObject;
import org.eclipse.persistence.internal.jpa.metadata.columns.ColumnMetadata;
import org.eclipse.persistence.internal.jpa.metadata.columns.JoinColumnMetadata;
import org.eclipse.persistence.mappings.CollectionMapping;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.ForeignReferenceMapping;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CollectionAccessor
extends RelationshipAccessor {
    private static final String ASCENDING = "ASC";
    private static final String DESCENDING = "DESC";
    private Class m_mapKeyClass;
    private ColumnMetadata m_mapKeyColumn;
    private ColumnMetadata m_orderColumn;
    private List<JoinColumnMetadata> m_mapKeyJoinColumns;
    private String m_mapKey;
    private String m_mappedBy;
    private String m_orderBy;
    private String m_mapKeyClassName;

    protected CollectionAccessor(String string) {
        super(string);
    }

    protected CollectionAccessor(Annotation annotation, MetadataAccessibleObject metadataAccessibleObject, ClassAccessor classAccessor) {
        super(annotation, metadataAccessibleObject, classAccessor);
        String string = this.m_mappedBy = annotation == null ? "" : (String)MetadataHelper.invokeMethod("mappedBy", annotation);
        if (this.isAnnotationPresent(OrderBy.class)) {
            this.m_orderBy = (String)MetadataHelper.invokeMethod("value", this.getAnnotation(OrderBy.class));
        }
        if (this.isAnnotationPresent(MapKey.class)) {
            this.m_mapKey = (String)MetadataHelper.invokeMethod("name", this.getAnnotation(MapKey.class));
        }
        if (this.isAnnotationPresent(MapKeyColumn.class)) {
            this.m_mapKeyColumn = new ColumnMetadata((Annotation)this.getAnnotation(MapKeyColumn.class), metadataAccessibleObject, this.getAttributeName());
        }
        if (this.isAnnotationPresent(MapKeyClass.class)) {
            this.m_mapKeyClass = (Class)MetadataHelper.invokeMethod("value", this.getAnnotation(MapKeyClass.class));
        }
        if (this.isAnnotationPresent(OrderColumn.class)) {
            this.m_orderColumn = new ColumnMetadata((Annotation)this.getAnnotation(OrderColumn.class), metadataAccessibleObject, this.getAttributeName());
        }
    }

    @Override
    public Enum getDefaultFetchType() {
        return FetchType.valueOf((String)"LAZY");
    }

    public String getMapKey() {
        return this.m_mapKey;
    }

    public Class getMapKeyClass() {
        return this.m_mapKeyClass;
    }

    public String getMapKeyClassName() {
        return this.m_mapKeyClassName;
    }

    public ColumnMetadata getMapKeyColumn() {
        return this.m_mapKeyColumn;
    }

    public List<JoinColumnMetadata> getMapKeyJoinColumns() {
        return this.m_mapKeyJoinColumns;
    }

    public String getMappedBy() {
        return this.m_mappedBy;
    }

    public String getOrderBy() {
        return this.m_orderBy;
    }

    protected ColumnMetadata getOrderColumn() {
        return this.m_orderColumn;
    }

    @Override
    public Class getReferenceClass() {
        if (this.m_referenceClass == null) {
            this.m_referenceClass = this.getTargetEntity();
            if (this.m_referenceClass == Void.TYPE) {
                this.m_referenceClass = this.getReferenceClassFromGeneric();
                if (this.m_referenceClass == null) {
                    throw ValidationException.unableToDetermineTargetEntity((String)this.getAttributeName(), (Class)this.getJavaClass());
                }
                this.getLogger().logConfigMessage(this.getLoggingContext(), this.getAnnotatedElement(), (Object)this.m_referenceClass);
            }
        }
        return this.m_referenceClass;
    }

    @Override
    public boolean isCollectionAccessor() {
        return true;
    }

    public boolean isMapCollectionAccessor() {
        return this.getAccessibleObject().isSupportedDirectMapClass(this.getDescriptor());
    }

    @Override
    public void initXMLObject(MetadataAccessibleObject metadataAccessibleObject) {
        super.initXMLObject(metadataAccessibleObject);
        this.initXMLObject(this.m_mapKeyColumn, metadataAccessibleObject);
        this.initXMLObject(this.m_orderColumn, metadataAccessibleObject);
        this.m_mapKeyClass = this.initXMLClassName(this.m_mapKeyClassName);
    }

    @Override
    public void process() {
        if (!this.getAccessibleObject().isSupportedCollectionClass(this.getDescriptor())) {
            throw ValidationException.invalidCollectionTypeForRelationship((Class)this.getJavaClass(), (Class)this.getRawClass(), (Object)this.getAttributeName());
        }
    }

    protected void process(CollectionMapping collectionMapping) {
        collectionMapping.setIsReadOnly(false);
        collectionMapping.setIsLazy(this.isLazy());
        collectionMapping.setIsPrivateOwned(this.isPrivateOwned());
        collectionMapping.setJoinFetch(this.getMappingJoinFetchType(this.getJoinFetch()));
        collectionMapping.setAttributeName(this.getAttributeName());
        collectionMapping.setReferenceClassName(this.getReferenceClassName());
        this.setAccessorMethods((DatabaseMapping)collectionMapping);
        this.processCascadeTypes((ForeignReferenceMapping)collectionMapping);
        this.processOrderBy(collectionMapping);
        String string = this.processMapKey(collectionMapping);
        this.setIndirectionPolicy(collectionMapping, string, this.usesIndirection());
        this.processReturnInsertAndUpdate();
        this.addMapping((DatabaseMapping)collectionMapping);
    }

    protected String processMapKey(CollectionMapping collectionMapping) {
        String string = null;
        if (this.isMapCollectionAccessor()) {
            MetadataDescriptor metadataDescriptor = this.getReferenceDescriptor();
            if (this.m_mapKey != null && !this.m_mapKey.equals("") || !metadataDescriptor.hasCompositePrimaryKey()) {
                String string2 = metadataDescriptor.getIdAttributeName();
                this.getLogger();
                String string3 = this.getName(this.m_mapKey, string2, "metadata_default_map_key_attribute_name");
                MappingAccessor mappingAccessor = metadataDescriptor.getAccessorFor(string3);
                if (mappingAccessor == null) {
                    throw ValidationException.couldNotFindMapKey((String)string3, (Class)metadataDescriptor.getJavaClass(), (DatabaseMapping)collectionMapping);
                }
                string = mappingAccessor.getAccessibleObjectName();
            }
        }
        return string;
    }

    protected void processOrderBy(CollectionMapping collectionMapping) {
        block12: {
            if (this.m_orderBy == null) break block12;
            MetadataDescriptor metadataDescriptor = this.getReferenceDescriptor();
            if (this.m_orderBy.equals("")) {
                List<String> list = metadataDescriptor.getIdOrderByAttributeNames();
                if (metadataDescriptor.hasEmbeddedIdAttribute()) {
                    String string = metadataDescriptor.getEmbeddedIdAttributeName();
                    for (String string2 : list) {
                        collectionMapping.addAggregateOrderBy(string, string2, false);
                    }
                } else {
                    for (String string : list) {
                        collectionMapping.addOrderBy(string, false);
                    }
                }
            } else {
                StringTokenizer stringTokenizer = new StringTokenizer(this.m_orderBy, ",");
                while (stringTokenizer.hasMoreTokens()) {
                    String string;
                    StringTokenizer stringTokenizer2 = new StringTokenizer(stringTokenizer.nextToken());
                    String string3 = stringTokenizer2.nextToken();
                    MappingAccessor mappingAccessor = metadataDescriptor.getAccessorFor(string3);
                    if (mappingAccessor == null) {
                        throw ValidationException.invalidOrderByValue((String)string3, (Class)metadataDescriptor.getJavaClass(), (String)this.getAccessibleObjectName(), (Class)this.getJavaClass());
                    }
                    String string4 = mappingAccessor.getAttributeName();
                    String string5 = string = stringTokenizer2.hasMoreTokens() ? stringTokenizer2.nextToken() : ASCENDING;
                    if (mappingAccessor.isEmbedded()) {
                        for (String string6 : metadataDescriptor.getOrderByAttributeNames()) {
                            collectionMapping.addAggregateOrderBy(this.m_orderBy, string6, string.equals(DESCENDING));
                        }
                        continue;
                    }
                    if (mappingAccessor.getClassAccessor().isEmbeddableAccessor()) {
                        Object object = this.m_orderBy;
                        if (((String)object).contains(".")) {
                            object = ((String)object).substring(0, ((String)object).lastIndexOf("."));
                        }
                        collectionMapping.addAggregateOrderBy((String)object, string4, string.equals(DESCENDING));
                        continue;
                    }
                    collectionMapping.addOrderBy(string4, string.equals(DESCENDING));
                }
            }
        }
    }

    public void setMapKey(String string) {
        this.m_mapKey = string;
    }

    public void setMapKeyClassName(String string) {
        this.m_mapKeyClassName = string;
    }

    public void setMapKeyColumn(ColumnMetadata columnMetadata) {
        this.m_mapKeyColumn = columnMetadata;
    }

    public void setMapKeyJoinColumns(List<JoinColumnMetadata> list) {
        this.m_mapKeyJoinColumns = list;
    }

    public void setMappedBy(String string) {
        this.m_mappedBy = string;
    }

    public void setOrderBy(String string) {
        this.m_orderBy = string;
    }

    public void setOrderColumn(ColumnMetadata columnMetadata) {
        this.m_orderColumn = columnMetadata;
    }
}

