/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.metadata.queries;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.persistence.internal.jpa.EJBQueryImpl;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataAccessibleObject;
import org.eclipse.persistence.internal.jpa.metadata.queries.MetadataHelper;
import org.eclipse.persistence.internal.jpa.metadata.queries.NamedNativeQueryMetadata;
import org.eclipse.persistence.internal.jpa.metadata.queries.StoredProcedureParameterMetadata;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.queries.StoredProcedureCall;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NamedStoredProcedureQueryMetadata
extends NamedNativeQueryMetadata {
    private Boolean m_returnsResultSet;
    private List<StoredProcedureParameterMetadata> m_parameters = new ArrayList<StoredProcedureParameterMetadata>();
    private String m_procedureName;

    public NamedStoredProcedureQueryMetadata() {
        super("<named-stored-procedure_query>");
    }

    public NamedStoredProcedureQueryMetadata(Annotation annotation, MetadataAccessibleObject metadataAccessibleObject) {
        super(annotation, metadataAccessibleObject);
        for (Annotation annotation2 : (Annotation[])MetadataHelper.invokeMethod("parameters", annotation)) {
            this.m_parameters.add(new StoredProcedureParameterMetadata(annotation2, metadataAccessibleObject));
        }
        this.m_procedureName = (String)MetadataHelper.invokeMethod("procedureName", annotation);
        this.m_returnsResultSet = (Boolean)MetadataHelper.invokeMethod("returnsResultSet", annotation);
    }

    @Override
    public boolean equals(Object object) {
        if (super.equals(object) && object instanceof NamedStoredProcedureQueryMetadata) {
            NamedStoredProcedureQueryMetadata namedStoredProcedureQueryMetadata = (NamedStoredProcedureQueryMetadata)object;
            if (!this.valuesMatch(this.m_returnsResultSet, namedStoredProcedureQueryMetadata.getReturnsResultSet())) {
                return false;
            }
            if (!this.valuesMatch(this.m_parameters, namedStoredProcedureQueryMetadata.getParameters())) {
                return false;
            }
            return this.valuesMatch(this.m_procedureName, namedStoredProcedureQueryMetadata.getProcedureName());
        }
        return false;
    }

    public String getProcedureName() {
        return this.m_procedureName;
    }

    public List<StoredProcedureParameterMetadata> getParameters() {
        return this.m_parameters;
    }

    public Boolean getReturnsResultSet() {
        return this.m_returnsResultSet;
    }

    @Override
    public void initXMLObject(MetadataAccessibleObject metadataAccessibleObject) {
        super.initXMLObject(metadataAccessibleObject);
        this.initXMLObjects(this.m_parameters, metadataAccessibleObject);
    }

    @Override
    public void process(AbstractSession abstractSession, ClassLoader classLoader) {
        StoredProcedureCall storedProcedureCall = new StoredProcedureCall();
        ArrayList<String> arrayList = new ArrayList<String>();
        for (StoredProcedureParameterMetadata storedProcedureParameterMetadata : this.m_parameters) {
            arrayList.addAll(storedProcedureParameterMetadata.process(storedProcedureCall));
        }
        storedProcedureCall.setProcedureName(this.m_procedureName);
        storedProcedureCall.setReturnsResultSet(this.m_returnsResultSet == null ? false : this.m_returnsResultSet);
        Map<String, Object> map = this.processQueryHints(abstractSession);
        if (this.getResultClass() == Void.TYPE) {
            if (this.getResultSetMapping().equals("")) {
                abstractSession.addQuery(this.getName(), EJBQueryImpl.buildStoredProcedureQuery(storedProcedureCall, arrayList, map, classLoader));
            } else {
                abstractSession.addQuery(this.getName(), EJBQueryImpl.buildStoredProcedureQuery(this.getResultSetMapping(), storedProcedureCall, arrayList, map, classLoader));
            }
        } else {
            abstractSession.addQuery(this.getName(), EJBQueryImpl.buildStoredProcedureQuery(MetadataHelper.getClassForName(this.getResultClass().getName(), classLoader), storedProcedureCall, arrayList, map, classLoader));
        }
    }

    public void setProcedureName(String string) {
        this.m_procedureName = string;
    }

    public void setParameters(List<StoredProcedureParameterMetadata> list) {
        this.m_parameters = list;
    }

    public void setReturnsResultSet(Boolean bl) {
        this.m_returnsResultSet = bl;
    }
}

