/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.weaving.jpa;

import java.io.IOException;
import java.io.Writer;
import java.lang.instrument.IllegalClassFormatException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.zip.ZipException;
import javax.persistence.spi.ClassTransformer;
import javax.persistence.spi.PersistenceUnitInfo;
import org.eclipse.persistence.exceptions.PersistenceUnitLoadingException;
import org.eclipse.persistence.exceptions.StaticWeaveException;
import org.eclipse.persistence.internal.helper.ConversionManager;
import org.eclipse.persistence.internal.helper.JPAConversionManager;
import org.eclipse.persistence.internal.jpa.deployment.Archive;
import org.eclipse.persistence.internal.jpa.deployment.ArchiveFactoryImpl;
import org.eclipse.persistence.internal.jpa.deployment.PersistenceUnitProcessor;
import org.eclipse.persistence.internal.jpa.deployment.SEPersistenceUnitInfo;
import org.eclipse.persistence.internal.jpa.metadata.MetadataProcessor;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.internal.weaving.TransformerFactory;
import org.eclipse.persistence.logging.DefaultSessionLog;
import org.eclipse.persistence.sessions.DatabaseLogin;
import org.eclipse.persistence.sessions.Project;
import org.eclipse.persistence.sessions.Session;
import org.eclipse.persistence.sessions.server.ServerSession;

public class StaticWeaveClassTransformer {
    private ArrayList<ClassTransformer> classTransformers;
    private Writer logWriter;
    private int logLevel = 8;
    private ClassLoader aClassLoader;

    public StaticWeaveClassTransformer(URL uRL, ClassLoader classLoader) throws Exception {
        this(uRL, classLoader, null, 8);
    }

    public StaticWeaveClassTransformer(URL uRL, ClassLoader classLoader, Writer writer, int n) throws URISyntaxException, IOException {
        this.aClassLoader = classLoader;
        this.logWriter = writer;
        this.logLevel = n;
        this.buildClassTransformers(uRL, classLoader);
    }

    public byte[] transform(String string, Class clazz, byte[] byArray) throws IllegalClassFormatException {
        ClassTransformer classTransformer;
        byte[] byArray2 = null;
        Iterator<ClassTransformer> iterator = this.classTransformers.iterator();
        while (iterator.hasNext() && (byArray2 = (classTransformer = iterator.next()).transform(this.aClassLoader, string, clazz, null, byArray)) == null) {
        }
        return byArray2;
    }

    private void buildClassTransformers(URL uRL, ClassLoader classLoader) throws URISyntaxException, IOException {
        if (this.classTransformers != null) {
            return;
        }
        this.classTransformers = new ArrayList();
        Archive archive = null;
        try {
            archive = new ArchiveFactoryImpl().createArchive(uRL);
        }
        catch (ZipException zipException) {
            throw StaticWeaveException.exceptionOpeningArchive((URL)uRL, (Exception)zipException);
        }
        List<SEPersistenceUnitInfo> list = PersistenceUnitProcessor.processPersistenceArchive(archive, classLoader);
        if (list == null) {
            throw PersistenceUnitLoadingException.couldNotGetUnitInfoFromUrl((URL)uRL);
        }
        for (SEPersistenceUnitInfo sEPersistenceUnitInfo : list) {
            sEPersistenceUnitInfo.setNewTempClassLoader(classLoader);
            ClassTransformer classTransformer = this.buildTransformer(sEPersistenceUnitInfo, this.logWriter, this.logLevel);
            this.classTransformers.add(classTransformer);
        }
    }

    private ClassTransformer buildTransformer(PersistenceUnitInfo persistenceUnitInfo, Writer writer, int n) {
        ClassLoader classLoader = persistenceUnitInfo.getNewTempClassLoader();
        ServerSession serverSession = new ServerSession(new Project(new DatabaseLogin()));
        serverSession.setLogLevel(n);
        if (writer != null) {
            ((DefaultSessionLog)serverSession.getSessionLog()).setWriter(writer);
        }
        serverSession.getPlatform().setConversionManager((ConversionManager)new JPAConversionManager());
        boolean bl = false;
        String string = (String)persistenceUnitInfo.getProperties().get("eclipselink.weaving.eager");
        if (string != null && string.equalsIgnoreCase("true")) {
            bl = true;
        }
        MetadataProcessor metadataProcessor = new MetadataProcessor(persistenceUnitInfo, (AbstractSession)serverSession, classLoader, true, bl);
        PersistenceUnitProcessor.processORMetadata(metadataProcessor, false);
        Collection<Class> collection = PersistenceUnitProcessor.buildEntityList(metadataProcessor.getProject(), classLoader);
        boolean bl2 = true;
        String string2 = (String)persistenceUnitInfo.getProperties().get("eclipselink.weaving.lazy");
        if (string2 != null && string2.equalsIgnoreCase("false")) {
            bl2 = false;
        }
        boolean bl3 = true;
        String string3 = (String)persistenceUnitInfo.getProperties().get("eclipselink.weaving.changetracking");
        if (string3 != null && string3.equalsIgnoreCase("false")) {
            bl3 = false;
        }
        boolean bl4 = true;
        String string4 = (String)persistenceUnitInfo.getProperties().get("eclipselink.weaving.fetchgroups");
        if (string4 != null && string4.equalsIgnoreCase("false")) {
            bl4 = false;
        }
        boolean bl5 = true;
        String string5 = (String)persistenceUnitInfo.getProperties().get("eclipselink.weaving.internal");
        if (string5 != null && string5.equalsIgnoreCase("false")) {
            bl5 = false;
        }
        return TransformerFactory.createTransformerAndModifyProject((Session)serverSession, collection, (ClassLoader)classLoader, (boolean)bl2, (boolean)bl3, (boolean)bl4, (boolean)bl5);
    }
}

