/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ejb.containers;

import com.sun.appserv.connectors.internal.api.ResourceHandle;
import com.sun.appserv.connectors.internal.api.TransactedPoolManager;
import com.sun.ejb.ComponentContext;
import com.sun.ejb.EjbInvocation;
import com.sun.ejb.containers.BaseContainer;
import com.sun.ejb.containers.EJBContextImpl;
import com.sun.ejb.containers.EJBLocalRemoteObject;
import com.sun.ejb.containers.EJBObjectImpl;
import com.sun.ejb.containers.EJBTimerService;
import com.sun.ejb.containers.EjbContainerUtilImpl;
import com.sun.ejb.containers.MessageBeanContextImpl;
import com.sun.ejb.containers.MessageBeanListenerImpl;
import com.sun.ejb.containers.RuntimeTimerState;
import com.sun.ejb.containers.TimerWrapper;
import com.sun.ejb.containers.util.pool.AbstractPool;
import com.sun.ejb.containers.util.pool.NonBlockingPool;
import com.sun.ejb.containers.util.pool.ObjectFactory;
import com.sun.ejb.spi.stats.MessageDrivenBeanStatsProvider;
import com.sun.enterprise.admin.monitor.callflow.ComponentType;
import com.sun.enterprise.config.serverbeans.MdbContainer;
import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.deployment.EjbMessageBeanDescriptor;
import com.sun.enterprise.deployment.JndiNameEnvironment;
import com.sun.enterprise.deployment.LifecycleCallbackDescriptor;
import com.sun.enterprise.deployment.runtime.BeanPoolDescriptor;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.enterprise.util.Utility;
import com.sun.logging.LogDomains;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ejb.CreateException;
import javax.ejb.EJBException;
import javax.ejb.EJBHome;
import javax.ejb.MessageDrivenBean;
import javax.ejb.RemoveException;
import org.glassfish.api.invocation.ComponentInvocation;
import org.glassfish.api.invocation.ResourceHandler;
import org.glassfish.ejb.api.MessageBeanListener;
import org.glassfish.ejb.api.MessageBeanProtocolManager;
import org.glassfish.ejb.api.ResourcesExceededException;
import org.glassfish.ejb.spi.MessageBeanClient;
import org.glassfish.ejb.spi.MessageBeanClientFactory;

public final class MessageBeanContainer
extends BaseContainer
implements MessageBeanProtocolManager,
MessageDrivenBeanStatsProvider {
    private static final Logger _logger = LogDomains.getLogger(MessageBeanContainer.class, (String)"javax.enterprise.system.container.ejb.mdb");
    private String appEJBName_;
    private static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(MessageBeanContainer.class);
    private static final int POOLED = 1;
    private static final int INVOKING = 2;
    private static final int DESTROYED = 3;
    private MessageBeanClient messageBeanClient_ = null;
    private AbstractPool messageBeanPool_ = null;
    private BeanPoolDescriptor beanPoolDesc_ = null;
    private int maxMessageBeanListeners_;
    private int numMessageBeanListeners_;
    private static final String MESSAGE_BEAN_CLIENT_FACTORY_PROP = "com.sun.enterprise.MessageBeanClientFactory";
    private static final String DEFAULT_MESSAGE_BEAN_CLIENT_FACTORY = "ConnectorMessageBeanClientFactory";
    private static final int DEFAULT_RESIZE_QUANTITY = 1;
    private static final int DEFAULT_STEADY_SIZE = 10;
    private static final int DEFAULT_MAX_POOL_SIZE = 60;
    private static final int DEFAULT_IDLE_TIMEOUT = 600;
    private static final int MIN_IDLE_TIMEOUT = 1;
    private int statMessageCount = 0;
    private TransactedPoolManager poolMgr;

    MessageBeanContainer(EjbDescriptor desc, ClassLoader loader) throws Exception {
        super(BaseContainer.ContainerType.MESSAGE_DRIVEN, desc, loader);
        this.appEJBName_ = desc.getApplication().getRegistrationName() + ":" + desc.getName();
        EjbMessageBeanDescriptor msgBeanDesc = (EjbMessageBeanDescriptor)desc;
        try {
            Method[] msgListenerMethods = msgBeanDesc.getMessageListenerInterfaceMethods(loader);
            for (int i = 0; i < msgListenerMethods.length; ++i) {
                Method next = msgListenerMethods[i];
                super.registerTxAttrForMethod(next, "Bean");
            }
            this.poolMgr = (TransactedPoolManager)EjbContainerUtilImpl.getInstance().getDefaultHabitat().getByContract(TransactedPoolManager.class);
            String factoryClassName = System.getProperty(MESSAGE_BEAN_CLIENT_FACTORY_PROP);
            MessageBeanClientFactory clientFactory = null;
            if (factoryClassName != null) {
                Class<?> clientFactoryClass = loader.loadClass(factoryClassName);
                clientFactory = (MessageBeanClientFactory)clientFactoryClass.newInstance();
            } else {
                clientFactory = (MessageBeanClientFactory)EjbContainerUtilImpl.getInstance().getDefaultHabitat().getComponent(MessageBeanClientFactory.class, DEFAULT_MESSAGE_BEAN_CLIENT_FACTORY);
            }
            _logger.log(Level.FINE, "Using " + clientFactory.getClass().getName() + " for message bean client factory in " + this.appEJBName_);
            this.createMessageBeanPool(msgBeanDesc);
            this.maxMessageBeanListeners_ = this.beanPoolDesc_.getMaxPoolSize();
            this.numMessageBeanListeners_ = 0;
            this.messageBeanClient_ = clientFactory.createMessageBeanClient(msgBeanDesc);
            this.messageBeanClient_.setup((MessageBeanProtocolManager)this);
            this.registerMonitorableComponents(msgListenerMethods);
            this.createCallFlowAgent(ComponentType.MDB);
        }
        catch (Exception ex) {
            if (this.messageBeanClient_ != null) {
                this.messageBeanClient_.close();
            }
            _logger.log(Level.SEVERE, "containers.mdb.create_container_exception", new Object[]{desc.getName(), ex.toString()});
            _logger.log(Level.SEVERE, ex.getClass().getName(), ex);
            throw ex;
        }
    }

    protected void registerMonitorableComponents(Method[] msgListenerMethods) {
    }

    protected void initializeHome() throws Exception {
    }

    private void createMessageBeanPool(EjbMessageBeanDescriptor descriptor) {
        this.beanPoolDesc_ = descriptor.getIASEjbExtraDescriptors().getBeanPool();
        if (this.beanPoolDesc_ == null) {
            this.beanPoolDesc_ = new BeanPoolDescriptor();
        }
        MdbContainer mdbc = (MdbContainer)this.ejbContainerUtilImpl.getDefaultHabitat().getComponent(MdbContainer.class);
        int maxPoolSize = this.beanPoolDesc_.getMaxPoolSize();
        if (maxPoolSize < 0) {
            maxPoolSize = MessageBeanContainer.stringToInt(mdbc.getMaxPoolSize(), this.appEJBName_, _logger);
        }
        maxPoolSize = this.validateValue(maxPoolSize, 1, -1, 60, "max-pool-size", this.appEJBName_, _logger);
        this.beanPoolDesc_.setMaxPoolSize(maxPoolSize);
        int value = this.beanPoolDesc_.getSteadyPoolSize();
        if (value < 0) {
            value = MessageBeanContainer.stringToInt(mdbc.getSteadyPoolSize(), this.appEJBName_, _logger);
        }
        value = this.validateValue(value, 0, maxPoolSize, 10, "steady-pool-size", this.appEJBName_, _logger);
        this.beanPoolDesc_.setSteadyPoolSize(value);
        value = this.beanPoolDesc_.getPoolResizeQuantity();
        if (value < 0) {
            value = MessageBeanContainer.stringToInt(mdbc.getPoolResizeQuantity(), this.appEJBName_, _logger);
        }
        value = this.validateValue(value, 1, maxPoolSize, 1, "pool-resize-quantity", this.appEJBName_, _logger);
        this.beanPoolDesc_.setPoolResizeQuantity(value);
        value = this.beanPoolDesc_.getPoolIdleTimeoutInSeconds();
        if (value <= 0) {
            value = MessageBeanContainer.stringToInt(mdbc.getIdleTimeoutInSeconds(), this.appEJBName_, _logger);
        }
        value = this.validateValue(value, 1, -1, 600, "idle-timeout-in-seconds", this.appEJBName_, _logger);
        this.beanPoolDesc_.setPoolIdleTimeoutInSeconds(value);
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, this.appEJBName_ + ": Setting message-driven bean pool max-pool-size=" + this.beanPoolDesc_.getMaxPoolSize() + ", steady-pool-size=" + this.beanPoolDesc_.getSteadyPoolSize() + ", pool-resize-quantity=" + this.beanPoolDesc_.getPoolResizeQuantity() + ", idle-timeout-in-seconds=" + this.beanPoolDesc_.getPoolIdleTimeoutInSeconds());
        }
        MessageBeanContextFactory objFactory = new MessageBeanContextFactory();
        this.messageBeanPool_ = new NonBlockingPool(this.appEJBName_, objFactory, this.beanPoolDesc_.getSteadyPoolSize(), this.beanPoolDesc_.getPoolResizeQuantity(), this.beanPoolDesc_.getMaxPoolSize(), this.beanPoolDesc_.getPoolIdleTimeoutInSeconds(), this.loader);
        this.registryMediator.registerProvider(this.messageBeanPool_);
    }

    protected static int stringToInt(String val, String appName, Logger logger) {
        int value = -1;
        try {
            value = Integer.parseInt(val);
        }
        catch (Exception e) {
            _logger.log(Level.WARNING, "containers.mdb.invalid_value", new Object[]{appName, new Integer(val), e.toString(), new Integer(0)});
            _logger.log(Level.WARNING, "", e);
        }
        return value;
    }

    protected int validateValue(int value, int lowLimit, int highLimit, int deft, String emsg, String appName, Logger logger) {
        if (value < lowLimit) {
            _logger.log(Level.WARNING, "containers.mdb.invalid_value", new Object[]{appName, new Integer(value), emsg, new Integer(lowLimit)});
            value = deft;
        }
        if (highLimit >= 0 && value > highLimit) {
            _logger.log(Level.WARNING, "containers.mdb.invalid_value", new Object[]{appName, new Integer(value), emsg, new Integer(highLimit)});
            value = highLimit;
        }
        return value;
    }

    private boolean containerStartsTx(Method method) {
        int txMode = this.getTxAttr(method, "Bean");
        return method.equals(this.ejbTimeoutMethod) ? txMode == 5 || txMode == 3 : txMode == 3;
    }

    public String getMonitorAttributeValues() {
        StringBuffer sbuf = new StringBuffer();
        sbuf.append("MESSAGEDRIVEN ");
        sbuf.append(this.appEJBName_);
        sbuf.append(this.messageBeanPool_.getAllAttrValues());
        sbuf.append("]");
        return sbuf.toString();
    }

    public boolean userTransactionMethodsAllowed(ComponentInvocation inv) {
        boolean utMethodsAllowed = false;
        if (this.isBeanManagedTran && inv instanceof EjbInvocation) {
            EjbInvocation ejbInvocation = (EjbInvocation)inv;
            EJBContextImpl mdc = (EJBContextImpl)ejbInvocation.context;
            utMethodsAllowed = !mdc.isUnitialized() && !mdc.isInEjbRemove();
        }
        return utMethodsAllowed;
    }

    public void setEJBHome(EJBHome ejbHome) throws Exception {
        throw new Exception("Can't set EJB Home on Message-driven bean");
    }

    public EJBObjectImpl getEJBObjectImpl(byte[] instanceKey) {
        throw new EJBException("No EJBObject for message-driven beans");
    }

    public EJBObjectImpl createEJBObjectImpl() throws CreateException {
        throw new EJBException("No EJBObject for message-driven beans");
    }

    void removeBean(EJBLocalRemoteObject ejbo, Method removeMethod, boolean local) throws RemoveException, EJBException {
        throw new EJBException("not used in message-driven beans");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    boolean callEJBTimeout(RuntimeTimerState timerState, EJBTimerService timerService) throws Exception {
        ResourceHandle nullResourceHandle;
        boolean redeliver;
        block10: {
            redeliver = false;
            nullResourceHandle = null;
            try {
                try {
                    this.beforeMessageDelivery(this.ejbTimeoutMethod, MessageDeliveryType.Timer, false, nullResourceHandle);
                    Object[] args = new Object[]{new TimerWrapper(timerState.getTimerId(), timerService)};
                    this.deliverMessage(args);
                }
                catch (Throwable t) {
                    redeliver = true;
                    _logger.log(Level.FINE, "ejbTimeout threw Runtime exception", t);
                    Object var7_8 = null;
                    if (!this.isBeanManagedTran && this.transactionManager.getStatus() == 1) {
                        redeliver = true;
                        _logger.log(Level.FINE, "ejbTimeout called setRollbackOnly");
                    }
                    if (!redeliver) {
                        boolean successfulPostEjbTimeout = timerService.postEjbTimeout(timerState.getTimerId());
                        redeliver = !successfulPostEjbTimeout;
                    }
                    boolean successfulAfterMessageDelivery = this.afterMessageDeliveryInternal(nullResourceHandle);
                    if (redeliver) return redeliver;
                    if (successfulAfterMessageDelivery) return redeliver;
                    return true;
                }
                Object var7_7 = null;
                if (this.isBeanManagedTran) break block10;
            }
            catch (Throwable throwable) {
                Object var7_9 = null;
                if (!this.isBeanManagedTran && this.transactionManager.getStatus() == 1) {
                    redeliver = true;
                    _logger.log(Level.FINE, "ejbTimeout called setRollbackOnly");
                }
                if (!redeliver) {
                    boolean successfulPostEjbTimeout = timerService.postEjbTimeout(timerState.getTimerId());
                    redeliver = !successfulPostEjbTimeout;
                }
                boolean successfulAfterMessageDelivery = this.afterMessageDeliveryInternal(nullResourceHandle);
                if (redeliver) throw throwable;
                if (successfulAfterMessageDelivery) throw throwable;
                redeliver = true;
                throw throwable;
            }
            if (this.transactionManager.getStatus() == 1) {
                redeliver = true;
                _logger.log(Level.FINE, "ejbTimeout called setRollbackOnly");
            }
        }
        if (!redeliver) {
            boolean successfulPostEjbTimeout = timerService.postEjbTimeout(timerState.getTimerId());
            redeliver = !successfulPostEjbTimeout;
        }
        boolean successfulAfterMessageDelivery = this.afterMessageDeliveryInternal(nullResourceHandle);
        if (redeliver) return redeliver;
        if (successfulAfterMessageDelivery) return redeliver;
        return true;
    }

    void forceDestroyBean(EJBContextImpl sc) {
        if (sc.getState() == EJBContextImpl.BeanState.DESTROYED) {
            return;
        }
        sc.setState(EJBContextImpl.BeanState.DESTROYED);
        this.messageBeanPool_.destroyObject(sc);
    }

    public void preInvoke(EjbInvocation inv) {
        throw new EJBException("preInvoke(Invocation) not supported");
    }

    protected ComponentContext _getContext(EjbInvocation inv) {
        MessageBeanContextImpl context = null;
        try {
            context = (MessageBeanContextImpl)this.messageBeanPool_.getObject(null);
            context.setState(EJBContextImpl.BeanState.INVOKING);
        }
        catch (Exception e) {
            throw new EJBException(e);
        }
        return context;
    }

    public void releaseContext(EjbInvocation inv) {
        MessageBeanContextImpl beanContext = (MessageBeanContextImpl)inv.context;
        if (beanContext.getState() == EJBContextImpl.BeanState.DESTROYED) {
            return;
        }
        beanContext.setState(EJBContextImpl.BeanState.POOLED);
        beanContext.setTransaction(null);
        beanContext.touch();
        this.messageBeanPool_.returnObject(beanContext);
    }

    public void appendStats(StringBuffer sbuf) {
        sbuf.append("\nMessageBeanContainer: ").append("CreateCount=").append(this.statCreateCount).append("; ").append("RemoveCount=").append(this.statRemoveCount).append("; ").append("MsgCount=").append(this.statMessageCount).append("; ");
        sbuf.append("]");
    }

    public void postInvoke(EjbInvocation inv) {
        throw new EJBException("postInvoke(Invocation) not supported in message-driven bean container");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MessageBeanListener createMessageBeanListener(ResourceHandle resource) throws ResourcesExceededException {
        boolean resourcesExceeded = false;
        MessageBeanContainer messageBeanContainer = this;
        synchronized (messageBeanContainer) {
            if (this.numMessageBeanListeners_ < this.maxMessageBeanListeners_) {
                ++this.numMessageBeanListeners_;
            } else {
                resourcesExceeded = true;
            }
        }
        if (resourcesExceeded) {
            ResourcesExceededException ree = new ResourcesExceededException("Message Bean Resources exceeded for message bean " + this.appEJBName_);
            _logger.log(Level.FINE, "exceeded max of " + this.maxMessageBeanListeners_, (Throwable)ree);
            throw ree;
        }
        return new MessageBeanListenerImpl(this, resource);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroyMessageBeanListener(MessageBeanListener listener) {
        MessageBeanContainer messageBeanContainer = this;
        synchronized (messageBeanContainer) {
            --this.numMessageBeanListeners_;
        }
    }

    public boolean isDeliveryTransacted(Method method) {
        return this.containerStartsTx(method);
    }

    public BeanPoolDescriptor getPoolDescriptor() {
        return this.beanPoolDesc_;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private MessageBeanContextImpl createMessageDrivenEJB() throws CreateException {
        MessageBeanContextImpl context;
        EjbInvocation inv;
        block9: {
            inv = null;
            context = null;
            ClassLoader originalClassLoader = null;
            boolean methodCalled = false;
            boolean methodCallFailed = false;
            try {
                try {
                    originalClassLoader = Utility.setContextClassLoader((ClassLoader)this.getClassLoader());
                    Object ejb = this.ejbClass.newInstance();
                    context = new MessageBeanContextImpl(ejb, this);
                    context.setInterceptorInstances(this.interceptorManager.createInterceptorInstances());
                    inv = this.invFactory.create(ejb, context);
                    inv.isMessageDriven = true;
                    this.invocationManager.preInvoke((ComponentInvocation)inv);
                    if (ejb instanceof MessageDrivenBean) {
                        ((MessageDrivenBean)ejb).setMessageDrivenContext(context);
                    }
                    this.injectionManager.injectInstance(ejb, (JndiNameEnvironment)this.ejbDescriptor, false);
                    for (Object interceptorInstance : context.getInterceptorInstances()) {
                        this.injectionManager.injectInstance(interceptorInstance, (JndiNameEnvironment)this.ejbDescriptor, false);
                    }
                    context.setContextCalled();
                    this.interceptorManager.intercept(LifecycleCallbackDescriptor.CallbackType.POST_CONSTRUCT, context);
                    ++this.statCreateCount;
                    context.setState(EJBContextImpl.BeanState.POOLED);
                }
                catch (Throwable t) {
                    _logger.log(Level.SEVERE, "containers.mdb.ejb_creation_exception", new Object[]{this.appEJBName_, t.toString()});
                    if (t instanceof InvocationTargetException) {
                        _logger.log(Level.SEVERE, t.getClass().getName(), t.getCause());
                    }
                    _logger.log(Level.SEVERE, t.getClass().getName(), t);
                    CreateException ce = new CreateException("Could not create Message-Driven EJB");
                    ce.initCause(t);
                    throw ce;
                }
                Object var12_13 = null;
                if (originalClassLoader == null) break block9;
            }
            catch (Throwable throwable) {
                Object var12_14 = null;
                if (originalClassLoader != null) {
                    Utility.setContextClassLoader((ClassLoader)originalClassLoader);
                }
                if (inv == null) throw throwable;
                this.invocationManager.postInvoke(inv);
                throw throwable;
            }
            Utility.setContextClassLoader((ClassLoader)originalClassLoader);
        }
        if (inv == null) return context;
        this.invocationManager.postInvoke((ComponentInvocation)inv);
        return context;
    }

    private void registerMessageBeanResource(ResourceHandle resourceHandle) throws Exception {
        if (resourceHandle != null) {
            this.poolMgr.registerResource(resourceHandle);
        }
    }

    private void unregisterMessageBeanResource(ResourceHandle resourceHandle) {
        if (resourceHandle != null) {
            this.poolMgr.unregisterResource(resourceHandle, 0x4000000);
        }
    }

    void afterBegin(EJBContextImpl context) {
    }

    void beforeCompletion(EJBContextImpl context) {
    }

    void afterCompletion(EJBContextImpl ctx, int status) {
    }

    public boolean passivateEJB(ComponentContext context) {
        return false;
    }

    public void activateEJB(Object ctx, Object instanceKey) {
    }

    public void startApplication() {
        super.startApplication();
        try {
            this.messageBeanClient_.start();
        }
        catch (Exception e) {
            _logger.log(Level.FINE, e.getClass().getName(), e);
            throw new RuntimeException("MessageBeanContainer.start failure for app " + this.appEJBName_, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cleanupResources() {
        block13: {
            ASyncClientShutdownTask task = new ASyncClientShutdownTask(this.appEJBName_, this.messageBeanClient_, this.loader, this.messageBeanPool_);
            int timeout = 0;
            try {
                boolean addedAsyncTask = false;
                if (timeout > 0) {
                    try {
                        this.ejbContainerUtilImpl.addWork(task);
                        addedAsyncTask = true;
                    }
                    catch (Throwable th) {
                        addedAsyncTask = false;
                        _logger.log(Level.WARNING, "[MDBContainer] Got exception while trying to add task to ContainerWorkPool. Will execute cleanupResources on current thread", th);
                    }
                }
                if (addedAsyncTask) {
                    ASyncClientShutdownTask aSyncClientShutdownTask = task;
                    synchronized (aSyncClientShutdownTask) {
                        if (!task.isDone()) {
                            _logger.log(Level.FINE, "[MDBContainer] Going to wait for a maximum of " + timeout + " seconds.");
                            task.wait(timeout * 1000);
                        }
                        if (!task.isDone()) {
                            _logger.log(Level.WARNING, "[MDBContainer] ASync task has not finished. Giving up after " + timeout + " seconds.");
                        } else {
                            _logger.log(Level.FINE, "[MDBContainer] ASync task has completed");
                        }
                        break block13;
                    }
                }
                _logger.log(Level.FINE, "[MDBContainer] Attempting to do cleanup()in current thread...");
                task.run();
                _logger.log(Level.WARNING, "[MDBContainer] Current thread done cleanup()... ");
            }
            catch (InterruptedException inEx) {
                _logger.log(Level.SEVERE, "containers.mdb.cleanup_exception", new Object[]{this.appEJBName_, inEx.toString()});
            }
            catch (Exception ex) {
                _logger.log(Level.SEVERE, "containers.mdb.cleanup_exception", new Object[]{this.appEJBName_, ex.toString()});
            }
        }
    }

    protected void doConcreteContainerShutdown(boolean appBeingUndeployed) {
        _logger.log(Level.FINE, "containers.mdb.shutdown_cleanup_start", this.appEJBName_);
        this.monitorOn = false;
        this.cleanupResources();
        _logger.log(Level.FINE, "containers.mdb.shutdown_cleanup_end", this.appEJBName_);
    }

    public void beforeMessageDelivery(Method method, MessageDeliveryType deliveryType, boolean txImported, ResourceHandle resourceHandle) {
        if (this.containerState != 0) {
            String errorMsg = localStrings.getLocalString("containers.mdb.invocation_closed", this.appEJBName_ + ": Message-driven bean invocation closed by container", new Object[]{this.appEJBName_});
            throw new EJBException(errorMsg);
        }
        EjbInvocation invocation = this.invFactory.create();
        try {
            MessageBeanContextImpl context = (MessageBeanContextImpl)this.getContext(invocation);
            if (deliveryType == MessageDeliveryType.Timer) {
                invocation.isTimerCallback = true;
            }
            invocation.originalContextClassLoader = Utility.setContextClassLoader((ClassLoader)this.getClassLoader());
            invocation.isMessageDriven = true;
            invocation.method = method;
            context.setState(EJBContextImpl.BeanState.INVOKING);
            invocation.context = context;
            invocation.instance = context.getEJB();
            invocation.ejb = context.getEJB();
            invocation.container = this;
            boolean startTx = false;
            if (!txImported) {
                startTx = this.containerStartsTx(method);
            }
            invocation.containerStartsTx = startTx;
            this.invocationManager.preInvoke((ComponentInvocation)invocation);
            if (startTx) {
                this.registerMessageBeanResource(resourceHandle);
            }
            this.preInvokeTx(invocation);
        }
        catch (Throwable c) {
            if (this.containerState != 0) {
                _logger.log(Level.SEVERE, "containers.mdb.preinvoke_exception", new Object[]{this.appEJBName_, c.toString()});
                _logger.log(Level.SEVERE, c.getClass().getName(), c);
            }
            invocation.exception = c;
        }
    }

    public Object deliverMessage(Object[] params) throws Throwable {
        Object result;
        block16: {
            EjbInvocation invocation = null;
            boolean methodCalled = false;
            result = null;
            invocation = (EjbInvocation)this.invocationManager.getCurrentInvocation();
            if (invocation == null && _logger.isLoggable(Level.FINEST)) {
                if (this.containerState != 0) {
                    _logger.log(Level.FINEST, "No invocation in onMessage  (container closing)");
                } else {
                    _logger.log(Level.FINEST, "No invocation in onMessage : ");
                }
            }
            if (invocation != null && invocation.exception == null) {
                try {
                    block15: {
                        try {
                            methodCalled = true;
                            if (this.ejbMethodStatsManager.isMethodMonitorOn()) {
                                this.ejbMethodStatsManager.preInvoke(invocation.method);
                            }
                            invocation.methodParams = params;
                            if (this.isTimedObject() && invocation.method.equals(this.ejbTimeoutMethod)) {
                                invocation.beanMethod = invocation.method;
                                this.invokeTargetBeanMethod(this.ejbTimeoutMethod, invocation, invocation.ejb, invocation.methodParams, null);
                                break block15;
                            }
                            invocation.beanMethod = invocation.ejb.getClass().getMethod(invocation.method.getName(), invocation.method.getParameterTypes());
                            result = super.intercept(invocation);
                        }
                        catch (InvocationTargetException ite) {
                            Throwable cause;
                            invocation.exception = cause = ite.getCause();
                            if (this.isSystemUncheckedException(cause)) {
                                EJBException ejbEx = new EJBException("message-driven bean method " + invocation.method + " system exception");
                                ejbEx.initCause(cause);
                                cause = ejbEx;
                            }
                            throw cause;
                        }
                        catch (Throwable t) {
                            EJBException ejbEx = new EJBException("message-bean container dispatch error");
                            ejbEx.initCause(t);
                            invocation.exception = ejbEx;
                            throw ejbEx;
                        }
                    }
                    Object var9_5 = null;
                    if (methodCalled && this.ejbMethodStatsManager.isMethodMonitorOn()) {
                        this.ejbMethodStatsManager.postInvoke(invocation.method, invocation.exception);
                    }
                    break block16;
                }
                catch (Throwable throwable) {
                    Object var9_6 = null;
                    if (methodCalled && this.ejbMethodStatsManager.isMethodMonitorOn()) {
                        this.ejbMethodStatsManager.postInvoke(invocation.method, invocation.exception);
                    }
                    throw throwable;
                }
            }
            if (invocation == null) {
                String errorMsg = localStrings.getLocalString("containers.mdb.invocation_closed", this.appEJBName_ + ": Message-driven bean invocation " + "closed by container", new Object[]{this.appEJBName_});
                throw new EJBException(errorMsg);
            }
            _logger.log(Level.SEVERE, "containers.mdb.invocation_exception", new Object[]{this.appEJBName_, invocation.exception.toString()});
            _logger.log(Level.SEVERE, invocation.exception.getClass().getName(), invocation.exception);
            EJBException ejbEx = new EJBException();
            ejbEx.initCause(invocation.exception);
            throw ejbEx;
        }
        return result;
    }

    public void afterMessageDelivery(ResourceHandle resourceHandle) {
        this.afterMessageDeliveryInternal(resourceHandle);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean afterMessageDeliveryInternal(ResourceHandle resourceHandle) {
        boolean success = false;
        EjbInvocation invocation = null;
        invocation = (EjbInvocation)this.invocationManager.getCurrentInvocation();
        if (invocation == null) {
            _logger.log(Level.SEVERE, "containers.mdb.no_invocation", new Object[]{this.appEJBName_, ""});
        } else {
            MessageBeanContextImpl beanContext = (MessageBeanContextImpl)invocation.context;
            try {
                try {
                    if (invocation.containerStartsTx) {
                        this.unregisterMessageBeanResource(resourceHandle);
                    }
                    this.invocationManager.postInvoke((ComponentInvocation)invocation);
                    this.postInvokeTx(invocation);
                    success = true;
                    ++this.statMessageCount;
                }
                catch (Throwable ce) {
                    _logger.log(Level.SEVERE, "containers.mdb.postinvoke_exception", new Object[]{this.appEJBName_, ce.toString()});
                    _logger.log(Level.SEVERE, ce.getClass().getName(), ce);
                    Object var7_6 = null;
                    this.releaseContext(invocation);
                }
                Object var7_5 = null;
                this.releaseContext(invocation);
            }
            catch (Throwable throwable) {
                Object var7_7 = null;
                this.releaseContext(invocation);
                throw throwable;
            }
            Utility.setContextClassLoader((ClassLoader)invocation.originalContextClassLoader);
            if (invocation.exception != null) {
                if (this.isSystemUncheckedException(invocation.exception)) {
                    success = false;
                }
                Level exLogLevel = this.isSystemUncheckedException(invocation.exception) ? Level.WARNING : Level.FINE;
                _logger.log(exLogLevel, "containers.mdb.invocation_exception", new Object[]{this.appEJBName_, invocation.exception.toString()});
                _logger.log(exLogLevel, invocation.exception.getClass().getName(), invocation.exception);
            }
        }
        return success;
    }

    public long getCreateCount() {
        return this.statCreateCount;
    }

    public long getRemoveCount() {
        return this.statRemoveCount;
    }

    public long getMessageCount() {
        return this.statMessageCount;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum MessageDeliveryType {
        Message,
        Timer;

    }

    private static class ASyncClientShutdownTask
    implements Runnable {
        private boolean done = false;
        String appName;
        MessageBeanClient mdbClient;
        ClassLoader clsLoader;
        AbstractPool mdbPool;

        ASyncClientShutdownTask(String appName, MessageBeanClient mdbClient, ClassLoader loader, AbstractPool mdbPool) {
            this.appName = appName;
            this.mdbClient = mdbClient;
            this.clsLoader = loader;
            this.mdbPool = mdbPool;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         */
        public void run() {
            block16: {
                ClassLoader previousClassLoader = null;
                previousClassLoader = Utility.setContextClassLoader((ClassLoader)this.clsLoader);
                this.mdbClient.close();
                ASyncClientShutdownTask aSyncClientShutdownTask = this;
                synchronized (aSyncClientShutdownTask) {
                    this.done = true;
                    this.notify();
                    _logger.log(Level.FINE, "[MDBContainer] ASync thread done with mdbClient.close()");
                }
                Object var5_5 = null;
                try {
                    this.mdbPool.close();
                }
                catch (Exception ex) {
                    _logger.log(Level.FINE, "Exception while closing pool", ex);
                }
                if (previousClassLoader != null) {
                    Utility.setContextClassLoader((ClassLoader)previousClassLoader);
                }
                break block16;
                {
                    catch (Exception e) {
                        _logger.log(Level.SEVERE, "containers.mdb.cleanup_exception", new Object[]{this.appName, e.toString()});
                        _logger.log(Level.SEVERE, e.getClass().getName(), e);
                        Object var5_6 = null;
                        try {
                            this.mdbPool.close();
                        }
                        catch (Exception ex) {
                            _logger.log(Level.FINE, "Exception while closing pool", ex);
                        }
                        if (previousClassLoader != null) {
                            Utility.setContextClassLoader((ClassLoader)previousClassLoader);
                        }
                    }
                }
                catch (Throwable throwable) {
                    Object var5_7 = null;
                    try {
                        this.mdbPool.close();
                    }
                    catch (Exception ex) {
                        _logger.log(Level.FINE, "Exception while closing pool", ex);
                    }
                    if (previousClassLoader != null) {
                        Utility.setContextClassLoader((ClassLoader)previousClassLoader);
                    }
                    throw throwable;
                }
            }
        }

        public synchronized boolean isDone() {
            return this.done;
        }
    }

    private class MessageBeanContextFactory
    implements ObjectFactory {
        private MessageBeanContextFactory() {
        }

        public Object create(Object param) {
            try {
                return MessageBeanContainer.this.createMessageDrivenEJB();
            }
            catch (CreateException ex) {
                throw new EJBException(ex);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void destroy(Object obj) {
            MessageBeanContextImpl beanContext = (MessageBeanContextImpl)obj;
            Object ejb = beanContext.getEJB();
            if (beanContext.getState() != EJBContextImpl.BeanState.DESTROYED) {
                block8: {
                    EjbInvocation inv = null;
                    try {
                        try {
                            inv = MessageBeanContainer.this.invFactory.create(ejb, beanContext);
                            inv.isMessageDriven = true;
                            MessageBeanContainer.this.invocationManager.preInvoke((ComponentInvocation)inv);
                            beanContext.setInEjbRemove(true);
                            MessageBeanContainer.this.interceptorManager.intercept(LifecycleCallbackDescriptor.CallbackType.PRE_DESTROY, beanContext);
                            ++MessageBeanContainer.this.statRemoveCount;
                        }
                        catch (Throwable t) {
                            _logger.log(Level.SEVERE, "containers.mdb_preinvoke_exception_indestroy", new Object[]{MessageBeanContainer.this.appEJBName_, t.toString()});
                            _logger.log(Level.SEVERE, t.getClass().getName(), t);
                            Object var7_6 = null;
                            beanContext.setInEjbRemove(false);
                            if (inv != null) {
                                MessageBeanContainer.this.invocationManager.postInvoke((ComponentInvocation)inv);
                            }
                            break block8;
                        }
                        Object var7_5 = null;
                    }
                    catch (Throwable throwable) {
                        Object var7_7 = null;
                        beanContext.setInEjbRemove(false);
                        if (inv != null) {
                            MessageBeanContainer.this.invocationManager.postInvoke((ComponentInvocation)inv);
                        }
                        throw throwable;
                    }
                    beanContext.setInEjbRemove(false);
                    if (inv != null) {
                        MessageBeanContainer.this.invocationManager.postInvoke((ComponentInvocation)inv);
                    }
                }
                beanContext.setState(EJBContextImpl.BeanState.DESTROYED);
            }
            MessageBeanContainer.this.transactionManager.componentDestroyed((ResourceHandler)beanContext);
            beanContext.setTransaction(null);
        }
    }
}

