/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.platform.database.oracle;

import java.io.IOException;
import java.io.Writer;
import java.lang.reflect.Constructor;
import java.security.AccessController;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Hashtable;
import java.util.Vector;
import oracle.jdbc.OraclePreparedStatement;
import oracle.jdbc.internal.OracleConnection;
import oracle.sql.OPAQUE;
import oracle.sql.TIMESTAMP;
import oracle.sql.TIMESTAMPLTZ;
import oracle.sql.TIMESTAMPTZ;
import org.eclipse.persistence.exceptions.ConversionException;
import org.eclipse.persistence.exceptions.DatabaseException;
import org.eclipse.persistence.exceptions.QueryException;
import org.eclipse.persistence.expressions.ExpressionOperator;
import org.eclipse.persistence.internal.databaseaccess.Accessor;
import org.eclipse.persistence.internal.databaseaccess.BindCallCustomParameter;
import org.eclipse.persistence.internal.databaseaccess.ConnectionCustomizer;
import org.eclipse.persistence.internal.databaseaccess.DatabaseCall;
import org.eclipse.persistence.internal.databaseaccess.DatabasePlatform;
import org.eclipse.persistence.internal.databaseaccess.FieldTypeDefinition;
import org.eclipse.persistence.internal.expressions.SpatialExpressionOperators;
import org.eclipse.persistence.internal.helper.ClassConstants;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.internal.platform.database.XMLTypePlaceholder;
import org.eclipse.persistence.internal.platform.database.oracle.TIMESTAMPHelper;
import org.eclipse.persistence.internal.platform.database.oracle.TIMESTAMPLTZWrapper;
import org.eclipse.persistence.internal.platform.database.oracle.TIMESTAMPTZWrapper;
import org.eclipse.persistence.internal.platform.database.oracle.TIMESTAMPTypes;
import org.eclipse.persistence.internal.platform.database.oracle.XMLTypeFactory;
import org.eclipse.persistence.internal.security.PrivilegedAccessHelper;
import org.eclipse.persistence.internal.security.PrivilegedClassForName;
import org.eclipse.persistence.internal.security.PrivilegedGetConstructorFor;
import org.eclipse.persistence.internal.security.PrivilegedInvokeConstructor;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.platform.database.oracle.NCharacter;
import org.eclipse.persistence.platform.database.oracle.NClob;
import org.eclipse.persistence.platform.database.oracle.NString;
import org.eclipse.persistence.platform.database.oracle.Oracle8Platform;
import org.eclipse.persistence.platform.database.oracle.OracleJDBC_10_1_0_2ProxyConnectionCustomizer;
import org.eclipse.persistence.queries.Call;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.ValueReadQuery;
import org.eclipse.persistence.sessions.Session;
import org.w3c.dom.Document;

public class Oracle9Platform
extends Oracle8Platform {
    public static final Class NCHAR = NCharacter.class;
    public static final Class NSTRING = NString.class;
    public static final Class NCLOB = NClob.class;
    public static final Class XMLTYPE = XMLTypePlaceholder.class;
    protected transient String driverVersion;
    protected transient boolean shouldPrintCalendar;
    protected transient boolean isTimestampInGmt;
    protected transient boolean isConnectionDataInitialized;
    private XMLTypeFactory xmlTypeFactory;

    public Object getObjectFromResultSet(ResultSet resultSet, int n, int n2, AbstractSession abstractSession) throws SQLException {
        if (n2 == 93 || n2 == 91) {
            return resultSet.getTimestamp(n);
        }
        if (n2 == -101) {
            TIMESTAMPTZ tIMESTAMPTZ = (TIMESTAMPTZ)resultSet.getObject(n);
            if (tIMESTAMPTZ != null && tIMESTAMPTZ.getLength() != 0L) {
                Connection connection = this.getConnection(abstractSession, resultSet.getStatement().getConnection());
                return new TIMESTAMPTZWrapper(tIMESTAMPTZ, connection, this.isTimestampInGmt(connection));
            }
            return null;
        }
        if (n2 == -102) {
            TIMESTAMPLTZ tIMESTAMPLTZ = (TIMESTAMPLTZ)resultSet.getObject(n);
            if (tIMESTAMPLTZ != null && tIMESTAMPLTZ.getLength() != 0L) {
                Timestamp timestamp = TIMESTAMPLTZ.toTimestamp((Connection)this.getConnection(abstractSession, resultSet.getStatement().getConnection()), (byte[])tIMESTAMPLTZ.toBytes());
                return new TIMESTAMPLTZWrapper(timestamp, ((oracle.jdbc.OracleConnection)this.getConnection(abstractSession, resultSet.getStatement().getConnection())).getSessionTimeZone());
            }
            return null;
        }
        if (n2 == 2007) {
            try {
                Object object = resultSet.getObject(n);
                if (!(object instanceof OPAQUE)) {
                    return object;
                }
                return this.getXMLTypeFactory().getString((OPAQUE)object);
            }
            catch (SQLException sQLException) {
                throw DatabaseException.sqlException((SQLException)sQLException, null, (AbstractSession)abstractSession, (boolean)false);
            }
        }
        return super.getObjectFromResultSet(resultSet, n, n2, abstractSession);
    }

    public boolean shouldUseCustomModifyForCall(DatabaseField databaseField) {
        Class clazz = databaseField.getType();
        if (clazz != null && this.isOracle9Specific(clazz)) {
            return true;
        }
        return super.shouldUseCustomModifyForCall(databaseField);
    }

    protected void initializePlatformOperators() {
        super.initializePlatformOperators();
        this.addOperator(ExpressionOperator.extract());
        this.addOperator(ExpressionOperator.extractValue());
        this.addOperator(ExpressionOperator.existsNode());
        this.addOperator(ExpressionOperator.isFragment());
        this.addOperator(ExpressionOperator.getStringVal());
        this.addOperator(ExpressionOperator.getNumberVal());
        this.addOperator(SpatialExpressionOperators.withinDistance());
        this.addOperator(SpatialExpressionOperators.relate());
        this.addOperator(SpatialExpressionOperators.filter());
        this.addOperator(SpatialExpressionOperators.nearestNeighbor());
    }

    protected Hashtable buildFieldTypes() {
        Hashtable hashtable = super.buildFieldTypes();
        hashtable.put(Document.class, new FieldTypeDefinition("sys.XMLType"));
        hashtable.put(Time.class, new FieldTypeDefinition("TIMESTAMP", false));
        hashtable.put(Timestamp.class, new FieldTypeDefinition("TIMESTAMP", false));
        hashtable.put(TIMESTAMP.class, new FieldTypeDefinition("TIMESTAMP", false));
        hashtable.put(TIMESTAMPTZ.class, new FieldTypeDefinition("TIMESTAMP WITH TIME ZONE", false));
        hashtable.put(TIMESTAMPLTZ.class, new FieldTypeDefinition("TIMESTAMP WITH LOCAL TIME ZONE", false));
        return hashtable;
    }

    protected Hashtable buildClassTypes() {
        Hashtable hashtable = super.buildClassTypes();
        hashtable.put("TIMESTAMP", TIMESTAMP.class);
        hashtable.put("TIMESTAMP WITH TIME ZONE", TIMESTAMPTZ.class);
        hashtable.put("TIMESTAMP WITH LOCAL TIME ZONE", TIMESTAMPLTZ.class);
        return hashtable;
    }

    public Object clone() {
        Oracle9Platform oracle9Platform = (Oracle9Platform)((Object)super.clone());
        oracle9Platform.clearConnectionData();
        return oracle9Platform;
    }

    public Object convertObject(Object object, Class clazz) throws ConversionException, DatabaseException {
        if (clazz == null || object != null && object.getClass() == clazz) {
            return object;
        }
        Object object2 = object;
        if (clazz == TIMESTAMPTypes.TIMESTAMP_CLASS || clazz == TIMESTAMPTypes.TIMESTAMPLTZ_CLASS) {
            return object;
        }
        if (clazz == TIMESTAMPTypes.TIMESTAMPTZ_CLASS) {
            if (object instanceof java.util.Date) {
                Calendar calendar = Calendar.getInstance();
                calendar.setTimeInMillis(((java.util.Date)object).getTime());
                return calendar;
            }
            return object;
        }
        if (clazz == XMLTYPE) {
            return object;
        }
        if (object instanceof TIMESTAMP) {
            try {
                object2 = ((TIMESTAMP)object).timestampValue();
            }
            catch (SQLException sQLException) {
                throw DatabaseException.sqlException((SQLException)sQLException);
            }
        } else if (object instanceof TIMESTAMPTZWrapper) {
            if (clazz == ClassConstants.CALENDAR || clazz == ClassConstants.GREGORIAN_CALENDAR) {
                try {
                    return TIMESTAMPHelper.buildCalendar((TIMESTAMPTZWrapper)object);
                }
                catch (SQLException sQLException) {
                    throw DatabaseException.sqlException((SQLException)sQLException);
                }
            }
            object2 = ((TIMESTAMPTZWrapper)object).getTimestamp();
        } else if (object instanceof TIMESTAMPLTZWrapper) {
            if (clazz == ClassConstants.CALENDAR || clazz == ClassConstants.GREGORIAN_CALENDAR) {
                try {
                    return TIMESTAMPHelper.buildCalendar((TIMESTAMPLTZWrapper)object);
                }
                catch (SQLException sQLException) {
                    throw DatabaseException.sqlException((SQLException)sQLException);
                }
            }
            object2 = ((TIMESTAMPLTZWrapper)object).getTimestamp();
        }
        return super.convertObject(object2, clazz);
    }

    protected void appendTimestamp(Timestamp timestamp, Writer writer) throws IOException {
        if (this.usesNativeSQL()) {
            writer.write("to_timestamp('");
            writer.write(Helper.printTimestamp((Timestamp)timestamp));
            writer.write("','yyyy-mm-dd HH24:MI:SS.FF')");
        } else {
            super.appendTimestamp(timestamp, writer);
        }
    }

    protected void appendCalendar(Calendar calendar, Writer writer) throws IOException {
        if (this.usesNativeSQL()) {
            writer.write("to_timestamp_tz('");
            writer.write(TIMESTAMPHelper.printCalendar(calendar));
            if (TIMESTAMPHelper.shouldAppendDaylightTime(calendar)) {
                writer.write("','yyyy-mm-dd HH24:MI:SS.FF TZR TZD')");
            } else {
                writer.write("','yyyy-mm-dd HH24:MI:SS.FF TZR')");
            }
        } else {
            super.appendCalendar(calendar, writer);
        }
    }

    public Connection getConnection(AbstractSession abstractSession, Connection connection) {
        if (abstractSession.getServerPlatform() != null && abstractSession.getLogin().shouldUseExternalConnectionPooling()) {
            return abstractSession.getServerPlatform().unwrapConnection(connection);
        }
        return connection;
    }

    protected synchronized void initializeConnectionData(Connection connection) throws SQLException {
        if (this.isConnectionDataInitialized) {
            return;
        }
        this.driverVersion = connection.getMetaData().getDriverVersion();
        boolean bl = this.shouldPrintCalendar = this.driverVersion.startsWith("9.") || this.driverVersion.startsWith("10.");
        if (Helper.compareVersions((String)this.driverVersion, (String)"11.1.0.7") < 0) {
            this.isTimestampInGmt = false;
        } else if (connection instanceof oracle.jdbc.OracleConnection) {
            String string = ((oracle.jdbc.OracleConnection)connection).getProperties().getProperty("oracle.jdbc.timestampTzInGmt", "true");
            this.isTimestampInGmt = string.equalsIgnoreCase("true");
        } else {
            this.isTimestampInGmt = true;
        }
        this.isConnectionDataInitialized = true;
    }

    public synchronized void clearConnectionData() {
        this.driverVersion = null;
        this.isConnectionDataInitialized = false;
    }

    public String getDriverVersion(Connection connection) throws SQLException {
        if (!this.isConnectionDataInitialized) {
            this.initializeConnectionData(connection);
        }
        return this.driverVersion;
    }

    public boolean shouldPrintCalendar(Connection connection) throws SQLException {
        if (!this.isConnectionDataInitialized) {
            this.initializeConnectionData(connection);
        }
        return this.shouldPrintCalendar;
    }

    public boolean isTimestampInGmt(Connection connection) throws SQLException {
        if (!this.isConnectionDataInitialized) {
            this.initializeConnectionData(connection);
        }
        return this.isTimestampInGmt;
    }

    public void setParameterValueInDatabaseCall(Object object, PreparedStatement preparedStatement, int n, AbstractSession abstractSession) throws SQLException {
        if (object instanceof Calendar) {
            Calendar calendar = (Calendar)object;
            Connection connection = this.getConnection(abstractSession, preparedStatement.getConnection());
            TIMESTAMPTZ tIMESTAMPTZ = TIMESTAMPHelper.buildTIMESTAMPTZ(calendar, connection, this.shouldPrintCalendar(connection));
            preparedStatement.setObject(n, tIMESTAMPTZ);
        } else {
            super.setParameterValueInDatabaseCall(object, preparedStatement, n, abstractSession);
        }
    }

    public Timestamp getTimestampFromServer(AbstractSession abstractSession, String string) {
        if (this.getTimestampQuery() != null) {
            this.getTimestampQuery().setSessionName(string);
            Object object = abstractSession.executeQuery((DatabaseQuery)this.getTimestampQuery());
            return ((TIMESTAMPTZWrapper)object).getTimestamp();
        }
        return super.getTimestampFromServer(abstractSession, string);
    }

    public ValueReadQuery getTimestampQuery() {
        if (this.timestampQuery == null) {
            this.timestampQuery = new ValueReadQuery();
            this.timestampQuery.setSQLString("SELECT SYSTIMESTAMP FROM DUAL");
        }
        return this.timestampQuery;
    }

    public String serverTimestampString() {
        return "SYSTIMESTAMP";
    }

    protected Vector buildToTIMESTAMPVec() {
        Vector<Class<Time>> vector = new Vector<Class<Time>>();
        vector.addElement(java.util.Date.class);
        vector.addElement(Timestamp.class);
        vector.addElement(Calendar.class);
        vector.addElement(String.class);
        vector.addElement(Long.class);
        vector.addElement(Date.class);
        vector.addElement(Time.class);
        return vector;
    }

    protected Vector buildToNStringCharVec() {
        Vector<Class> vector = new Vector<Class>();
        vector.addElement(String.class);
        vector.addElement(Character.class);
        return vector;
    }

    protected Vector buildToNClobVec() {
        Vector<Class<char[]>> vector = new Vector<Class<char[]>>();
        vector.addElement(String.class);
        vector.addElement(Character[].class);
        vector.addElement(char[].class);
        return vector;
    }

    public void setShouldUseLocatorForLOBWrite(boolean bl) {
        this.usesLocatorForLOBWrite = bl;
    }

    public boolean shouldUseLocatorForLOBWrite() {
        return this.usesLocatorForLOBWrite;
    }

    public int getLobValueLimits() {
        return this.lobValueLimits;
    }

    public void setLobValueLimits(int n) {
        this.lobValueLimits = n;
    }

    protected boolean isOracle9Specific(Class clazz) {
        return clazz == NCHAR || clazz == NSTRING || clazz == NCLOB || clazz == XMLTYPE;
    }

    protected boolean isClob(Class clazz) {
        return NCLOB.equals(clazz) || super.isClob(clazz);
    }

    public Object getCustomModifyValueForCall(Call call, Object object, DatabaseField databaseField, boolean bl) {
        Class clazz = databaseField.getType();
        if (clazz != null && this.isOracle9Specific(clazz)) {
            if (object == null) {
                return null;
            }
            if (NCHAR.equals(clazz) || NSTRING.equals(clazz)) {
                return new NTypeBindCallCustomParameter(object);
            }
            if (NCLOB.equals(clazz)) {
                object = this.convertToDatabaseType(object);
                if (this.shouldUseLocatorForLOBWrite() && this.lobValueExceedsLimit(object)) {
                    ((DatabaseCall)call).addContext(databaseField, object);
                    object = new String(" ");
                }
                return new NTypeBindCallCustomParameter(object);
            }
            if (XMLTYPE.equals(clazz)) {
                return this.getXMLTypeFactory().createXMLTypeBindCallCustomParameter(object);
            }
        }
        return super.getCustomModifyValueForCall(call, object, databaseField, bl);
    }

    protected Vector buildFromStringCharVec(Class clazz) {
        Vector vector = this.getConversionManager().getDataTypesConvertedFrom(clazz);
        vector.addElement(NCHAR);
        vector.addElement(NSTRING);
        if (clazz == String.class) {
            vector.addElement(NCLOB);
        }
        return vector;
    }

    public Vector getDataTypesConvertedFrom(Class clazz) {
        Vector vector;
        if (this.dataTypesConvertedFromAClass == null) {
            this.dataTypesConvertedFromAClass = new Hashtable(5);
        }
        if ((vector = (Vector)this.dataTypesConvertedFromAClass.get(clazz)) != null) {
            return vector;
        }
        vector = super.getDataTypesConvertedFrom(clazz);
        if (clazz == String.class || clazz == Character.class) {
            vector.addElement(NCHAR);
            vector.addElement(NSTRING);
            if (clazz == String.class) {
                vector.addElement(NCLOB);
            }
        }
        if (clazz == char[].class || clazz == Character[].class) {
            vector.addElement(NCLOB);
        }
        this.dataTypesConvertedFromAClass.put(clazz, vector);
        return vector;
    }

    public Vector getDataTypesConvertedTo(Class clazz) {
        Vector vector;
        if (this.dataTypesConvertedToAClass == null) {
            this.dataTypesConvertedToAClass = new Hashtable(5);
        }
        if ((vector = (Vector)this.dataTypesConvertedToAClass.get(clazz)) != null) {
            return vector;
        }
        vector = clazz == NCHAR || clazz == NSTRING ? this.buildToNStringCharVec() : (clazz == NCLOB ? this.buildToNClobVec() : super.getDataTypesConvertedTo(clazz));
        this.dataTypesConvertedToAClass.put(clazz, vector);
        return vector;
    }

    public int getJDBCType(DatabaseField databaseField) {
        int n = super.getJDBCType(databaseField);
        if (n == 2007) {
            return 12;
        }
        return n;
    }

    public int getJDBCType(Class clazz) {
        if (clazz == XMLTYPE) {
            return 12;
        }
        return super.getJDBCType(clazz);
    }

    public int executeBatch(Statement statement, boolean bl) throws SQLException {
        if (this.usesNativeBatchWriting() && bl) {
            return ((OraclePreparedStatement)statement).sendBatch();
        }
        return super.executeBatch(statement, bl);
    }

    public int addBatch(PreparedStatement preparedStatement) throws SQLException {
        if (this.usesNativeBatchWriting()) {
            return preparedStatement.executeUpdate();
        }
        return super.addBatch(preparedStatement);
    }

    public Statement prepareBatchStatement(Statement statement) throws SQLException {
        if (this.usesNativeBatchWriting()) {
            ((OraclePreparedStatement)statement).setExecuteBatch(this.getMaxBatchWritingSize());
        }
        return statement;
    }

    protected XMLTypeFactory getXMLTypeFactory() {
        if (this.xmlTypeFactory == null) {
            String string = "org.eclipse.persistence.internal.platform.database.oracle.xdb.XMLTypeFactoryImpl";
            try {
                if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
                    Class clazz = (Class)AccessController.doPrivileged(new PrivilegedClassForName(string, true, ((Object)((Object)this)).getClass().getClassLoader()));
                    Constructor constructor = (Constructor)AccessController.doPrivileged(new PrivilegedGetConstructorFor(clazz, new Class[0], true));
                    this.xmlTypeFactory = (XMLTypeFactory)AccessController.doPrivileged(new PrivilegedInvokeConstructor(constructor, new Object[0]));
                } else {
                    Class clazz = PrivilegedAccessHelper.getClassForName((String)string, (boolean)true, (ClassLoader)((Object)((Object)this)).getClass().getClassLoader());
                    Constructor constructor = PrivilegedAccessHelper.getConstructorFor((Class)clazz, (Class[])new Class[0], (boolean)true);
                    this.xmlTypeFactory = (XMLTypeFactory)PrivilegedAccessHelper.invokeConstructor((Constructor)constructor, (Object[])new Object[0]);
                }
            }
            catch (Exception exception) {
                throw QueryException.reflectiveCallOnTopLinkClassFailed((String)string, (Exception)exception);
            }
        }
        return this.xmlTypeFactory;
    }

    public boolean isXDBDocument(Object object) {
        return this.getXMLTypeFactory().isXDBDocument(object);
    }

    public boolean canUnwrapOracleConnection() {
        return true;
    }

    public Connection unwrapOracleConnection(Connection connection) {
        if (connection instanceof OracleConnection) {
            return ((OracleConnection)connection).getPhysicalConnection();
        }
        return super.unwrapOracleConnection(connection);
    }

    public boolean isOracle9() {
        return true;
    }

    public ConnectionCustomizer createConnectionCustomizer(Accessor accessor, AbstractSession abstractSession) {
        Object object = abstractSession.getProperty("eclipselink.oracle.proxy-type");
        if (object == null || object instanceof String && ((String)object).length() == 0) {
            return null;
        }
        return new OracleJDBC_10_1_0_2ProxyConnectionCustomizer(accessor, (Session)abstractSession);
    }

    protected static class NTypeBindCallCustomParameter
    extends BindCallCustomParameter {
        public NTypeBindCallCustomParameter(Object object) {
            super(object);
        }

        public boolean shouldUseUnwrappedConnection() {
            return true;
        }

        public void set(DatabasePlatform databasePlatform, PreparedStatement preparedStatement, int n, AbstractSession abstractSession) throws SQLException {
            ((OraclePreparedStatement)preparedStatement).setFormOfUse(n, (short)2);
            super.set(databasePlatform, preparedStatement, n, abstractSession);
        }
    }
}

