/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment.annotation.handlers;

import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.deployment.MethodDescriptor;
import com.sun.enterprise.deployment.MethodPermission;
import com.sun.enterprise.deployment.WebComponentDescriptor;
import com.sun.enterprise.deployment.annotation.context.EjbContext;
import com.sun.enterprise.deployment.annotation.context.WebBundleContext;
import com.sun.enterprise.deployment.annotation.context.WebComponentContext;
import com.sun.enterprise.deployment.annotation.handlers.AbstractCommonAttributeHandler;
import com.sun.enterprise.deployment.annotation.handlers.PostProcessor;
import com.sun.enterprise.deployment.util.TypeUtil;
import com.sun.enterprise.deployment.web.SecurityConstraint;
import com.sun.enterprise.deployment.web.WebResourceCollection;
import java.lang.annotation.Annotation;
import java.lang.annotation.ElementType;
import java.lang.reflect.Method;
import javax.annotation.security.PermitAll;
import org.glassfish.apf.AnnotatedElementHandler;
import org.glassfish.apf.AnnotationInfo;
import org.glassfish.apf.AnnotationProcessorException;
import org.glassfish.apf.HandlerProcessingResult;
import org.jvnet.hk2.annotations.Service;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service
public class PermitAllHandler
extends AbstractCommonAttributeHandler
implements PostProcessor {
    public Class<? extends Annotation> getAnnotationType() {
        return PermitAll.class;
    }

    @Override
    protected HandlerProcessingResult processAnnotation(AnnotationInfo ainfo, EjbContext[] ejbContexts) throws AnnotationProcessorException {
        if (this.hasMoreThanOneAccessControlAnnotation(ainfo)) {
            return this.getDefaultFailedResult();
        }
        for (EjbContext ejbContext : ejbContexts) {
            EjbDescriptor ejbDesc = ejbContext.getDescriptor();
            if (ElementType.TYPE.equals((Object)ainfo.getElementType())) {
                ejbContext.addPostProcessInfo(ainfo, this);
                continue;
            }
            Method annMethod = (Method)ainfo.getAnnotatedElement();
            for (Object next : ejbDesc.getSecurityBusinessMethodDescriptors()) {
                MethodDescriptor md = (MethodDescriptor)next;
                Method m = md.getMethod(ejbDesc);
                if (!TypeUtil.sameMethodSignature(m, annMethod) || this.hasMethodPermissionsFromDD(md, ejbDesc)) continue;
                ejbDesc.addPermissionedMethod(MethodPermission.getUncheckedMethodPermission(), md);
            }
        }
        return this.getDefaultProcessedResult();
    }

    @Override
    protected HandlerProcessingResult processAnnotation(AnnotationInfo ainfo, WebComponentContext[] webCompContexts) throws AnnotationProcessorException {
        if (this.hasMoreThanOneAccessControlAnnotation(ainfo)) {
            return this.getDefaultFailedResult();
        }
        boolean ok = true;
        if (ElementType.TYPE.equals((Object)ainfo.getElementType())) {
            for (WebComponentContext webCompContext : webCompContexts) {
                WebComponentDescriptor webCompDesc = webCompContext.getDescriptor();
                SecurityConstraint secConstr = this.addHttpMethodConstraint(webCompDesc, null);
                webCompContext.setTypeSecurityConstraint(secConstr);
            }
        } else {
            Method annMethod = (Method)ainfo.getAnnotatedElement();
            if (this.isValidHttpServletAnnotatedMethod(annMethod)) {
                String httpMethod = annMethod.getName().substring(2).toUpperCase();
                for (WebComponentContext webCompContext : webCompContexts) {
                    WebComponentDescriptor webCompDesc = webCompContext.getDescriptor();
                    this.addHttpMethodConstraint(webCompDesc, httpMethod);
                    SecurityConstraint typeSecConstr = webCompContext.getTypeSecurityConstraint();
                    if (typeSecConstr == null) continue;
                    for (WebResourceCollection wrc : typeSecConstr.getWebResourceCollections()) {
                        wrc.addHttpMethodOmission(httpMethod);
                    }
                }
            } else {
                ok = false;
            }
        }
        return ok ? this.getDefaultProcessedResult() : this.getDefaultFailedResult();
    }

    @Override
    protected HandlerProcessingResult processAnnotation(AnnotationInfo ainfo, WebBundleContext webBundleContext) throws AnnotationProcessorException {
        return this.getInvalidAnnotatedElementHandlerResult((AnnotatedElementHandler)webBundleContext, ainfo);
    }

    @Override
    public Class<? extends Annotation>[] getTypeDependencies() {
        return this.getEjbAndWebAnnotationTypes();
    }

    @Override
    protected boolean supportTypeInheritance() {
        return true;
    }

    @Override
    public void postProcessAnnotation(AnnotationInfo ainfo, AnnotatedElementHandler aeHandler) throws AnnotationProcessorException {
        EjbContext ejbContext = (EjbContext)aeHandler;
        EjbDescriptor ejbDesc = ejbContext.getDescriptor();
        if (!(ejbContext.isInherited() || ejbDesc.getMethodPermissionsFromDD() != null && ejbDesc.getMethodPermissionsFromDD().size() != 0)) {
            for (MethodDescriptor md : this.getMethodAllDescriptors(ejbDesc)) {
                ejbDesc.addPermissionedMethod(MethodPermission.getUncheckedMethodPermission(), md);
            }
        } else {
            Class classAn = (Class)ainfo.getAnnotatedElement();
            for (Object next : ejbDesc.getSecurityBusinessMethodDescriptors()) {
                MethodDescriptor md = (MethodDescriptor)next;
                if (!classAn.equals(ejbContext.getDeclaringClass(md)) || this.hasMethodPermissionsFromDD(md, ejbDesc)) continue;
                ejbDesc.addPermissionedMethod(MethodPermission.getUncheckedMethodPermission(), md);
            }
        }
    }

    private SecurityConstraint addHttpMethodConstraint(WebComponentDescriptor webCompDesc, String httpMethod) {
        return this.getSecurityConstraint(webCompDesc, httpMethod);
    }
}

