/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment.archivist;

import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.WebBundleDescriptor;
import com.sun.enterprise.deployment.archivist.Archivist;
import com.sun.enterprise.deployment.archivist.WebFragmentArchivist;
import com.sun.enterprise.deployment.io.DeploymentDescriptorFile;
import com.sun.enterprise.deployment.io.WebDeploymentDescriptorFile;
import com.sun.enterprise.deployment.io.runtime.WebRuntimeDDFile;
import com.sun.enterprise.deployment.util.ApplicationValidator;
import com.sun.enterprise.deployment.util.ModuleContentValidator;
import com.sun.enterprise.deployment.util.XModuleType;
import com.sun.logging.LogDomains;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.Set;
import java.util.Vector;
import org.glassfish.api.admin.ServerEnvironment;
import org.glassfish.api.deployment.archive.Archive;
import org.glassfish.api.deployment.archive.ReadableArchive;
import org.glassfish.deployment.common.DeploymentUtils;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.PerLookup;
import org.xml.sax.SAXParseException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service
@Scoped(value=PerLookup.class)
public class WebArchivist
extends Archivist<WebBundleDescriptor> {
    private static final String DEFAULT_WEB_XML = "default-web.xml";
    @Inject
    ServerEnvironment env;
    DeploymentDescriptorFile standardDD = new WebDeploymentDescriptorFile();
    private WebBundleDescriptor defaultBundleDescriptor = null;
    private WebBundleDescriptor validatedDefaultBundleDescriptor = null;

    @Override
    public XModuleType getModuleType() {
        return XModuleType.WAR;
    }

    @Override
    public void setDescriptor(Application descriptor) {
        Set<WebBundleDescriptor> webBundles = descriptor.getWebBundleDescriptors();
        if (webBundles.size() > 0) {
            this.descriptor = webBundles.iterator().next();
            if (((WebBundleDescriptor)this.descriptor).getModuleDescriptor().isStandalone()) {
                return;
            }
            this.descriptor = null;
        }
    }

    @Override
    public String getWebServicesDeploymentDescriptorPath() {
        return "WEB-INF/webservices.xml";
    }

    @Override
    public DeploymentDescriptorFile getStandardDDFile() {
        return this.standardDD;
    }

    @Override
    public DeploymentDescriptorFile getConfigurationDDFile() {
        return new WebRuntimeDDFile();
    }

    @Override
    public synchronized WebBundleDescriptor getDefaultBundleDescriptor() {
        if (this.defaultBundleDescriptor == null) {
            this.defaultBundleDescriptor = this.getDefaultWebBundleDescriptor();
        }
        return this.defaultBundleDescriptor;
    }

    public synchronized WebBundleDescriptor getValidatedDefaultBundleDescriptor() {
        if (this.validatedDefaultBundleDescriptor == null) {
            this.validatedDefaultBundleDescriptor = this.getDefaultWebBundleDescriptor();
            ApplicationValidator validator = new ApplicationValidator();
            validator.accept(this.validatedDefaultBundleDescriptor);
        }
        return this.validatedDefaultBundleDescriptor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private WebBundleDescriptor getDefaultWebBundleDescriptor() {
        WebBundleDescriptor defaultWebBundleDesc = new WebBundleDescriptor();
        InputStream fis = null;
        try {
            URL defaultWebXml = this.getDefaultWebXML();
            if (defaultWebXml != null) {
                fis = defaultWebXml.openStream();
                WebDeploymentDescriptorFile wddf = new WebDeploymentDescriptorFile();
                wddf.setXMLValidation(false);
                defaultWebBundleDesc.addWebBundleDescriptor((WebBundleDescriptor)wddf.read(fis));
            }
        }
        catch (Exception e) {
            LogDomains.getLogger(WebArchivist.class, (String)"javax.enterprise.system.container.web").warning("Error in parsing default-web.xml");
        }
        finally {
            try {
                if (fis != null) {
                    fis.close();
                }
            }
            catch (IOException iOException) {}
        }
        return defaultWebBundleDesc;
    }

    protected URL getDefaultWebXML() throws IOException {
        File file = new File(this.env.getConfigDirPath(), DEFAULT_WEB_XML);
        if (file.exists()) {
            return file.toURI().toURL();
        }
        return null;
    }

    @Override
    protected void postOpen(WebBundleDescriptor descriptor, ReadableArchive archive) throws IOException {
        super.postOpen(descriptor, archive);
        WebBundleDescriptor webBundle = descriptor;
        ModuleContentValidator mdv = new ModuleContentValidator(archive);
        webBundle.visit(mdv);
    }

    @Override
    public void validate(ClassLoader aClassLoader) {
        ClassLoader cl = aClassLoader;
        if (cl == null) {
            cl = this.classLoader;
        }
        if (cl == null) {
            return;
        }
        ((WebBundleDescriptor)this.descriptor).setClassLoader(cl);
        ((WebBundleDescriptor)this.descriptor).visit(new ApplicationValidator());
    }

    @Override
    protected boolean postHandles(ReadableArchive abstractArchive) throws IOException {
        return DeploymentUtils.isWebArchive((ReadableArchive)abstractArchive);
    }

    @Override
    protected String getArchiveExtension() {
        return ".war";
    }

    @Override
    public Vector getLibraries(Archive archive) {
        Enumeration entries = archive.entries();
        if (entries == null) {
            return null;
        }
        Vector<String> libs = new Vector<String>();
        while (entries.hasMoreElements()) {
            String entryName = (String)entries.nextElement();
            if (!entryName.startsWith("WEB-INF/lib") || !entryName.endsWith(".jar")) continue;
            libs.add(entryName);
        }
        return libs;
    }

    @Override
    protected void postStandardDDsRead(WebBundleDescriptor descriptor, ReadableArchive archive) throws IOException {
        this.readStandardFragment(descriptor, archive);
        super.postStandardDDsRead(descriptor, archive);
        if (this.getDefaultBundleDescriptor() != null) {
            descriptor.addWebBundleDescriptor(this.defaultBundleDescriptor, true);
        }
    }

    protected void readStandardFragment(WebBundleDescriptor descriptor, ReadableArchive archive) throws IOException {
        Vector libs = this.getLibraries((Archive)archive);
        if (libs != null && libs.size() > 0) {
            WebBundleDescriptor mergedWebFragment = null;
            for (int i = 0; i < libs.size(); ++i) {
                String lib = (String)libs.get(i);
                WebFragmentArchivist wfArchivist = new WebFragmentArchivist();
                wfArchivist.initializeContext(this);
                wfArchivist.setRuntimeXMLValidation(this.getRuntimeXMLValidation());
                wfArchivist.setRuntimeXMLValidationLevel(this.getRuntimeXMLValidationLevel());
                wfArchivist.setAnnotationProcessingRequested(false);
                ReadableArchive embeddedArchive = archive.getSubArchive(lib);
                if (!wfArchivist.hasStandardDeploymentDescriptor(embeddedArchive)) continue;
                WebBundleDescriptor wdesc = null;
                try {
                    wdesc = (WebBundleDescriptor)wfArchivist.open(embeddedArchive);
                }
                catch (SAXParseException ex) {
                    IOException ioex = new IOException();
                    ioex.initCause(ex);
                    throw ioex;
                }
                if (wdesc.isFullFlag()) {
                    descriptor.addMetadataCompleteWebFragment(lib.substring(lib.lastIndexOf(47) + 1));
                }
                if (mergedWebFragment != null) {
                    mergedWebFragment.addWebBundleDescriptor(wdesc);
                    continue;
                }
                mergedWebFragment = wdesc;
            }
            if (mergedWebFragment != null) {
                descriptor.addWebBundleDescriptor(mergedWebFragment);
            }
        }
    }
}

