/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment.node.ejb;

import com.sun.enterprise.deployment.ConcurrentMethodDescriptor;
import com.sun.enterprise.deployment.Descriptor;
import com.sun.enterprise.deployment.EjbBundleDescriptor;
import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.deployment.EjbInitInfo;
import com.sun.enterprise.deployment.EjbRemovalInfo;
import com.sun.enterprise.deployment.EjbSessionDescriptor;
import com.sun.enterprise.deployment.MethodDescriptor;
import com.sun.enterprise.deployment.ScheduledTimerDescriptor;
import com.sun.enterprise.deployment.TimeoutValueDescriptor;
import com.sun.enterprise.deployment.node.DescriptorFactory;
import com.sun.enterprise.deployment.node.LifecycleCallbackNode;
import com.sun.enterprise.deployment.node.MethodNode;
import com.sun.enterprise.deployment.node.XMLElement;
import com.sun.enterprise.deployment.node.ejb.AroundInvokeNode;
import com.sun.enterprise.deployment.node.ejb.ConcurrentMethodNode;
import com.sun.enterprise.deployment.node.ejb.EjbInitNode;
import com.sun.enterprise.deployment.node.ejb.EjbRemoveNode;
import com.sun.enterprise.deployment.node.ejb.InterfaceBasedEjbNode;
import com.sun.enterprise.deployment.node.ejb.ScheduledTimerNode;
import com.sun.enterprise.deployment.node.ejb.TimeoutValueNode;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.Attributes;

public class EjbSessionNode
extends InterfaceBasedEjbNode {
    private EjbSessionDescriptor descriptor;
    private boolean inDependsOn = false;
    private List<String> dependsOn = null;

    public EjbSessionNode() {
        this.registerElementHandler(new XMLElement("around-invoke"), AroundInvokeNode.class, "addAroundInvokeDescriptor");
        this.registerElementHandler(new XMLElement("post-construct"), LifecycleCallbackNode.class, "addPostConstructDescriptor");
        this.registerElementHandler(new XMLElement("pre-destroy"), LifecycleCallbackNode.class, "addPreDestroyDescriptor");
        this.registerElementHandler(new XMLElement("post-activate"), LifecycleCallbackNode.class, "addPostActivateDescriptor");
        this.registerElementHandler(new XMLElement("pre-passivate"), LifecycleCallbackNode.class, "addPrePassivateDescriptor");
        this.registerElementHandler(new XMLElement("timeout-method"), MethodNode.class, "setEjbTimeoutMethod");
        this.registerElementHandler(new XMLElement("init-method"), EjbInitNode.class, "addInitMethod");
        this.registerElementHandler(new XMLElement("remove-method"), EjbRemoveNode.class, "addRemoveMethod");
        this.registerElementHandler(new XMLElement("stateful-timeout"), TimeoutValueNode.class, "addStatefulTimeoutDescriptor");
        this.registerElementHandler(new XMLElement("after-begin-method"), MethodNode.class, "addAfterBeginDescriptor");
        this.registerElementHandler(new XMLElement("before-completion-method"), MethodNode.class, "addBeforeCompletionDescriptor");
        this.registerElementHandler(new XMLElement("after-completion-method"), MethodNode.class, "addAfterCompletionDescriptor");
        this.registerElementHandler(new XMLElement("async-method"), MethodNode.class, "addAsynchronousMethod");
        this.registerElementHandler(new XMLElement("concurrent-method"), ConcurrentMethodNode.class, "addConcurrentMethodFromXml");
    }

    public EjbDescriptor getEjbDescriptor() {
        if (this.descriptor == null) {
            this.descriptor = (EjbSessionDescriptor)DescriptorFactory.getDescriptor(this.getXMLPath());
            this.descriptor.setEjbBundleDescriptor((EjbBundleDescriptor)this.getParentNode().getDescriptor());
        }
        return this.descriptor;
    }

    protected Map getDispatchTable() {
        Map table = super.getDispatchTable();
        table.put("session-type", "setSessionType");
        table.put("transaction-type", "setTransactionType");
        table.put("init-on-startup", "setInitOnStartup");
        return table;
    }

    public void startElement(XMLElement element, Attributes attributes) {
        if ("local-bean".equals(element.getQName())) {
            this.descriptor.setLocalBean(true);
        } else if ("depends-on".equals(element.getQName())) {
            this.inDependsOn = true;
            this.dependsOn = new ArrayList<String>();
        }
        super.startElement(element, attributes);
    }

    public void setElementValue(XMLElement element, String value) {
        if (this.inDependsOn && "ejb-name".equals(element.getQName())) {
            this.dependsOn.add(value);
        } else if ("concurrency-management-type".equals(element.getQName())) {
            this.descriptor.setConcurrencyManagementType(EjbSessionDescriptor.ConcurrencyManagementType.valueOf(value));
        } else {
            super.setElementValue(element, value);
        }
    }

    public boolean endElement(XMLElement element) {
        if ("depends-on".equals(element.getQName())) {
            this.inDependsOn = false;
            this.descriptor.setDependsOn(this.dependsOn.toArray(new String[0]));
            this.dependsOn = null;
        }
        return super.endElement(element);
    }

    public Node writeDescriptor(Node parent, String nodeName, Descriptor descriptor) {
        MethodDescriptor afterCompletionMethod;
        MethodDescriptor beforeCompletionMethod;
        ConcurrentMethodDescriptor cDesc;
        if (!(descriptor instanceof EjbSessionDescriptor)) {
            throw new IllegalArgumentException(this.getClass() + " cannot handles descriptors of type " + descriptor.getClass());
        }
        EjbSessionDescriptor ejbDesc = (EjbSessionDescriptor)descriptor;
        Node ejbNode = super.writeDescriptor(parent, nodeName, descriptor);
        this.writeDisplayableComponentInfo(ejbNode, descriptor);
        this.writeCommonHeaderEjbDescriptor(ejbNode, ejbDesc);
        EjbSessionNode.appendTextChild(ejbNode, "session-type", ejbDesc.getSessionType());
        if (ejbDesc.hasStatefulTimeout()) {
            TimeoutValueNode timeoutValueNode = new TimeoutValueNode();
            TimeoutValueDescriptor timeoutDesc = new TimeoutValueDescriptor();
            timeoutDesc.setValue(ejbDesc.getStatefulTimeoutValue());
            timeoutDesc.setUnit(ejbDesc.getStatefulTimeoutUnit());
            timeoutValueNode.writeDescriptor(ejbNode, "stateful-timeout", timeoutDesc);
        }
        MethodNode methodNode = new MethodNode();
        if (ejbDesc.isTimedObject()) {
            if (ejbDesc.getEjbTimeoutMethod() != null) {
                methodNode.writeJavaMethodDescriptor(ejbNode, "timeout-method", ejbDesc.getEjbTimeoutMethod());
            }
            for (ScheduledTimerDescriptor timerDesc : ejbDesc.getScheduledTimerDescriptors()) {
                ScheduledTimerNode timerNode = new ScheduledTimerNode();
                timerNode.writeDescriptor(ejbNode, "timer", timerDesc);
            }
        }
        if (ejbDesc.isSingleton()) {
            EjbSessionNode.appendTextChild(ejbNode, "init-on-startup", Boolean.toString(ejbDesc.getInitOnStartup()));
        }
        if (!ejbDesc.isStateless()) {
            EjbSessionNode.appendTextChild(ejbNode, "concurrency-management-type", ejbDesc.getConcurrencyManagementType().toString());
        }
        for (EjbSessionDescriptor.AccessTimeoutHolder next : ejbDesc.getAccessTimeoutInfo()) {
            cDesc = new ConcurrentMethodDescriptor();
            cDesc.setConcurrentMethod(next.method);
            TimeoutValueDescriptor timeoutDesc = new TimeoutValueDescriptor();
            timeoutDesc.setValue(next.value);
            timeoutDesc.setUnit(next.unit);
            cDesc.setAccessTimeout(timeoutDesc);
            ConcurrentMethodNode cNode = new ConcurrentMethodNode();
            cNode.writeDescriptor(ejbNode, "concurrent-method", cDesc);
        }
        for (MethodDescriptor nextReadLock : ejbDesc.getReadLockMethods()) {
            cDesc = new ConcurrentMethodDescriptor();
            cDesc.setConcurrentMethod(nextReadLock);
            cDesc.setWriteLock(false);
            ConcurrentMethodNode cNode = new ConcurrentMethodNode();
            cNode.writeDescriptor(ejbNode, "concurrent-method", cDesc);
        }
        if (ejbDesc.hasDependsOn()) {
            Element dependsOnNode = EjbSessionNode.appendChild(ejbNode, "depends-on");
            for (String depend : ejbDesc.getDependsOn()) {
                EjbSessionNode.appendTextChild((Node)dependsOnNode, "ejb-name", depend);
            }
        }
        if (ejbDesc.hasInitMethods()) {
            EjbInitNode initNode = new EjbInitNode();
            for (EjbInitInfo next : ejbDesc.getInitMethods()) {
                initNode.writeDescriptor(ejbNode, "init-method", next);
            }
        }
        if (ejbDesc.hasRemoveMethods()) {
            EjbRemoveNode removeNode = new EjbRemoveNode();
            for (EjbRemovalInfo next : ejbDesc.getAllRemovalInfo()) {
                removeNode.writeDescriptor(ejbNode, "remove-method", next);
            }
        }
        for (MethodDescriptor nextDesc : ejbDesc.getAsynchronousMethods()) {
            methodNode.writeDescriptor(ejbNode, "async-method", nextDesc, ejbDesc.getName());
        }
        EjbSessionNode.appendTextChild(ejbNode, "transaction-type", ejbDesc.getTransactionType());
        MethodDescriptor afterBeginMethod = ejbDesc.getAfterBeginMethod();
        if (afterBeginMethod != null) {
            methodNode.writeJavaMethodDescriptor(ejbNode, "after-begin-method", afterBeginMethod);
        }
        if ((beforeCompletionMethod = ejbDesc.getBeforeCompletionMethod()) != null) {
            methodNode.writeJavaMethodDescriptor(ejbNode, "before-completion-method", beforeCompletionMethod);
        }
        if ((afterCompletionMethod = ejbDesc.getAfterCompletionMethod()) != null) {
            methodNode.writeJavaMethodDescriptor(ejbNode, "after-completion-method", afterCompletionMethod);
        }
        this.writeAroundInvokeDescriptors(ejbNode, ejbDesc.getAroundInvokeDescriptors().iterator());
        this.writeEnvEntryDescriptors(ejbNode, ejbDesc.getEnvironmentProperties().iterator());
        this.writeEjbReferenceDescriptors(ejbNode, ejbDesc.getEjbReferenceDescriptors().iterator());
        this.writeServiceReferenceDescriptors(ejbNode, ejbDesc.getServiceReferenceDescriptors().iterator());
        this.writeResourceRefDescriptors(ejbNode, ejbDesc.getResourceReferenceDescriptors().iterator());
        this.writeResourceEnvRefDescriptors(ejbNode, ejbDesc.getJmsDestinationReferenceDescriptors().iterator());
        this.writeMessageDestinationRefDescriptors(ejbNode, ejbDesc.getMessageDestinationReferenceDescriptors().iterator());
        this.writeEntityManagerReferenceDescriptors(ejbNode, ejbDesc.getEntityManagerReferenceDescriptors().iterator());
        this.writeEntityManagerFactoryReferenceDescriptors(ejbNode, ejbDesc.getEntityManagerFactoryReferenceDescriptors().iterator());
        this.writePostConstructDescriptors(ejbNode, ejbDesc.getPostConstructDescriptors().iterator());
        this.writePreDestroyDescriptors(ejbNode, ejbDesc.getPreDestroyDescriptors().iterator());
        this.writePostActivateDescriptors(ejbNode, ejbDesc.getPostActivateDescriptors().iterator());
        this.writePrePassivateDescriptors(ejbNode, ejbDesc.getPrePassivateDescriptors().iterator());
        this.writeRoleReferenceDescriptors(ejbNode, ejbDesc.getRoleReferences().iterator());
        this.writeSecurityIdentityDescriptor(ejbNode, ejbDesc);
        return ejbNode;
    }
}

