/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 * Please see the source distribution for copyright info.
 */
if (typeof(Scales) == 'undefined') {
	Scales = {};
}

Scales.DateSelector = function(config) {
    this.config = config;
    this.showing = false;
    
    var trigger = this.config.clientId + "Trigger";

    var pos = YAHOO.util.Dom.getXY(trigger);
    this.container = YAHOO.util.Dom.get(this.config.clientId+"Container");
    YAHOO.util.Dom.setStyle(this.container, "position", "absolute");
    
    this.calendar = new YAHOO.widget.Calendar(this.container, {
            mindate: this.config.minDate
            ,maxdate: this.config.maxDate
            ,pageDate: this.config.startMonth
            ,selected: this.config.selectedDate
            ,SHOW_WEEKDAYS: this.config.showWeekdays
            ,START_WEEKDAY: this.config.startWeekday
            ,SHOW_WEEK_HEADER: this.config.showWeekHeader
            ,SHOW_WEEK_FOOTER: this.config.showWeekFooter
            ,HIDE_BLANK_WEEKS: this.config.hideBlankWeeks
            ,MDY_DAY_POSITION: this.config.dayPosition
            ,MDY_MONTH_POSITION: this.config.monthPosition
            ,MDY_YEAR_POSITION: this.config.yearPosition
            ,navigator: this.config.navigator
    });
    // l10n support
    this.calendar.cfg.setProperty("DATE_FIELD_DELIMITER", this.config.dateFieldDelimiter);
    this.calendar.cfg.setProperty("MDY_DAY_POSITION", this.config.mdyDayPosition);
    this.calendar.cfg.setProperty("MDY_MONTH_POSITION", this.config.mdyMonthPosition);
    this.calendar.cfg.setProperty("MDY_YEAR_POSITION", this.config.mdyYearPosition);
    this.calendar.cfg.setProperty("MD_DAY_POSITION", this.config.mdDayPosition);
    this.calendar.cfg.setProperty("MD_MONTH_POSITION", this.config.mdMonthPosition);
    this.calendar.cfg.setProperty("MONTHS_SHORT", this.config.monthsShort);
    this.calendar.cfg.setProperty("MONTHS_LONG", this.config.monthsLong);
    this.calendar.cfg.setProperty("WEEKDAYS_1CHAR", this.config.weekdays1Char);
    this.calendar.cfg.setProperty("WEEKDAYS_SHORT", this.config.weekdaysShort);
    this.calendar.cfg.setProperty("WEEKDAYS_MEDIUM", this.config.weekdaysMedium);
    this.calendar.cfg.setProperty("WEEKDAYS_LONG", this.config.weekdaysLong);

    this.calendar.render();
    this.calendar.selectEvent.subscribe(this.onSelect, this, true);

    if (this.config.popup == true) {
        pos[1] = pos[1] + 20;
        YAHOO.util.Dom.setXY(this.container, pos, true);
        YAHOO.util.Dom.setStyle(this.container, "display", "none");

        var el = YAHOO.util.Dom.get(trigger);
        el.calendar = this.calender;
        YAHOO.util.Event.addListener(trigger, "click", this.toggle, this, true);
    } else {
        YAHOO.util.Dom.setStyle(trigger, "display", "none");
        YAHOO.util.Dom.setStyle(this.container, "display", "block");
        YAHOO.util.Dom.setStyle(this.container, "float", "none");
        YAHOO.util.Dom.setStyle(this.container, "left", pos[0] + "px");
        YAHOO.util.Dom.setStyle(this.container, "position", "relative");
        YAHOO.util.Dom.setStyle(this.container, "top", "-20px");
        YAHOO.util.Dom.setStyle(this.container, "width", 
            YAHOO.util.Dom.getStyle(YAHOO.util.Dom.getFirstChild(this.container), 'width'));
    }
}

Scales.DateSelector.prototype.toggle = function() {
    if (this.config.popup == true) {
        if (!this.showing) {
            this.zIndex = YAHOO.util.Dom.getStyle(this.container, "z-index");
            YAHOO.util.Dom.setStyle(this.container, "z-index", "999");
            this.calendar.show();
            //var container = YAHOO.util.Dom.get(this.divId);
            //YAHOO.util.Dom.setStyle(container, "position", "fixed");
        } else {
            this.calendar.hide();
            YAHOO.util.Dom.setStyle(this.container, "z-index", this.zIndex);
        }
        this.showing = !this.showing;
    }
}

Scales.DateSelector.prototype.onSelect = function() {
    var inputField = YAHOO.util.Dom.get(this.config.clientId);
    inputField.value = this.calendar.getSelectedDates()[0].format(this.config.format.toLowerCase());
    this.toggle();
    if (inputField.onchange) {
        inputField.onchange();
    }
}

Scales.DateSelector.prototype.formatDate = function() {
        var selDate = this.calendar.getSelectedDates()[0];
        var date_separator = "/";
        var day_ = selDate.getDate();
        var day = ( day_ < 10 ) ? "0" + day_ : day_;
        var month_ = selDate.getMonth()+1;
        var month = ( month_ < 10 ) ? "0" + month_ : month_;
        var year = selDate.getFullYear();
        return year + date_separator + month + date_separator + day;
}

/*
	Date Format 1.1
	(c) 2007 Steven Levithan <stevenlevithan.com>
	MIT license
	With code by Scott Trenda (Z and o flags, and enhanced brevity)

        Source: http://blog.stevenlevithan.com/archives/date-time-format
*/

/** 
        dateFormat
	Accepts a date, a mask, or a date and a mask.
	Returns a formatted version of the given date.
	The date defaults to the current date/time.
	The mask defaults ``"ddd mmm d yyyy HH:MM:ss"``.
*/
var dateFormat = function () {
	var	token        = /d{1,4}|m{1,4}|yy(?:yy)?|([HhMsTt])\1?|[LloZ]|"[^"]*"|'[^']*'/g,
		timezone     = /\b(?:[PMCEA][SDP]T|(?:Pacific|Mountain|Central|Eastern|Atlantic) (?:Standard|Daylight|Prevailing) Time|(?:GMT|UTC)(?:[-+]\d{4})?)\b/g,
		timezoneClip = /[^-+\dA-Z]/g,
		pad = function (value, length) {
			value = String(value);
			length = parseInt(length) || 2;
			while (value.length < length)
				value = "0" + value;
			return value;
		};

	// Regexes and supporting functions are cached through closure
	return function (date, mask) {
		// Treat the first argument as a mask if it doesn't contain any numbers
		if (
			arguments.length == 1 &&
			(typeof date == "string" || date instanceof String) &&
			!/\d/.test(date)
		) {
			mask = date;
			date = undefined;
		}

		date = date ? new Date(date) : new Date();
		if (isNaN(date))
			throw "invalid date";

		var dF = dateFormat;
		mask   = String(dF.masks[mask] || mask || dF.masks["default"]);

		var	d = date.getDate(),
			D = date.getDay(),
			m = date.getMonth(),
			y = date.getFullYear(),
			H = date.getHours(),
			M = date.getMinutes(),
			s = date.getSeconds(),
			L = date.getMilliseconds(),
			o = date.getTimezoneOffset(),
			flags = {
				d:    d,
				dd:   pad(d),
				ddd:  dF.i18n.dayNames[D],
				dddd: dF.i18n.dayNames[D + 7],
				m:    m + 1,
				mm:   pad(m + 1),
				mmm:  dF.i18n.monthNames[m],
				mmmm: dF.i18n.monthNames[m + 12],
				yy:   String(y).slice(2),
				yyyy: y,
				h:    H % 12 || 12,
				hh:   pad(H % 12 || 12),
				H:    H,
				HH:   pad(H),
				M:    M,
				MM:   pad(M),
				s:    s,
				ss:   pad(s),
				l:    pad(L, 3),
				L:    pad(L > 99 ? Math.round(L / 10) : L),
				t:    H < 12 ? "a"  : "p",
				tt:   H < 12 ? "am" : "pm",
				T:    H < 12 ? "A"  : "P",
				TT:   H < 12 ? "AM" : "PM",
				Z:    (String(date).match(timezone) || [""]).pop().replace(timezoneClip, ""),
				o:    (o > 0 ? "-" : "+") + pad(Math.floor(Math.abs(o) / 60) * 100 + Math.abs(o) % 60, 4)
			};

		return mask.replace(token, function ($0) {
			return ($0 in flags) ? flags[$0] : $0.slice(1, $0.length - 1);
		});
	};
}();

// Some common format strings
dateFormat.masks = {
	"default":       "ddd mmm d yyyy HH:MM:ss",
	shortDate:       "m/d/yy",
	mediumDate:      "mmm d, yyyy",
	longDate:        "mmmm d, yyyy",
	fullDate:        "dddd, mmmm d, yyyy",
	shortTime:       "h:MM TT",
	mediumTime:      "h:MM:ss TT",
	longTime:        "h:MM:ss TT Z",
	isoDate:         "yyyy-mm-dd",
	isoTime:         "HH:MM:ss",
	isoDateTime:     "yyyy-mm-dd'T'HH:MM:ss",
	isoFullDateTime: "yyyy-mm-dd'T'HH:MM:ss.lo"
};

// Internationalization strings
dateFormat.i18n = {
	dayNames: [
		"Sun", "Mon", "Tue", "Wed", "Thr", "Fri", "Sat",
		"Sunday", "Monday", "Tuesday", "Wednesday", "Thursday", "Friday", "Saturday"
	],
	monthNames: [
		"Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec",
		"January", "February", "March", "April", "May", "June", "July", "August", "September", "October", "November", "December"
	]
};

// For convenience...
Date.prototype.format = function (mask) {
	return dateFormat(this, mask);
}

