/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 * 
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 * 
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common Development
 * and Distribution License("CDDL") (collectively, the "License").  You
 * may not use this file except in compliance with the License. You can obtain
 * a copy of the License at https://glassfish.dev.java.net/public/CDDL+GPL.html
 * or glassfish/bootstrap/legal/LICENSE.txt.  See the License for the specific
 * language governing permissions and limitations under the License.
 * 
 * When distributing the software, include this License Header Notice in each
 * file and include the License file at glassfish/bootstrap/legal/LICENSE.txt.
 * Sun designates this particular file as subject to the "Classpath" exception
 * as provided by Sun in the GPL Version 2 section of the License file that
 * accompanied this code.  If applicable, add the following below the License
 * Header, with the fields enclosed by brackets [] replaced by your own
 * identifying information: "Portions Copyrighted [year]
 * [name of copyright owner]"
 * 
 * Contributor(s):
 * 
 * If you wish your version of this file to be governed by only the CDDL or
 * only the GPL Version 2, indicate your decision by adding "[Contributor]
 * elects to include this software in this distribution under the [CDDL or GPL
 * Version 2] license."  If you don't indicate a single choice of license, a
 * recipient has the option to distribute your version of this file under
 * either the CDDL, the GPL Version 2 or to extend the choice of license to
 * its licensees as provided above.  However, if you add GPL Version 2 code
 * and therefore, elected the GPL Version 2 license, then the option applies
 * only if the new code is made subject to such option by the copyright
 * holder.
 */

if (typeof YAHOO == "undefined") { 
    var YAHOO = {};
}
if (typeof Scales == "undefined") {
//var Scales = YAHOO.namespace("Scales");
}

if (typeof scalesPanels == "undefined") {
    var scalesPanels = [];
    var currentMaxZ = 1;

    registerPanel = function(id, panel, flat) {
        scalesPanels[id] = panel;
        if (!flat) {
            YAHOO.util.Event.addListener(id, "mousedown", bringToFront);
        } else {
            node = YAHOO.util.Dom.get(id);
            YAHOO.util.Dom.setStyle(node.parentNode.parentNode, 'height', node.clientHeight + 'px');
        }

        currentMaxZ++;
    }

    setZToMax = function (target) {
        YAHOO.util.Dom.setStyle(target, 'z-index', ++currentMaxZ);
    }

    bringToFront = function (event) {
        setZToMax(event.target.parentNode.parentNode);
    }


    showPanel = function(id) {
        panel = scalesPanels[id];
        scalesPanels[id].show();
        setZToMax(scalesPanels[id].element);
    }

    hidePanel = function(id) {
        scalesPanels[id].hide();
    }

    resizeTabView = function(id, maxHeight) {
        var tabs = YAHOO.util.Dom.getChildren(YAHOO.util.Dom.getElementsByClassName("yui-content", "div", YAHOO.util.Dom.get(id))[0]);
        var tallestTab = 0;

        for (i = 0; i != tabs.length; i++) {
           var height = tabs[i].clientHeight;
           tallestTab = (height > tallestTab) ? height : tallestTab;
        }
        maxHeight = maxHeight.replace("px", "");

        if (maxHeight == "auto") {
            maxHeight = tallestTab;
        } else {
            if (tallestTab > maxHeight) {
                maxHeight = maxHeight;
            }
        }
        maxHeight = maxHeight + "px";

        for (i = 0; i != tabs.length; i++) {
            YAHOO.util.Dom.setStyle(tabs[i], "height", maxHeight);
        }
    }
}