if (typeof(Scales) == 'undefined') {
	Scales = {};
}

Scales.Uploader = function(config) {
    this.uploader = null;
    this.uploadCounter = 0; 
    this.fileIdHash = null; 
    this.dataArr = null; 
    this.clientId = config.clientId;
    this.sessionId = YAHOO.util.Cookie.get("JSESSIONID");
        //config.sessionId;
    
    try {
        this.uploader = new YAHOO.widget.Uploader("uploader");
    } catch (err) {
        alert (err);
    }
    YAHOO.util.Dom.setStyle ("uploader", "width", "0px");
    YAHOO.util.Dom.setStyle ("uploader", "height", "0px");
    this.uploader.addListener("fileSelect",this.onFileSelect, this, true); 
    this.uploader.addListener("uploadComplete",this.onUploadComplete, this, true); 
    this.uploader.addListener("uploadProgress",this.onUploadProgress, this, true); 
    this.uploader.addListener("uploadStart",this.onUploadStart, this, true); 
    
    YAHOO.util.Event.addListener("uploader_browse_button", "click", this.browse, this, true); 
    YAHOO.util.Event.addListener("uploader_clear_button", "click", this.clear, this, true); 
    YAHOO.util.Event.addListener("uploader_upload_button", "click", this.upload, this, true); 
}

Scales.Uploader.prototype.clear = function() {
    this.uploader.clearFileList();
}

Scales.Uploader.prototype.browse = function() {
    this.uploader.browse(true);
}

Scales.Uploader.prototype.upload = function() {
    var idToUpload = this.dataArr[this.uploadCounter]["id"]; 
    var url = this.uploadUrl + 
        "?componentId=" + this.clientId +
        "&JSESSIONID=" + this.sessionId;

    this.uploader.upload(idToUpload, url, "POST"); //, {user_cookies:document.cookie});
}

Scales.Uploader.prototype.onFileSelect = function(event) {
    fileList = event.fileList;
    this.createDataTable(fileList);
}

Scales.Uploader.prototype.onUploadProgress = function(event) {
    rowNum = this.fileIdHash[event["id"]];
    prog = Math.round(100*(event["bytesLoaded"]/event["bytesTotal"]));
    progbar = '<hr style="color: #f00; background-color: #f00; text-align:left; margin: 0 auto 0 0; height: 5px; width: ' + 
        prog + 'px"/>';
    this.singleSelectDataTable.updateRow(rowNum, {name: this.dataArr[rowNum]["name"], size: this.dataArr[rowNum]["size"], progress: progbar});
}

Scales.Uploader.prototype.onUploadStart = function(event) { 
    rowNum = this.fileIdHash[event["id"]]; 
    this.singleSelectDataTable.updateRow(rowNum, {name: this.dataArr[rowNum]["name"], size: this.dataArr[rowNum]["size"], progress: "Starting..."});       
}

Scales.Uploader.prototype.onUploadComplete = function(event) {
    rowNum = this.fileIdHash[event["id"]];
    progbar = '<hr style="color: #f00; background-color: #f00; text-align:left; margin: 0 auto 0 0; height: 5px; width: 100px"/>';
    this.singleSelectDataTable.updateRow(rowNum, {name: this.dataArr[rowNum]["name"], size: this.dataArr[rowNum]["size"], progress: progbar});

    if (this.uploadCounter < this.dataArr.length - 1) {
        this.uploadCounter++;
        this.upload();
    } else {
        this.clear();
        alert("All files uploaded!");
    }
}

Scales.Uploader.prototype.createDataTable = function(entries) {
    try{
        var rowCounter = 0;
        this.fileIdHash = [];
        this.dataArr = [];
        for(var i in entries) {
            var entry = entries[i];
            dataObj = {};

            for (var j in entry) {
                dataObj[j] = entry[j];
            }
            this.dataArr.push(dataObj);
            this.fileIdHash[dataObj["id"]] = rowCounter;
            rowCounter++;
        }

        this.allData = {data: this.dataArr};

        var myColumnDefs = [
            {key:"name", label: "File Name", sortable:true},
            {key:"size", label: "Size", sortable:true},
            {key:"progress", label: "Upload progress", sortable:false}
        ];
        this.myDataSource = new YAHOO.util.DataSource(this.allData);
        this.myDataSource.dataType = YAHOO.util.DataSource.TYPE_JSARRAY;
        this.myDataSource.responseType = YAHOO.util.DataSource.TYPE_JSON;
        this.myDataSource.responseSchema = {
            resultsList: ["data"],
            fields: ["id","name","created","modified","type", "size", "progress"]
        };

        /*
        this.singleSelectDataTable = new YAHOO.widget.DataTable("uploader_table",
               myColumnDefs, this.myDataSource, {
                   //caption:"Files To Upload",
                   selectionMode:"single"
               });
        */
   } catch (err) {
       alert(err);
   }
}