/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.mbeanserver;

import java.util.ArrayList;
import java.util.Set;
import javax.management.JMException;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.management.remote.JMXServiceURL;
import org.glassfish.admin.mbeanserver.AMXStartupServiceMBean;
import org.glassfish.admin.mbeanserver.BooterOldMBean;
import org.glassfish.admin.mbeanserver.Util;
import org.jvnet.hk2.component.Habitat;

final class BooterOld
implements BooterOldMBean {
    private final MBeanServer mMBeanServer;
    private final ObjectName mObjectName;
    private final Habitat mHabitat;
    private ObjectName mDomainRootObjectName;

    private static void debug(String s) {
        System.out.println(s);
    }

    private BooterOld(Habitat habitat, MBeanServer mbeanServer) {
        this.mHabitat = habitat;
        this.mMBeanServer = mbeanServer;
        this.mObjectName = BooterOldMBean.OBJECT_NAME;
        this.mDomainRootObjectName = null;
        if (this.mMBeanServer.isRegistered(this.mObjectName)) {
            throw new IllegalStateException();
        }
    }

    public static synchronized BooterOld create(Habitat habitat, MBeanServer server) {
        BooterOld booter = new BooterOld(habitat, server);
        ObjectName objectName = BooterOldMBean.OBJECT_NAME;
        try {
            if (!server.registerMBean(booter, objectName).getObjectName().equals(objectName)) {
                throw new IllegalStateException();
            }
        }
        catch (JMException e) {
            throw new IllegalStateException(e);
        }
        return booter;
    }

    public synchronized ObjectName bootAMX() {
        if (this.mDomainRootObjectName == null) {
            AMXStartupServiceMBean loader = null;
            try {
                loader = (AMXStartupServiceMBean)this.mHabitat.getByContract(AMXStartupServiceMBean.class);
            }
            catch (Throwable t) {
                t.printStackTrace();
                throw new RuntimeException(t);
            }
            BooterOld.debug("Got loader for AMXStartupServiceMBean: " + loader);
            ObjectName startupON = AMXStartupServiceMBean.OBJECT_NAME;
            if (!this.mMBeanServer.isRegistered(startupON)) {
                BooterOld.debug("AMX MBean not yet available: " + startupON);
                throw new IllegalStateException("AMX MBean not yet available: " + startupON);
            }
            try {
                this.mDomainRootObjectName = (ObjectName)this.mMBeanServer.invoke(startupON, "loadAMXMBeans", null, null);
            }
            catch (JMException e) {
                e.printStackTrace();
                throw new RuntimeException(e);
            }
        }
        return this.mDomainRootObjectName;
    }

    public JMXServiceURL[] getJMXServiceURLs() {
        ObjectName queryPattern = Util.newObjectName("jmxremote:type=jmx-connector,*");
        Set<ObjectName> objectNames = this.mMBeanServer.queryNames(queryPattern, null);
        ArrayList<JMXServiceURL> urls = new ArrayList<JMXServiceURL>();
        for (ObjectName objectName : objectNames) {
            try {
                urls.add((JMXServiceURL)this.mMBeanServer.getAttribute(objectName, "Address"));
            }
            catch (JMException e) {
                e.printStackTrace();
            }
        }
        return urls.toArray(new JMXServiceURL[urls.size()]);
    }
}

