/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.amx.impl.loader;

import java.util.Collection;
import javax.management.JMException;
import javax.management.MBeanServer;
import javax.management.MBeanServerConnection;
import javax.management.MBeanServerInvocationHandler;
import javax.management.ObjectName;
import javax.management.StandardMBean;
import javax.management.remote.JMXServiceURL;
import org.glassfish.admin.amx.base.DomainRoot;
import org.glassfish.admin.amx.base.MBeanTracker;
import org.glassfish.admin.amx.base.MBeanTrackerMBean;
import org.glassfish.admin.amx.core.AMXProxy;
import org.glassfish.admin.amx.core.proxy.AMXBooter;
import org.glassfish.admin.amx.core.proxy.ProxyFactory;
import org.glassfish.admin.amx.impl.loader.Loader;
import org.glassfish.admin.amx.impl.util.ImplUtil;
import org.glassfish.admin.amx.impl.util.InjectedValues;
import org.glassfish.admin.amx.impl.util.Issues;
import org.glassfish.admin.amx.impl.util.SingletonEnforcer;
import org.glassfish.admin.amx.util.FeatureAvailability;
import org.glassfish.admin.amx.util.TimingDelta;
import org.glassfish.admin.amx.util.jmx.JMXUtil;
import org.glassfish.admin.mbeanserver.AMXLoader;
import org.glassfish.admin.mbeanserver.AMXStartupServiceNewMBean;
import org.glassfish.admin.mbeanserver.BooterNewMBean;
import org.glassfish.admin.mbeanserver.PendingConfigBeans;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.Habitat;
import org.jvnet.hk2.component.PostConstruct;
import org.jvnet.hk2.component.PreDestroy;

@Service
public final class AMXStartupServiceNew
implements PostConstruct,
PreDestroy,
AMXStartupServiceNewMBean {
    @Inject
    Habitat mHabitat;
    @Inject
    InjectedValues mInjectedValues;
    @Inject
    private MBeanServer mMBeanServer;
    @Inject
    private volatile PendingConfigBeans mPendingConfigBeans;
    private volatile ObjectName mAMXLoaderObjectName;
    private volatile MBeanTracker mSupport;
    private static final ObjectName MBEAN_TRACKER_OBJECT_NAME = JMXUtil.newObjectName((String)"v3-support", (String)"type=mbean-tracker");
    private static final String AMX_LOADER_DEFAULT_OBJECTNAME = "v3-support:type=amx-loader,name=core";
    private static ObjectName LOADER_OBJECTNAME = null;

    private static void debug(String s) {
        System.out.println(s);
    }

    public static MBeanTrackerMBean getMBeanTracker(MBeanServer server) {
        return MBeanServerInvocationHandler.newProxyInstance(server, MBEAN_TRACKER_OBJECT_NAME, MBeanTrackerMBean.class, false);
    }

    public void postConstruct() {
        TimingDelta delta = new TimingDelta();
        SingletonEnforcer.register(this.getClass(), this);
        if (this.mMBeanServer == null) {
            throw new Error("AMXStartup: null MBeanServer");
        }
        if (this.mPendingConfigBeans == null) {
            throw new Error("AMXStartup: null mPendingConfigBeans");
        }
        try {
            StandardMBean mbean = new StandardMBean(this, AMXStartupServiceNewMBean.class);
            this.mMBeanServer.registerMBean(mbean, OBJECT_NAME);
            this.mSupport = new MBeanTracker();
            this.mMBeanServer.registerMBean(this.mSupport, MBEAN_TRACKER_OBJECT_NAME);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new Error(e);
        }
        ImplUtil.getLogger().fine("Initialized AMXStartupServiceNew in " + delta.elapsedMillis() + " ms, registered as " + OBJECT_NAME);
    }

    public void preDestroy() {
        ImplUtil.getLogger().info("AMXStartupService.preDestroy(): stopping AMX");
        this.unloadAMXMBeans();
    }

    public JMXServiceURL[] getJMXServiceURLs() {
        try {
            return (JMXServiceURL[])this.mMBeanServer.getAttribute(BooterNewMBean.OBJECT_NAME, "JMXServiceURLs");
        }
        catch (JMException e) {
            throw new RuntimeException(e);
        }
    }

    public static AMXStartupServiceNewMBean getAMXStartupServiceMBeanProxy(MBeanServer mbs) {
        AMXStartupServiceNewMBean ss = null;
        if (mbs.isRegistered(OBJECT_NAME)) {
            ss = (AMXStartupServiceNewMBean)AMXStartupServiceNewMBean.class.cast(MBeanServerInvocationHandler.newProxyInstance(mbs, OBJECT_NAME, AMXStartupServiceNewMBean.class, false));
        }
        return ss;
    }

    public synchronized ObjectName getDomainRoot() {
        try {
            return this.getDomainRootProxy().extra().objectName();
        }
        catch (Exception exception) {
            return null;
        }
    }

    DomainRoot getDomainRootProxy() {
        return ProxyFactory.getInstance((MBeanServer)this.mMBeanServer).getDomainRootProxy();
    }

    public ObjectName loadAMXMBeans() {
        ObjectName objectName = AMXBooter.findDomainRoot((MBeanServerConnection)this.mMBeanServer);
        if (objectName == null) {
            try {
                objectName = this._loadAMXMBeans();
            }
            catch (Exception e) {
                AMXStartupServiceNew.debug("AMXStartupServiceNew.loadAMXMBeans: " + e);
                throw new RuntimeException(e);
            }
        }
        return objectName;
    }

    public static synchronized ObjectName loadAMX(MBeanServer mbeanServer) {
        if (LOADER_OBJECTNAME == null) {
            boolean inDAS = true;
            Issues.getAMXIssues().notDone("LoadAMX.loadAMX(): determine if this is the DAS");
            Loader loader = new Loader();
            ObjectName tempObjectName = JMXUtil.newObjectName((String)AMX_LOADER_DEFAULT_OBJECTNAME);
            try {
                LOADER_OBJECTNAME = mbeanServer.registerMBean(loader, tempObjectName).getObjectName();
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new RuntimeException(e);
            }
        }
        return LOADER_OBJECTNAME;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized ObjectName _loadAMXMBeans() {
        this.mAMXLoaderObjectName = AMXStartupServiceNew.loadAMX(this.mMBeanServer);
        try {
            Collection loaders = this.mHabitat.getAllByContract(AMXLoader.class);
            for (AMXLoader loader : loaders) {
                try {
                    ObjectName top = loader.loadAMXMBeans();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        finally {
            FeatureAvailability.getInstance().registerFeature("AMXReady", (Object)this.getDomainRoot());
        }
        return this.getDomainRoot();
    }

    public synchronized void unloadAMXMBeans() {
        if (this.getDomainRoot() != null) {
            Collection loaders = this.mHabitat.getAllByContract(AMXLoader.class);
            for (AMXLoader loader : loaders) {
                try {
                    loader.unloadAMXMBeans();
                }
                catch (Exception e) {
                    ImplUtil.getLogger().info("AMXLoader failed to unload: " + e);
                }
            }
            ImplUtil.unregisterAMXMBeans((AMXProxy)this.getDomainRootProxy());
        }
    }
}

