/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.amx.impl.mbean;

import com.sun.appserv.server.util.Version;
import com.sun.enterprise.universal.Duration;
import com.sun.enterprise.universal.io.SmartFile;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.glassfish.admin.amx.base.BulkAccess;
import org.glassfish.admin.amx.base.DomainRoot;
import org.glassfish.admin.amx.base.Ext;
import org.glassfish.admin.amx.base.Pathnames;
import org.glassfish.admin.amx.base.QueryMgr;
import org.glassfish.admin.amx.base.Sample;
import org.glassfish.admin.amx.base.SystemStatus;
import org.glassfish.admin.amx.base.Tools;
import org.glassfish.admin.amx.base.UploadDownloadMgr;
import org.glassfish.admin.amx.impl.loader.BootUtil;
import org.glassfish.admin.amx.impl.mbean.AMXImplBase;
import org.glassfish.admin.amx.impl.mbean.BulkAccessImpl;
import org.glassfish.admin.amx.impl.mbean.ComplianceMonitor;
import org.glassfish.admin.amx.impl.mbean.ExtImpl;
import org.glassfish.admin.amx.impl.mbean.MonitoringRootImpl;
import org.glassfish.admin.amx.impl.mbean.QueryMgrImpl;
import org.glassfish.admin.amx.impl.mbean.SampleImpl;
import org.glassfish.admin.amx.impl.mbean.ToolsImpl;
import org.glassfish.admin.amx.impl.mbean.UploadDownloadMgrImpl;
import org.glassfish.admin.amx.impl.mbeans.PathnamesImpl;
import org.glassfish.admin.amx.impl.util.InjectedValues;
import org.glassfish.admin.amx.impl.util.Issues;
import org.glassfish.admin.amx.impl.util.ObjectNameBuilder;
import org.glassfish.admin.amx.monitoring.MonitoringRoot;
import org.glassfish.admin.amx.util.FeatureAvailability;
import org.glassfish.server.ServerEnvironmentImpl;

public class DomainRootImpl
extends AMXImplBase {
    private String mAppserverDomainName = null;
    private volatile ComplianceMonitor mCompliance;

    public DomainRootImpl() {
        super(null, DomainRoot.class);
    }

    public void stopDomain() {
        this.getDomainRootProxy().getExt().getRuntimeMgr().stopDomain();
    }

    public ObjectName getQueryMgr() {
        return this.child(QueryMgr.class);
    }

    public ObjectName getUploadDownloadMgr() {
        return this.child(UploadDownloadMgr.class);
    }

    public ObjectName getPathnames() {
        return this.child(Pathnames.class);
    }

    public ObjectName getSystemStatus() {
        return this.child(SystemStatus.class);
    }

    public ObjectName getBulkAccess() {
        return this.child(BulkAccess.class);
    }

    public ObjectName preRegisterHook(ObjectName selfObjectName) throws Exception {
        this.mAppserverDomainName = BootUtil.getInstance().getAppserverDomainName();
        return selfObjectName;
    }

    public void preRegisterDone() throws Exception {
        super.preRegisterDone();
    }

    protected void postRegisterHook(Boolean registrationSucceeded) {
        boolean registeredOK = registrationSucceeded;
        if (registeredOK) {
            this.mCompliance = ComplianceMonitor.getInstance(this.getDomainRootProxy());
        }
        super.postRegisterHook(registrationSucceeded);
        if (registeredOK) {
            this.mCompliance.validate(this.getObjectName());
            this.mCompliance.start();
        }
    }

    public String getAppserverDomainName() {
        return this.mAppserverDomainName;
    }

    protected final void registerChildren() {
        super.registerChildren();
        ObjectName self = this.getObjectName();
        ObjectNameBuilder objectNames = new ObjectNameBuilder(this.getMBeanServer(), self);
        ObjectName childObjectName = null;
        AMXImplBase mbean = null;
        MBeanServer server = this.getMBeanServer();
        childObjectName = objectNames.buildChildObjectName(Ext.class);
        mbean = new ExtImpl(self);
        this.registerChild(mbean, childObjectName);
        childObjectName = objectNames.buildChildObjectName(Tools.class);
        mbean = new ToolsImpl(self);
        this.registerChild(mbean, childObjectName);
        childObjectName = objectNames.buildChildObjectName(QueryMgr.class);
        mbean = new QueryMgrImpl(self);
        this.registerChild(mbean, childObjectName);
        childObjectName = objectNames.buildChildObjectName(BulkAccess.class);
        mbean = new BulkAccessImpl(self);
        this.registerChild(mbean, childObjectName);
        childObjectName = objectNames.buildChildObjectName(UploadDownloadMgr.class);
        mbean = new UploadDownloadMgrImpl(self);
        this.registerChild(mbean, childObjectName);
        childObjectName = objectNames.buildChildObjectName(Sample.class);
        mbean = new SampleImpl(self);
        this.registerChild(mbean, childObjectName);
        childObjectName = objectNames.buildChildObjectName(Pathnames.class);
        mbean = new PathnamesImpl(self);
        this.registerChild(mbean, childObjectName);
        childObjectName = objectNames.buildChildObjectName(MonitoringRoot.class);
        mbean = new MonitoringRootImpl(self);
        this.registerChild(mbean, childObjectName);
    }

    public boolean getAMXReady() {
        this.waitAMXReady();
        return true;
    }

    public void waitAMXReady() {
        FeatureAvailability.getInstance().waitForFeature("AMXReady", this.getClass().getName());
    }

    public String getDebugPort() {
        Issues.getAMXIssues().notDone("DomainRootImpl.getDebugPort");
        return "9999";
    }

    public String getApplicationServerFullVersion() {
        return Version.getFullVersion();
    }

    public String getInstanceRoot() {
        return SmartFile.sanitize((String)("" + System.getProperty("com.sun.aas.instanceRoot")));
    }

    public String getDomainDir() {
        return SmartFile.sanitize((String)BootUtil.getInstance().getInstanceRoot().toString());
    }

    public String getConfigDir() {
        return this.getDomainDir() + "/" + "config";
    }

    public String getInstallDir() {
        return SmartFile.sanitize((String)("" + System.getProperty("com.sun.aas.installRoot")));
    }

    public Object[] getUptimeMillis() {
        ServerEnvironmentImpl env = InjectedValues.getInstance().getServerEnvironment();
        long elapsed = System.currentTimeMillis() - env.getStartupContext().getCreationTime();
        Duration duration = new Duration(elapsed);
        return new Object[]{elapsed, duration.toString()};
    }

    static String toString(InputStream is) throws IOException {
        StringBuffer sbuf = new StringBuffer();
        char[] chars = new char[32768];
        InputStreamReader reader = new InputStreamReader(is);
        do {
            int len;
            if ((len = reader.read(chars, 0, chars.length)) < 1) continue;
            sbuf.append(chars, 0, len);
        } while (reader.ready());
        return sbuf.toString();
    }
}

