/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.eis.interactions;

import java.util.Map;
import java.util.Vector;
import javax.resource.ResourceException;
import javax.resource.cci.MappedRecord;
import javax.resource.cci.Record;
import org.eclipse.persistence.eis.EISAccessor;
import org.eclipse.persistence.eis.EISException;
import org.eclipse.persistence.eis.EISMappedRecord;
import org.eclipse.persistence.eis.interactions.EISInteraction;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.sessions.AbstractRecord;
import org.eclipse.persistence.sessions.DatabaseRecord;

public class MappedInteraction
extends EISInteraction {
    protected String inputResultPath = "";
    protected Vector argumentNames;

    public void addArgument(String string) {
        this.addArgument(string, string);
    }

    public void addArgument(String string, String string2) {
        this.getArgumentNames().addElement(string);
        this.getArguments().addElement(new DatabaseField(string2));
    }

    public void addArgumentValue(String string, Object object) {
        this.getArgumentNames().addElement(string);
        this.getArguments().addElement(object);
    }

    public String getInputResultPath() {
        return this.inputResultPath;
    }

    public void setInputResultPath(String string) {
        this.inputResultPath = string;
    }

    public Vector getArgumentNames() {
        if (this.argumentNames == null) {
            this.argumentNames = new Vector();
        }
        return this.argumentNames;
    }

    public void setArgumentNames(Vector vector) {
        this.argumentNames = vector;
    }

    public Record createInputRecord(EISAccessor eISAccessor) {
        try {
            MappedRecord mappedRecord = null;
            if (this.getInputRow() != null && !this.hasArguments()) {
                if (this.getInputResultPath().length() == 0) {
                    mappedRecord = (MappedRecord)this.createRecordElement(this.getInputRecordName(), this.getInputRow(), eISAccessor);
                } else {
                    mappedRecord = eISAccessor.getRecordFactory().createMappedRecord(this.getInputRecordName());
                    Object object = this.createRecordElement(this.getInputResultPath(), this.getInputRow(), eISAccessor);
                    eISAccessor.getEISPlatform().setValueInRecord(this.getInputResultPath(), object, mappedRecord, eISAccessor);
                }
            } else {
                mappedRecord = eISAccessor.getRecordFactory().createMappedRecord(this.getInputRecordName());
                for (int i = 0; i < this.getArgumentNames().size(); ++i) {
                    String string = (String)this.getArgumentNames().get(i);
                    Object object = this.getParameters().get(i);
                    if (object == null && this.getInputRow() != null) {
                        object = this.getInputRow().get(string);
                    }
                    object = this.createRecordElement(string, object, eISAccessor);
                    eISAccessor.getEISPlatform().setValueInRecord(string, object, mappedRecord, eISAccessor);
                }
            }
            return mappedRecord;
        }
        catch (ResourceException resourceException) {
            throw EISException.resourceException(resourceException, eISAccessor, null);
        }
    }

    public AbstractRecord buildRow(Record record, EISAccessor eISAccessor) {
        AbstractRecord abstractRecord = null;
        if (!(record instanceof MappedRecord)) {
            abstractRecord = new DatabaseRecord(1);
            abstractRecord.put(this.getOutputResultPath(), (Object)record);
            return abstractRecord;
        }
        MappedRecord mappedRecord = (MappedRecord)record;
        if (this.hasOutputArguments()) {
            abstractRecord = new DatabaseRecord(this.getOutputArgumentNames().size());
            for (int i = 0; i < this.getOutputArgumentNames().size(); ++i) {
                DatabaseField databaseField = (DatabaseField)this.getOutputArguments().get(i);
                abstractRecord.put(databaseField, mappedRecord.get(this.getOutputArgumentNames().get(i)));
            }
            return abstractRecord;
        }
        if (this.getOutputResultPath().length() > 0) {
            mappedRecord = (MappedRecord)mappedRecord.get((Object)this.getOutputResultPath());
        }
        abstractRecord = new EISMappedRecord((Map)mappedRecord, eISAccessor);
        return abstractRecord;
    }
}

